/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import lsedit.ArrowDimensions;
import lsedit.Cardinal;
import lsedit.ClientSupplierSet;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.SrcCardinal;
import lsedit.Util;

public class EntityComponent
extends JComponent
implements Icon {
    public static final int MARGIN = 5;
    public static final int MIN_FLAP_HT = 3;
    public static final int MAX_FLAP_HT = 8;
    public static final int FLAP_MARGIN = 4;
    public static final int TINY_FLAP_WD = 10;
    public static final int MIN_FLAP_WD = 75;
    public static final int CONTENTS_FLAG_X = 3;
    public static final int CONTENTS_FLAG_Y = 9;
    public static final int CONTENTS_FLAG_DIM = 8;
    public static final int CONTENTS_FLAG_X_RESERVE = 11;
    public static final int CONTENTS_FLAG_Y_RESERVE = 17;
    private EntityInstance m_entityInstance;
    private double m_avgX;
    private Cardinal[] m_dstCardinals;
    private SrcCardinal[] m_srcCardinals;
    private static int[] m_xp = null;
    private static int[] m_yp = null;

    private static int[] getXp() {
        if (m_xp == null) {
            m_xp = new int[21];
        }
        return m_xp;
    }

    private static int[] getYp() {
        if (m_yp == null) {
            m_yp = new int[21];
        }
        return m_yp;
    }

    public EntityComponent(EntityInstance entityInstance) {
        this.m_entityInstance = entityInstance;
        this.setLayout(null);
        entityInstance.setSwingObject(this);
        this.setBounds(entityInstance.getX(), entityInstance.getY(), entityInstance.getWidth(), entityInstance.getHeight());
        if (m_xp == null) {
            m_xp = new int[21];
            m_yp = new int[21];
        }
    }

    public String toString() {
        return "EntityComponent: " + this.m_entityInstance.toString();
    }

    public EntityInstance getEntityInstance() {
        return this.m_entityInstance;
    }

    public boolean shades(EntityComponent entityComponent) {
        int n;
        int n2;
        int n3;
        int n4 = this.getX();
        return n4 >= (n3 = entityComponent.getX()) && (n2 = this.getY()) >= (n = entityComponent.getY()) && (n4 += this.getWidth()) <= (n3 += entityComponent.getWidth()) && (n2 += this.getHeight()) <= (n += entityComponent.getHeight());
    }

    public void computeShading() {
        Container container = this.getParent();
        if (container instanceof EntityComponent) {
            EntityInstance entityInstance = this.getEntityInstance();
            int n = container.getComponentCount();
            while (n > 0) {
                EntityComponent entityComponent;
                if ((entityComponent = (EntityComponent)container.getComponent(--n)) == this) {
                    entityInstance.orMark(0x10000000);
                    return;
                }
                if (!this.shades(entityComponent)) continue;
                entityInstance.orMark(0x30000000);
                return;
            }
        }
    }

    public Component add(Component component) {
        EntityComponent entityComponent = (EntityComponent)component;
        EntityInstance entityInstance = entityComponent.getEntityInstance();
        double d = entityInstance.widthRelLocal() * entityInstance.heightRelLocal();
        int n = this.getComponentCount();
        entityInstance.nandMark(0x10000000);
        for (int i = 0; i < n; ++i) {
            EntityComponent entityComponent2 = (EntityComponent)this.getComponent(i);
            EntityInstance entityInstance2 = entityComponent2.getEntityInstance();
            double d2 = entityInstance2.widthRelLocal() * entityInstance2.heightRelLocal();
            if (d2 > d) {
                return this.add(component, i);
            }
            entityInstance2.nandMark(0x10000000);
        }
        return super.add(component);
    }

    public void areaMoved() {
        Container container = this.getParent();
        if (container instanceof EntityComponent) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                EntityComponent entityComponent = (EntityComponent)container.getComponent(i);
                EntityInstance entityInstance = entityComponent.getEntityInstance();
                if (entityInstance.isMarked(0x10000000)) {
                    entityInstance.nandMark(0x10000000);
                    if (entityInstance.isMarked(0x20000000)) {
                        entityInstance.repaint();
                    }
                }
                if (entityComponent == this) break;
            }
        }
    }

    public void areaChanged() {
        double d;
        int n;
        EntityInstance entityInstance;
        EntityComponent entityComponent;
        Container container = this.getParent();
        if (!(container instanceof EntityComponent)) {
            return;
        }
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (true) {
            if (n3 == n2) {
                return;
            }
            entityComponent = (EntityComponent)container.getComponent(n3);
            entityInstance = entityComponent.getEntityInstance();
            entityInstance.nandMark(0x10000000);
            if (this == entityComponent) break;
            ++n3;
        }
        double d2 = entityInstance.widthRelLocal() * entityInstance.heightRelLocal();
        for (n = n3 - 1; n >= 0 && !((d = (entityInstance = (entityComponent = (EntityComponent)container.getComponent(n)).getEntityInstance()).widthRelLocal() * entityInstance.heightRelLocal()) <= d2); --n) {
        }
        if (++n != n3) {
            container.remove(n3);
            container.add((Component)this, n);
            return;
        }
        for (n = n3 + 1; n < n2 && !((d = (entityInstance = (entityComponent = (EntityComponent)container.getComponent(n)).getEntityInstance()).widthRelLocal() * entityInstance.heightRelLocal()) >= d2); ++n) {
        }
        if (--n != n3) {
            container.remove(n3);
            container.add((Component)this, n);
        }
    }

    public void resetDstCardinals(int n) {
        if (this.m_dstCardinals == null) {
            if (n > 0) {
                this.m_dstCardinals = new Cardinal[n];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Cardinal cardinal = this.m_dstCardinals[i];
                if (cardinal == null) continue;
                cardinal.reset();
            }
        }
    }

    public Cardinal[] getDstCardinals() {
        return this.m_dstCardinals;
    }

    public void resetSrcCardinals(int n) {
        if (this.m_srcCardinals == null) {
            if (n > 0) {
                this.m_srcCardinals = new SrcCardinal[n];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                SrcCardinal srcCardinal = this.m_srcCardinals[i];
                if (srcCardinal == null) continue;
                srcCardinal.reset();
            }
        }
    }

    public Cardinal[] getSrcCardinals() {
        return this.m_srcCardinals;
    }

    public void setAvgX(double d) {
        this.m_avgX = d;
    }

    public double getAvgX() {
        return this.m_avgX;
    }

    public static void paintImage(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        block7: for (int i = 16; i != 0; i >>= 1) {
            if ((i & n) == 0) continue;
            switch (i) {
                case 1: {
                    int n6 = n4;
                    if (n5 < n6) {
                        n6 = n5;
                    }
                    int n7 = n2 + n4 / 2;
                    int n8 = n3 + n5 / 2;
                    graphics.drawOval(n7 - n6 / 10, n8 - 7 * n6 / 20, n6 / 5, n6 / 5);
                    graphics.drawLine(n7, n8 - 3 * n6 / 20, n7, n8 + 3 * n6 / 20);
                    graphics.drawLine(n7 - n6 / 4, n8 - n6 / 20, n7 + n6 / 4, n8 - n6 / 20);
                    graphics.drawLine(n7, n8 + 3 * n6 / 20, n7 - n6 / 5, n8 + 2 * n6 / 5);
                    graphics.drawLine(n7, n8 + 3 * n6 / 20, n7 + n6 / 5, n8 + 2 * n6 / 5);
                    continue block7;
                }
                case 2: {
                    graphics.drawOval(n2, n3, n4, n5);
                    continue block7;
                }
                case 4: {
                    graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
                    continue block7;
                }
                case 8: {
                    int n6 = n4 / 5;
                    int n7 = n5 / 5;
                    int n8 = Math.min(n6, n7);
                    graphics.drawRoundRect(n2, n3, n4 - 1, n5 - 1, n8, n8);
                    continue block7;
                }
                case 16: {
                    int n6 = n4;
                    if (n5 < n6) {
                        n6 = n5;
                    }
                    int n7 = n2 + n4 / 2;
                    int n8 = n3 + n5 / 2;
                    graphics.drawLine(n7 - n6 / 4, n8 - n6 / 4, n7 + n6 / 4, n8 + n6 / 4);
                    graphics.drawLine(n7 + n6 / 4, n8 - n6 / 4, n7 - n6 / 4, n8 + n6 / 4);
                    continue block7;
                }
            }
        }
    }

    private static void draw3DRectRaised(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        Color color3 = Color.white;
        Color color4 = Color.darkGray;
        if (!ArrowDimensions.isBlackWhite3D()) {
            color3 = color.brighter();
            color4 = color.darker();
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n + ArrowDimensions.m_pixels_3d, n2 + ArrowDimensions.m_pixels_3d, n3 - 2 * ArrowDimensions.m_pixels_3d, n4 - 2 * ArrowDimensions.m_pixels_3d);
        }
        graphics.setColor(color3);
        graphics.fillRect(n, n2, ArrowDimensions.m_pixels_3d, n4);
        graphics.fillRect(n + ArrowDimensions.m_pixels_3d, n2, n3 - ArrowDimensions.m_pixels_3d, ArrowDimensions.m_pixels_3d);
        graphics.setColor(color4);
        graphics.fillRect(n + ArrowDimensions.m_pixels_3d, n2 + n4 - ArrowDimensions.m_pixels_3d, n3 - ArrowDimensions.m_pixels_3d, ArrowDimensions.m_pixels_3d);
        graphics.fillRect(n + n3 - ArrowDimensions.m_pixels_3d, n2, ArrowDimensions.m_pixels_3d, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2, n + ArrowDimensions.m_pixels_3d - 1, n2 + ArrowDimensions.m_pixels_3d - 1);
    }

    private static void draw3DRectSunken(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        Color color3 = Color.white;
        Color color4 = Color.darkGray;
        if (!ArrowDimensions.isBlackWhite3D()) {
            color3 = color.brighter();
            color4 = color.darker();
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n + ArrowDimensions.m_pixels_3d, n2 + ArrowDimensions.m_pixels_3d, n3 - 2 * ArrowDimensions.m_pixels_3d, n4 - 2 * ArrowDimensions.m_pixels_3d);
        }
        graphics.setColor(color4);
        graphics.fillRect(n, n2, ArrowDimensions.m_pixels_3d, n4);
        graphics.fillRect(n + ArrowDimensions.m_pixels_3d, n2, n3 - ArrowDimensions.m_pixels_3d, ArrowDimensions.m_pixels_3d);
        graphics.setColor(color3);
        graphics.fillRect(n + ArrowDimensions.m_pixels_3d, n2 + n4 - ArrowDimensions.m_pixels_3d, n3 - ArrowDimensions.m_pixels_3d, ArrowDimensions.m_pixels_3d);
        graphics.fillRect(n + n3 - ArrowDimensions.m_pixels_3d, n2, ArrowDimensions.m_pixels_3d, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(n + n3 - ArrowDimensions.m_pixels_3d, n2 + n4 - ArrowDimensions.m_pixels_3d, n + n3 - 1, n2 + n4 - 1);
    }

    public static void paintShape(Graphics graphics, EntityInstance entityInstance, int n, int n2, int n3, int n4, boolean bl, Color color) {
        if (n3 > 0 && n4 > 0) {
            int n5;
            int n6;
            int[] nArray = m_xp;
            int[] nArray2 = m_yp;
            int n7 = 0;
            int n8 = 0;
            int n9 = entityInstance.isDrawRoot() ? 0 : entityInstance.getInheritedStyle();
            int n10 = entityInstance.isDrawRoot() ? 0 : entityInstance.getClassDirection();
            Color color2 = !bl ? null : (color != null ? color : (entityInstance.red_closed() ? Color.red.darker() : entityInstance.getCurrentObjectColor()));
            Color color3 = entityInstance.red_open() ? Color.red.darker() : Color.black;
            switch (n9) {
                case 0: {
                    EntityComponent.draw3DRectRaised(graphics, color3, color2, n, n2, n3 - 1, n4 - 1);
                    break;
                }
                case 24: {
                    EntityComponent.draw3DRectSunken(graphics, color3, color2, n, n2, n3 - 1, n4 - 1);
                    break;
                }
                case 1: {
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.fillRect(n, n2, n3, n4);
                    }
                    graphics.setColor(color3);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    break;
                }
                case 2: {
                    int n11 = Math.min(Math.min(n3, n4) / 2, 16);
                    nArray[0] = n;
                    nArray2[0] = n2;
                    nArray[1] = n + n3 - n11;
                    nArray2[1] = n2;
                    nArray[2] = n + n3 - 1;
                    nArray2[2] = n2 + n11;
                    nArray[3] = nArray[2];
                    nArray2[3] = n2 + n4 - 1;
                    nArray[4] = n;
                    nArray2[4] = nArray2[3];
                    nArray[5] = nArray[0];
                    nArray2[5] = nArray2[0];
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.fillPolygon(nArray, nArray2, 6);
                    }
                    graphics.setColor(color3);
                    graphics.drawPolygon(nArray, nArray2, 6);
                    nArray[0] = nArray[1];
                    nArray2[0] = nArray2[2];
                    nArray[3] = nArray[0];
                    nArray2[3] = nArray2[0];
                    graphics.drawPolygon(nArray, nArray2, 4);
                    break;
                }
                case 3: {
                    int n11 = Math.min(Math.min(n3, n4) / 2, 8);
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.fillRect(n, n2 + n11 / 2, n3, n4 - n11);
                        graphics.fillOval(n, n2, n3, n11);
                        graphics.fillOval(n, n2 + n4 - n11, n3, n11);
                    }
                    graphics.setColor(color3);
                    graphics.drawOval(n, n2, n3, n11);
                    graphics.drawArc(n, n2 + n4 - n11 - 1, n3, n11, 180, 180);
                    graphics.drawLine(n, n2 + n11 / 2, n, n2 + n4 - n11 / 2);
                    graphics.drawLine(n + n3 - 1, n2 + n11 / 2, n + n3 - 1, n2 + n4 - n11 / 2);
                    break;
                }
                case 4: {
                    int n11 = (int)((double)n3 * 0.4);
                    int n12 = Math.max(3, Math.min(8, (int)((double)n4 * 0.2)));
                    int n13 = 4;
                    if (n11 < 75) {
                        n11 += n11 / 2;
                    }
                    if (n11 < 10) {
                        n11 = Math.min(n11 + 4, n3 - n3 / 3);
                        n13 = 0;
                    }
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.fillRect(n, n2, n3 - 1, n4 - 1);
                    }
                    graphics.setColor(color3);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    int n14 = n;
                    int n15 = n2 + n12;
                    int n16 = n + n3 - 1;
                    int n17 = n15;
                    if (entityInstance.isOpen()) {
                        graphics.drawLine(n14, n15, n16, n17);
                        break;
                    }
                    int n18 = n + n13;
                    int n19 = n2 + n12;
                    graphics.drawLine(n14, n15, n18, n19);
                    int n20 = n18 + n12 / 2;
                    n6 = n2;
                    graphics.drawLine(n18, n19, n20, n6);
                    int n21 = n + n11;
                    int n22 = n6;
                    graphics.drawLine(n20, n6, n21, n22);
                    int n23 = n21 + n12 / 2;
                    int n24 = n15;
                    graphics.drawLine(n21, n22, n23, n24);
                    graphics.drawLine(n23, n24, n16, n17);
                    break;
                }
                case 5: {
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.fillOval(n, n2, n3, n4);
                    }
                    graphics.setColor(color3);
                    graphics.drawOval(n, n2, n3, n4);
                    break;
                }
                case 6: {
                    int n11 = n3 / 4;
                    int n12 = n4 / 4;
                    int n13 = Math.min(n11, n12);
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.fillRoundRect(n, n2, n3 - 1, n4 - 1, n13, n13);
                    }
                    graphics.setColor(color3);
                    graphics.drawRoundRect(n, n2, n3 - 1, n4 - 1, n13, n13);
                    break;
                }
                case 7: {
                    graphics.setColor(color2);
                    Util.drawOutlineBox(graphics, n, n2, n3, n4);
                    break;
                }
                case 8: {
                    graphics.setColor(color2);
                    Util.drawGroupBox(graphics, n, n2, n3, n4, entityInstance.getEntityLabel());
                    break;
                }
                case 9: {
                    switch (n10) {
                        case 0: {
                            nArray[0] = n;
                            nArray2[0] = n2 + n4 - 1;
                            nArray[1] = n + n3 / 2;
                            nArray2[1] = n2;
                            nArray[2] = n + n3 - 1;
                            nArray2[2] = nArray2[0];
                            break;
                        }
                        case 1: {
                            nArray[0] = n;
                            nArray2[0] = n2;
                            nArray[1] = n + n3 - 1;
                            nArray2[1] = n2 + n4 / 2;
                            nArray[2] = nArray[0];
                            nArray2[2] = n2 + n4 - 1;
                            break;
                        }
                        case 2: {
                            nArray[0] = n;
                            nArray2[0] = n2;
                            nArray[1] = n + n3 - 1;
                            nArray2[1] = nArray2[0];
                            nArray[2] = n + n3 / 2;
                            nArray2[2] = n2 + n4 - 1;
                            break;
                        }
                        case 3: {
                            nArray[0] = n + n3 - 1;
                            nArray2[0] = n2;
                            nArray[1] = n;
                            nArray2[1] = n2 + n4 / 2;
                            nArray[2] = nArray[0];
                            nArray2[2] = n2 + n4 - 1;
                        }
                    }
                    n7 = 4;
                    break;
                }
                case 10: {
                    switch (n10) {
                        case 0: {
                            nArray[0] = n;
                            nArray2[0] = n2 + n4 - 1;
                            nArray[1] = n + n3 / 5;
                            nArray2[1] = n2;
                            nArray[2] = n + n3 - 1;
                            nArray2[2] = n2;
                            nArray[3] = n + n3 * 4 / 5;
                            nArray2[3] = n2 + n4 - 1;
                            break;
                        }
                        case 1: {
                            nArray[0] = n;
                            nArray2[0] = n2;
                            nArray[1] = n + n3 - 1;
                            nArray2[1] = n2 + n4 / 5;
                            nArray[2] = nArray[1];
                            nArray2[2] = n2 + n4 - 1;
                            nArray[3] = nArray[0];
                            nArray2[3] = n2 + 4 * n4 / 5;
                            break;
                        }
                        case 2: {
                            nArray[0] = n + n3 / 5;
                            nArray2[0] = n2 + n4 - 1;
                            nArray[1] = n;
                            nArray2[1] = n2;
                            nArray[2] = n + 4 * n3 / 5;
                            nArray2[2] = n2;
                            nArray[3] = n + n3 - 1;
                            nArray2[3] = n2 + n4 - 1;
                            break;
                        }
                        case 3: {
                            nArray[0] = n;
                            nArray2[0] = n2 + n4 / 5;
                            nArray[1] = n + n3 - 1;
                            nArray2[1] = n2;
                            nArray[2] = nArray[1];
                            nArray2[2] = n2 + 4 * n4 / 5;
                            nArray[3] = nArray[0];
                            nArray2[3] = n2 + n4 - 1;
                        }
                    }
                    n7 = 5;
                    break;
                }
                case 11: {
                    switch (n10) {
                        case 0: {
                            nArray[0] = n;
                            nArray2[0] = n2 + n4 - 1;
                            nArray[1] = n + n3 / 5;
                            nArray2[1] = n2;
                            nArray[2] = n + 4 * n3 / 5;
                            nArray2[2] = nArray2[1];
                            nArray[3] = n + n3 - 1;
                            nArray2[3] = nArray2[0];
                            break;
                        }
                        case 1: {
                            nArray[0] = n;
                            nArray2[0] = n2;
                            nArray[1] = n + n3 - 1;
                            nArray2[1] = n2 + n4 / 5;
                            nArray[2] = nArray[1];
                            nArray2[2] = n2 + 4 * n4 / 5;
                            nArray[3] = nArray[0];
                            nArray2[3] = n2 + n4 - 1;
                            break;
                        }
                        case 2: {
                            nArray[0] = n;
                            nArray2[0] = n2;
                            nArray[1] = n + n3 - 1;
                            nArray2[1] = nArray2[0];
                            nArray[2] = n + 4 * n3 / 5;
                            nArray2[2] = n2 + n4 - 1;
                            nArray[3] = n + n3 / 5;
                            nArray2[3] = nArray2[2];
                            break;
                        }
                        case 3: {
                            nArray[0] = n + n3 - 1;
                            nArray2[0] = n2;
                            nArray[1] = n;
                            nArray2[1] = n2 + n4 / 5;
                            nArray[2] = nArray[1];
                            nArray2[2] = n2 + 4 * n4 / 5;
                            nArray[3] = nArray[0];
                            nArray2[3] = n2 + n4 - 1;
                        }
                    }
                    n7 = 5;
                    break;
                }
                case 12: {
                    n8 = 3;
                    break;
                }
                case 13: {
                    n8 = 4;
                    break;
                }
                case 14: {
                    n8 = 5;
                    break;
                }
                case 15: {
                    n8 = 6;
                    break;
                }
                case 16: {
                    n8 = 8;
                    break;
                }
                case 17: {
                    n8 = 10;
                    break;
                }
                case 18: {
                    n8 = 12;
                    break;
                }
                case 19: {
                    n8 = 14;
                    break;
                }
                case 20: {
                    n8 = 16;
                    break;
                }
                case 21: {
                    n8 = 18;
                    break;
                }
                case 22: {
                    n8 = 20;
                    break;
                }
                case 23: {
                    int n11 = n2 + n4 * 4 / 5;
                    nArray[0] = n + 3 * n3 / 8;
                    nArray2[0] = n11;
                    nArray[1] = nArray[0];
                    nArray2[1] = n2 + 193 * n4 / 200;
                    nArray[2] = n + 2 * n3 / 3;
                    nArray2[2] = n11;
                    nArray[3] = nArray[0];
                    nArray2[3] = nArray2[0];
                    if (bl) {
                        graphics.setColor(color2);
                        graphics.fillRect(n, n2, n3, n4 * 4 / 5);
                        graphics.fillArc(n, n2 + n4 / 2, n3 / 2, n4 / 2, -180, 180);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    }
                    graphics.setColor(color3);
                    graphics.drawLine(n, n2, n, n2 + n4 * 3 / 4);
                    graphics.drawLine(n, n2, n + n3 - 1, n2);
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n11);
                    graphics.drawLine(n + 2 * n3 / 3, n11, n + n3 - 1, n11);
                    graphics.drawArc(n, n2 + n4 / 2 - 1, n3 / 2, n4 / 2 - 1, -180, 120);
                    graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                    break;
                }
            }
            if (n8 != 0) {
                n7 = n8 + 1;
                double d = Math.toRadians(entityInstance.getClassAngle() - 90.0);
                double d2 = Math.PI * 2 / (double)n8;
                double d3 = n3;
                double d4 = n4;
                for (n6 = 0; n6 < n8; ++n6) {
                    nArray[n6] = n + (int)(d3 * (1.0 + Math.cos(d)) * 0.5);
                    nArray2[n6] = n2 + (int)(d4 * (1.0 + Math.sin(d)) * 0.5);
                    d -= d2;
                }
            }
            if (n7 != 0) {
                nArray[n7 - 1] = nArray[0];
                nArray2[n7 - 1] = nArray2[0];
                if (bl) {
                    graphics.setColor(color2);
                    graphics.fillPolygon(nArray, nArray2, n7);
                }
                graphics.setColor(color3);
                graphics.drawPolygon(nArray, nArray2, n7);
            }
            if (!entityInstance.isDrawRoot() && !entityInstance.isOpen() && (n5 = entityInstance.getClassImage()) != 0) {
                graphics.setColor(color2);
                Color color4 = ColorCache.getInverse(color2.getRGB());
                graphics.setColor(color4);
                EntityComponent.paintImage(graphics, n5, n, n2, n3, n4);
            }
        }
    }

    public void paintMap(Graphics graphics, int n, int n2, int n3, int n4, EntityInstance entityInstance, int n5) {
        if (n3 > 0 && n4 > 0) {
            EntityInstance entityInstance2 = this.m_entityInstance;
            Color color = entityInstance2 == entityInstance ? Color.green : entityInstance2.getInheritedObjectColor();
            EntityComponent.paintShape(graphics, this.m_entityInstance, n, n2, n3, n4, !entityInstance2.hasChildren() || n5 == 1, color);
            if (n5 < 1) {
                Enumeration enumeration = entityInstance2.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
                    int n6 = n + (int)((double)n3 * entityInstance3.xRelLocal());
                    int n7 = n2 + (int)((double)n4 * entityInstance3.yRelLocal());
                    int n8 = (int)((double)n3 * entityInstance3.widthRelLocal());
                    int n9 = (int)((double)n4 * entityInstance3.heightRelLocal());
                    entityInstance3.paintMap(graphics, n6, n7, n8, n9, entityInstance, n5 + 1);
                }
            }
        }
    }

    protected void drawTopLeftLabel(Graphics graphics) {
        EntityInstance entityInstance = this.m_entityInstance;
        switch (entityInstance.getInheritedStyle()) {
            case 4: {
                graphics.setFont(EntityInstance.getSmallFont());
                int n = (int)((double)this.getWidth() * 0.4);
                int n2 = Math.max(3, Math.min(8, (int)((double)this.getHeight() * 0.2)));
                if (n < 75) {
                    n += n / 2;
                }
                if (n < 10) {
                    n = Math.min(n + 4, this.getWidth() - this.getWidth() / 3);
                }
                Util.drawStringWrapped(graphics, entityInstance.getEntityLabel(), 4 + n2 / 2 + 2, 0.0, n, this.getHeight() - 10, false, false);
                break;
            }
            case 6: {
                graphics.setFont(EntityInstance.getOpenClassFont());
                Util.drawStringWrapped(graphics, entityInstance.getEntityLabel(), 15.0, 5.0, this.getWidth() - 10, this.getHeight() - 10, false, false);
                break;
            }
            default: {
                graphics.setFont(EntityInstance.getSmallFont());
                Util.drawStringWrapped(graphics, entityInstance.getEntityLabel(), 5.0, 5.0, this.getWidth() - 10, this.getHeight() - 10, false, false);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        EntityInstance entityInstance = this.m_entityInstance;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = 5;
        String string = entityInstance.getEntityLabel();
        if (!entityInstance.isMarked(0x10000000)) {
            this.computeShading();
        }
        if (entityInstance.isMarked(0x20000000)) {
            int n5 = ArrowDimensions.m_shadow_size;
            int n6 = (n2 > n3 ? n3 : n2) >> 1;
            if (n5 > n6) {
                n5 = n6;
            }
            if (n5 > 0) {
                Color color = entityInstance.red_closed() ? Color.red.darker() : entityInstance.getCurrentObjectColor();
                color = color.darker();
                EntityComponent.paintShape(graphics, this.m_entityInstance, n5, n5, n2 -= n5, n3 -= n5, true, color);
            }
        }
        EntityComponent.paintShape(graphics, this.m_entityInstance, 0, 0, n2, n3, true, null);
        Diagram diagram = entityInstance.getDiagram();
        LandscapeEditorCore landscapeEditorCore = diagram.getLs();
        if (landscapeEditorCore.isShowGrid() && entityInstance == diagram.getDrawRoot()) {
            int n7 = diagram.getGrid();
            if (n7 > 1) {
                graphics.setColor(diagram.getGridColor());
                for (n = n7; n < n3; n += n7) {
                    graphics.drawLine(0, n, n2 - 1, n);
                }
                for (n = n7; n < n2; n += n7) {
                    graphics.drawLine(n, 0, n, n3 - 1);
                }
            }
        }
        if (entityInstance.isMarked(4096)) {
            graphics.setColor(Color.white);
            graphics.drawRect(0, 0, n2, n3);
            graphics.drawRect(1, 1, n2 - 1, n3 - 1);
        }
        if (entityInstance.close_with_children_under_drawroot() && n2 > 11 && n3 > 17) {
            graphics.setColor(ColorCache.getInverse(entityInstance.getInheritedObjectColor().getRGB()));
            graphics.drawRect(3, 9, 8, 8);
            graphics.drawLine(4, 13, 10, 13);
            graphics.drawLine(7, 10, 7, 16);
            n4 += 11;
        }
        graphics.setColor(entityInstance.getCurrentLabelColor());
        switch (entityInstance.getInheritedStyle()) {
            case 8: {
                Util.drawGroupBoxLabel(graphics, 0, 0, n2, string);
                break;
            }
            default: {
                boolean bl3;
                int n8 = this.getWidth() - 5 - n4;
                if (entityInstance.isOpen()) {
                    bl3 = false;
                    switch (entityInstance.getInheritedStyle()) {
                        case 4: {
                            graphics.setFont(EntityInstance.getSmallFont());
                            int n9 = (int)((double)this.getWidth() * 0.4);
                            n = Math.max(3, Math.min(8, (int)((double)this.getHeight() * 0.2)));
                            if (n9 < 75) {
                                n9 += n9 / 2;
                            }
                            if (n9 < 10) {
                                n9 = Math.min(n9 + 4, this.getWidth() - this.getWidth() / 3);
                            }
                            n4 = 4 + n / 2 + 2;
                            break;
                        }
                        case 6: {
                            graphics.setFont(EntityInstance.getOpenClassFont());
                            break;
                        }
                        default: {
                            graphics.setFont(EntityInstance.getSmallFont());
                            break;
                        }
                    }
                } else {
                    bl3 = true;
                    if (!entityInstance.isMarked(6)) {
                        graphics.setFont(entityInstance.getAdjustedClosedFont());
                    } else {
                        graphics.setFont(ClientSupplierSet.getClientSupplierFont());
                        EntityInstance entityInstance2 = entityInstance.getContainedBy();
                        if (entityInstance2 != null) {
                            string = entityInstance2.getEntityLabel() + " .\n" + string;
                        }
                    }
                }
                Util.drawStringWrapped(graphics, string, n4, 5.0, n8, this.getHeight() - 10, bl3, false);
            }
        }
        if (entityInstance.getGroupFlag()) {
            int n10;
            graphics.setColor(entityInstance.getInheritedLabelColor());
            int n11 = n10 = n3 < 20 ? 4 : 6;
            if (entityInstance.getGroupKeyFlag()) {
                graphics.fillRect(1, 1, n10, n10);
                graphics.fillRect(n2 / 2 - n10 / 2, 1, n10, n10);
                graphics.fillRect(n2 - n10, 1, n10, n10);
                graphics.fillRect(1, n3 / 2 - n10 / 2, n10, n10);
                graphics.fillRect(n2 - n10, n3 / 2 - n10 / 2, n10, n10);
                graphics.fillRect(1, n3 - n10, n10, n10);
                graphics.fillRect(n2 / 2 - n10 / 2, n3 - n10, n10, n10);
                graphics.fillRect(n2 - n10, n3 - n10, n10, n10);
            } else {
                graphics.drawRect(1, 1, n10, n10);
                graphics.drawRect(n2 / 2 - n10 / 2, 1, n10, n10);
                graphics.drawRect(n2 - n10 - 1, 1, n10, n10);
                graphics.drawRect(1, n3 / 2 - n10 / 2, n10, n10);
                graphics.drawRect(n2 - n10 - 1, n3 / 2 - n10 / 2, n10, n10);
                graphics.drawRect(1, n3 - n10 - 1, n10, n10);
                graphics.drawRect(n2 / 2 - n10 / 2, n3 - n10 - 1, n10, n10);
                graphics.drawRect(n2 - n10 - 1, n3 - n10 - 1, n10, n10);
            }
        }
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.translate(n, n2);
        this.paintComponent(graphics);
    }
}

