/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Cardinal;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.DiagramCoordinates;
import lsedit.EdgePoint;
import lsedit.EntityBelow;
import lsedit.EntityCache;
import lsedit.EntityChildren;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.EntityParents;
import lsedit.EntityPosition;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject3D;
import lsedit.MsgOut;
import lsedit.MyUndoableEdit;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.SrcCardinal;
import lsedit.Ta;
import lsedit.Util;

public class EntityInstance
extends LandscapeObject3D
implements Icon,
DiagramCoordinates,
MouseListener,
MouseMotionListener {
    public static final int SMALL_FONT = 0;
    public static final int REG_FONT = 1;
    public static final String LABEL_ID = "label";
    public static final String XPOSITION_ID = "x";
    public static final String YPOSITION_ID = "y";
    public static final String WIDTH_ID = "width";
    public static final String HEIGHT_ID = "height";
    public static final String XRELPOSITION_ID = "xrel";
    public static final String YRELPOSITION_ID = "yrel";
    public static final String WIDTHREL_ID = "widthrel";
    public static final String HEIGHTREL_ID = "heightrel";
    public static final String IN_ELISION_ID = "elision";
    public static final String OUT_ELISION_ID = "outelision";
    public static final String CLIENT_ELISION_ID = "clientelision";
    public static final String SUPPLIER_ELISION_ID = "supplierelision";
    public static final String INTERNAL_ELISION_ID = "internalelision";
    public static final String AGG_ELISION_ID = "aggelision";
    public static final String NAVLINK_ID = "navlink";
    public static final String INPOINT_ID = "inpoints";
    public static final String OUTPOINT_ID = "outpoints";
    public static final String LEFTPOINT_ID = "leftpoints";
    public static final String RIGHTPOINT_ID = "rightpoints";
    public static final String DESC_ID = "description";
    public static final String TITLE_ID = "title";
    public static final String FONTDELTA_ID = "fontdelta";
    public static final int ID_ATTR = 0;
    public static final int CLASS_ATTR = 1;
    public static final int LABEL_ATTR = 2;
    public static final int TITLE_ATTR = 3;
    public static final int DESC_ATTR = 4;
    public static final int COLOR_ATTR = 5;
    public static final int LABEL_COLOR_ATTR = 6;
    public static final int OPEN_COLOR_ATTR = 7;
    public static final int XRELPOSITION_ATTR = 8;
    public static final int YRELPOSITION_ATTR = 9;
    public static final int WIDTHREL_ATTR = 10;
    public static final int HEIGHTREL_ATTR = 11;
    public static final int FONTDELTA_ATTR = 12;
    public static final int ATTRS = 13;
    public static final String[] attributeName = new String[]{"id", "class", "label", "title", "description", "color", "labelcolor", "opencolor", "xrel", "yrel", "widthrel", "heightrel", "fontdelta"};
    public static final int[] attributeType = new int[]{3, 15, 3, 3, 12, 8, 8, 8, 2, 2, 2, 2, 1};
    public static final int RSZ_NONE = -1;
    private static final int RSZ_NW = 0;
    private static final int RSZ_N = 1;
    private static final int RSZ_NE = 2;
    private static final int RSZ_E = 3;
    private static final int RSZ_SE = 4;
    private static final int RSZ_S = 5;
    private static final int RSZ_SW = 6;
    private static final int RSZ_W = 7;
    private static final double TAB_HEIGHT = 16.0;
    private static final int MOUSE_NEAR_EDGE_THRESHOLD = 4;
    private static final int SEP_THRESHOLD = 8;
    private static final int MARGIN = 5;
    private static final int MIN_HEIGHT = 10;
    private static final int MIN_WIDTH = 30;
    private static final int CONTENTS_FLAG_DIM = 8;
    public static final String DEFAULT_OPEN_CLASS_FONT_NAME = "Helvetica";
    public static final int DEFAULT_OPEN_CLASS_FONT_STYLE = 0;
    public static final int DEFAULT_OPEN_CLASS_FONT_SIZE = 12;
    protected static Font m_openClassFont = FontCache.get("Helvetica", 0, 12);
    public static final String DEFAULT_CLOSED_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CLOSED_FONT_STYLE = 0;
    public static final int DEFAULT_CLOSED_FONT_SIZE = 12;
    protected static Font m_closedFont = FontCache.get("Helvetica", 0, 12);
    public static final String DEFAULT_SMALL_FONT_NAME = "Helvetica";
    public static final int DEFAULT_SMALL_FONT_STYLE = 0;
    public static final int DEFAULT_SMALL_FONT_SIZE = 10;
    protected static Font m_smallFont = FontCache.get("Helvetica", 0, 10);
    public static final int DIAGRAM_MARK = 1;
    public static final int CLIENT_MARK = 2;
    public static final int SUPPLIER_MARK = 4;
    public static final int OMNIPRESENT_LIBRARY = 256;
    public static final int OMNIPRESENT_CLIENT = 512;
    public static final int OMNIPRESENT_SUPPLIER = 1024;
    public static final int HIGHLIGHT_EDGE_MARK = 4096;
    public static final int REDBOX_MARK = 32768;
    public static final int GROUP_MARK = 65536;
    public static final int GROUPKEY_MARK = 131072;
    public static final int OPEN_MARK = 262144;
    public static final int CLOSED_MARK = 524288;
    public static final int CLIENT_SUPPLIER = 6;
    public static final int IN_DIAGRAM = 7;
    public static final int PRESENTATION_MARKS = 233472;
    public static final int OMNIPRESENT_CS = 1536;
    public static final int OMNIPRESENT = 1792;
    public static final int IN_TREE_MARK = 0x100000;
    public static final int LIFTED_MARK = 0x200000;
    public static final int IN_GRAPH_MARK = 0x400000;
    public static final int DUMMY_NODE_MARK = 0x800000;
    public static final int HAS_LABEL_MARK = 0x1000000;
    public static final int DELETED_MARK = 0x2000000;
    public static final int SPRING_MARK = 0x4000000;
    public static final int SHADING_KNOWN_MARK = 0x10000000;
    public static final int SHADES_MARK = 0x20000000;
    public static final int EXPANDED_TOC_MARK = 0x40000000;
    public static final int PERMANENT_MARKS = 58722048;
    public static final double WIDTHRELLOCAL_DEFAULT = 0.9375;
    public static final double HEIGHTRELLOCAL_DEFAULT = 0.9375;
    private static EntityInstance m_currentDescEntity = null;
    private int m_mark = 0;
    private String m_title;
    private Vector m_dstElision;
    private Vector m_srcElision;
    private Vector m_enteringElision;
    private Vector m_exitingElision;
    private Vector m_internalElision;
    private EdgePoint[] m_topPoints;
    private EdgePoint[] m_bottomPoints;
    private EdgePoint[] m_leftPoints;
    private EdgePoint[] m_rightPoints;
    private int m_diagramX = Integer.MIN_VALUE;
    private int m_diagramY = Integer.MIN_VALUE;
    private int m_x;
    private int m_y;
    private int m_width;
    private int m_height;
    protected double m_xrelLocal = -1.0;
    protected double m_yrelLocal = -1.0;
    protected double m_widthrelLocal = -1.0;
    protected double m_heightrelLocal = -1.0;
    protected EntityPosition[] m_positions = null;
    private int m_fontDelta = 0;
    private int m_preorder;
    private int m_postorder;
    private Vector m_srcRelList = new Vector();
    private Vector m_dstRelList = new Vector();
    private Vector m_srcLiftedList = new Vector();
    private Vector m_dstLiftedList = new Vector();
    protected static Hashtable est = new Hashtable();

    public EntityComponent neededPlainComponent() {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent == null) {
            entityComponent = new EntityComponent(this);
        }
        return entityComponent;
    }

    public void setToolTipText(EntityComponent entityComponent) {
        String string = this.isDrawRoot() ? null : this.getFullEntityLabel();
        entityComponent.setToolTipText(string);
    }

    public void setToolTipText() {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent != null) {
            this.setToolTipText(entityComponent);
        }
    }

    public void areaMoved() {
        EntityComponent entityComponent;
        if (this.isMarked(0x10000000) && (entityComponent = (EntityComponent)this.getSwingObject()) != null) {
            entityComponent.areaMoved();
        }
    }

    public void areaChanged() {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent != null) {
            entityComponent.areaChanged();
        }
    }

    public EntityComponent neededComponent() {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent == null) {
            entityComponent = new EntityComponent(this);
            this.setToolTipText(entityComponent);
            entityComponent.addMouseListener(this);
            entityComponent.addMouseMotionListener(this);
        }
        return entityComponent;
    }

    private Vector neededDstElision() {
        Vector vector = this.m_dstElision;
        if (vector == null) {
            this.m_dstElision = vector = new Vector();
        }
        return vector;
    }

    private Vector neededSrcElision() {
        Vector vector = this.m_srcElision;
        if (vector == null) {
            this.m_srcElision = vector = new Vector();
        }
        return vector;
    }

    private Vector neededEnteringElision() {
        Vector vector = this.m_enteringElision;
        if (vector == null) {
            this.m_enteringElision = vector = new Vector();
        }
        return vector;
    }

    private Vector neededExitingElision() {
        Vector vector = this.m_exitingElision;
        if (vector == null) {
            this.m_exitingElision = vector = new Vector();
        }
        return vector;
    }

    private Vector neededInternalElision() {
        Vector vector = this.m_internalElision;
        if (vector == null) {
            this.m_internalElision = vector = new Vector();
        }
        return vector;
    }

    public static Font getClosedFont() {
        return m_closedFont;
    }

    public Font getAdjustedClosedFont() {
        Font font = m_closedFont;
        int n = this.m_fontDelta;
        if (n != 0) {
            String string = font.getFamily();
            int n2 = font.getStyle();
            int n3 = font.getSize();
            if ((n3 += n) < 1) {
                n3 = 1;
            }
            font = FontCache.get(string, n2, n3);
        }
        return font;
    }

    public static void setClosedFont(Font font) {
        m_closedFont = font;
    }

    public static Font getOpenClassFont() {
        return m_openClassFont;
    }

    public static void setOpenClassFont(Font font) {
        m_openClassFont = font;
    }

    public static Font getSmallFont() {
        return m_smallFont;
    }

    public static void setSmallFont(Font font) {
        m_smallFont = font;
    }

    public void removeTreeFromCache(EntityCache entityCache) {
        entityCache.remove(this);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.removeTreeFromCache(entityCache);
        }
    }

    public void addTreeToCache(EntityCache entityCache) {
        entityCache.put(this);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.addTreeToCache(entityCache);
        }
    }

    public void removeAll() {
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null) {
            jComponent.removeAll();
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            EntityComponent entityComponent = this.neededComponent();
            entityComponent.setVisible(true);
        } else {
            EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
            if (entityComponent != null) {
                entityComponent.setVisible(false);
            }
        }
    }

    public void repaint() {
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null) {
            jComponent.repaint();
        }
    }

    public void validate() {
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null) {
            jComponent.validate();
        }
    }

    public void paintMap(Graphics graphics, int n, int n2, int n3, int n4, EntityInstance entityInstance, int n5) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.paintMap(graphics, n, n2, n3, n4, entityInstance, n5);
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    protected EntityInstance getDrawRoot() {
        return this.getDiagram().getDrawRoot();
    }

    public boolean isDrawRoot() {
        return this == this.getDrawRoot();
    }

    protected int numRelationClasses() {
        return this.getTa().numRelationClasses();
    }

    protected RelationClass numToRelationClass(int n) {
        return this.getTa().numToRelationClass(n);
    }

    protected void setFont(Graphics graphics, int n) {
        switch (n) {
            case 0: {
                graphics.setFont(m_smallFont);
                return;
            }
        }
        graphics.setFont(this.getAdjustedClosedFont());
    }

    public int getFontDelta() {
        return this.m_fontDelta;
    }

    protected boolean setFontDelta(int n) {
        if (this.m_fontDelta != n) {
            this.m_fontDelta = n;
            this.repaint();
            return true;
        }
        return false;
    }

    public void updateFontDelta(int n) {
        int n2 = this.m_fontDelta;
        if (this.setFontDelta(n) && this.undoEnabled()) {
            new SetFontDelta(n2);
        }
    }

    public void shiftDeltaFont(int n) {
        this.updateFontDelta(this.m_fontDelta + n);
    }

    public Color getCurrentLabelColor() {
        if (this.isMarked(32768) && !this.isOpen()) {
            return Color.yellow;
        }
        return this.getInheritedLabelColor();
    }

    protected void parsePoints(EdgePoint[] edgePointArray, Attribute attribute) {
        AttributeValueItem attributeValueItem = attribute.avi;
        while (attributeValueItem != null) {
            RelationClass relationClass = this.getTa().getRelationClass(attributeValueItem.value);
            if (relationClass != null) {
                int n = relationClass.getNid();
                double d = Util.parseReal(attributeValueItem.next.value);
                double d2 = Util.parseReal(attributeValueItem.next.next.value);
                if (edgePointArray[n] == null) {
                    edgePointArray[n] = new EdgePoint(this);
                } else if (relationClass != edgePointArray[n].getRc()) {
                    MsgOut.println("Class nid mismatch");
                }
                edgePointArray[n].setProperties(relationClass, d, d2);
                edgePointArray[n].hasMoved();
            }
            attributeValueItem = attributeValueItem.nextList;
        }
    }

    protected void processElision(Attribute attribute, Vector vector) {
        AttributeValueItem attributeValueItem = attribute.avi;
        while (attributeValueItem != null) {
            String string = (String)est.get(attributeValueItem.value);
            if (string == null) {
                string = attributeValueItem.value;
                est.put(string, string);
            }
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            attributeValueItem = attributeValueItem.next;
        }
    }

    protected void processRawElision(String[] stringArray, Vector vector) {
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
    }

    protected boolean processFirstOrderAttributes(Attribute attribute) {
        AttributeValueItem attributeValueItem = attribute.avi;
        int n = 0;
        AttributeValueItem attributeValueItem2 = attributeValueItem;
        while (attributeValueItem2 != null) {
            ++n;
            attributeValueItem2 = attributeValueItem2.next;
        }
        if (attribute.hasId(XPOSITION_ID)) {
            if (n > 0) {
                this.setxLocal(attribute.parseReal());
                attribute.id = XRELPOSITION_ID;
            }
            return true;
        }
        if (attribute.hasId(YPOSITION_ID)) {
            if (n > 0) {
                this.setyLocal(attribute.parseReal());
                attribute.id = YRELPOSITION_ID;
            }
            return true;
        }
        if (attribute.hasId(WIDTH_ID)) {
            if (n > 0) {
                this.setwidthLocal(attribute.parseReal());
                attribute.id = WIDTHREL_ID;
            }
            return true;
        }
        if (attribute.hasId(HEIGHT_ID)) {
            if (n > 0) {
                this.setheightLocal(attribute.parseReal());
                attribute.id = HEIGHTREL_ID;
            }
            return true;
        }
        if (attribute.hasId(XRELPOSITION_ID)) {
            if (n > 0) {
                this.setXRelLocalBounded(attribute.parseReal());
                if (n > 1) {
                    this.setPositionArraySize(n);
                    EntityPosition[] entityPositionArray = this.m_positions;
                    int n2 = 0;
                    attributeValueItem2 = attributeValueItem;
                    while (attributeValueItem2 != null) {
                        EntityPosition entityPosition = entityPositionArray[n2];
                        if (entityPosition == null) {
                            this.m_positions[n2] = entityPosition = new EntityPosition();
                        }
                        entityPosition.m_xrelLocal = Util.parseReal(attributeValueItem2.value);
                        ++n2;
                        attributeValueItem2 = attributeValueItem2.next;
                    }
                }
            }
            return true;
        }
        if (attribute.hasId(YRELPOSITION_ID)) {
            if (n > 0) {
                this.setYRelLocalBounded(attribute.parseReal());
                if (n > 1) {
                    this.setPositionArraySize(n);
                    EntityPosition[] entityPositionArray = this.m_positions;
                    int n3 = 0;
                    attributeValueItem2 = attributeValueItem;
                    while (attributeValueItem2 != null) {
                        EntityPosition entityPosition = entityPositionArray[n3];
                        if (entityPosition == null) {
                            this.m_positions[n3] = entityPosition = new EntityPosition();
                        }
                        entityPosition.m_yrelLocal = Util.parseReal(attributeValueItem2.value);
                        ++n3;
                        attributeValueItem2 = attributeValueItem2.next;
                    }
                }
            }
            return true;
        }
        if (attribute.hasId(WIDTHREL_ID)) {
            if (n > 0) {
                this.setWidthRelLocalBounded(attribute.parseReal());
                if (n > 1) {
                    this.setPositionArraySize(n);
                    EntityPosition[] entityPositionArray = this.m_positions;
                    int n4 = 0;
                    attributeValueItem2 = attributeValueItem;
                    while (attributeValueItem2 != null) {
                        EntityPosition entityPosition = entityPositionArray[n4];
                        if (entityPosition == null) {
                            this.m_positions[n4] = entityPosition = new EntityPosition();
                        }
                        entityPosition.m_widthrelLocal = Util.parseReal(attributeValueItem2.value);
                        ++n4;
                        attributeValueItem2 = attributeValueItem2.next;
                    }
                }
            }
            return true;
        }
        if (attribute.hasId(HEIGHTREL_ID)) {
            if (n > 0) {
                this.setHeightRelLocalBounded(attribute.parseReal());
                if (n > 1) {
                    this.setPositionArraySize(n);
                    EntityPosition[] entityPositionArray = this.m_positions;
                    int n5 = 0;
                    attributeValueItem2 = attributeValueItem;
                    while (attributeValueItem2 != null) {
                        EntityPosition entityPosition = entityPositionArray[n5];
                        if (entityPosition == null) {
                            this.m_positions[n5] = entityPosition = new EntityPosition();
                        }
                        entityPosition.m_heightrelLocal = Util.parseReal(attributeValueItem2.value);
                        ++n5;
                        attributeValueItem2 = attributeValueItem2.next;
                    }
                }
            }
            return true;
        }
        if (attribute.hasId(LABEL_ID)) {
            if (n > 0) {
                this.setLabel(attribute.parseString());
            }
            return true;
        }
        if (attribute.hasId(DESC_ID)) {
            if (n > 0) {
                this.setDescription(attribute.parseString());
            }
            return true;
        }
        if (attribute.hasId(TITLE_ID)) {
            if (n > 0) {
                this.setTitle(attribute.parseString());
            }
            return true;
        }
        if (attribute.hasId(FONTDELTA_ID)) {
            if (n > 0) {
                this.setFontDelta(attribute.parseInt());
            }
            return true;
        }
        if (attribute.hasId("color")) {
            if (n > 0) {
                this.setObjectColor(attribute.parseColor());
            }
            return true;
        }
        if (attribute.hasId("opencolor")) {
            if (n > 0) {
                this.setColorWhenOpen(attribute.parseColor());
            }
            return true;
        }
        if (attribute.hasId("labelcolor")) {
            if (n > 0) {
                this.setLabelColor(attribute.parseColor());
            }
            return true;
        }
        if (attribute.hasId(IN_ELISION_ID)) {
            if (n > 0) {
                this.processElision(attribute, this.neededDstElision());
            }
            return true;
        }
        if (attribute.hasId(OUT_ELISION_ID)) {
            if (n > 0) {
                this.processElision(attribute, this.neededSrcElision());
            }
            return true;
        }
        if (attribute.hasId(CLIENT_ELISION_ID)) {
            if (n > 0) {
                this.processElision(attribute, this.neededEnteringElision());
            }
            return true;
        }
        if (attribute.hasId(SUPPLIER_ELISION_ID)) {
            if (n > 0) {
                this.processElision(attribute, this.neededExitingElision());
            }
            return true;
        }
        if (attribute.hasId(INTERNAL_ELISION_ID)) {
            if (n > 0) {
                this.processElision(attribute, this.neededInternalElision());
            }
            return true;
        }
        if (attribute.hasId(INPOINT_ID)) {
            if (n > 0) {
                if (this.m_topPoints == null) {
                    this.m_topPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.m_topPoints, attribute);
            }
            return true;
        }
        if (attribute.hasId(OUTPOINT_ID)) {
            if (n > 0) {
                if (this.m_bottomPoints == null) {
                    this.m_bottomPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.m_bottomPoints, attribute);
            }
            return true;
        }
        if (attribute.hasId(LEFTPOINT_ID)) {
            if (n > 0) {
                if (this.m_leftPoints == null) {
                    this.m_leftPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.m_leftPoints, attribute);
            }
            return true;
        }
        if (attribute.hasId(RIGHTPOINT_ID)) {
            if (n > 0) {
                if (this.m_rightPoints == null) {
                    this.m_rightPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.m_rightPoints, attribute);
            }
            return true;
        }
        return false;
    }

    public static void reportFirstOrderAttributes(ResultBox resultBox) {
        resultBox.addText(XRELPOSITION_ID);
        resultBox.addText(YRELPOSITION_ID);
        resultBox.addText(WIDTHREL_ID);
        resultBox.addText(HEIGHTREL_ID);
        resultBox.addText(LABEL_ID);
        resultBox.addText(DESC_ID);
        resultBox.addText(TITLE_ID);
        resultBox.addText(FONTDELTA_ID);
        resultBox.addText("color");
        resultBox.addText("opencolor");
        resultBox.addText("labelcolor");
        resultBox.addText(IN_ELISION_ID);
        resultBox.addText(OUT_ELISION_ID);
        resultBox.addText(CLIENT_ELISION_ID);
        resultBox.addText(SUPPLIER_ELISION_ID);
        resultBox.addText(INTERNAL_ELISION_ID);
        resultBox.addText(INPOINT_ID);
        resultBox.addText(OUTPOINT_ID);
        resultBox.addText(LEFTPOINT_ID);
        resultBox.addText(RIGHTPOINT_ID);
        resultBox.addResultTitle("Legacy first order attributes");
        resultBox.addText(XPOSITION_ID);
        resultBox.addText(YPOSITION_ID);
        resultBox.addText(WIDTH_ID);
        resultBox.addText(HEIGHT_ID);
    }

    public EntityInstance(EntityClass entityClass, String string) {
        this.setParentClass(entityClass);
        super.setLabel(string);
        this.setId(string);
    }

    public String getLabel() {
        if (this.isMarked(0x1000000)) {
            return super.getLabel();
        }
        return null;
    }

    public void setLabel(String string) {
        if (string == null || Util.isBlank(string)) {
            if (this.isMarked(0x1000000)) {
                super.setLabel(this.getId());
                this.m_mark &= 0xFEFFFFFF;
            }
        } else {
            super.setLabel(string);
            this.orMark(0x1000000);
        }
    }

    public String getEntityLabel() {
        return super.getLabel();
    }

    public String getFullEntityLabel() {
        if (this.isMarked(0x1000000)) {
            return super.getLabel();
        }
        return super.getId();
    }

    public String getClassLabel() {
        return this.getEntityClass().getLabel();
    }

    public void closeAll(String string) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.setContainElision(string);
            entityInstance.closeAll(string);
        }
    }

    public void openAll(String string) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearContainElision(string);
            entityInstance.openAll(string);
        }
    }

    public void shapeChanges(EntityClass entityClass) {
        if (entityClass == this.getParentClass()) {
            this.adjustEdgePoints();
            this.validateAllMyEdges();
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.shapeChanges(entityClass);
        }
    }

    public String getStyleName(int n) {
        return EntityClass.getEntityStyleName(n);
    }

    private void setPositionArraySize(int n) {
        EntityPosition[] entityPositionArray = this.m_positions;
        if (entityPositionArray == null) {
            this.m_positions = entityPositionArray = new EntityPosition[n];
        } else if (entityPositionArray.length < n) {
            EntityPosition[] entityPositionArray2 = entityPositionArray;
            this.m_positions = entityPositionArray = new EntityPosition[n];
            int n2 = entityPositionArray2.length;
            while (--n2 >= 0) {
                entityPositionArray[n2] = entityPositionArray2[n2];
            }
        }
    }

    public void exchangePositioning(int n, int n2, int n3) {
        EntityPosition entityPosition;
        this.setPositionArraySize(n3);
        EntityPosition[] entityPositionArray = this.m_positions;
        if (this.m_xrelLocal >= 0.0 || this.m_yrelLocal >= 0.0 || this.m_widthrelLocal >= 0.0 || this.m_heightrelLocal >= 0.0) {
            entityPosition = entityPositionArray[n];
            if (entityPosition == null) {
                entityPositionArray[n] = entityPosition = new EntityPosition();
            }
            entityPosition.m_xrelLocal = this.m_xrelLocal;
            entityPosition.m_yrelLocal = this.m_yrelLocal;
            entityPosition.m_widthrelLocal = this.m_widthrelLocal;
            entityPosition.m_heightrelLocal = this.m_heightrelLocal;
        }
        if ((entityPosition = entityPositionArray[n2]) == null) {
            this.m_xrelLocal = -1.0;
            this.m_yrelLocal = -1.0;
            this.m_widthrelLocal = -1.0;
            this.m_heightrelLocal = -1.0;
        } else {
            this.m_xrelLocal = entityPosition.m_xrelLocal;
            this.m_yrelLocal = entityPosition.m_yrelLocal;
            this.m_widthrelLocal = entityPosition.m_widthrelLocal;
            this.m_heightrelLocal = entityPosition.m_heightrelLocal;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.exchangePositioning(n, n2, n3);
        }
    }

    public String getTitle() {
        return this.m_title;
    }

    public boolean setTitle(String string) {
        if (string == null ? this.m_title == null : string.equals(this.m_title)) {
            return false;
        }
        this.m_title = string;
        return true;
    }

    public void updateTitle(String string) {
        String string2 = this.m_title;
        if (this.setTitle(string) && this.undoEnabled()) {
            new SetTitle(string2);
        }
    }

    public void addContainment(EntityInstance entityInstance) {
        if (entityInstance.inDiagram()) {
            EntityComponent entityComponent = this.neededComponent();
            EntityComponent entityComponent2 = entityInstance.neededComponent();
            this.nandMark(786432);
            entityComponent.add(entityComponent2);
        }
    }

    public void addUnder(JComponent jComponent) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.removeAll();
        this.orMark(1);
        if (this.isOpen()) {
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.addUnderEntity(this);
            }
        }
        jComponent.add(entityComponent);
    }

    public void addUnderEntity(EntityInstance entityInstance) {
        EntityClass entityClass = this.getEntityClass();
        if (entityClass.isShown()) {
            EntityComponent entityComponent = entityInstance.neededComponent();
            this.addUnder(entityComponent);
        }
    }

    public boolean removeContainment(EntityInstance entityInstance) {
        JComponent jComponent;
        JComponent jComponent2 = this.getSwingObject();
        if (jComponent2 != null && (jComponent = entityInstance.getSwingObject()) != null) {
            jComponent2.remove(jComponent);
        }
        entityInstance.m_mark &= 0x3800700;
        return true;
    }

    public RelationInstance getRelation(RelationClass relationClass, EntityInstance entityInstance) {
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass || relationInstance.getDst() != entityInstance) continue;
            return relationInstance;
        }
        return null;
    }

    public void addSrcRelation(RelationInstance relationInstance) {
        this.m_srcRelList.addElement(relationInstance);
    }

    public void addSrcRelationIfAbsent(RelationInstance relationInstance) {
        if (!this.m_srcRelList.contains(relationInstance)) {
            this.m_srcRelList.addElement(relationInstance);
        }
    }

    public void removeSrcRelation(RelationInstance relationInstance) {
        this.m_srcRelList.removeElement(relationInstance);
    }

    public void addDstRelation(RelationInstance relationInstance) {
        this.m_dstRelList.addElement(relationInstance);
    }

    public void addDstRelationIfAbsent(RelationInstance relationInstance) {
        if (!this.m_dstRelList.contains(relationInstance)) {
            this.m_dstRelList.addElement(relationInstance);
        }
    }

    public void removeDstRelation(RelationInstance relationInstance) {
        this.m_dstRelList.removeElement(relationInstance);
    }

    public void duplicateEdges(RelationClass relationClass, RelationClass relationClass2) {
        Ta ta = this.getTa();
        Vector vector = this.m_srcRelList;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            RelationInstance relationInstance = (RelationInstance)vector.elementAt(i);
            RelationClass relationClass3 = relationInstance.getRelationClass();
            if (relationClass3.isContainsClass()) {
                relationInstance.getDst().duplicateEdges(relationClass, relationClass2);
            }
            if (relationClass3 != relationClass) continue;
            ta.getNewRelation(relationClass2, this, relationInstance.getDst());
        }
    }

    public void addAttribute(Attribute attribute) {
        if (this.processFirstOrderAttributes(attribute)) {
            return;
        }
        super.addAttribute(attribute);
    }

    public void assignAttributes(Attribute attribute) {
        while (attribute != null) {
            if (attribute.avi == null) {
                MsgOut.println("Null attribute assignment");
            } else if (!this.processFirstOrderAttributes(attribute)) {
                Attribute attribute2 = this.getLsAttribute(attribute.id);
                if (attribute2 == null) {
                    this.putLsAttribute(attribute);
                } else {
                    if (attribute2.m_cloneOnAssign) {
                        attribute2 = (Attribute)attribute2.clone();
                        attribute2.m_cloneOnAssign = false;
                        this.replaceAttribute(attribute2);
                    }
                    attribute2.avi = attribute.avi;
                }
            }
            attribute = attribute.next;
        }
    }

    public void validateAllMyEdgesForClass(RelationClass relationClass) {
        RelationInstance relationInstance;
        Enumeration enumeration = this.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass) continue;
            if (relationInstance.m_drawSrc != this) {
                System.out.println("validateAllMyEdges() " + this + " drawsrc " + relationInstance.m_drawSrc);
                continue;
            }
            relationInstance.validate();
        }
        enumeration = this.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass) continue;
            if (relationInstance.m_drawDst != this) {
                System.out.println("validateAllMyEdges() " + this + " drawdst " + relationInstance.m_drawDst);
                continue;
            }
            relationInstance.validate();
        }
    }

    public void validateAllMyEdges() {
        RelationInstance relationInstance;
        Enumeration enumeration = this.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.m_drawSrc != this) {
                System.out.println("validateAllMyEdges() " + this + " drawsrc " + relationInstance.m_drawSrc);
                continue;
            }
            relationInstance.validate();
        }
        enumeration = this.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.m_drawDst != this) {
                System.out.println("validateAllMyEdges() " + this + " drawdst " + relationInstance.m_drawDst);
                continue;
            }
            relationInstance.validate();
        }
    }

    protected void rescale(EdgePoint[] edgePointArray) {
        if (edgePointArray != null) {
            for (int i = 0; i < edgePointArray.length; ++i) {
                if (edgePointArray[i] == null) continue;
                edgePointArray[i].clearRc();
            }
        }
    }

    protected void adjustEdgePoints(EdgePoint[] edgePointArray) {
        if (edgePointArray != null) {
            for (int i = 0; i < edgePointArray.length; ++i) {
                EdgePoint edgePoint = edgePointArray[i];
                if (edgePoint == null) continue;
                edgePoint.adjustEdgePoint();
                edgePoint.rescale();
            }
        }
    }

    protected void adjustEdgePoints() {
        this.adjustEdgePoints(this.m_topPoints);
        this.adjustEdgePoints(this.m_bottomPoints);
        this.adjustEdgePoints(this.m_leftPoints);
        this.adjustEdgePoints(this.m_rightPoints);
    }

    protected void assignDimensions() {
        int n = this.numChildren();
        int n2 = (int)Math.sqrt(n);
        double d = 0.9375 * (double)n2 / (double)(2 * n);
        double d2 = 0.9375 * (double)n2 / (double)(2 * n);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.m_widthrelLocal < 0.0) {
                entityInstance.setWidthRelLocalBounded(d);
            }
            if (!(entityInstance.m_heightrelLocal < 0.0)) continue;
            entityInstance.setHeightRelLocalBounded(d2);
        }
    }

    protected void assignLocations() {
        EntityInstance entityInstance;
        Vector<EntityInstance> vector = null;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (!(entityInstance.m_xrelLocal < 0.0) && !(entityInstance.m_yrelLocal < 0.0)) continue;
            if (vector == null) {
                vector = new Vector<EntityInstance>();
            }
            vector.add(entityInstance);
        }
        if (vector != null) {
            Diagram diagram = this.getDiagram();
            LandscapeEditorCore landscapeEditorCore = diagram.getLs();
            int n = this.getWidth();
            int n2 = this.getHeight();
            boolean bl = diagram.undoEnabled();
            if (bl) {
                diagram.setUndoEnabled(false);
            }
            landscapeEditorCore.getLayouter().doLayout1(vector, this);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.resize(n, n2);
            }
            if (bl) {
                diagram.setUndoEnabled(true);
            }
            vector = null;
        }
    }

    protected void getEdgePoints(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[3] = this.m_xrelLocal;
        dArray2[0] = dArray2[1] = this.m_yrelLocal;
        dArray[1] = dArray[2] = this.m_xrelLocal + this.m_widthrelLocal;
        dArray2[2] = dArray2[3] = this.m_yrelLocal + this.m_heightrelLocal;
    }

    protected static void getFramePoints(double[] dArray, double[] dArray2) {
        dArray[3] = 0.0;
        dArray[0] = 0.0;
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray2[3] = 1.0;
        dArray2[2] = 1.0;
    }

    protected void setInitialLocation(EntityInstance entityInstance) {
        double d;
        double d2;
        EntityInstance entityInstance2;
        EntityInstance[] entityInstanceArray = new EntityInstance[entityInstance.numChildren()];
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        int n = 0;
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (entityInstance2 == this || !(entityInstance2.xRelLocal() >= 0.0) || !(entityInstance2.yRelLocal() >= 0.0) || !(entityInstance2.widthRelLocal() > 0.0) || !(entityInstance2.heightRelLocal() > 0.0)) continue;
            entityInstanceArray[n++] = entityInstance2;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i <= n; ++i) {
            if (i < n) {
                entityInstance2 = entityInstanceArray[i];
                entityInstance2.getEdgePoints(dArray, dArray2);
            } else {
                EntityInstance.getFramePoints(dArray, dArray2);
            }
            for (int j = i; j <= n; ++j) {
                if (j < n) {
                    entityInstance2 = entityInstanceArray[j];
                    entityInstance2.getEdgePoints(dArray3, dArray4);
                } else {
                    EntityInstance.getFramePoints(dArray3, dArray4);
                }
                for (int k = 0; k < 4; ++k) {
                    int n2;
                    double d8 = dArray[k];
                    double d9 = dArray2[k];
                    int n3 = n2 = i == j ? k + 1 : 0;
                    while (n2 < 4) {
                        double d10;
                        double d11;
                        double d12 = dArray3[n2];
                        double d13 = d12 - d8;
                        if (d13 != 0.0 && (d11 = (d10 = dArray4[n2]) - d9) != 0.0) {
                            double d14;
                            if (d13 < 0.0) {
                                d2 = d12;
                                d13 = -d13;
                            } else {
                                d2 = d8;
                            }
                            if (d11 < 0.0) {
                                d = d10;
                                d11 = -d11;
                            } else {
                                d = d9;
                            }
                            double d15 = d2 + d13;
                            double d16 = d + d11;
                            int n4 = n;
                            while (n4 > 0) {
                                double d17;
                                double d18;
                                double d19;
                                double d20;
                                if ((d20 = (entityInstance2 = entityInstanceArray[--n4]).xRelLocal()) >= d15 || (d19 = d20 + entityInstance2.widthRelLocal()) <= d2 || (d18 = entityInstance2.yRelLocal()) >= d16 || (d17 = d18 + entityInstance2.heightRelLocal()) <= d) continue;
                                ++n4;
                                break;
                            }
                            if (n4 == 0 && (d14 = d13 * d11) > d7) {
                                d3 = d2;
                                d4 = d;
                                d7 = d14;
                                d5 = d13;
                                d6 = d11;
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
        if (d7 > 0.0) {
            d2 = d3 + (d5 /= 2.0) / 2.0;
            d = d4 + (d6 /= 2.0) / 2.0;
            this.setRelLocal(d2, d, d5, d6);
        }
    }

    public void setSize(int n, int n2) {
        JComponent jComponent = this.getSwingObject();
        if (n <= 0 || n2 <= 0) {
            if (this.m_width > 0 && this.m_height > 0) {
                this.openStatusUnknown();
            }
            n2 = 0;
            n = 0;
        } else if (!(this.m_width > 0 && this.m_height > 0 || this.isOpen())) {
            this.openStatusUnknown();
        }
        this.m_width = n;
        this.m_height = n2;
        if (jComponent != null) {
            jComponent.setSize(n, n2);
        }
        this.resizeChildren();
    }

    public void resize(int n, int n2) {
        int n3 = (int)((double)n * this.widthRelLocal());
        int n4 = (int)((double)n2 * this.heightRelLocal());
        this.setSize(n3, n4);
    }

    public void resizeChildren() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.rescale(this.m_topPoints);
        this.rescale(this.m_bottomPoints);
        this.rescale(this.m_leftPoints);
        this.rescale(this.m_rightPoints);
        if (this.isOpen()) {
            EntityInstance entityInstance;
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                if (!(entityInstance.m_widthrelLocal < 0.0) && !(entityInstance.m_heightrelLocal < 0.0)) continue;
                this.assignDimensions();
                break;
            }
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.resize(n, n2);
            }
        }
    }

    public void setLocation(int n, int n2) {
        JComponent jComponent = this.getSwingObject();
        this.m_x = n;
        this.m_y = n2;
        if (jComponent != null) {
            jComponent.setLocation(n, n2);
        }
        this.relocateChildren();
    }

    public void setBothLocations(int n, int n2, int n3, int n4) {
        this.m_diagramX = n + n3;
        this.m_diagramY = n2 + n4;
        this.setLocation(n3, n4);
    }

    public void relocate(int n, int n2, int n3, int n4) {
        int n5 = (int)((double)n3 * this.xRelLocal());
        int n6 = (int)((double)n4 * this.yRelLocal());
        this.setBothLocations(n, n2, n5, n6);
    }

    public void relocateChildren() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isOpen()) {
            EntityInstance entityInstance;
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                if (!(entityInstance.m_xrelLocal < 0.0) && !(entityInstance.m_yrelLocal < 0.0)) continue;
                this.assignLocations();
                break;
            }
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.relocate(this.m_diagramX, this.m_diagramY, n, n2);
            }
        }
    }

    public void setBothBounds(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setSize(n5, n6);
        this.setBothLocations(n, n2, n3, n4);
    }

    public Rectangle getDiagramBounds() {
        return new Rectangle(this.getDiagramX(), this.getDiagramY(), this.getWidth(), this.getHeight());
    }

    protected void scale(double d, double d2, boolean bl, boolean bl2) {
        if (bl) {
            double d3 = this.xRelLocal();
            double d4 = this.yRelLocal();
            double d5 = this.widthRelLocal() * d;
            double d6 = this.heightRelLocal() * d2;
            if (bl2) {
                d3 *= d;
                d4 *= d2;
            }
            this.updateRelLocal(d3, d4, d5, d6);
        } else {
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.scale(d, d2, true, true);
            }
        }
    }

    public void scale(double d, boolean bl, boolean bl2) {
        this.scale(d, d, bl, bl2);
    }

    public void scale(double d, boolean bl) {
        this.scale(d, d, bl, false);
    }

    public void scale(double d) {
        this.scale(d, d, true, false);
    }

    public void scaleX(double d, boolean bl, boolean bl2) {
        this.scale(d, 1.0, bl, bl2);
    }

    public void scaleX(double d, boolean bl) {
        this.scale(d, 1.0, bl, false);
    }

    public void scaleX(double d) {
        this.scale(d, 1.0, true, false);
    }

    public void scaleY(double d, boolean bl, boolean bl2) {
        this.scale(1.0, d, bl, bl2);
    }

    public void scaleY(double d, boolean bl) {
        this.scale(1.0, d, bl, false);
    }

    public void scaleY(double d) {
        this.scale(1.0, d, true, false);
    }

    private void doFitScale(double d, double d2, double d3, double d4) {
        this.updateRelLocal(this.xRelLocal() * d3 + d, this.yRelLocal() * d4 - d2, d + this.widthRelLocal() * d3, d2 + this.heightRelLocal() * d4);
    }

    public Dimension getLabelDim(Graphics graphics, int n, boolean bl) {
        EntityInstance entityInstance;
        String string = this.getEntityLabel();
        this.setFont(graphics, n);
        if (bl && (entityInstance = this.getContainedBy()) != null) {
            string = entityInstance.getEntityLabel() + " |\n" + string;
        }
        return Util.stringWrappedDim(graphics, string);
    }

    public Dimension getLabelDim(Graphics graphics, int n) {
        return this.getLabelDim(graphics, n, false);
    }

    public int getMinFitWidth(Graphics graphics) {
        Dimension dimension = this.getLabelDim(graphics, 1);
        int n = dimension.width + 10;
        if (this.hasChildren()) {
            n += 11;
        }
        return n;
    }

    public boolean hasChildren() {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        Vector vector = this.m_srcRelList;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            RelationInstance relationInstance = (RelationInstance)vector.elementAt(i);
            if (relationInstance.getRelationClass() != relationClass) continue;
            return true;
        }
        return false;
    }

    public int numChildren() {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        Vector vector = this.m_srcRelList;
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RelationInstance relationInstance = (RelationInstance)vector.elementAt(i);
            if (relationInstance.getRelationClass() != relationClass) continue;
            ++n2;
        }
        return n2;
    }

    public EntityInstance getFirstChild() {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        Vector vector = this.m_srcRelList;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            RelationInstance relationInstance = (RelationInstance)vector.elementAt(i);
            if (relationInstance.getRelationClass() != relationClass) continue;
            return relationInstance.getDst();
        }
        return null;
    }

    public EntityInstance getChild(int n) {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        Vector vector = this.m_srcRelList;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            RelationInstance relationInstance = (RelationInstance)vector.elementAt(i);
            if (relationInstance.getRelationClass() != relationClass) continue;
            if (n == 0) {
                return relationInstance.getDst();
            }
            --n;
        }
        return null;
    }

    public int getIndexOfChild(Object object) {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        Vector vector = this.m_srcRelList;
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RelationInstance relationInstance = (RelationInstance)vector.elementAt(i);
            if (relationInstance.getRelationClass() != relationClass) continue;
            if (relationInstance.getDst() == object) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Enumeration getBelow(RelationClass relationClass) {
        return new EntityBelow(this.m_srcRelList, relationClass);
    }

    public Enumeration getChildren() {
        return new EntityChildren(this.m_srcRelList);
    }

    public void addChildren(Vector vector) {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        Vector vector2 = this.m_srcRelList;
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            RelationInstance relationInstance = (RelationInstance)vector2.elementAt(i);
            if (relationInstance.getRelationClass() != relationClass) continue;
            vector.add(relationInstance.getDst());
        }
    }

    public Enumeration getParents() {
        return new EntityParents(this.m_dstRelList);
    }

    public Dimension getFitDim(Graphics graphics, int n, boolean bl) {
        Dimension dimension = this.getLabelDim(graphics, n, bl);
        if (this.hasChildren() && !this.isOpen()) {
            dimension.width += 8;
        }
        dimension.width += 15;
        dimension.height += 7;
        return dimension;
    }

    public Dimension getFitDim(Graphics graphics, int n) {
        return this.getFitDim(graphics, n, false);
    }

    public void invalidateAllEdges() {
        RelationInstance relationInstance;
        Enumeration enumeration = this.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.invalidateEdge();
        }
        enumeration = this.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.invalidateEdge();
        }
    }

    public void drawAllEdges(EntityInstance entityInstance) {
        RelationInstance relationInstance;
        Enumeration enumeration = this.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.draw(true);
        }
        enumeration = this.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = relationInstance.m_drawSrc;
            if (entityInstance.hasDescendant(entityInstance2)) continue;
            relationInstance.draw(true);
        }
    }

    public void drawHighlightedEdges() {
        RelationInstance relationInstance;
        Enumeration enumeration = this.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.drawHighlighted();
        }
        enumeration = this.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.drawHighlighted();
        }
    }

    public void getInstancesRaw(Vector vector, Hashtable hashtable) {
        Integer[] integerArray = new Integer[]{(Integer)hashtable.get(this.getId()), (Integer)hashtable.get(this.getParentClass().getId())};
        vector.addElement(integerArray);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.getInstancesRaw(vector, hashtable);
        }
    }

    public void writeInstance(PrintStream printStream) throws IOException {
        printStream.print("$INSTANCE " + this.qt(this.getId()) + " " + this.qt(this.getParentClass().getId()) + "\n");
    }

    public void writeInstances(PrintStream printStream) throws IOException {
        this.writeInstance(printStream);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeInstances(printStream);
        }
    }

    public void writeRelations(PrintStream printStream) throws IOException {
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.writeRelation(printStream);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeRelations(printStream);
        }
    }

    protected void writeElision(PrintStream printStream, Vector vector, String string) {
        if (vector != null && vector.size() > 0) {
            printStream.print(" " + string + " = (");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                printStream.print(string2);
                if (!enumeration.hasMoreElements()) continue;
                printStream.print(" ");
            }
            printStream.print(")\n");
        }
    }

    protected void writePoints(PrintStream printStream, EdgePoint[] edgePointArray, String string) {
        if (edgePointArray != null) {
            int n;
            for (n = 1; n < edgePointArray.length && (edgePointArray[n] == null || edgePointArray[n].isDefault()); ++n) {
            }
            if (n == edgePointArray.length) {
                return;
            }
            printStream.print("\t" + string + " = ( ");
            for (n = 1; n < edgePointArray.length; ++n) {
                if (edgePointArray[n] == null) continue;
                edgePointArray[n].writePoint(printStream);
            }
            printStream.print(")\n");
        }
    }

    protected void regRawElision(Vector vector, Hashtable hashtable, Vector vector2, String string) {
        if (vector2 != null && vector2.size() > 0) {
            int n = vector2.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)vector2.elementAt(i);
            }
            this.regRawAttribute(vector, hashtable, string, stringArray);
        }
    }

    public void writeOptionsAttributes(PrintStream printStream) throws IOException {
        String string;
        LandscapeClassObject landscapeClassObject = this.getParentClass();
        printStream.print(this.qt(this.getId()) + " {\n");
        String string2 = this.getLabel();
        if (string2 == null) {
            string2 = this.getEntityLabel();
        }
        if (string2 != null) {
            printStream.print(" label = " + this.qt(string2) + "\n");
        }
        if ((string = this.getDescription()) != null) {
            printStream.print(" description = " + AttributeValueItem.qt(string) + "\n");
        }
        super.writeAttributes(printStream, landscapeClassObject, false);
        printStream.print("}\n");
    }

    public void writeAttribute(PrintStream printStream, int n) throws IOException {
        String string;
        int n2;
        String string2;
        EntityPosition entityPosition;
        int n3;
        LandscapeClassObject landscapeClassObject = this.getParentClass();
        printStream.print(this.qt(this.getId()) + " {\n");
        if (this.m_positions == null) {
            n3 = -1;
        } else {
            n3 = this.m_positions.length;
            while (--n3 >= 0 && !(n3 == n ? this.m_xrelLocal >= 0.0 || this.m_yrelLocal >= 0.0 || this.m_widthrelLocal >= 0.0 || this.m_heightrelLocal >= 0.0 : (entityPosition = this.m_positions[n3]) != null && (entityPosition.m_xrelLocal >= 0.0 || entityPosition.m_yrelLocal >= 0.0 || entityPosition.m_widthrelLocal >= 0.0 || entityPosition.m_heightrelLocal >= 0.0))) {
            }
        }
        if (n3 < 0) {
            double d = this.m_xrelLocal;
            if (d >= 0.0 && d <= 1.0) {
                printStream.print(" xrel      = " + d + "\n");
            }
            if ((d = this.m_yrelLocal) >= 0.0 && d <= 1.0) {
                printStream.print(" yrel      = " + d + "\n");
            }
            if ((d = this.m_widthrelLocal) >= 0.0 && d <= 1.0) {
                printStream.print(" widthrel  = " + d + "\n");
            }
            if ((d = this.m_heightrelLocal) >= 0.0 && d <= 1.0) {
                printStream.print(" heightrel = " + d + "\n");
            }
        } else {
            double d;
            int n4;
            printStream.print(" xrel      = (");
            for (n4 = 0; n4 <= n3; ++n4) {
                if (n4 != 0) {
                    printStream.print(" ");
                }
                d = n4 == n ? this.m_xrelLocal : ((entityPosition = this.m_positions[n4]) == null ? -1.0 : entityPosition.m_xrelLocal);
                printStream.print(d);
            }
            printStream.print(")\n");
            printStream.print(" yrel      = (");
            for (n4 = 0; n4 <= n3; ++n4) {
                if (n4 != 0) {
                    printStream.print(" ");
                }
                d = n4 == n ? this.m_yrelLocal : ((entityPosition = this.m_positions[n4]) == null ? -1.0 : entityPosition.m_yrelLocal);
                printStream.print(d);
            }
            printStream.print(")\n");
            printStream.print(" widthrel  = (");
            for (n4 = 0; n4 <= n3; ++n4) {
                if (n4 != 0) {
                    printStream.print(" ");
                }
                d = n4 == n ? this.m_widthrelLocal : ((entityPosition = this.m_positions[n4]) == null ? -1.0 : entityPosition.m_widthrelLocal);
                printStream.print(d);
            }
            printStream.print(")\n");
            printStream.print(" heightrel = (");
            for (n4 = 0; n4 <= n3; ++n4) {
                if (n4 != 0) {
                    printStream.print(" ");
                }
                d = n4 == n ? this.m_heightrelLocal : ((entityPosition = this.m_positions[n4]) == null ? -1.0 : entityPosition.m_heightrelLocal);
                printStream.print(d);
            }
            printStream.print(")\n");
        }
        if ((string2 = this.getLabel()) != null) {
            printStream.print(" label = " + this.qt(string2) + "\n");
        }
        if ((n2 = this.getStyle()) >= 0 && (landscapeClassObject == null || landscapeClassObject.getInheritedStyle() != n2)) {
            printStream.print(" style = " + n2 + "\n");
        }
        if ((string = this.getDescription()) != null && (this.isRoot() || !landscapeClassObject.defaultValue(DESC_ID, string))) {
            printStream.print(" description = " + AttributeValueItem.qt(string) + "\n");
        }
        this.writeElision(printStream, this.m_dstElision, IN_ELISION_ID);
        this.writeElision(printStream, this.m_srcElision, OUT_ELISION_ID);
        this.writeElision(printStream, this.m_enteringElision, CLIENT_ELISION_ID);
        this.writeElision(printStream, this.m_exitingElision, SUPPLIER_ELISION_ID);
        this.writeElision(printStream, this.m_internalElision, INTERNAL_ELISION_ID);
        this.writePoints(printStream, this.m_topPoints, INPOINT_ID);
        this.writePoints(printStream, this.m_bottomPoints, OUTPOINT_ID);
        this.writePoints(printStream, this.m_leftPoints, LEFTPOINT_ID);
        this.writePoints(printStream, this.m_rightPoints, RIGHTPOINT_ID);
        if (this.m_fontDelta != 0) {
            printStream.print(" fontdelta = ");
            printStream.print(this.m_fontDelta + "\n");
        }
        super.writeAttributes(printStream, landscapeClassObject, false);
        printStream.print("}\n");
    }

    public void writeAttributes(PrintStream printStream, int n) throws IOException {
        this.writeAttribute(printStream, n);
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.writeAttributes(printStream);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeAttributes(printStream, n);
        }
    }

    public void setOpen() {
        if (!this.isMarked(262144)) {
            this.nandMark(524288);
            this.orMark(262144);
        }
    }

    public void setClosed() {
        if (!this.isMarked(524288)) {
            this.nandMark(262144);
            this.orMark(524288);
        }
    }

    public void openStatusUnknown() {
        this.nandMark(786432);
    }

    public boolean isOpen() {
        if (!this.isMarked(786432)) {
            if (!this.hasChildren() || this.getWidth() <= 0 || this.getHeight() <= 0) {
                this.setClosed();
            } else {
                Ta ta = this.getTa();
                String string = ta.getContainsId();
                if (!this.isDstRelationElided(string)) {
                    this.setOpen();
                } else {
                    this.setClosed();
                }
            }
        }
        return this.isMarked(262144);
    }

    public boolean red_closed() {
        return this.isMarked(32768) && !this.isOpen();
    }

    public boolean red_open() {
        return this.isMarked(32768) && this.isOpen();
    }

    public boolean close_with_children_under_drawroot() {
        return !this.isOpen() && this.hasChildren() && !this.isMarked(6);
    }

    public void removeAllEdges() {
        RelationInstance relationInstance;
        int n = this.m_srcRelList.size();
        while (n > 0) {
            relationInstance = (RelationInstance)this.m_srcRelList.elementAt(--n);
            relationInstance.removeEdge();
        }
        n = this.m_dstRelList.size();
        while (n > 0) {
            relationInstance = (RelationInstance)this.m_dstRelList.elementAt(--n);
            relationInstance.removeEdge();
        }
    }

    public RelationInstance getContainedByRelation(RelationClass relationClass) {
        Enumeration enumeration = this.m_dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass) continue;
            return relationInstance;
        }
        return null;
    }

    public EntityInstance getContainedBy(RelationClass relationClass) {
        RelationInstance relationInstance = this.getContainedByRelation(relationClass);
        if (relationInstance != null) {
            return relationInstance.getSrc();
        }
        return null;
    }

    public EntityInstance getContainedBy() {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        return this.getContainedBy(relationClass);
    }

    public void setContainedBy(EntityInstance entityInstance) {
        Ta ta = this.getTa();
        RelationClass relationClass = ta.getContainsClass();
        RelationInstance relationInstance = this.getContainedByRelation(relationClass);
        if (relationInstance != null) {
            if (relationInstance.getSrc() == entityInstance) {
                return;
            }
            relationInstance.removeEdge();
        }
        if (entityInstance != null) {
            ta.addEdge(entityInstance, this, relationClass);
        }
    }

    public EntityClass getEntityClass() {
        return (EntityClass)this.getParentClass();
    }

    public boolean isRoot() {
        return this.getContainedBy() == null;
    }

    public int cntNodesInSubtree(RelationClass relationClass) {
        if (this.isMarked(0x100000)) {
            Ta ta = this.getTa();
            ta.hasMultipleParents(relationClass, this);
            return -1;
        }
        int n = 1;
        this.orMark(0x100000);
        Enumeration enumeration = this.getBelow(relationClass);
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            int n2 = entityInstance.cntNodesInSubtree(relationClass);
            if (n2 < 0) {
                return n2;
            }
            n += n2;
        }
        return n;
    }

    public void clearTreeMark() {
        this.nandMark(0x100000);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearTreeMark();
        }
    }

    public void clearValidatedMark() {
        RelationInstance relationInstance;
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.nandMark(16384);
        }
        enumeration = this.m_dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.nandMark(16384);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearValidatedMark();
        }
    }

    public String toString() {
        return this.getEntityLabel();
    }

    public void updateDiagramBounds(int n, int n2, int n3, int n4) {
        double d;
        double d2;
        double d3;
        double d4;
        this.m_diagramX = n;
        this.m_diagramY = n2;
        EntityInstance entityInstance = this.getContainedBy();
        double d5 = entityInstance.getWidth();
        double d6 = entityInstance.getHeight();
        if (d5 <= 0.0) {
            d4 = 0.0;
            d3 = 0.0;
        } else {
            d4 = (double)(n - entityInstance.m_diagramX) / d5;
            d3 = (double)n3 / d5;
        }
        if (d6 <= 0.0) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d2 = (double)(n2 - entityInstance.m_diagramY) / d6;
            d = (double)n4 / d6;
        }
        this.updateRelLocal(d4, d2, d3, d);
        this.setSize(n3, n4);
        this.setLocation(n - this.getParentDiagramX(), n2 - this.getParentDiagramY());
        this.validateAllMyEdges();
        this.moveCardinals();
    }

    public void updateDiagramBounds(Rectangle rectangle) {
        this.updateDiagramBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle getChildBoundingBox() {
        if (!this.hasChildren()) {
            return null;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.getX() < n) {
                n = entityInstance.getX();
            }
            if (entityInstance.getY() < n3) {
                n3 = entityInstance.getY();
            }
            if (entityInstance.getX() + entityInstance.getWidth() > n2) {
                n2 = entityInstance.getX() + entityInstance.getWidth();
            }
            if (entityInstance.getY() + entityInstance.getHeight() <= n4) continue;
            n4 = entityInstance.getY() + entityInstance.getHeight();
        }
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public Color getBackgroundWhenOpen() {
        Color color = this.getInheritedColorWhenOpen();
        if (color == null) {
            int n = 191;
            EntityInstance entityInstance = this;
            EntityInstance entityInstance2 = this.getDrawRoot();
            if (!entityInstance2.hasDescendant(this)) {
                entityInstance2 = entityInstance2.commonAncestor(this);
            }
            while (entityInstance != entityInstance2) {
                if ((n -= 13) <= 0) {
                    return Color.lightGray;
                }
                entityInstance = entityInstance.getContainedBy();
            }
            color = ColorCache.get(n, n, n);
        }
        return color;
    }

    public Color getCurrentObjectColor() {
        Color color = this.isOpen() ? this.getBackgroundWhenOpen() : this.getInheritedObjectColor();
        return color;
    }

    public boolean isRelationElided(Vector vector, String string) {
        return vector != null && vector.contains(string);
    }

    protected boolean toggleElision(Vector vector, String string) {
        if (this.isRelationElided(vector, string)) {
            if (!vector.removeElement(string)) {
                MsgOut.println("remove() failed");
            }
            return false;
        }
        vector.addElement(string);
        return true;
    }

    public boolean toggleDstElision(String string) {
        MsgOut.dprintln("toggle target " + string);
        return this.toggleElision(this.neededDstElision(), string);
    }

    public void toggleContainElision(String string) {
        this.toggleDstElision(string);
        this.openStatusUnknown();
    }

    public boolean setContainElision(String string) {
        if (!this.isDstRelationElided(string)) {
            this.toggleContainElision(string);
            this.openStatusUnknown();
            return true;
        }
        return false;
    }

    public void clearContainElision(String string) {
        if (this.m_dstElision != null) {
            this.m_dstElision.removeElement(string);
        }
    }

    public boolean toggleDstElision(RelationClass relationClass) {
        return this.toggleDstElision(relationClass.getId());
    }

    public boolean toggleSrcElision(String string) {
        MsgOut.dprintln("toggle out " + string);
        return this.toggleElision(this.neededSrcElision(), string);
    }

    public boolean toggleSrcElision(RelationClass relationClass) {
        return this.toggleSrcElision(relationClass.getId());
    }

    public boolean toggleEnteringElision(String string) {
        MsgOut.dprintln("toggle client " + string);
        return this.toggleElision(this.neededEnteringElision(), string);
    }

    public boolean toggleEnteringElision(RelationClass relationClass) {
        return this.toggleEnteringElision(relationClass.getId());
    }

    public boolean toggleExitingElision(String string) {
        MsgOut.dprintln("toggle exiting " + string);
        return this.toggleElision(this.neededExitingElision(), string);
    }

    public boolean toggleExitingElision(RelationClass relationClass) {
        return this.toggleExitingElision(relationClass.getId());
    }

    public boolean toggleInternalElision(String string) {
        MsgOut.dprintln("toggle internal " + string);
        return this.toggleElision(this.neededInternalElision(), string);
    }

    public boolean toggleInternalElision(RelationClass relationClass) {
        return this.toggleInternalElision(relationClass.getId());
    }

    public boolean isDstRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.m_dstElision, relationClass.getId());
    }

    public boolean isDstRelationElided(String string) {
        return this.isRelationElided(this.m_dstElision, string);
    }

    public boolean isSrcRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.m_srcElision, relationClass.getId());
    }

    public boolean isSrcRelationElided(String string) {
        return this.isRelationElided(this.m_srcElision, string);
    }

    public boolean isEnteringRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.m_enteringElision, relationClass.getId());
    }

    public boolean isEnteringRelationElided(String string) {
        return this.isRelationElided(this.m_enteringElision, string);
    }

    public boolean isExitingRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.m_exitingElision, relationClass.getId());
    }

    public boolean isExitingRelationElided(String string) {
        return this.isRelationElided(this.m_exitingElision, string);
    }

    public boolean isInternalRelationElided(RelationClass relationClass) {
        return this.isRelationElided(this.m_internalElision, relationClass.getId());
    }

    public boolean isInternalRelationElided(String string) {
        return this.isRelationElided(this.m_internalElision, string);
    }

    public int getPostorder() {
        return this.m_postorder;
    }

    public boolean hasAncestor(EntityInstance entityInstance) {
        return entityInstance.m_preorder < this.m_preorder && this.m_postorder <= entityInstance.m_postorder;
    }

    public boolean hasDescendant(EntityInstance entityInstance) {
        return this.m_preorder < entityInstance.m_preorder && entityInstance.m_postorder <= this.m_postorder;
    }

    public boolean hasDescendantOrSelf(EntityInstance entityInstance) {
        return this.m_preorder <= entityInstance.m_preorder && entityInstance.m_postorder <= this.m_postorder;
    }

    public boolean hasDescendantsOrSelf(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            EntityInstance entityInstance = (EntityInstance)vector.elementAt(i);
            if (this.hasDescendantOrSelf(entityInstance)) continue;
            return false;
        }
        return true;
    }

    public boolean allDescendants(Vector vector) {
        int n = vector.size();
        while (--n >= 0) {
            EntityInstance entityInstance = (EntityInstance)vector.elementAt(n);
            if (entityInstance.hasAncestor(this)) continue;
            return false;
        }
        return true;
    }

    public boolean reallyHasDescendantOrSelf(EntityInstance entityInstance) {
        if (entityInstance == this) {
            return true;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (!entityInstance2.hasDescendantOrSelf(entityInstance)) continue;
            return entityInstance2.reallyHasDescendantOrSelf(entityInstance);
        }
        return false;
    }

    public boolean isPathBetween(EntityInstance entityInstance) {
        return this.m_preorder <= entityInstance.m_preorder && entityInstance.m_postorder <= this.m_postorder || entityInstance.m_preorder <= this.m_preorder && this.m_postorder <= entityInstance.m_postorder;
    }

    public EntityInstance commonAncestor(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        for (entityInstance2 = this.getContainedBy(); entityInstance2 != null && !entityInstance2.hasDescendant(entityInstance); entityInstance2 = entityInstance2.getContainedBy()) {
        }
        return entityInstance2;
    }

    public EntityInstance clientServer() {
        EntityInstance entityInstance;
        for (entityInstance = this; entityInstance != null && !entityInstance.isMarked(6); entityInstance = entityInstance.getContainedBy()) {
        }
        return entityInstance;
    }

    public boolean inDiagram() {
        return this.isMarked(7);
    }

    public EntityInstance getVisibleEntity() {
        EntityInstance entityInstance;
        for (entityInstance = this; entityInstance != null && !this.inDiagram(); entityInstance = entityInstance.getContainedBy()) {
        }
        return entityInstance;
    }

    public EntityInstance getMouseOver(int n, int n2) {
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null && jComponent.contains(n, n2)) {
            if (this.isOpen()) {
                Enumeration enumeration = this.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                    EntityInstance entityInstance2 = entityInstance.getMouseOver(n, n2);
                    if (entityInstance2 == null) continue;
                    return entityInstance2;
                }
            }
            return this;
        }
        return null;
    }

    public EntityInstance containing(Rectangle rectangle) {
        if (this.containsRectangle(rectangle)) {
            if (this.hasChildren() && this.isOpen()) {
                Enumeration enumeration = this.getChildren();
                while (enumeration.hasMoreElements()) {
                    EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                    EntityInstance entityInstance2 = entityInstance.containing(rectangle);
                    if (entityInstance2 == null) continue;
                    return entityInstance2;
                }
            }
            return this;
        }
        return null;
    }

    public Vector getSrcRelList() {
        return this.m_srcRelList;
    }

    public Vector getDstRelList() {
        return this.m_dstRelList;
    }

    public Enumeration srcRelationElements() {
        return this.m_srcRelList.elements();
    }

    public Enumeration dstRelationElements() {
        return this.m_dstRelList.elements();
    }

    public Enumeration srcLiftedRelationElements() {
        return this.m_srcLiftedList.elements();
    }

    public Enumeration dstLiftedRelationElements() {
        return this.m_dstLiftedList.elements();
    }

    protected void addSrcRels(Vector vector) {
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.addSrcRels(vector);
        }
    }

    public Enumeration srcRelationAbstractedElements() {
        Vector vector = new Vector();
        this.addSrcRels(vector);
        return vector.elements();
    }

    protected void addDstRels(Vector vector) {
        Enumeration enumeration = this.m_dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.addDstRels(vector);
        }
    }

    public Enumeration dstRelationAbstractedElements() {
        Vector vector = new Vector();
        this.addDstRels(vector);
        return vector.elements();
    }

    public Vector groupRegion(Rectangle rectangle) {
        if (!this.hasChildren()) {
            return null;
        }
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (!entityInstance.intersectsLayout(rectangle)) continue;
            entityInstance.setGroupFlag();
            vector.addElement(entityInstance);
        }
        if (vector.isEmpty()) {
            return null;
        }
        return vector;
    }

    public void getGroup(Vector vector) {
        if (this.getGroupFlag()) {
            vector.addElement(this);
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.getGroup(vector);
        }
    }

    protected void setGroupFlag() {
        EntityClass entityClass;
        if (!this.isMarked(65536) && (entityClass = this.getEntityClass()).isShown()) {
            this.orMark(65536);
            this.repaint();
        }
    }

    protected void clearGroupFlag() {
        if (this.isMarked(196608)) {
            this.nandMark(196608);
            this.repaint();
        }
    }

    public boolean getGroupFlag() {
        return this.isMarked(65536);
    }

    protected void setGroupKeyFlag() {
        if (!this.isMarked(131072)) {
            this.orMark(131072);
            this.repaint();
        }
    }

    protected void clearGroupKeyFlag() {
        if (this.isMarked(131072)) {
            this.nandMark(131072);
            this.repaint();
        }
    }

    public boolean getGroupKeyFlag() {
        return this.isMarked(131072);
    }

    public void getRedBoxGroup(Vector vector) {
        if (this.isMarked(32768)) {
            vector.addElement(this);
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.getRedBoxGroup(vector);
        }
    }

    public void setRedBoxFlag() {
        if (!this.isMarked(32768)) {
            this.orMark(32768);
            this.repaint();
        }
    }

    public void clearRedBoxFlag() {
        if (this.isMarked(32768)) {
            this.nandMark(32768);
            this.repaint();
        }
    }

    public void clearAllFlags() {
        this.clearGroupFlag();
        this.clearGroupKeyFlag();
        this.clearRedBoxFlag();
        this.openStatusUnknown();
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.clearHighlightFlag();
            relationInstance.clearGroupFlag();
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearAllFlags();
        }
    }

    public void clearQueryFlags() {
        this.clearRedBoxFlag();
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.clearHighlightFlag();
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearQueryFlags();
        }
    }

    public void clearGroupFlags() {
        this.clearGroupFlag();
        this.clearGroupKeyFlag();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearGroupFlags();
        }
    }

    public boolean isClippedLabel() {
        return this.getWidth() < 30 || this.getHeight() < 10;
    }

    public boolean isClickable() {
        return true;
    }

    public void orMark(int n) {
        this.m_mark |= n;
    }

    public void andMark(int n) {
        this.m_mark &= n;
    }

    public void nandMark(int n) {
        this.m_mark &= ~n;
    }

    public boolean isMarked(int n) {
        return (this.m_mark & n) != 0;
    }

    public int getMark() {
        return this.m_mark;
    }

    public int getOmnipresent() {
        return this.m_mark & 0x700;
    }

    public boolean isClient() {
        return this.isMarked(2);
    }

    public boolean isSupplier() {
        return this.isMarked(4);
    }

    public boolean isClientOrSupplier() {
        return this.isMarked(6);
    }

    public void markDeleted() {
        this.m_mark |= 0x2000000;
    }

    public void clearDeleted() {
        this.m_mark &= 0xFDFFFFFF;
    }

    public double parentsWidthLocal() {
        EntityInstance entityInstance = this.getContainedBy();
        if (entityInstance == null) {
            return this.getDiagram().getWidth();
        }
        return entityInstance.parentsWidthLocal() * entityInstance.widthRelLocal();
    }

    public double parentsHeightLocal() {
        EntityInstance entityInstance = this.getContainedBy();
        if (entityInstance == null) {
            return this.getDiagram().getHeight();
        }
        return entityInstance.parentsHeightLocal() * entityInstance.heightRelLocal();
    }

    public double parentsWidth() {
        EntityInstance entityInstance = this.getContainedBy();
        if (entityInstance == null) {
            return this.getDiagram().getWidth();
        }
        return entityInstance.getWidth();
    }

    public double parentsHeight() {
        EntityInstance entityInstance = this.getContainedBy();
        if (entityInstance == null) {
            return this.getDiagram().getHeight();
        }
        return entityInstance.getHeight();
    }

    public double xRelLocal() {
        return this.m_xrelLocal;
    }

    public void setXRelLocal(double d) {
        this.m_xrelLocal = d;
    }

    public double yRelLocal() {
        return this.m_yrelLocal;
    }

    public void setYRelLocal(double d) {
        this.m_yrelLocal = d;
    }

    public double widthRelLocal() {
        return this.m_widthrelLocal;
    }

    public void setWidthRelLocal(double d) {
        this.m_widthrelLocal = d;
    }

    public double heightRelLocal() {
        return this.m_heightrelLocal;
    }

    public void setXRelLocalBounded(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.setXRelLocal(d);
    }

    public void updateXRelLocal(double d) {
        double d2 = this.m_xrelLocal;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d != d2) {
            this.setXRelLocal(d);
            this.areaMoved();
            if (this.undoEnabled()) {
                new SetXRelLocal(d2);
            }
        }
    }

    public void setYRelLocalBounded(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.setYRelLocal(d);
    }

    public void updateYRelLocal(double d) {
        double d2 = this.m_yrelLocal;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d != d2) {
            this.setYRelLocal(d);
            this.areaMoved();
            if (this.undoEnabled()) {
                new SetYRelLocal(d2);
            }
        }
    }

    public void setWidthRelLocalBounded(double d) {
        if (d > 1.0) {
            d = 1.0;
        }
        if (this.m_xrelLocal + d > 1.0) {
            this.setXRelLocal(1.0 - d);
        }
        this.setWidthRelLocal(d);
    }

    public void updateWidthRelLocal(double d) {
        double d2 = this.m_widthrelLocal;
        if (d > 1.0) {
            d = 1.0;
        }
        if (this.m_xrelLocal + d > 1.0) {
            this.updateXRelLocal(1.0 - d);
        }
        if (d != d2) {
            this.setWidthRelLocal(d);
            if (this.undoEnabled()) {
                new SetWidthRelLocal(d2);
            }
            this.areaChanged();
        }
    }

    public void setHeightRelLocal(double d) {
        this.m_heightrelLocal = d;
    }

    public void setHeightRelLocalBounded(double d) {
        if (d > 1.0) {
            d = 1.0;
        }
        if (this.m_yrelLocal + d > 1.0) {
            this.setYRelLocal(1.0 - d);
        }
        this.setHeightRelLocal(d);
    }

    public void updateHeightRelLocal(double d) {
        double d2 = this.m_heightrelLocal;
        if (d > 1.0) {
            d = 1.0;
        }
        if (this.m_yrelLocal + d > 1.0) {
            this.updateYRelLocal(1.0 - d);
        }
        if (d != d2) {
            this.setHeightRelLocal(d);
            if (this.undoEnabled()) {
                new SetHeightRelLocal(d2);
            }
            this.areaChanged();
        }
    }

    public void setRelLocal(double d, double d2, double d3, double d4) {
        this.setXRelLocal(d);
        this.setYRelLocal(d2);
        this.setWidthRelLocal(d3);
        this.setHeightRelLocal(d4);
    }

    public void setRelLocal(EntityInstance entityInstance) {
        this.setXRelLocal(entityInstance.xRelLocal());
        this.setYRelLocal(entityInstance.yRelLocal());
        this.setWidthRelLocal(entityInstance.widthRelLocal());
        this.setHeightRelLocal(entityInstance.heightRelLocal());
    }

    public void setRelLocalBounded(double d, double d2, double d3, double d4) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        if (d + d3 > 1.0) {
            d = 1.0 - d3;
        }
        if (d2 + d4 > 1.0) {
            d2 = 1.0 - d4;
        }
        this.setRelLocal(d, d2, d3, d4);
    }

    public void updateRelLocal(double d, double d2, double d3, double d4) {
        double d5 = this.m_xrelLocal;
        double d6 = this.m_yrelLocal;
        double d7 = this.m_widthrelLocal;
        double d8 = this.m_heightrelLocal;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        if (d + d3 > 1.0) {
            d = 1.0 - d3;
        }
        if (d2 + d4 > 1.0) {
            d2 = 1.0 - d4;
        }
        if (d != d5 || d2 != d6 || d3 != d7 || d4 != d8) {
            this.setRelLocal(d, d2, d3, d4);
            if (this.undoEnabled()) {
                new SetRelLocal(d5, d6, d7, d8);
            }
            if (d3 * d4 != d7 * d8) {
                this.areaChanged();
            }
        }
    }

    public void computeRelCoordinates(double d, double d2, double d3, double d4) {
        double d5 = this.m_xrelLocal;
        double d6 = this.m_yrelLocal;
        double d7 = this.m_widthrelLocal;
        double d8 = this.m_heightrelLocal;
        if (d3 == 0.0) {
            this.setXRelLocal(0.0);
            this.setWidthRelLocal(0.0);
        } else {
            this.setXRelLocal(d5 / d3);
            this.setWidthRelLocal(d7 / d3);
        }
        if (d4 == 0.0) {
            this.setYRelLocal(0.0);
            this.setHeightRelLocal(0.0);
        } else {
            this.setYRelLocal(d6 / d4);
            this.setHeightRelLocal(d8 / d4);
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.computeRelCoordinates(d5, d6, d7, d8);
        }
    }

    public void setxLocal(double d) {
        this.getTa().m_uses_local_coordinates = true;
        this.setXRelLocal(d);
    }

    public void setyLocal(double d) {
        this.getTa().m_uses_local_coordinates = true;
        this.setYRelLocal(d);
    }

    public void setwidthLocal(double d) {
        this.getTa().m_uses_local_coordinates = true;
        this.setWidthRelLocal(d);
    }

    public void setheightLocal(double d) {
        this.getTa().m_uses_local_coordinates = true;
        this.setHeightRelLocal(d);
    }

    public int getPrimaryAttributeCount() {
        return 13;
    }

    public String getLsAttributeNameAt(int n) {
        String string = n < 13 ? attributeName[n] : super.getLsAttributeNameAt(n);
        return string;
    }

    public int getLsAttributeTypeAt(int n) {
        int n2 = n < 13 ? attributeType[n] : super.getLsAttributeTypeAt(n);
        return n2;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                LandscapeClassObject landscapeClassObject = this.getParentClass();
                if (landscapeClassObject == null) {
                    object = null;
                    break;
                }
                object = landscapeClassObject.getLabelId();
                break;
            }
            case 2: {
                object = this.getLabel();
                break;
            }
            case 3: {
                object = this.getTitle();
                break;
            }
            case 4: {
                object = this.getDescription();
                break;
            }
            case 5: {
                object = this.getObjectColor();
                break;
            }
            case 6: {
                object = this.getLabelColor();
                break;
            }
            case 7: {
                object = this.getColorWhenOpen();
                break;
            }
            case 8: {
                object = new Double(this.xRelLocal());
                break;
            }
            case 9: {
                object = new Double(this.yRelLocal());
                break;
            }
            case 10: {
                object = new Double(this.widthRelLocal());
                break;
            }
            case 11: {
                object = new Double(this.heightRelLocal());
                break;
            }
            case 12: {
                object = new Integer(this.m_fontDelta);
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void updateAttributeValueAt(int n, Object object) {
        block0 : switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                if (object == null) break;
                LandscapeClassObject landscapeClassObject = this.getParentClass();
                String string = (String)object;
                if (landscapeClassObject != null && landscapeClassObject.getLabelId().equals(string)) break;
                Enumeration enumeration = this.getTa().enumEntityClasses();
                while (enumeration.hasMoreElements()) {
                    EntityClass entityClass = (EntityClass)enumeration.nextElement();
                    if (!entityClass.getLabelId().equals(string)) continue;
                    this.updateParentClass(entityClass);
                    break block0;
                }
                break;
            }
            case 2: {
                this.updateLabel((String)object);
                break;
            }
            case 3: {
                this.updateTitle((String)object);
                break;
            }
            case 4: {
                this.updateDescription((String)object);
                break;
            }
            case 5: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 6: {
                this.updateLabelColor((Color)object);
                break;
            }
            case 7: {
                this.updateColorWhenOpen((Color)object);
                break;
            }
            case 8: {
                this.updateXRelLocal((Double)object);
                break;
            }
            case 9: {
                this.updateYRelLocal((Double)object);
                break;
            }
            case 10: {
                this.updateWidthRelLocal((Double)object);
                break;
            }
            case 11: {
                this.updateHeightRelLocal((Double)object);
                break;
            }
            case 12: {
                this.updateFontDelta((Integer)object);
                break;
            }
            default: {
                super.updateAttributeValueAt(n, object);
            }
        }
    }

    public boolean containsDiagramPoint(int n, int n2) {
        if (n < this.getDiagramX()) {
            return false;
        }
        if (n > this.getDiagramX() + this.getWidth()) {
            return false;
        }
        if (n2 < this.getDiagramY()) {
            return false;
        }
        return n2 <= this.getDiagramY() + this.getHeight();
    }

    public void dump(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
        System.out.println(this);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.dump(n + 2);
        }
    }

    public int prepostorder(int n) {
        this.m_preorder = n;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            n = entityInstance.prepostorder(n + 1);
        }
        this.m_postorder = n;
        return n;
    }

    public int getPreorder() {
        return this.m_preorder;
    }

    public int nodesInSubtree() {
        return this.m_postorder - this.m_preorder + 1;
    }

    public void clearAllMarks(int n, int n2) {
        this.andMark(n | 0x3800700);
        this.m_srcLiftedList.removeAllElements();
        this.m_dstLiftedList.removeAllElements();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.clearAllMarks(n, n2);
        }
        enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.clearMark(n2);
        }
    }

    public void addClients(Vector vector, EntityInstance entityInstance, boolean bl, boolean bl2, boolean bl3) {
        if (this != entityInstance) {
            EntityInstance entityInstance2;
            Enumeration enumeration;
            if (!this.hasDescendant(entityInstance)) {
                EntityClass entityClass = null;
                if (bl2 && (entityClass = this.getEntityClass()).isShown()) {
                    entityClass = null;
                }
                if (entityClass == null) {
                    enumeration = this.m_srcRelList.elements();
                    while (enumeration.hasMoreElements()) {
                        RelationClass relationClass;
                        RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
                        if (bl && !(relationClass = relationInstance.getRelationClass()).isClassVisible() || !entityInstance.hasDescendant(entityInstance2 = relationInstance.getDst()) || !(entityClass = entityInstance2.getEntityClass()).isShown()) continue;
                        if (!bl3) {
                            do {
                                if ((entityInstance2 = entityInstance2.getContainedBy()) != entityInstance) continue;
                                this.orMark(2);
                                vector.addElement(this);
                                return;
                            } while (entityInstance2.isOpen());
                            continue;
                        }
                        this.orMark(2);
                        vector.addElement(this);
                        return;
                    }
                }
            }
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance2.addClients(vector, entityInstance, bl, bl2, bl3);
            }
        }
    }

    public void addSuppliers(Vector vector, EntityInstance entityInstance, boolean bl, boolean bl2, boolean bl3) {
        if (this != entityInstance) {
            EntityInstance entityInstance2;
            Enumeration enumeration;
            if (!this.hasDescendant(entityInstance)) {
                EntityClass entityClass = null;
                if (bl2 && (entityClass = this.getEntityClass()).isShown()) {
                    entityClass = null;
                }
                if (entityClass == null) {
                    enumeration = this.m_dstRelList.elements();
                    while (enumeration.hasMoreElements()) {
                        RelationClass relationClass;
                        RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
                        if (bl && !(relationClass = relationInstance.getRelationClass()).isClassVisible() || !entityInstance.hasDescendant(entityInstance2 = relationInstance.getSrc()) || !(entityClass = entityInstance2.getEntityClass()).isShown()) continue;
                        if (!bl3) {
                            do {
                                if ((entityInstance2 = entityInstance2.getContainedBy()) != entityInstance) continue;
                                this.orMark(4);
                                vector.addElement(this);
                                return;
                            } while (entityInstance2.isOpen());
                            continue;
                        }
                        this.orMark(4);
                        vector.addElement(this);
                        return;
                    }
                }
            }
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance2.addSuppliers(vector, entityInstance, bl, bl2, bl3);
            }
        }
    }

    protected boolean liftSrc(RelationInstance relationInstance) {
        LandscapeClassObject landscapeClassObject = relationInstance.getParentClass();
        if (!relationInstance.isMarked(1536)) {
            Enumeration enumeration = this.srcLiftedRelationElements();
            while (enumeration.hasMoreElements()) {
                RelationInstance relationInstance2 = (RelationInstance)enumeration.nextElement();
                if (relationInstance.m_drawSrc != relationInstance2.m_drawSrc || relationInstance.m_drawDst != relationInstance2.m_drawDst || landscapeClassObject != relationInstance2.getParentClass()) continue;
                relationInstance2.incrementFrequency(relationInstance);
                return false;
            }
        }
        this.m_srcLiftedList.add(relationInstance);
        return true;
    }

    protected void liftDst(RelationInstance relationInstance) {
        this.m_dstLiftedList.add(relationInstance);
    }

    public boolean openEdgeExpansion(EntityInstance entityInstance, EntityInstance entityInstance2, String string, String string2, ResultBox resultBox) {
        boolean bl = false;
        String string3 = string2;
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getDst();
            if (this == entityInstance && entityInstance3 == entityInstance2 || !entityInstance2.hasDescendantOrSelf(entityInstance3)) continue;
            bl = true;
            resultBox.addRelation(string2, relationInstance);
            if (string3 == string2) {
                string3 = string2 + "+- ";
            }
            relationInstance.orMark(1024);
            if (entityInstance3 == entityInstance2) continue;
            do {
                entityInstance3 = entityInstance3.getContainedBy();
                entityInstance3.clearContainElision(string);
            } while (entityInstance3 != entityInstance2);
        }
        boolean bl2 = false;
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4 = (EntityInstance)enumeration.nextElement();
            boolean bl3 = entityInstance4.openEdgeExpansion(entityInstance, entityInstance2, string, string3, resultBox);
            if (!bl3 || bl2) continue;
            bl2 = true;
            bl = true;
            this.clearContainElision(string);
        }
        return bl;
    }

    public boolean openSrcEdgeExpansion(EntityInstance entityInstance, EntityInstance entityInstance2, String string, String string2, ResultBox resultBox) {
        boolean bl = false;
        String string3 = string2;
        Enumeration enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getDst();
            if (this == entityInstance && entityInstance3 == entityInstance2 || !entityInstance2.hasDescendantOrSelf(entityInstance3)) continue;
            bl = true;
            resultBox.addRelation(string2, relationInstance);
            if (string3 == string2) {
                string3 = string2 + "+- ";
            }
            relationInstance.orMark(1024);
        }
        boolean bl2 = false;
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4 = (EntityInstance)enumeration.nextElement();
            boolean bl3 = entityInstance4.openSrcEdgeExpansion(entityInstance, entityInstance2, string, string3, resultBox);
            if (!bl3 || bl2) continue;
            bl2 = true;
            bl = true;
            this.clearContainElision(string);
        }
        return bl;
    }

    public boolean openDstEdgeExpansion(EntityInstance entityInstance, EntityInstance entityInstance2, String string, String string2, ResultBox resultBox) {
        boolean bl = false;
        String string3 = string2;
        Enumeration enumeration = this.m_dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getSrc();
            if (entityInstance3 == entityInstance && this == entityInstance2 || !entityInstance.hasDescendantOrSelf(entityInstance3)) continue;
            bl = true;
            resultBox.addRelation(string2, relationInstance);
            if (string3 == string2) {
                string3 = string2 + "+- ";
            }
            relationInstance.orMark(1024);
        }
        boolean bl2 = false;
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4 = (EntityInstance)enumeration.nextElement();
            boolean bl3 = entityInstance4.openDstEdgeExpansion(entityInstance, entityInstance2, string, string3, resultBox);
            if (!bl3 || bl2) continue;
            bl2 = true;
            bl = true;
            this.clearContainElision(string);
        }
        return bl;
    }

    public void computeAllDiagramEdges(EntityInstance entityInstance, Vector vector, Vector vector2, EntityInstance entityInstance2, boolean bl) {
        RelationInstance relationInstance;
        EntityClass entityClass = this.getEntityClass();
        if (!entityClass.isShown()) {
            return;
        }
        Enumeration enumeration = this.m_dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.resetFrequency();
            EntityInstance entityInstance3 = relationInstance.m_src;
            if (!(vector == null && vector2 == null || entityInstance.isPathBetween(entityInstance3))) {
                relationInstance.m_drawSrc = entityInstance3.clientServer();
            }
            if (entityInstance2 != null) {
                if (entityInstance2.hasDescendant(entityInstance3)) continue;
                relationInstance.m_drawDst = entityInstance2;
                continue;
            }
            relationInstance.m_drawDst = this;
        }
        enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.resetFrequency();
            EntityInstance entityInstance4 = relationInstance.m_dst;
            if (vector2 != null && !entityInstance.isPathBetween(entityInstance4)) {
                relationInstance.m_drawDst = entityInstance4.clientServer();
            }
            if (entityInstance2 != null) {
                if (entityInstance2.hasDescendant(entityInstance4)) continue;
                relationInstance.m_drawSrc = entityInstance2;
                continue;
            }
            relationInstance.m_drawSrc = this;
        }
        if (entityInstance2 == null) {
            this.orMark(1);
            if (!this.isOpen()) {
                entityInstance2 = this;
                if (!bl) {
                    return;
                }
            }
        } else {
            this.setSwingObject(null);
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance5 = (EntityInstance)enumeration.nextElement();
            entityInstance5.computeAllDiagramEdges(entityInstance, vector, vector2, entityInstance2, bl);
        }
    }

    public void liftAllDiagramEdges(boolean bl) {
        EntityInstance entityInstance;
        EntityInstance entityInstance2;
        RelationInstance relationInstance;
        Enumeration enumeration = this.m_dstRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.isMarked(0x200000)) continue;
            relationInstance.orMark(0x200000);
            entityInstance2 = relationInstance.m_drawSrc;
            if (entityInstance2 == null || (entityInstance = relationInstance.m_drawDst) == null || !entityInstance2.liftSrc(relationInstance)) continue;
            entityInstance.liftDst(relationInstance);
        }
        enumeration = this.m_srcRelList.elements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.isMarked(0x200000)) continue;
            relationInstance.orMark(0x200000);
            entityInstance2 = relationInstance.m_drawSrc;
            if (entityInstance2 == null || (entityInstance = relationInstance.m_drawDst) == null || !entityInstance2.liftSrc(relationInstance)) continue;
            entityInstance.liftDst(relationInstance);
        }
        if (!bl && !this.isOpen()) {
            return;
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
            entityInstance3.liftAllDiagramEdges(bl);
        }
    }

    public void validateEdges() {
        RelationInstance relationInstance;
        Enumeration enumeration = this.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.validate();
        }
        enumeration = this.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.validate();
        }
        if (!this.isMarked(524288)) {
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.validateEdges();
            }
        }
    }

    public boolean intersectsLayout(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle2.intersects(rectangle);
    }

    public boolean containsRectangle(Rectangle rectangle) {
        int n = this.getDiagramX();
        int n2 = this.getDiagramY();
        return n < rectangle.x && rectangle.x + rectangle.width < n + this.getWidth() && n2 < rectangle.y && rectangle.y + rectangle.height < n2 + this.getHeight();
    }

    public boolean isFramedBy(int n, int n2, int n3, int n4) {
        int n5 = this.getDiagramX();
        int n6 = this.getDiagramY();
        if (n > n5 || n2 > n6) {
            return false;
        }
        if (n + n3 < (n5 += this.getWidth())) {
            return false;
        }
        if (n2 + n4 < (n6 += this.getHeight())) {
            return false;
        }
        EntityClass entityClass = this.getEntityClass();
        return entityClass.isShown();
    }

    public int getParentDiagramX() {
        Container container;
        DiagramCoordinates diagramCoordinates;
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null && (diagramCoordinates = (container = jComponent.getParent()) instanceof EntityComponent ? ((EntityComponent)container).getEntityInstance() : (DiagramCoordinates)((Object)container)) != null) {
            return diagramCoordinates.getDiagramX();
        }
        return 0;
    }

    public int getParentDiagramY() {
        Container container;
        DiagramCoordinates diagramCoordinates;
        JComponent jComponent = this.getSwingObject();
        if (jComponent != null && (diagramCoordinates = (container = jComponent.getParent()) instanceof EntityComponent ? ((EntityComponent)container).getEntityInstance() : (DiagramCoordinates)((Object)container)) != null) {
            return diagramCoordinates.getDiagramY();
        }
        return 0;
    }

    public int getDiagramX() {
        return this.m_diagramX;
    }

    public int getDiagramY() {
        return this.m_diagramY;
    }

    public void computeAvgX() {
        EntityComponent entityComponent = this.neededComponent();
        double d = 0.0;
        int n = 0;
        int n2 = this.getDiagram().getEdgeMode();
        if (n2 == 2) {
            RelationInstance relationInstance;
            Enumeration enumeration = this.srcLiftedRelationElements();
            while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                EntityInstance entityInstance = relationInstance.m_drawDst;
                d += (double)(entityInstance.getDiagramX() + entityInstance.getWidth() / 2);
                ++n;
            }
            enumeration = this.dstLiftedRelationElements();
            while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                EntityInstance entityInstance = relationInstance.m_drawSrc;
                d += (double)(entityInstance.getDiagramX() + entityInstance.getWidth() / 2);
                ++n;
            }
        } else {
            double d2;
            RelationInstance relationInstance;
            Enumeration enumeration = this.srcLiftedRelationElements();
            while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                EntityInstance entityInstance = relationInstance.m_drawDst;
                d2 = relationInstance.getRelationClass().getIOfactor();
                d += (double)entityInstance.getDiagramX() + (double)entityInstance.getWidth() * d2;
                ++n;
            }
            enumeration = this.dstLiftedRelationElements();
            while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                EntityInstance entityInstance = relationInstance.m_drawSrc;
                d2 = relationInstance.getRelationClass().getIOfactor();
                d += (double)entityInstance.getDiagramX() + (double)entityInstance.getWidth() * d2;
                ++n;
            }
        }
        double d3 = n > 0 ? d / (double)n : -1.0;
        entityComponent.setAvgX(d3);
    }

    public double getAvgX() {
        EntityComponent entityComponent = this.neededComponent();
        return entityComponent.getAvgX();
    }

    public void resetDstCardinals(int n) {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent != null) {
            entityComponent.resetDstCardinals(n);
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.resetDstCardinals(n);
            }
        }
    }

    public void resetSrcCardinals(int n) {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent != null) {
            entityComponent.resetSrcCardinals(n);
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.resetSrcCardinals(n);
            }
        }
    }

    public void calcDstEdgeCardinals(boolean bl) {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent != null) {
            Cardinal[] cardinalArray = entityComponent.getDstCardinals();
            Enumeration enumeration = this.m_dstLiftedList.elements();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass;
                RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
                if (bl && !relationInstance.getHighlightFlag() || (relationClass = relationInstance.getRelationClass()).isContainsClass()) continue;
                int n = relationClass.getNid();
                Cardinal cardinal = cardinalArray[n];
                if (cardinal == null) {
                    cardinalArray[n] = cardinal = new Cardinal();
                }
                cardinal.sum(relationInstance);
            }
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.calcDstEdgeCardinals(bl);
            }
        }
    }

    public void calcSrcEdgeCardinals(boolean bl) {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent != null) {
            Cardinal[] cardinalArray = entityComponent.getSrcCardinals();
            Enumeration enumeration = this.m_srcLiftedList.elements();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass;
                RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
                if (bl && !relationInstance.getHighlightFlag() || (relationClass = relationInstance.getRelationClass()).isContainsClass()) continue;
                int n = relationClass.getNid();
                Cardinal cardinal = cardinalArray[n];
                if (cardinal == null) {
                    cardinalArray[n] = cardinal = new SrcCardinal();
                }
                cardinal.sum(relationInstance);
            }
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.calcSrcEdgeCardinals(bl);
            }
        }
    }

    public void showDstCardinals() {
        EntityComponent entityComponent;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n > 0 && n2 > 0 && (entityComponent = (EntityComponent)this.getSwingObject()) != null) {
            EntityClass entityClass;
            Cardinal[] cardinalArray = entityComponent.getDstCardinals();
            if (cardinalArray != null && (entityClass = this.getEntityClass()).isShown()) {
                Diagram diagram = this.getDiagram();
                int n3 = this.getDiagramX();
                int n4 = this.getDiagramY();
                int n5 = cardinalArray.length;
                while (n5 > 0) {
                    int n6;
                    Cardinal cardinal;
                    if ((cardinal = cardinalArray[--n5]) == null || (n6 = cardinal.getCnt()) <= 0) continue;
                    RelationClass relationClass = diagram.numToRelationClass(n5);
                    double d = relationClass.getIOfactor();
                    cardinal.setBackground(relationClass.getInheritedObjectColor());
                    cardinal.setCenterTop(n3, n4, n, n2, d);
                    diagram.add(cardinal);
                }
            }
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.showDstCardinals();
            }
        }
    }

    public void showSrcCardinals() {
        EntityComponent entityComponent;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n > 0 && n2 > 0 && (entityComponent = (EntityComponent)this.getSwingObject()) != null) {
            EntityClass entityClass;
            Cardinal[] cardinalArray = entityComponent.getSrcCardinals();
            if (cardinalArray != null && (entityClass = this.getEntityClass()).isShown()) {
                Diagram diagram = this.getDiagram();
                int n3 = this.getDiagramX();
                int n4 = this.getDiagramY();
                int n5 = cardinalArray.length;
                while (n5 > 0) {
                    int n6;
                    Cardinal cardinal;
                    if ((cardinal = cardinalArray[--n5]) == null || (n6 = cardinal.getCnt()) <= 0) continue;
                    RelationClass relationClass = diagram.numToRelationClass(n5);
                    double d = relationClass.getIOfactor();
                    cardinal.setBackground(relationClass.getInheritedObjectColor());
                    cardinal.setCenterTop(n3, n4, n, n2, d);
                    diagram.add(cardinal);
                }
            }
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.showSrcCardinals();
            }
        }
    }

    public void moveCardinals() {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n > 0 && n2 > 0) {
                double d;
                RelationClass relationClass;
                Cardinal cardinal;
                int n3;
                Diagram diagram = this.getDiagram();
                int n4 = this.getDiagramX();
                int n5 = this.getDiagramY();
                Cardinal[] cardinalArray = entityComponent.getDstCardinals();
                if (cardinalArray != null) {
                    n3 = cardinalArray.length;
                    while (n3 > 0) {
                        if ((cardinal = cardinalArray[--n3]) == null) continue;
                        relationClass = diagram.numToRelationClass(n3);
                        d = relationClass.getIOfactor();
                        cardinal.setCenterTop(n4, n5, n, n2, d);
                        cardinal.revalidate();
                    }
                }
                if ((cardinalArray = entityComponent.getSrcCardinals()) != null) {
                    n3 = cardinalArray.length;
                    while (n3 > 0) {
                        if ((cardinal = cardinalArray[--n3]) == null) continue;
                        relationClass = diagram.numToRelationClass(n3);
                        d = relationClass.getIOfactor();
                        cardinal.setCenterTop(n4, n5, n, n2, d);
                        cardinal.revalidate();
                    }
                }
            }
        }
    }

    public RealPoint calculateIntercept(RealPoint realPoint, RealPoint realPoint2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.getY() - 1;
        double d4 = this.getY() + this.getHeight() + 1;
        double d5 = this.getX() - 1;
        double d6 = this.getX() + this.getWidth() + 1;
        boolean bl = true;
        double d7 = realPoint.getX();
        double d8 = realPoint.getY();
        if (d7 < d5 || d7 > d6 || d8 < d3 || d8 > d4) {
            MsgOut.println("calculateIntercept: p1 is not in box");
            return new RealPoint(d, d2);
        }
        double d9 = realPoint2.getX();
        double d10 = realPoint2.getY();
        if (d7 == d9 && d8 == d10) {
            MsgOut.println("calculateIntercept: p1 == p2");
            return new RealPoint(d, d2);
        }
        if (d6 <= d9) {
            d = d6;
        } else if (d9 < d5) {
            d = d5;
        } else {
            bl = false;
        }
        if (bl) {
            d2 = d8 + (d - d7) * ((d10 - d8) / (d9 - d7));
            boolean bl2 = bl = d3 <= d2 && d2 <= d4;
        }
        if (!bl) {
            bl = true;
            if (d10 <= d3) {
                d2 = d3;
            } else if (d10 >= d4) {
                d2 = d4;
            } else {
                bl = false;
            }
            if (bl) {
                d = d7 + (d2 - d8) * ((d9 - d7) / (d10 - d8));
                boolean bl3 = bl = d5 <= d && d <= d6;
            }
        }
        if (!bl) {
            MsgOut.println("calculateIntercept failed: " + d7 + " " + d8 + " " + d9 + " " + d10);
        }
        return new RealPoint(d, d2);
    }

    public int overResizeTab(int n, int n2) {
        int n3;
        int n4 = this.getDiagramX();
        if (n < n4) {
            return -1;
        }
        if (n <= n4 + 6) {
            n3 = 0;
        } else {
            int n5 = n4 + this.getWidth();
            if (n > n5) {
                return -1;
            }
            if (n >= n5 - 6) {
                n3 = 2;
            } else {
                int n6 = (n4 + n5) / 2;
                if (n < n6 - 3 || n > n6 + 3) {
                    return -1;
                }
                n3 = 1;
            }
        }
        int n7 = this.getDiagramY();
        if (n2 < n7) {
            return -1;
        }
        if (n2 > n7 + 6) {
            int n8 = n7 + this.getHeight();
            if (n2 > n8) {
                return -1;
            }
            if (n2 >= n8 - 6) {
                n3 += 6;
            } else {
                int n9 = (n7 + n8) / 2;
                if (n2 < n9 - 3 || n2 > n9 + 3) {
                    return -1;
                }
                n3 += 3;
            }
        }
        switch (n3) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 7;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    public boolean isPointOverIO(EdgePoint edgePoint, int n, int n2) {
        int n3 = (int)(edgePoint.getX() + 0.5);
        int n4 = (int)(edgePoint.getY() + 0.5);
        return n3 - 3 < n && n < n3 + 3 && n4 - 3 < n2 && n2 < n4 + 3;
    }

    public void drawHighlight() {
        if (!this.isMarked(4096)) {
            this.orMark(4096);
            this.repaint();
        }
    }

    public void undrawHighlight() {
        if (this.isMarked(4096)) {
            this.nandMark(4096);
            this.repaint();
        }
    }

    public EdgePoint getPoint(RelationClass relationClass, int n) {
        EdgePoint edgePoint;
        EdgePoint[] edgePointArray;
        int n2 = relationClass.getNid();
        switch (n) {
            case 0: {
                edgePointArray = this.m_topPoints;
                break;
            }
            case 1: {
                edgePointArray = this.m_bottomPoints;
                break;
            }
            case 2: {
                edgePointArray = this.m_leftPoints;
                break;
            }
            default: {
                edgePointArray = this.m_rightPoints;
            }
        }
        if (edgePointArray == null || edgePointArray.length <= n2) {
            EdgePoint[] edgePointArray2 = new EdgePoint[this.numRelationClasses()];
            if (edgePointArray != null) {
                for (int i = 0; i < edgePointArray.length; ++i) {
                    edgePointArray2[i] = edgePointArray[i];
                    edgePointArray[i] = null;
                }
            }
            edgePointArray = edgePointArray2;
            switch (n) {
                case 0: {
                    this.m_topPoints = edgePointArray;
                    break;
                }
                case 1: {
                    this.m_bottomPoints = edgePointArray;
                    break;
                }
                case 2: {
                    this.m_leftPoints = edgePointArray;
                    break;
                }
                default: {
                    this.m_rightPoints = edgePointArray;
                }
            }
        }
        if ((edgePoint = edgePointArray[n2]) == null || edgePoint.getRc() != relationClass) {
            double d = relationClass.getIOfactor();
            double d2 = 0.0;
            double d3 = 0.0;
            switch (n) {
                case 0: {
                    d2 = d;
                    break;
                }
                case 1: {
                    d2 = d;
                    d3 = 1.0;
                    break;
                }
                case 2: {
                    d3 = d;
                    break;
                }
                default: {
                    d2 = 1.0;
                    d3 = d;
                }
            }
            if (edgePoint == null) {
                edgePointArray[n2] = edgePoint = new EdgePoint(this);
                edgePoint.setProperties(relationClass, d2, d3);
            } else {
                edgePoint.setRc(relationClass);
            }
            edgePoint.rescale();
        }
        return edgePoint;
    }

    public EdgePoint getOutPoint(RelationInstance relationInstance, int n, Rectangle rectangle, Rectangle rectangle2) {
        RelationClass relationClass = relationInstance.getRelationClass();
        if (n == 1) {
            EntityInstance entityInstance = relationInstance.getSrc();
            if (this == entityInstance || entityInstance.hasAncestor(this)) {
                return this.getPoint(relationClass, 1);
            }
            return this.getPoint(relationClass, 0);
        }
        if (rectangle2.y - (rectangle.y + rectangle.height) > 8) {
            return this.getPoint(relationClass, 1);
        }
        if (rectangle.y - (rectangle2.y + rectangle2.height) > 8) {
            return this.getPoint(relationClass, 0);
        }
        if (rectangle2.x - (rectangle.x + rectangle.width) > 8) {
            return this.getPoint(relationClass, 3);
        }
        if (rectangle.x - (rectangle2.x + rectangle2.width) > 8) {
            return this.getPoint(relationClass, 2);
        }
        if (rectangle2.y > rectangle.y + rectangle.height) {
            return this.getPoint(relationClass, 1);
        }
        return this.getPoint(relationClass, 0);
    }

    public EdgePoint getLeftOutPoint(RelationInstance relationInstance) {
        RelationClass relationClass = relationInstance.getRelationClass();
        return this.getPoint(relationClass, 2);
    }

    public EdgePoint getRightOutPoint(RelationInstance relationInstance) {
        RelationClass relationClass = relationInstance.getRelationClass();
        return this.getPoint(relationClass, 3);
    }

    public EdgePoint getTopOutPoint(RelationInstance relationInstance) {
        RelationClass relationClass = relationInstance.getRelationClass();
        return this.getPoint(relationClass, 0);
    }

    public EdgePoint getBottomOutPoint(RelationInstance relationInstance) {
        RelationClass relationClass = relationInstance.getRelationClass();
        return this.getPoint(relationClass, 1);
    }

    protected EdgePoint testMouseOverIO(EdgePoint[] edgePointArray, int n, int n2) {
        if (edgePointArray == null) {
            return null;
        }
        for (int i = 0; i < edgePointArray.length; ++i) {
            EdgePoint edgePoint = edgePointArray[i];
            if (edgePoint == null || !this.isPointOverIO(edgePoint, n, n2)) continue;
            return edgePoint;
        }
        return null;
    }

    public EdgePoint getMouseOverIO(int n, int n2) {
        EdgePoint edgePoint = this.testMouseOverIO(this.m_topPoints, n, n2);
        if (edgePoint != null) {
            return edgePoint;
        }
        edgePoint = this.testMouseOverIO(this.m_bottomPoints, n, n2);
        if (edgePoint != null) {
            return edgePoint;
        }
        edgePoint = this.testMouseOverIO(this.m_leftPoints, n, n2);
        if (edgePoint != null) {
            return edgePoint;
        }
        return this.testMouseOverIO(this.m_rightPoints, n, n2);
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.paintIcon(component, graphics, n, n2);
    }

    public int getClassImage() {
        return this.getEntityClass().getImage();
    }

    public double getClassAngle() {
        return this.getEntityClass().getAngle();
    }

    public int getClassDirection() {
        int n = (int)this.getClassAngle();
        return (n + 45) / 90 % 4;
    }

    public int validateEntityAttributes(Vector vector, Vector[] vectorArray, ResultBox resultBox) {
        Enumeration enumeration;
        EntityClass entityClass = this.getEntityClass();
        int n = 0;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            if (entityClass != vector.elementAt(i)) continue;
            Vector vector2 = vectorArray[i];
            if (vector2 == null) {
                vectorArray[i] = vector2 = entityClass.getValidAttributes();
            }
            boolean bl = false;
            enumeration = this.getLsAttributesEnum();
            if (enumeration == null) continue;
            block1: while (enumeration.hasMoreElements()) {
                Attribute attribute;
                Attribute attribute2 = (Attribute)enumeration.nextElement();
                String string = attribute2.id;
                int n3 = vector2.size();
                do {
                    if (--n3 < 0) {
                        if (!bl) {
                            resultBox.addResultEntity(this);
                            bl = true;
                            ++n;
                        }
                        resultBox.addResultAttribute(attribute2);
                        continue block1;
                    }
                    attribute = (Attribute)vector2.elementAt(n3);
                } while (!string.equals(attribute.id));
            }
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            n += entityInstance.validateEntityAttributes(vector, vectorArray, resultBox);
        }
        return n;
    }

    public int validateRelationAttributes(Vector vector, Vector[] vectorArray, ResultBox resultBox) {
        Enumeration enumeration;
        int n = 0;
        int n2 = vector.size();
        Enumeration enumeration2 = this.m_srcRelList.elements();
        block0: while (enumeration2.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration2.nextElement();
            RelationClass relationClass = relationInstance.getRelationClass();
            for (int i = 0; i < n2; ++i) {
                if (relationClass != vector.elementAt(i)) continue;
                Vector vector2 = vectorArray[i];
                if (vector2 == null) {
                    vectorArray[i] = vector2 = relationClass.getValidAttributes();
                }
                boolean bl = false;
                enumeration = relationInstance.getLsAttributesEnum();
                if (enumeration == null) continue block0;
                block2: while (enumeration.hasMoreElements()) {
                    Attribute attribute;
                    Attribute attribute2 = (Attribute)enumeration.nextElement();
                    String string = attribute2.id;
                    int n3 = vector2.size();
                    do {
                        if (--n3 < 0) {
                            if (!bl) {
                                resultBox.addRelation(relationInstance);
                                bl = true;
                                ++n;
                            }
                            resultBox.addResultAttribute(attribute2);
                            continue block2;
                        }
                        attribute = (Attribute)vector2.elementAt(n3);
                    } while (!string.equals(attribute.id));
                }
                continue block0;
            }
        }
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            n += entityInstance.validateRelationAttributes(vector, vectorArray, resultBox);
        }
        return n;
    }

    public int validateRelations(Vector vector, boolean[][][] blArray, ResultBox resultBox, EntityInstance entityInstance) {
        int n = 0;
        int n2 = vector.size();
        Enumeration enumeration = this.m_srcRelList.elements();
        for (int i = 0; i < 2; ++i) {
            block1: while (enumeration.hasMoreElements()) {
                RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
                if (relationInstance.isMarked(16384)) continue;
                relationInstance.orMark(16384);
                RelationClass relationClass = relationInstance.getRelationClass();
                for (int j = 0; j < n2; ++j) {
                    if (relationClass != vector.elementAt(j)) continue;
                    boolean[][] blArray2 = blArray[j];
                    if (blArray2 == null) {
                        blArray2 = relationClass.getInheritedRelationArray();
                        blArray[j] = blArray2;
                    }
                    EntityInstance entityInstance2 = relationInstance.getSrc();
                    EntityInstance entityInstance3 = relationInstance.getDst();
                    if (entityInstance2 == entityInstance || entityInstance3 == entityInstance) continue block1;
                    EntityClass entityClass = entityInstance2.getEntityClass();
                    EntityClass entityClass2 = entityInstance3.getEntityClass();
                    if (blArray2[entityClass.getOrderedId()][entityClass2.getOrderedId()]) continue block1;
                    resultBox.addRelation("", relationInstance);
                    ++n;
                    continue block1;
                }
            }
            enumeration = this.m_dstRelList.elements();
        }
        Enumeration enumeration2 = this.getChildren();
        while (enumeration2.hasMoreElements()) {
            EntityInstance entityInstance4 = (EntityInstance)enumeration2.nextElement();
            n += entityInstance4.validateRelations(vector, blArray, resultBox, entityInstance);
        }
        return n;
    }

    public void gatherLeaves(Vector vector) {
        EntityInstance entityInstance = null;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.gatherLeaves(vector);
        }
        if (entityInstance == null) {
            vector.add(this);
        }
    }

    public void noEdges() {
        this.m_srcRelList = new Vector();
        this.m_dstRelList.clear();
        this.m_srcLiftedList.clear();
        this.m_dstLiftedList.clear();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Diagram diagram = this.getDiagram();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n <= 11 && n2 <= 17 && n >= 3 && n2 >= 9 && this.m_width > 11 && this.m_height > 17 && this.close_with_children_under_drawroot()) {
            LandscapeEditorCore landscapeEditorCore = diagram.getLs();
            landscapeEditorCore.processKey(99, 0, this);
            return;
        }
        diagram.entityPressed(mouseEvent, this, mouseEvent.getX() + this.getDiagramX(), mouseEvent.getY() + this.getDiagramY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.getDiagram().entityReleased(mouseEvent, this, mouseEvent.getX() + this.getDiagramX(), mouseEvent.getY() + this.getDiagramY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.getDiagram().entityDragged(mouseEvent, this, mouseEvent.getX() + this.getDiagramX(), mouseEvent.getY() + this.getDiagramY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Diagram diagram = this.getDiagram();
        if (this != g_infoShown) {
            int n;
            LandscapeEditorCore landscapeEditorCore = diagram.getLs();
            if (g_infoShown instanceof RelationInstance) {
                ((RelationInstance)g_infoShown).repaint();
            }
            if (((n = mouseEvent.getModifiers()) & 1) == 0) {
                landscapeEditorCore.infoShown(this);
            }
            String string = this.getEntityLabel();
            EntityInstance entityInstance = this.getContainedBy();
            if (entityInstance != null) {
                string = entityInstance.getEntityLabel() + " . " + string;
            }
            landscapeEditorCore.showInfo(string);
            if (m_currentDescEntity != this && !this.isOpen() && this.getEntityClass() != null) {
                String string2 = this.getEntityLabel();
                String string3 = this.getTitle();
                String string4 = this.getDescription();
                if (string4 == null) {
                    string4 = "The " + string2 + " " + this.getClassLabel() + ".";
                }
                String string5 = " (" + this.getClassLabel() + (this.hasChildren() ? " - " + this.numChildren() + " items)" : ")");
                string5 = string3 != null ? string3 + string5 : string2 + string5;
                landscapeEditorCore.setRightTextBox(string5, string4);
                m_currentDescEntity = this;
            }
        }
        diagram.movedOverThing(mouseEvent, this, mouseEvent.getX() + this.getDiagramX(), mouseEvent.getY() + this.getDiagramY());
    }

    class SetRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_oldX;
        double m_oldY;
        double m_oldWidth;
        double m_oldHeight;
        double m_newX;
        double m_newY;
        double m_newWidth;
        double m_newHeight;

        SetRelLocal(double d, double d2, double d3, double d4) {
            this.m_oldX = d;
            this.m_oldY = d2;
            this.m_oldWidth = d3;
            this.m_oldHeight = d4;
            this.m_newX = EntityInstance.this.m_xrelLocal;
            this.m_newY = EntityInstance.this.m_yrelLocal;
            this.m_newWidth = EntityInstance.this.m_widthrelLocal;
            this.m_newHeight = EntityInstance.this.m_heightrelLocal;
            EntityInstance.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityInstance.this.toString() + " RelLocal {" + Util.formatFraction(this.m_newX) + EntityInstance.XPOSITION_ID + Util.formatFraction(this.m_newY) + "," + Util.formatFraction(this.m_newWidth) + EntityInstance.XPOSITION_ID + Util.formatFraction(this.m_newHeight) + "}";
        }

        public void undo() {
            EntityInstance.this.setRelLocal(this.m_oldX, this.m_oldY, this.m_oldWidth, this.m_oldHeight);
            EntityInstance.this.getDiagram().redrawDiagram();
        }

        public void redo() {
            EntityInstance.this.setRelLocal(this.m_newX, this.m_newY, this.m_newWidth, this.m_newHeight);
            EntityInstance.this.getDiagram().redrawDiagram();
        }
    }

    class SetHeightRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_old;
        double m_new;

        SetHeightRelLocal(double d) {
            this.m_old = d;
            this.m_new = EntityInstance.this.m_heightrelLocal;
            EntityInstance.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityInstance.this.toString() + " heightRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            EntityInstance.this.setHeightRelLocal(this.m_old);
            EntityInstance.this.getDiagram().redrawDiagram();
        }

        public void redo() {
            EntityInstance.this.setHeightRelLocal(this.m_new);
            EntityInstance.this.getDiagram().redrawDiagram();
        }
    }

    class SetWidthRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_old;
        double m_new;

        SetWidthRelLocal(double d) {
            this.m_old = d;
            this.m_new = EntityInstance.this.m_widthrelLocal;
            EntityInstance.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityInstance.this.toString() + " widthRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            EntityInstance.this.setWidthRelLocal(this.m_old);
            EntityInstance.this.getDiagram().redrawDiagram();
        }

        public void redo() {
            EntityInstance.this.setWidthRelLocal(this.m_new);
            EntityInstance.this.getDiagram().redrawDiagram();
        }
    }

    class SetYRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_old;
        double m_new;

        SetYRelLocal(double d) {
            this.m_old = d;
            this.m_new = EntityInstance.this.m_yrelLocal;
            EntityInstance.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityInstance.this.toString() + " yRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            EntityInstance.this.setYRelLocal(this.m_old);
            EntityInstance.this.getDiagram().redrawDiagram();
        }

        public void redo() {
            EntityInstance.this.setYRelLocal(this.m_new);
            EntityInstance.this.getDiagram().redrawDiagram();
        }
    }

    class SetXRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_old;
        double m_new;

        SetXRelLocal(double d) {
            this.m_old = d;
            this.m_new = EntityInstance.this.m_xrelLocal;
            EntityInstance.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityInstance.this.toString() + " xRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            EntityInstance.this.setXRelLocal(this.m_old);
            EntityInstance.this.getDiagram().redrawDiagram();
        }

        public void redo() {
            EntityInstance.this.setXRelLocal(this.m_new);
            EntityInstance.this.getDiagram().redrawDiagram();
        }
    }

    class SetTitle
    extends MyUndoableEdit
    implements UndoableEdit {
        String m_old;
        String m_new;

        SetTitle(String string) {
            this.m_old = string;
            this.m_new = EntityInstance.this.m_title;
            EntityInstance.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityInstance.this.toString() + " Title";
        }

        public void undo() {
            EntityInstance.this.m_title = this.m_old;
        }

        public void redo() {
            EntityInstance.this.m_title = this.m_new;
        }
    }

    class SetFontDelta
    extends MyUndoableEdit
    implements UndoableEdit {
        int m_old;
        int m_new;

        SetFontDelta(int n) {
            this.m_old = n;
            this.m_new = EntityInstance.this.m_fontDelta;
            EntityInstance.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityInstance.this.toString() + " FontDelta " + this.m_new;
        }

        public void undo() {
            EntityInstance.this.setFontDelta(this.m_old);
        }

        public void redo() {
            EntityInstance.this.setFontDelta(this.m_new);
        }
    }
}

