/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class ExpandLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int XBORDER = 0;
    protected static final int YBORDER = 1;
    protected static final String[] m_textfield_tags = new String[]{"expand:xborder[", "expand:yborder["};
    protected static final String[] m_textfield_titles = new String[]{"X Border fraction of total:", "Y Border fraction of total:"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "0.05"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "0.05"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "0.05"};
    protected static double m_xborder = 0.05;
    protected static double m_yborder = 0.05;
    protected static final int HORIZONTALLY = 0;
    protected static final int VERTICALLY = 1;
    protected static final String[] m_checkbox_tags = new String[]{"expand:horizontally[", "expand:vertically["};
    protected static final String[] m_checkbox_titles = new String[]{"Expand horizontally:", "Expand vertically:"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};

    protected void setParameter(int n, String string) {
        string = string.trim();
        try {
            double d = Double.parseDouble(string);
            switch (n) {
                case 0: {
                    m_xborder = d;
                    break;
                }
                case 1: {
                    m_yborder = d;
                }
            }
            ExpandLayout.m_textfield_currents[n] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static boolean parameterBoolean(int n) {
        return m_checkbox_currents[n];
    }

    public String getTag() {
        return "expand:";
    }

    public void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    ExpandLayout.m_textfield_defaults[n] = string;
                }
                case 1: {
                    this.setParameter(n, string);
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    ExpandLayout.m_checkbox_defaults[n] = bl;
                }
                case 1: {
                    ExpandLayout.m_checkbox_currents[n] = bl;
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    public ExpandLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Expand";
    }

    public String getMenuLabel() {
        return "Expand layout to fill area";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isLayouter() {
        return true;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        ExpandConfigure expandConfigure = new ExpandConfigure();
        boolean bl = expandConfigure.ok();
        expandConfigure.dispose();
        return bl;
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
        double d;
        EntityInstance entityInstance2;
        Enumeration enumeration;
        boolean bl;
        double d2 = m_xborder;
        double d3 = m_yborder;
        boolean bl2 = ExpandLayout.parameterBoolean(0);
        boolean bl3 = ExpandLayout.parameterBoolean(1);
        if (!bl2 && !bl3) {
            return;
        }
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 0.0;
        double d7 = 1.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (bl2) {
            bl = true;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                if (bl) {
                    d9 = d8 = entityInstance2.xRelLocal();
                    d10 = entityInstance2.widthRelLocal();
                    bl = false;
                    continue;
                }
                if (entityInstance2.xRelLocal() < d8) {
                    d8 = entityInstance2.xRelLocal();
                }
                if (!((d = entityInstance2.xRelLocal()) > d9)) continue;
                d9 = d;
                d10 = entityInstance2.widthRelLocal();
            }
            if (!bl) {
                d4 = d8;
                if ((d9 -= d8) != 0.0) {
                    d5 = (1.0 - d2 - d10) / d9;
                }
            }
        }
        if (bl3) {
            bl = true;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                if (bl) {
                    d9 = d8 = entityInstance2.yRelLocal();
                    d11 = entityInstance2.heightRelLocal();
                    bl = false;
                    continue;
                }
                if (entityInstance2.yRelLocal() < d8) {
                    d8 = entityInstance2.yRelLocal();
                }
                if (!((d = entityInstance2.yRelLocal()) > d9)) continue;
                d9 = d;
                d11 = entityInstance2.heightRelLocal();
            }
            if (!bl) {
                d6 = d8;
                if ((d9 -= d8) != 0.0) {
                    d7 = (1.0 - d3 - d11) / d9;
                }
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            double d12 = entityInstance2.xRelLocal();
            double d13 = entityInstance2.yRelLocal();
            double d14 = (d12 - d4) * d5 + d2 / 2.0;
            double d15 = (d13 - d6) * d7 + d3 / 2.0;
            if (d14 == d12 && d15 == d13) continue;
            double d16 = entityInstance2.widthRelLocal();
            double d17 = entityInstance2.heightRelLocal();
            entityInstance2.updateRelLocal(d14, d15, d16, d17);
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        this.m_ls.setCursor(3);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Expand algorithm requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Expand layout");
        this.doLayout1(vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Expand algorithm";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            diagram.redrawDiagram();
            this.m_ls.doFeedback(string);
        }
    }

    class ExpandConfigure
    extends JDialog
    implements ActionListener,
    ItemListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected ExpandImage m_expandImage;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public ExpandConfigure() {
            JLabel jLabel;
            int n;
            super(ExpandLayout.this.getLs().getFrame(), "Expand Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(4, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(4, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 20);
                jTextField.setFont(font);
                jTextField.addActionListener(this);
                jPanel3.add(jTextField);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                JCheckBox jCheckBox;
                jLabel = new JLabel(m_checkbox_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                this.m_checkboxes[n] = jCheckBox = new JCheckBox("", m_checkbox_currents[n]);
                jCheckBox.setFont(font);
                jCheckBox.addActionListener(this);
                jPanel3.add(jCheckBox);
            }
            jPanel.add("West", jPanel2);
            jPanel.add("East", jPanel3);
            Container container = this.getContentPane();
            container.add("North", jPanel);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            this.m_expandImage = new ExpandImage();
            jPanel4.add("North", this.m_expandImage);
            this.m_expandImage.validate();
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            jPanel4.add("South", this.m_message);
            container.add("Center", jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                String string = m_button_titles[n];
                if (string == null) {
                    string = ExpandLayout.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string);
                jButton.setFont(font2);
                String string2 = m_button_tips[n];
                if (string2 != null) {
                    jButton.setToolTipText(string2);
                }
                jButton.addActionListener(this);
                jPanel5.add(jButton);
            }
            container.add("South", jPanel5);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ExpandLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ExpandLayout.m_checkbox_defaults[n] = m_checkbox_resets[n];
                    }
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                    }
                    break;
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ExpandLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ExpandLayout.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                    }
                    break;
                }
                case 3: {
                    LandscapeEditorCore landscapeEditorCore = ExpandLayout.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(ExpandLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ExpandLayout.this.m_ls.getFrame(), "Expands/Contracts the visible area of the diagram\nto produce the specified horizontal and vertical\nborders", "Help", 0);
                    return;
                }
                default: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        JTextField jTextField = this.m_textfields[n];
                        if (object != jTextField && n2 != 0) continue;
                        String string = jTextField.getText();
                        string = string.trim();
                        String string2 = m_textfield_titles[n];
                        try {
                            double d = Double.parseDouble(string);
                            if (!(d < 0.0) && !(d >= 1.0)) continue;
                            this.m_message.setText(string2 + " must be in the range 0 to 1.0");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (n2) {
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ExpandLayout.this.setParameter(n, this.m_textfields[n].getText());
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ExpandLayout.m_checkbox_currents[n] = this.m_checkboxes[n].isSelected();
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    this.m_expandImage.repaint();
                    return;
                }
            }
            this.setVisible(false);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.m_expandImage.repaint();
        }

        class ExpandImage
        extends JComponent {
            public ExpandImage() {
                Dimension dimension = new Dimension(400, 240);
                this.setLayout(null);
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.setMaximumSize(dimension);
                this.setSize(dimension);
                this.setVisible(true);
            }

            public void paintComponent(Graphics graphics) {
                double d = m_xborder;
                double d2 = m_yborder;
                boolean bl = ExpandLayout.parameterBoolean(0);
                boolean bl2 = ExpandLayout.parameterBoolean(1);
                int n = this.getWidth();
                int n2 = this.getHeight();
                int n3 = (int)((double)n * (d / 2.0));
                int n4 = (int)((double)n2 * (d2 / 2.0));
                int n5 = (int)((double)n * (1.0 - d));
                int n6 = (int)((double)n2 * (1.0 - d2));
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
                graphics.setColor(Color.blue);
                if (bl) {
                    graphics.drawLine(n3, n4, n3, n4 + n6);
                    graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6);
                }
                if (bl2) {
                    graphics.drawLine(n3, n4, n3 + n5, n4);
                    graphics.drawLine(n3, n4 + n6, n3 + n5, n4 + n6);
                }
            }
        }
    }
}

