/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RelationInstance;

public class FrameModeHandler
extends LandscapeModeHandler {
    protected Diagram m_diagram = null;
    protected DrawOutline m_drawOutline = null;
    protected boolean m_shift_down;
    protected boolean m_control_down;
    protected int m_start_x;
    protected int m_start_y;
    protected int m_end_x;
    protected int m_end_y;
    protected EditModeHandler m_parent;

    public FrameModeHandler(EditModeHandler editModeHandler) {
        super(editModeHandler.m_ls);
        this.m_parent = editModeHandler;
        this.m_drawOutline = new DrawOutline();
    }

    public void cleanup() {
        if (this.m_diagram != null) {
            this.m_drawOutline.setVisible(false);
            this.m_diagram.remove(this.m_drawOutline);
            this.m_diagram = null;
            this.m_ls.setCursor(0);
        }
    }

    public void entityPressed(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        Diagram diagram;
        this.m_diagram = diagram = this.m_ls.getDiagram();
        this.m_shift_down = mouseEvent.isShiftDown();
        this.m_control_down = mouseEvent.isControlDown();
        this.m_end_x = this.m_start_x = n;
        this.m_end_y = this.m_start_y = n2;
        this.m_drawOutline.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
        this.m_drawOutline.setVisible(true);
        diagram.add((Component)this.m_drawOutline, 0);
        this.m_parent.setSubHandler(this);
    }

    public void entityDragged(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        this.m_end_x = n;
        this.m_end_y = n2;
        this.m_drawOutline.repaint();
    }

    public void entityReleased(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        Diagram diagram = this.m_diagram;
        if (diagram != null) {
            int n3 = this.m_start_x;
            int n4 = this.m_end_x - n3;
            int n5 = this.m_start_y;
            int n6 = this.m_end_y - n5;
            if (n4 < 0) {
                n3 = this.m_end_x;
                n4 = -n4;
            }
            if (n6 < 0) {
                n5 = this.m_end_y;
                n6 = -n6;
            }
            if (n4 == 0 || n6 == 0) {
                if (!this.m_shift_down) {
                    diagram.clearFlags();
                }
            } else {
                boolean bl = false;
                EntityInstance entityInstance2 = null;
                if (this.m_control_down) {
                    Vector vector;
                    Enumeration enumeration = entityInstance.getChildren();
                    while (enumeration.hasMoreElements()) {
                        EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
                        if (!entityInstance3.isFramedBy(n3, n5, n4, n6)) continue;
                        if (entityInstance3.getGroupKeyFlag()) {
                            entityInstance2 = entityInstance3;
                            entityInstance3.clearGroupKeyFlag();
                            diagram.clearKeyEntity();
                            continue;
                        }
                        if (!entityInstance3.getGroupFlag()) continue;
                        entityInstance3.clearGroupFlag();
                    }
                    if (entityInstance2 != null && (vector = diagram.getGroup()) != null) {
                        diagram.setKeyEntity((EntityInstance)vector.elementAt(0));
                    }
                } else {
                    EntityInstance entityInstance4 = this.m_diagram.getKeyEntity();
                    if (this.m_shift_down) {
                        entityInstance2 = entityInstance4;
                    } else if (entityInstance4 != null && entityInstance4.getContainedBy() == entityInstance && entityInstance4.isFramedBy(n3, n5, n4, n6)) {
                        entityInstance2 = entityInstance4;
                    }
                    if (!this.m_shift_down) {
                        diagram.clearFlags();
                    }
                    Enumeration enumeration = entityInstance.getChildren();
                    while (enumeration.hasMoreElements()) {
                        EntityInstance entityInstance5 = (EntityInstance)enumeration.nextElement();
                        if (!entityInstance5.isFramedBy(n3, n5, n4, n6)) continue;
                        if (!bl) {
                            if (entityInstance2 == null) {
                                entityInstance2 = entityInstance5;
                            }
                            bl = true;
                        }
                        if (entityInstance5 == entityInstance2) {
                            if (entityInstance5.getGroupKeyFlag()) continue;
                            diagram.setKeyEntity(entityInstance5);
                            continue;
                        }
                        if (entityInstance5.getGroupFlag()) continue;
                        entityInstance5.setGroupFlag();
                    }
                }
                if (bl) {
                    diagram.setPreserveEntityMarks(196608);
                    diagram.setPreserveRelationMarks(0);
                    this.m_ls.show_groupList();
                }
            }
        }
        this.m_parent.cleanup();
    }

    public void relationPressed(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        relationInstance.setGroupAndHighlightFlag();
        this.m_parent.cleanup();
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.GREEN);
        }

        public void paintComponent(Graphics graphics) {
            int n = FrameModeHandler.this.m_start_x;
            int n2 = FrameModeHandler.this.m_end_x - n;
            if (n2 == 0) {
                return;
            }
            int n3 = FrameModeHandler.this.m_start_y;
            int n4 = FrameModeHandler.this.m_end_y - n3;
            if (n4 == 0) {
                return;
            }
            if (n2 < 0) {
                n = FrameModeHandler.this.m_end_x;
                n2 = -n2;
            }
            if (n4 < 0) {
                n3 = FrameModeHandler.this.m_end_y;
                n4 = -n4;
            }
            graphics.drawRect(n, n3, n2, n4);
        }
    }
}

