/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;

class HiChildren {
    static final boolean debug = false;

    HiChildren() {
    }

    private static void addDummyNodes(HiGraph hiGraph) throws HiGraphException {
        HiArc hiArc;
        hiGraph.m_visited = 0;
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            HiChildren.addDummyNodes(hiGraph2);
        }
        HiGraph hiGraph3 = hiGraph.m_parent == null ? null : hiGraph.m_parent.from();
        int n = hiGraph.m_out.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            hiArc = (HiArc)hiGraph.m_out.elementAt(i);
            HiGraph hiGraph4 = hiArc.to();
            if (hiGraph4.m_parent == null || hiGraph4.m_parent.from() != hiGraph3 || (n2 = hiGraph4.m_rank - hiGraph.m_rank - 1) <= 0) continue;
            int n3 = hiGraph.m_sink_rank - hiGraph.m_rank;
            if (n2 < n3 - 1 || hiArc.onSide()) {
                n3 = 0;
            }
            boolean bl = hiArc.reversed();
            HiGraph hiGraph5 = null;
            while (n2 > n3) {
                hiGraph5 = hiGraph3.newChild();
                hiGraph5.m_rank = hiGraph.m_rank + n2;
                hiGraph5.sinkrank(hiGraph5.m_rank);
                hiGraph5.newOutputArc(hiArc);
                hiArc = new HiArc(hiGraph, hiGraph5);
                hiArc.reverse(bl);
                hiGraph5.newInputArc(hiArc);
                --n2;
            }
            hiGraph.m_out.setElementAt(hiArc, i);
        }
    }

    private static void postorderlevel(HiGraph hiGraph) {
        int n = hiGraph.m_minbeneath;
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            int n2 = hiGraph2.m_postorder - hiGraph2.m_minbeneath;
            hiGraph2.m_minbeneath = n;
            hiGraph2.m_postorder = n + n2;
            n += n2 + 1;
        }
    }

    private static int postorder(HiGraph hiGraph, int n) {
        int n2 = n;
        hiGraph.m_minbeneath = n;
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            n2 = HiChildren.postorder(hiGraph2, n2);
        }
        hiGraph.m_postorder = n2;
        return n2 + 1;
    }

    private static void fillMatrix(HiGraph[] hiGraphArray, int[][][] nArray) {
        for (int i = hiGraphArray.length - 1; i >= 0; --i) {
            HiGraph hiGraph = hiGraphArray[i];
            Enumeration enumeration = hiGraph.m_in.elements();
            block1: while (enumeration.hasMoreElements()) {
                hiGraph = hiGraphArray[i];
                HiArc hiArc = (HiArc)enumeration.nextElement();
                HiGraph hiGraph2 = hiArc.from();
                while (true) {
                    int n;
                    if ((n = hiGraph.m_depth) == hiGraph2.m_depth) {
                        int n2 = hiGraph.m_position;
                        int n3 = hiGraph2.m_position;
                        if (n2 == n3) continue block1;
                        int[][] nArray2 = nArray[n];
                        if (n3 < n2) {
                            int[] nArray3 = nArray2[n2];
                            int n4 = n3;
                            nArray3[n4] = nArray3[n4] + 1;
                        } else {
                            int[] nArray4 = nArray2[n3];
                            int n5 = n2;
                            nArray4[n5] = nArray4[n5] + 1;
                        }
                        hiGraph = hiGraph.m_parent.from();
                        hiGraph2 = hiGraph2.m_parent.from();
                        continue;
                    }
                    if (hiGraph2.m_depth > n) {
                        hiGraph2 = hiGraph2.m_parent.from();
                        continue;
                    }
                    hiGraph = hiGraph.m_parent.from();
                }
            }
        }
    }

    private static void dumpMatrix(HiGraph[] hiGraphArray, int[][][] nArray) {
        System.out.println("\nAdjacency matrix\n");
        for (int i = 0; i < nArray.length; ++i) {
            System.out.println("At depth " + i);
            int[][] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                int[] nArray3 = nArray2[j];
                for (int k = 0; k < nArray3.length; ++k) {
                    System.out.print("\t" + nArray3[k]);
                }
                System.out.print("\n");
            }
        }
    }

    private static int[][][] buildMatrices(HiGraph[] hiGraphArray) {
        int n;
        int[][] nArrayArray;
        int n2;
        int n3;
        int n4 = hiGraphArray.length;
        int n5 = n4 - 1;
        HiGraph hiGraph = hiGraphArray[n5];
        int[][][] nArrayArray2 = new int[hiGraph.m_depth + 1][][];
        int n6 = 0;
        hiGraph = hiGraphArray[0];
        int n7 = hiGraph.m_depth;
        for (n3 = 1; n3 < n4; ++n3) {
            hiGraph = hiGraphArray[n3];
            if (hiGraph.m_depth == n7) continue;
            n2 = n3 - n6;
            nArrayArray = new int[n2][];
            nArrayArray2[n7] = nArrayArray;
            for (n = 0; n < n2; ++n) {
                nArrayArray[n] = new int[n + 1];
            }
            n6 = n3;
            n7 = hiGraph.m_depth;
        }
        n2 = n3 - n6;
        nArrayArray = new int[n2][];
        nArrayArray2[n7] = nArrayArray;
        for (n = 0; n < n2; ++n) {
            nArrayArray[n] = new int[n + 1];
        }
        return nArrayArray2;
    }

    private static void computeOutside(HiGraph[] hiGraphArray, int n, int[][][] nArray) {
        int n2;
        HiGraph hiGraph;
        HiGraph hiGraph2 = hiGraphArray[n];
        Vector vector = hiGraph2.m_children;
        if (vector.size() == 0) {
            return;
        }
        hiGraph2 = hiGraphArray[n];
        int n3 = hiGraph2.m_depth;
        int n4 = hiGraphArray.length;
        for (int i = n + 1; i < n4; ++i) {
            hiGraph = hiGraphArray[i];
            if (hiGraph.m_depth == n3) continue;
            n3 = hiGraph.m_depth;
            break;
        }
        for (n2 = i; n2 < n4; ++n2) {
            hiGraph = hiGraphArray[n2];
            if (hiGraph.m_depth != n3) break;
        }
        int[][] nArray2 = nArray[n3];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph3 = hiArc.to();
            int n5 = hiGraph3.m_position;
            int n6 = 0;
            for (int i = i; i < n2; ++i) {
                HiGraph hiGraph4 = hiGraphArray[i];
                HiGraph hiGraph5 = hiGraph4.m_parent.from();
                if (hiGraph5 == hiGraph2) continue;
                int n7 = hiGraph4.m_position;
                int n8 = n7 > n5 ? nArray2[n7][n5] : nArray2[n5][n7];
                if (hiGraph5.m_postorder > hiGraph2.m_postorder) {
                    n6 += n8;
                    continue;
                }
                n6 -= n8;
            }
            hiGraph3.m_outside = n6;
        }
    }

    private static boolean reorder(HiGraph hiGraph, int[][][] nArray, int n) {
        int n2;
        int n3;
        int[] nArray2;
        int n4;
        HiGraph hiGraph2;
        HiArc hiArc;
        int n5;
        Vector vector = hiGraph.m_children;
        int n6 = vector.size();
        boolean bl = false;
        for (n5 = 0; n5 < n6; ++n5) {
            hiArc = (HiArc)vector.elementAt(n5);
            hiGraph2 = hiArc.to();
            if (hiGraph2.m_children.size() == 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return bl;
        }
        bl = false;
        if (hiGraph.dontReorder()) {
            return bl;
        }
        int[][] nArray3 = nArray[hiGraph.m_depth + 1];
        for (n5 = 0; n5 < n6; ++n5) {
            hiArc = (HiArc)vector.elementAt(n5);
            hiGraph2 = hiArc.to();
            n4 = hiGraph2.m_position;
            nArray2 = nArray3[n4];
            n3 = hiGraph2.m_outside * n;
            for (n2 = 0; n2 < n4; ++n2) {
                n3 += nArray2[n2];
            }
            nArray2[n4] = n3;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            int n7;
            HiGraph hiGraph3;
            HiArc hiArc2;
            hiArc = (HiArc)vector.elementAt(n5);
            hiGraph2 = hiArc.to();
            n4 = hiGraph2.m_position;
            int n8 = n5;
            int n9 = nArray3[n4][n4];
            for (n2 = n5 + 1; n2 < n6; ++n2) {
                hiArc2 = (HiArc)vector.elementAt(n2);
                hiGraph3 = hiArc2.to();
                n7 = hiGraph3.m_position;
                int n10 = nArray3[n7][n7];
                if (n10 >= n9) continue;
                n8 = n2;
                n9 = n10;
            }
            hiArc2 = (HiArc)vector.elementAt(n8);
            hiGraph3 = hiArc2.to();
            if (n8 != n5) {
                vector.setElementAt(hiArc2, n5);
                vector.setElementAt(hiArc, n8);
                bl = true;
            }
            n4 = hiGraph3.m_position;
            for (n2 = n5 + 1; n2 < n6; ++n2) {
                hiArc2 = (HiArc)vector.elementAt(n2);
                hiGraph3 = hiArc.to();
                n7 = hiGraph3.m_position;
                nArray2 = nArray3[n7];
                n3 = n4 < n7 ? nArray2[n4] : nArray3[n4][n7];
                int n11 = n7;
                nArray2[n11] = nArray2[n11] - (n3 << 1);
            }
        }
        return bl;
    }

    static void order(HiGraph hiGraph, int n) throws HiGraphException {
        HiGraph hiGraph2;
        int n2;
        HiChildren.addDummyNodes(hiGraph);
        int n3 = HiChildren.postorder(hiGraph, 1) - 1;
        HiGraph[] hiGraphArray = new HiGraph[n3];
        int n4 = 0;
        hiGraphArray[n4] = hiGraph;
        int n5 = 0;
        int n6 = hiGraph.m_depth;
        hiGraph.m_position = 0;
        ++n4;
        for (n2 = 0; n2 < n4; ++n2) {
            hiGraph2 = hiGraphArray[n2];
            if (hiGraph2.m_depth != n6) {
                n6 = hiGraph2.m_depth;
                n5 = 0;
            }
            hiGraph2.m_position = n5++;
            Vector vector = hiGraph2.m_children;
            int n7 = vector.size();
            for (int i = 0; i < n7; ++i) {
                HiArc hiArc = (HiArc)vector.elementAt(i);
                hiGraphArray[n4++] = hiArc.to();
            }
        }
        int[][][] nArray = HiChildren.buildMatrices(hiGraphArray);
        HiChildren.fillMatrix(hiGraphArray, nArray);
        for (n2 = 0; n2 < n4; ++n2) {
            HiChildren.computeOutside(hiGraphArray, n2, nArray);
            hiGraph2 = hiGraphArray[n2];
            if (!HiChildren.reorder(hiGraph2, nArray, n)) continue;
            HiChildren.postorderlevel(hiGraph2);
        }
    }
}

