/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.HiSimplex;

public class HiRank {
    private static void assignWeights(HiGraph hiGraph) throws HiGraphException {
        HiArc hiArc;
        HiGraph hiGraph2 = hiGraph.m_sink;
        if (hiGraph2 != null) {
            hiGraph2.dispose();
            hiGraph2 = null;
            hiGraph.m_sink = null;
        }
        if (hiGraph.m_children.size() != 0) {
            hiGraph.m_sink = hiGraph2 = hiGraph.newChild(2);
        }
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph3 = hiArc.to();
            hiArc.setWeight(0);
            hiArc.setMinlength(1);
            if (hiGraph3 == hiGraph2) continue;
            HiRank.assignWeights(hiGraph3);
            if (hiGraph3.m_sink != null) {
                hiGraph3 = hiGraph3.m_sink;
            }
            hiArc = hiGraph2.newInputArc(hiGraph3);
            hiArc.setWeight(0);
            hiArc.setMinlength(1);
        }
        enumeration = hiGraph.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            if (hiArc.getWeight() == 0) {
                hiArc.setWeight(1);
            }
            if (hiArc.getMinlength() != 0) continue;
            hiArc.setMinlength(1);
        }
    }

    static void removesinks(HiGraph hiGraph) throws HiGraphException {
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiRank.removesinks(hiArc.to());
        }
        HiGraph hiGraph2 = hiGraph.m_sink;
        if (hiGraph2 == null) {
            hiGraph.m_sink_rank = hiGraph.m_rank;
        } else {
            hiGraph.m_sink_rank = hiGraph2.m_rank;
            hiGraph.m_sink = null;
            hiGraph2.dispose();
        }
    }

    private static void balance(HiGraph hiGraph, int[] nArray) throws HiGraphException {
        int n;
        int n2;
        HiGraph hiGraph2;
        int n3;
        HiArc hiArc = hiGraph.m_parent;
        int n4 = hiArc != null ? hiArc.from().m_rank + 1 : 0;
        int n5 = hiGraph.m_sink_rank - 1;
        int[] nArray2 = new int[n5 + 2];
        Vector vector = hiGraph.m_children;
        int n6 = vector.size();
        if (hiGraph.horizontalArray()) {
            for (n3 = n6 - 1; n3 >= 0; --n3) {
                hiArc = (HiArc)vector.elementAt(n3);
                hiGraph2 = hiArc.to();
                hiGraph2.m_rank = hiGraph.m_rank + 1;
            }
        }
        for (n3 = n6 - 1; n3 >= 0; --n3) {
            hiArc = (HiArc)vector.elementAt(n3);
            hiGraph2 = hiArc.to();
            int n7 = hiGraph2.m_rank;
            nArray2[n7] = nArray2[n7] + 1;
        }
        int n8 = Integer.MIN_VALUE;
        if (n6 > 0) {
            n2 = Integer.MAX_VALUE;
            for (n3 = n6 - 1; n3 >= 0; --n3) {
                hiArc = (HiArc)vector.elementAt(n3);
                hiGraph2 = hiArc.to();
                HiRank.balance(hiGraph2, nArray2);
                if (hiGraph2.m_rank < n2) {
                    n2 = hiGraph2.m_rank;
                }
                if (hiGraph2.m_sink_rank <= n8) continue;
                n8 = hiGraph2.m_sink_rank;
            }
            if (n5 >= n2) {
                n5 = n2 - 1;
            }
            hiGraph.m_sink_rank = n8 + 1;
            n4 = hiGraph.m_rank;
        }
        nArray2 = null;
        if (n5 <= n4 || hiGraph.m_weight != 0) {
            return;
        }
        vector = hiGraph.m_in;
        n6 = vector.size();
        for (n3 = n6 - 1; n3 >= 0; --n3) {
            hiArc = (HiArc)vector.elementAt(n3);
            hiGraph2 = hiArc.from();
            if (hiGraph2.m_rank < n4 || n5 > (n4 = hiGraph2.m_rank + 1)) continue;
            return;
        }
        vector = hiGraph.m_out;
        n6 = vector.size();
        for (n3 = n6 - 1; n3 >= 0; --n3) {
            hiArc = (HiArc)vector.elementAt(n3);
            hiGraph2 = hiArc.to();
            if (hiGraph2.m_rank > n5 || (n5 = hiGraph2.m_rank - 1) > n4) continue;
            return;
        }
        if (n8 > 0) {
            hiGraph.m_rank = n5;
            return;
        }
        n2 = hiGraph.m_rank;
        int n9 = n5 + n4;
        for (n3 = n4; n3 <= n5; ++n3) {
            int n10;
            if (nArray[n3] < nArray[n2]) {
                n2 = n3;
                continue;
            }
            if (nArray[n3] != nArray[n2]) continue;
            n = n9 - n2 * 2;
            if (n < 0) {
                n = -n;
            }
            if ((n10 = n9 - n3 * 2) < 0) {
                n10 = -n10;
            }
            if (n10 >= n) continue;
            n2 = n3;
        }
        n = n2 - hiGraph.m_rank;
        if (n != 0) {
            System.out.println("Moving " + hiGraph + " from rank=" + hiGraph.m_rank + " to " + n2);
            int n11 = hiGraph.m_rank;
            nArray[n11] = nArray[n11] - 1;
            int n12 = n2;
            nArray[n12] = nArray[n12] + 1;
            hiGraph.m_rank += n;
        }
    }

    public static void compute(HiGraph hiGraph, int n) throws HiGraphException {
        HiRank.assignWeights(hiGraph);
        HiSimplex.simplex(hiGraph, n);
        HiRank.removesinks(hiGraph);
    }
}

