/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.SimplexLayout;
import lsedit.SortVector;

class HiRow {
    HiRow() {
    }

    static HiGraph[][] buildBoard(HiGraph hiGraph) {
        HiGraph hiGraph2;
        HiArc hiArc;
        int n;
        int[] nArray = new int[hiGraph.m_sink_rank - hiGraph.m_rank + 1];
        int[] nArray2 = new int[hiGraph.m_sink_rank - hiGraph.m_rank + 1];
        Vector vector = hiGraph.m_children;
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            hiArc = (HiArc)vector.elementAt(n);
            hiGraph2 = hiArc.to();
            int n3 = hiGraph2.m_rank - hiGraph.m_rank;
            nArray[n3] = nArray[n3] + 1;
        }
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = n4++;
            if (nArray[n] == 0) continue;
        }
        HiGraph[][] hiGraphArray = new HiGraph[n4][];
        n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            hiGraphArray[n4++] = new HiGraph[nArray[n]];
            nArray[n] = 0;
        }
        for (n = 0; n < n2; ++n) {
            int n5;
            hiArc = (HiArc)vector.elementAt(n);
            hiGraph2 = hiArc.to();
            int n6 = nArray2[hiGraph2.m_rank - hiGraph.m_rank];
            hiGraph2.m_position = n5 = nArray[n6];
            hiGraphArray[n6][n5] = hiGraph2;
            int n7 = n6;
            nArray[n7] = nArray[n7] + 1;
        }
        return hiGraphArray;
    }

    static void dumpRow(int n, HiGraph[] hiGraphArray) {
        System.out.print(n + ":");
        for (int i = 0; i < hiGraphArray.length; ++i) {
            System.out.print(hiGraphArray[i].m_position + ":" + hiGraphArray[i] + " ");
        }
        System.out.println("");
    }

    static void dumpBoard(HiGraph[][] hiGraphArray) {
        for (int i = 0; i < hiGraphArray.length; ++i) {
            HiRow.dumpRow(i, hiGraphArray[i]);
        }
    }

    private static void rowWeight(HiGraph hiGraph) {
        int n;
        HiGraph hiGraph2;
        HiArc hiArc;
        int n2;
        int n3 = 0;
        Vector vector = hiGraph.m_out;
        int n4 = n2 = vector.size();
        while (n4 > 0) {
            hiArc = (HiArc)vector.elementAt(--n4);
            hiGraph2 = hiArc.to();
            n3 += hiGraph2.m_position;
        }
        vector = hiGraph.m_in;
        n4 = n = vector.size();
        while (n4 > 0) {
            hiArc = (HiArc)vector.elementAt(--n4);
            hiGraph2 = hiArc.from();
            n3 += hiGraph2.m_position;
        }
        hiGraph.m_rowweight = (n += n2) == 0 ? -1.0 : (double)(n3 += n) / (double)n;
    }

    private static boolean shake(HiGraph[] hiGraphArray) {
        HiGraph hiGraph;
        boolean bl = false;
        int n = hiGraphArray.length;
        while (n > 0) {
            hiGraph = hiGraphArray[--n];
            HiRow.rowWeight(hiGraph);
        }
        int n2 = hiGraphArray.length;
        block1: while (true) {
            double d = -2.0;
            n = hiGraphArray.length;
            while (n > 0) {
                hiGraph = hiGraphArray[--n];
                if (!(d < hiGraph.m_rowweight)) continue;
                d = hiGraph.m_rowweight;
            }
            n = 0;
            while (true) {
                if (n >= hiGraphArray.length) continue block1;
                hiGraph = hiGraphArray[n];
                if (hiGraph.m_rowweight == d) {
                    if (hiGraph.m_position != --n2) {
                        hiGraph.m_position = n2;
                        bl = true;
                    }
                    hiGraph.m_rowweight = -3.0;
                    if (n2 == 0) {
                        return bl;
                    }
                }
                ++n;
            }
            break;
        }
    }

    private static boolean orderchildren(SimplexLayout simplexLayout, HiGraph hiGraph) throws HiGraphException {
        int n;
        Vector vector = hiGraph.m_children;
        int n2 = vector.size();
        boolean bl = false;
        hiGraph.m_position = 0;
        if (n2 == 0) {
            return bl;
        }
        for (n = 0; n < n2; ++n) {
            HiArc hiArc = (HiArc)vector.elementAt(n);
            HiGraph hiGraph2 = hiArc.to();
            bl |= HiRow.orderchildren(simplexLayout, hiGraph2);
        }
        if (bl) {
            return bl;
        }
        if (hiGraph.dontReorder()) {
            System.out.println("Don't reorder " + hiGraph);
            return true;
        }
        HiGraph[][] hiGraphArray = HiRow.buildBoard(hiGraph);
        int n3 = simplexLayout.crossing();
        int n4 = hiGraphArray.length;
        if (n4 > 1) {
            int n5 = 1;
            boolean bl2 = false;
            boolean bl3 = false;
            n = 0;
            while (true) {
                bl2 |= HiRow.shake(hiGraphArray[n]);
                if ((n3 -= n4) < 0) break;
                if ((n += n5) >= 0 && n < n4) continue;
                if (!bl2) break;
                bl2 = false;
                bl3 = true;
                n5 = -n5;
                n += 2 * n5;
            }
            if (bl3) {
                SortVector.byPosition(vector);
            }
        }
        return true;
    }

    static void order(SimplexLayout simplexLayout, HiGraph hiGraph) throws HiGraphException {
        HiRow.orderchildren(simplexLayout, hiGraph);
    }
}

