/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;

class HiSimplex {
    static final boolean debug = false;

    HiSimplex() {
    }

    public static void dump_constraints(HiGraph hiGraph) {
        HiGraph hiGraph2;
        HiArc hiArc;
        System.out.print(hiGraph + ":");
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            System.out.print(" =" + hiArc.getMinlength() + "(" + hiArc.getWeight() + ")=>" + hiGraph2);
        }
        enumeration = hiGraph.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            System.out.print(" -" + hiArc.getMinlength() + "(" + hiArc.getWeight() + ")->" + hiGraph2);
        }
        System.out.print("\n");
        enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            HiSimplex.dump_constraints(hiGraph2);
        }
    }

    private static void destroy_span(HiGraph hiGraph) throws HiGraphException {
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            HiSimplex.destroy_span(hiGraph2);
        }
        hiGraph.m_span.removeAllElements();
        hiGraph.m_span = null;
        hiGraph.m_back = null;
    }

    private static void dumpspan(HiGraph hiGraph) {
        HiArc hiArc;
        for (int i = 0; i < hiGraph.m_rank; ++i) {
            System.out.print(" ");
        }
        System.out.print("[rank=" + hiGraph.m_rank + " weight=" + hiGraph.m_weight + "]" + hiGraph.label());
        Enumeration enumeration = hiGraph.m_span.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            System.out.print(" (cut=" + hiArc.cutValue() + ")" + hiArc);
        }
        System.out.print("\n");
        enumeration = hiGraph.m_span.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            if (hiGraph2 == hiGraph) {
                hiGraph2 = hiArc.from();
            }
            HiSimplex.dumpspan(hiGraph2);
        }
    }

    private static void dumpspantree(HiGraph hiGraph) {
        System.out.println("Dumping graph because of " + hiGraph);
        HiGraph hiGraph2 = hiGraph;
        while (hiGraph2.m_parent != null) {
            hiGraph2 = hiGraph2.m_parent.from();
        }
        hiGraph2.dump();
        System.out.println("Dumping spanning tree");
        hiGraph2 = hiGraph;
        while (hiGraph2.m_back != null) {
            if (hiGraph2 == hiGraph2.m_back.from()) {
                hiGraph2 = hiGraph2.m_back.to();
                continue;
            }
            hiGraph2 = hiGraph2.m_back.from();
        }
        HiSimplex.dumpspan(hiGraph2);
    }

    private static int prepareGraph(HiGraph hiGraph) {
        int n = 1;
        hiGraph.m_visited = 0;
        hiGraph.m_rank = 0;
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            n += HiSimplex.prepareGraph(hiGraph2);
        }
        return n;
    }

    private static void placeBelow(HiGraph hiGraph) throws HiGraphException {
        HiGraph hiGraph2;
        HiArc hiArc;
        int n;
        Vector vector = hiGraph.m_children;
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            hiArc = (HiArc)vector.elementAt(n);
            hiGraph2 = hiArc.to();
            HiSimplex.placeBelow(hiGraph2);
        }
        if (n2 == 0) {
            return;
        }
        vector = hiGraph.m_out;
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            HiArc hiArc2;
            hiArc = (HiArc)vector.elementAt(n);
            if (hiArc.onSide()) continue;
            HiGraph hiGraph3 = hiGraph2 = hiArc.to();
            while (hiGraph3 != hiGraph && (hiArc2 = hiGraph3.m_parent) != null) {
                hiGraph3 = hiArc2.from();
            }
            if (hiGraph3 == hiGraph) continue;
            hiGraph2.newInputArc(hiGraph.m_sink);
        }
    }

    private static void fixCycles(HiGraph hiGraph) throws HiGraphException {
        if (hiGraph.m_visited == 0) {
            HiArc hiArc;
            hiGraph.m_visited = 1;
            Vector vector = hiGraph.m_children;
            int n = vector.size();
            while (n > 0) {
                hiArc = (HiArc)vector.elementAt(--n);
                HiSimplex.fixCycles(hiArc.to());
            }
            Vector vector2 = hiGraph.m_out;
            n = vector2.size();
            while (n > 0) {
                hiArc = (HiArc)vector2.elementAt(--n);
                HiGraph hiGraph2 = hiArc.to();
                if (hiGraph2.m_visited == 1) {
                    HiGraph.removeArc(vector2, hiArc);
                    HiGraph.removeArc(hiGraph2.m_in, hiArc);
                    hiArc.reverse();
                    hiGraph2.m_out.addElement(hiArc);
                    hiGraph.m_in.addElement(hiArc);
                    continue;
                }
                HiSimplex.fixCycles(hiGraph2);
            }
            hiGraph.m_visited = 2;
        }
    }

    private static void countInputArcs(HiGraph hiGraph) {
        if (hiGraph.m_span == null) {
            hiGraph.m_span = new Vector();
        }
        hiGraph.m_inputs = (hiGraph.m_parent != null ? 1 : 0) + hiGraph.m_in.size();
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            HiSimplex.countInputArcs(hiGraph2);
        }
    }

    private static int feasibleRank(HiGraph hiGraph, int n, HiArc[] hiArcArray) {
        Enumeration enumeration = hiGraph.m_children.elements();
        for (int i = 0; i < 2; ++i) {
            while (enumeration.hasMoreElements()) {
                HiGraph hiGraph2;
                HiArc hiArc = (HiArc)enumeration.nextElement();
                HiGraph hiGraph3 = hiArc.to();
                int n2 = hiGraph.m_rank + hiArc.getMinlength();
                if (n2 > hiGraph3.m_rank) {
                    hiGraph3.m_rank = n2;
                }
                if (--hiGraph3.m_inputs != 0) continue;
                if (n2 == hiGraph3.m_rank) {
                    hiGraph2 = hiGraph;
                } else {
                    Enumeration enumeration2 = hiGraph3.m_in.elements();
                    while (enumeration2.hasMoreElements()) {
                        hiArc = (HiArc)enumeration2.nextElement();
                        hiGraph2 = hiArc.from();
                        n2 = hiGraph2.m_rank + hiArc.getMinlength();
                        if (n2 != hiGraph3.m_rank) continue;
                    }
                    if (n2 != hiGraph3.m_rank) {
                        hiArc = hiGraph3.m_parent;
                        hiGraph2 = hiArc.from();
                        n2 = hiGraph2.m_rank + hiArc.getMinlength();
                        if (n2 != hiGraph3.m_rank) {
                            System.out.println("Can't find tight arc for " + hiGraph + " " + hiGraph3);
                        }
                    }
                }
                hiGraph3.m_back = hiArc;
                hiGraph2 = hiArc.from();
                hiGraph2.m_span.addElement(hiArc);
                hiArcArray[n++] = hiArc;
            }
            enumeration = hiGraph.m_out.elements();
        }
        return n;
    }

    private static int isfeasible(HiGraph hiGraph) throws HiGraphException {
        int n = 0;
        hiGraph.m_visited = 0;
        for (int i = 0; i < 2; ++i) {
            Enumeration enumeration;
            Enumeration enumeration2 = enumeration = i == 0 ? hiGraph.m_children.elements() : hiGraph.m_out.elements();
            while (enumeration.hasMoreElements()) {
                HiArc hiArc = (HiArc)enumeration.nextElement();
                HiGraph hiGraph2 = hiArc.to();
                int n2 = hiGraph2.m_rank - hiGraph.m_rank - hiArc.getMinlength();
                if (n2 < 0) {
                    throw new HiGraphException("Graph no longer feasible on " + hiArc + " " + hiGraph2.m_rank + "-" + hiGraph.m_rank + "<" + hiArc.getMinlength());
                }
                n += n2 * hiArc.getWeight();
                if (i != 0) continue;
                n += HiSimplex.isfeasible(hiGraph2);
            }
        }
        return n;
    }

    private static void spantreevalid1(HiGraph hiGraph) throws HiGraphException {
        if (hiGraph.m_visited != 0) {
            throw new HiGraphException("Spanning tree is not a tree");
        }
        hiGraph.m_visited = 1;
        Enumeration enumeration = hiGraph.m_span.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            HiGraph hiGraph3 = hiArc.from();
            if (hiGraph2 != hiGraph) {
                if (hiGraph2.m_rank - hiGraph3.m_rank != hiArc.getMinlength()) {
                    throw new HiGraphException("Spanning arc " + hiArc + " not tight " + hiGraph2.m_rank + "-" + hiGraph3.m_rank + "!=" + hiArc.getMinlength());
                }
            } else {
                hiGraph3 = hiGraph2;
                hiGraph2 = hiArc.from();
                if (hiGraph3.m_rank - hiGraph2.m_rank != hiArc.getMinlength()) {
                    throw new HiGraphException("Spanning arc " + hiArc + " not tight " + hiGraph3.m_rank + "-" + hiGraph2.m_rank + "!=" + hiArc.getMinlength());
                }
            }
            if (hiGraph2.m_postorder >= hiGraph.m_postorder || hiGraph2.m_postorder < hiGraph.m_minbeneath) {
                throw new HiGraphException("Post order wrong");
            }
            if (hiGraph3 != hiGraph) {
                throw new HiGraphException("Spanning arc broken");
            }
            HiSimplex.spantreevalid1(hiGraph2);
        }
    }

    private static void spantreevalid2(HiGraph hiGraph) throws HiGraphException {
        if (hiGraph.m_visited == 0) {
            throw new HiGraphException("Spanning tree never connected " + hiGraph.label());
        }
        hiGraph.m_visited = 0;
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.to();
            HiSimplex.spantreevalid2(hiGraph2);
        }
    }

    private static void isvalid(HiGraph hiGraph) throws HiGraphException {
        int n = HiSimplex.isfeasible(hiGraph);
        HiGraph hiGraph2 = hiGraph;
        while (hiGraph2.m_back != null) {
            hiGraph2 = hiGraph2.m_back.from();
        }
        HiSimplex.spantreevalid1(hiGraph2);
        HiSimplex.spantreevalid2(hiGraph);
    }

    private static void computeWeights(HiGraph hiGraph) {
        int n = 0;
        HiArc hiArc = hiGraph.m_parent;
        if (hiArc != null) {
            n = hiArc.getWeight();
        }
        Enumeration enumeration = hiGraph.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            n -= hiArc.getWeight();
            HiGraph hiGraph2 = hiArc.to();
            HiSimplex.computeWeights(hiGraph2);
        }
        enumeration = hiGraph.m_in.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            n += hiArc.getWeight();
            if (hiArc.from().m_out.contains(hiArc)) continue;
            System.out.println("Input arc " + hiArc + " broken when computing weights");
        }
        enumeration = hiGraph.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            n -= hiArc.getWeight();
            if (hiArc.to().m_in.contains(hiArc)) continue;
            System.out.println("Output arc " + hiArc + " broken when computing weights");
        }
        hiGraph.m_weight = n;
    }

    private static void postorder(HiGraph hiGraph, int n) {
        HiArc hiArc;
        HiGraph hiGraph2 = null;
        int n2 = n;
        int n3 = 0;
        hiGraph.m_minbeneath = n;
        Enumeration enumeration = hiGraph.m_span.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            int n4 = hiArc.getMinlength();
            if (hiGraph2 != hiGraph) {
                hiGraph2.m_rank = hiGraph.m_rank + n4;
            } else {
                hiGraph2 = hiArc.from();
                hiGraph2.m_rank = hiGraph.m_rank - n4;
            }
            HiSimplex.postorder(hiGraph2, n2);
            n3 += hiArc.cutValue();
            n2 = hiGraph2.m_postorder + 1;
        }
        hiGraph.m_postorder = n2;
        n3 += hiGraph.m_weight;
        hiArc = hiGraph.m_back;
        if (hiArc != null) {
            hiArc.cutValue(n3);
        }
    }

    private static HiArc alternativeEdge(HiArc hiArc, int n, HiArc[] hiArcArray, int n2) throws HiGraphException {
        int n3;
        boolean bl = true;
        HiArc hiArc2 = null;
        HiGraph hiGraph = hiArc.to();
        HiGraph hiGraph2 = hiArc.from();
        int n4 = Integer.MAX_VALUE;
        if (hiGraph.m_postorder > hiGraph2.m_postorder) {
            hiGraph = hiGraph2;
            bl = false;
        }
        int n5 = hiGraph.m_minbeneath;
        int n6 = hiGraph.m_postorder;
        int n7 = n3 = n2;
        do {
            boolean bl2;
            HiArc hiArc3 = hiArcArray[n7];
            HiGraph hiGraph3 = hiArc3.to();
            if (hiGraph3.m_back != hiArc3) {
                hiGraph3 = hiArc3.from();
            }
            boolean bl3 = bl2 = hiGraph3.m_postorder >= n5 && hiGraph3.m_postorder <= n6;
            if (bl2 ^ bl) {
                int n8;
                HiGraph hiGraph4;
                Enumeration enumeration = hiGraph3.m_in.elements();
                while (enumeration.hasMoreElements()) {
                    hiArc3 = (HiArc)enumeration.nextElement();
                    if (hiArc3 == hiArc) continue;
                    hiGraph4 = hiArc3.from();
                    if (!((hiGraph4.m_postorder >= n5 && hiGraph4.m_postorder <= n6) ^ bl2) || (n8 = hiGraph3.m_rank - hiGraph4.m_rank - hiArc3.getMinlength()) >= n4) continue;
                    n4 = n8;
                    hiArc2 = hiArc3;
                }
                hiArc3 = hiGraph3.m_parent;
                if (hiArc3 == null) {
                    throw new HiGraphException("AlternativeNodeEdge examining root?");
                }
                if (hiArc3 != hiArc) {
                    hiGraph4 = hiArc3.from();
                    if ((hiGraph4.m_postorder >= n5 && hiGraph4.m_postorder <= n6) ^ bl2 && (n8 = hiGraph3.m_rank - hiGraph4.m_rank - hiArc3.getMinlength()) < n4) {
                        n4 = n8;
                        hiArc2 = hiArc3;
                    }
                }
            }
            if (++n7 != n) continue;
            n7 = 0;
        } while (n7 != n3);
        return hiArc2;
    }

    private static void updateSpanningTree(HiArc hiArc, HiArc hiArc2) throws HiGraphException {
        HiGraph hiGraph;
        HiArc hiArc3;
        HiGraph hiGraph2;
        HiGraph hiGraph3 = hiArc.from();
        HiGraph hiGraph4 = hiArc.to();
        if (hiGraph3.m_postorder > hiGraph4.m_postorder) {
            hiGraph2 = hiGraph3;
            hiGraph3 = hiGraph4;
            hiGraph4 = hiGraph2;
        }
        HiGraph hiGraph5 = hiArc2.from();
        HiGraph hiGraph6 = hiArc2.to();
        if (hiGraph5.m_postorder < hiGraph3.m_minbeneath || hiGraph5.m_postorder > hiGraph3.m_postorder) {
            hiGraph2 = hiGraph5;
            hiGraph5 = hiGraph6;
            hiGraph6 = hiGraph2;
        }
        if (hiGraph5.m_postorder > hiGraph3.m_postorder || hiGraph5.m_postorder < hiGraph3.m_minbeneath) {
            throw new HiGraphException("Alternative head " + hiGraph5 + " in " + hiArc2 + " doesn't address disconnected component " + hiGraph3 + " in " + hiArc);
        }
        if (hiGraph6.m_postorder <= hiGraph3.m_postorder && hiGraph6.m_postorder >= hiGraph3.m_minbeneath) {
            throw new HiGraphException("Alternative tail " + hiGraph6 + " in " + hiArc2 + " doesn't address connected component " + hiGraph3 + " in " + hiArc);
        }
        HiArc hiArc4 = hiArc2;
        HiGraph hiGraph7 = hiGraph6;
        hiGraph2 = hiGraph5;
        while (hiGraph2 != hiGraph4) {
            hiArc3 = hiGraph2.m_back;
            if (hiArc3 == null) {
                System.out.println("Back null!!!");
            }
            hiGraph2.m_back = hiArc4;
            hiGraph7.m_span.addElement(hiArc4);
            hiGraph = hiArc3.from();
            if (hiGraph == hiGraph2) {
                hiGraph = hiArc3.to();
            }
            HiGraph.removeArc(hiGraph.m_span, hiArc3);
            hiGraph7 = hiGraph2;
            hiArc4 = hiArc3;
            hiGraph2 = hiGraph;
        }
        int n = hiGraph5.m_postorder;
        int n2 = hiGraph6.m_postorder;
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        hiGraph2 = hiGraph4;
        while (hiGraph2.m_minbeneath > n || hiGraph2.m_postorder < n2) {
            hiArc3 = hiGraph2.m_back;
            hiGraph = hiArc3.to();
            if (hiGraph == hiGraph2) {
                hiGraph = hiArc3.from();
            }
            hiGraph2 = hiGraph;
        }
        HiSimplex.postorder(hiGraph2, hiGraph2.m_minbeneath);
    }

    static void simplex(HiGraph hiGraph, int n) throws HiGraphException {
        HiGraph hiGraph2;
        int n2;
        int n3 = HiSimplex.prepareGraph(hiGraph);
        HiArc[] hiArcArray = new HiArc[n3];
        if (hiGraph.m_sink != null) {
            HiSimplex.placeBelow(hiGraph);
        }
        HiSimplex.fixCycles(hiGraph);
        HiSimplex.countInputArcs(hiGraph);
        hiGraph.m_rank = 0;
        int n4 = HiSimplex.feasibleRank(hiGraph, 0, hiArcArray);
        for (n2 = 0; n2 < n4; ++n2) {
            hiGraph2 = hiArcArray[n2].to();
            n4 = HiSimplex.feasibleRank(hiGraph2, n4, hiArcArray);
        }
        HiSimplex.computeWeights(hiGraph);
        HiSimplex.postorder(hiGraph, 1);
        n2 = 0;
        int n5 = n;
        int n6 = 0;
        if (n4 != 0) {
            HiArc hiArc;
            for (n5 = n; n5 != 0; --n5) {
                int n7;
                n2 = n7 = n6;
                int n8 = 0;
                do {
                    if (++n2 == n4) {
                        n2 = 0;
                    }
                    hiArc = hiArcArray[n2];
                    int n9 = hiArc.cutValue();
                    hiGraph2 = hiArc.to();
                    if (hiArc != hiGraph2.m_back) {
                        n9 = 0 - n9;
                    }
                    if (n9 >= n8) continue;
                    n8 = n9;
                    n6 = n2;
                } while (n2 != n7);
                if (n8 == 0) break;
                HiArc hiArc2 = HiSimplex.alternativeEdge(hiArcArray[n6], n4, hiArcArray, n6);
                if (hiArc2 == null) {
                    throw new HiGraphException("Simplex operation not yet optimal but no improvement found");
                }
                HiSimplex.updateSpanningTree(hiArcArray[n6], hiArc2);
                hiArcArray[n6] = hiArc2;
            }
            if (n5 == 0) {
                System.out.println("Unable to optimize ranking using " + n + " simplex improvements on a graph of " + n3 + " nodes");
            }
            for (n2 = 0; n2 < n4; ++n2) {
                hiArc = hiArcArray[n2];
                hiArcArray[n2] = null;
            }
        }
        HiSimplex.destroy_span(hiGraph);
        hiArcArray = null;
    }
}

