/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lsedit.ColorCache;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.FontCache;
import lsedit.ImageCheckBox;

class ImageChooser
extends JDialog
implements ActionListener,
ItemListener {
    protected ImageCheckBox[] m_checkboxes;
    protected LayoutImage m_layoutImage;
    protected JButton m_ok;
    protected JButton m_cancel;
    protected Integer m_result;

    private int getNewImageValue() {
        ImageCheckBox[] imageCheckBoxArray = this.m_checkboxes;
        int n = imageCheckBoxArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ImageCheckBox imageCheckBox = imageCheckBoxArray[i];
            if (!imageCheckBox.isSelected()) continue;
            n2 |= 1 << i;
        }
        return n2;
    }

    public ImageChooser(JFrame jFrame, Integer n) {
        super(jFrame, "Select image properties", true);
        int n2 = EntityClass.imageName.length;
        this.m_result = n;
        int n3 = n;
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(n2, 1, 0, 0);
        jPanel.setLayout(gridLayout);
        this.m_checkboxes = new ImageCheckBox[n2];
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            ImageCheckBox imageCheckBox;
            this.m_checkboxes[i] = imageCheckBox = new ImageCheckBox(EntityClass.imageName[i], (n3 & n4) != 0, n4);
            imageCheckBox.setFont(font2);
            jPanel.add(imageCheckBox);
            imageCheckBox.addItemListener(this);
            n4 <<= 1;
        }
        Container container = this.getContentPane();
        container.add("North", jPanel);
        this.m_layoutImage = new LayoutImage();
        this.m_layoutImage.validate();
        container.add("Center", this.m_layoutImage);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(font2);
        jPanel2.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(font2);
        jPanel2.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        container.add("South", jPanel2);
        this.pack();
        this.setVisible(true);
    }

    public Integer getImage() {
        return this.m_result;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof ImageCheckBox) {
            this.m_layoutImage.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_ok) {
            int n = this.getNewImageValue();
            if (n != this.m_result) {
                this.m_result = new Integer(n);
            }
        } else if (object != this.m_cancel) {
            return;
        }
        this.setVisible(false);
    }

    class LayoutImage
    extends JComponent {
        public LayoutImage() {
            Dimension dimension = new Dimension(240, 240);
            this.setLayout(null);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setSize(dimension);
            this.setVisible(true);
        }

        public void paintComponent(Graphics graphics) {
            int n = ImageChooser.this.getNewImageValue();
            graphics.setColor(Color.black);
            EntityComponent.paintImage(graphics, n, 20, 20, 200, 200);
        }
    }
}

