/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.LandscapeObject3D;
import lsedit.MyUndoableEdit;
import lsedit.ResultBox;
import lsedit.Ta;
import lsedit.Util;

public abstract class LandscapeClassObject
extends LandscapeObject3D {
    private Vector m_inherits = new Vector();
    protected static final String CLASSLABEL_ID = "class_label";
    protected static final String CLASSSTYLE_ID = "class_style";
    protected static final String CLASSDESC_ID = "class_description";
    private int m_nid = -1;
    private Diagram m_dg;
    private Ta m_ta;

    public LandscapeClassObject(Ta ta) {
        this.m_ta = ta;
        this.m_dg = ta.getDiagram();
    }

    public Enumeration getParentElements() {
        return this.m_inherits.elements();
    }

    public int getParentCnt() {
        return this.m_inherits.size();
    }

    public Vector getInherits() {
        return this.m_inherits;
    }

    public void setInherits(Vector vector) {
        this.m_inherits = vector;
        if (this.m_dg != null) {
            this.m_dg.getLs().repaint();
        }
    }

    public void updateInherits(Vector vector) {
        Vector vector2 = this.getInherits();
        if (vector2.size() != vector.size() || !vector.containsAll(vector2)) {
            this.setInherits(vector);
            if (this.undoEnabled()) {
                new SetInherits(vector2);
            }
        }
    }

    public boolean directlyInheritsFrom(Object object) {
        return this.m_inherits.contains(object);
    }

    public boolean subclassOf(LandscapeClassObject landscapeClassObject) {
        Enumeration enumeration = this.getParentElements();
        while (enumeration.hasMoreElements()) {
            LandscapeClassObject landscapeClassObject2 = (LandscapeClassObject)enumeration.nextElement();
            if (landscapeClassObject2 != landscapeClassObject && !landscapeClassObject2.subclassOf(landscapeClassObject)) continue;
            return true;
        }
        return false;
    }

    public Vector getClassAndSubclasses(Hashtable hashtable) {
        boolean bl;
        Vector<LandscapeClassObject> vector = new Vector<LandscapeClassObject>();
        vector.add(this);
        do {
            bl = false;
            Enumeration enumeration = hashtable.elements();
            block1: while (enumeration.hasMoreElements()) {
                LandscapeClassObject landscapeClassObject = (LandscapeClassObject)enumeration.nextElement();
                if (vector.contains(landscapeClassObject)) continue;
                Vector vector2 = landscapeClassObject.getInherits();
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    if (!vector.contains(vector2.elementAt(i))) continue;
                    vector.add(landscapeClassObject);
                    bl = true;
                    continue block1;
                }
            }
        } while (bl);
        return vector;
    }

    public Vector getClassAndSuperclasses() {
        boolean bl;
        Vector<LandscapeClassObject> vector = new Vector<LandscapeClassObject>();
        vector.add(this);
        do {
            bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                LandscapeClassObject landscapeClassObject = (LandscapeClassObject)vector.elementAt(i);
                Vector vector2 = landscapeClassObject.getInherits();
                for (int j = 0; j < vector2.size(); ++j) {
                    LandscapeClassObject landscapeClassObject2 = (LandscapeClassObject)vector2.elementAt(j);
                    if (vector.contains(landscapeClassObject2)) continue;
                    vector.add(landscapeClassObject2);
                    bl = true;
                }
            }
        } while (bl);
        return vector;
    }

    public Vector getValidAttributes() {
        Vector vector = this.getClassAndSuperclasses();
        int n = vector.size();
        Vector<Attribute> vector2 = new Vector<Attribute>();
        for (int i = 0; i < n; ++i) {
            LandscapeClassObject landscapeClassObject = (LandscapeClassObject)vector.elementAt(i);
            Enumeration enumeration = landscapeClassObject.getLsAttributesEnum();
            if (enumeration == null) continue;
            block1: while (enumeration.hasMoreElements()) {
                Attribute attribute;
                Attribute attribute2 = (Attribute)enumeration.nextElement();
                String string = attribute2.id;
                int n2 = vector2.size();
                do {
                    if (--n2 < 0) {
                        vector2.add(attribute2);
                        continue block1;
                    }
                    attribute = (Attribute)vector2.elementAt(n2);
                } while (!string.equals(attribute.id));
            }
        }
        return vector2;
    }

    public String addParentClass(LandscapeClassObject landscapeClassObject) {
        if (landscapeClassObject == null) {
            return "Can't inherit from null class";
        }
        if (this.subclassOf(landscapeClassObject)) {
            return "Already inherits from " + landscapeClassObject.getId();
        }
        int n = this.m_inherits.size();
        while (--n >= 0) {
            LandscapeClassObject landscapeClassObject2 = (LandscapeClassObject)this.m_inherits.elementAt(n);
            if (!landscapeClassObject.subclassOf(landscapeClassObject2)) continue;
            this.m_inherits.remove(n);
        }
        this.m_inherits.addElement(landscapeClassObject);
        return null;
    }

    protected boolean processClassAttributes(Attribute attribute) {
        if (attribute.avi != null) {
            if (attribute.id.equals(CLASSLABEL_ID)) {
                this.setLabel(attribute.avi.value);
                return true;
            }
            if (attribute.id.equals(CLASSSTYLE_ID)) {
                this.setStyle(Util.parseInt(attribute.avi.value));
                return true;
            }
            if (attribute.id.equals(CLASSDESC_ID)) {
                this.setDescription(attribute.avi.value);
                return true;
            }
        }
        return false;
    }

    public void reportClassAttributes(ResultBox resultBox) {
        resultBox.addText(CLASSLABEL_ID);
        resultBox.addText(CLASSSTYLE_ID);
        resultBox.addText(CLASSDESC_ID);
        resultBox.addText("color");
        resultBox.addText("labelcolor");
        resultBox.addText("opencolor");
    }

    public Ta getTa() {
        return this.m_ta;
    }

    public Diagram getDiagram() {
        return this.m_dg;
    }

    public int getNid() {
        return this.m_nid;
    }

    public void setNid(int n) {
        this.m_nid = n;
    }

    public String getLabelId() {
        return "(" + this.m_nid + ") " + this.getLabel();
    }

    public LandscapeClassObject derivedFrom(int n) {
        return n < this.m_inherits.size() ? (LandscapeClassObject)this.m_inherits.elementAt(n) : null;
    }

    public void addAttribute(Attribute attribute) {
        if (attribute.avi != null && attribute.id.startsWith("class_") && this.processClassAttributes(attribute)) {
            return;
        }
        if (this.processFirstOrder(attribute)) {
            return;
        }
        Attribute attribute2 = this.getLsAttribute(attribute.id);
        if (attribute2 == null) {
            this.putLsAttribute(attribute);
            attribute.m_cloneOnAssign = true;
        } else if (attribute.avi != null) {
            attribute2.avi = attribute.avi;
        }
    }

    public Attribute getLsAttribute(String string) {
        Attribute attribute = super.getLsAttribute(string);
        if (attribute != null) {
            return attribute;
        }
        Enumeration enumeration = this.getParentElements();
        while (enumeration.hasMoreElements()) {
            LandscapeClassObject landscapeClassObject = (LandscapeClassObject)enumeration.nextElement();
            attribute = landscapeClassObject.getLsAttribute(string);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        String string;
        int n;
        super.writeAttributes(printStream, null, true);
        String string2 = this.getLabel();
        if (!this.getId().equals(string2)) {
            printStream.print(" class_label = " + this.qt(string2) + "\n");
        }
        if ((n = this.getStyle()) >= 0) {
            printStream.print(" class_style = " + n + "\n");
        }
        if ((string = this.getDescription()) != null) {
            printStream.print(" class_description = " + AttributeValueItem.qt(string) + "\n");
        }
    }

    public void setColor(Color color) {
        Attribute attribute = this.getLsAttribute("color");
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        attribute.avi.value = "" + d;
        attribute.avi.next.value = "" + d2;
        attribute.avi.next.next.value = "" + d3;
    }

    class SetInherits
    extends MyUndoableEdit
    implements UndoableEdit {
        Vector m_old;
        Vector m_new;

        SetInherits(Vector vector) {
            this.m_old = vector;
            this.m_new = LandscapeClassObject.this.getInherits();
            LandscapeClassObject.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeClassObject.this.getLabel() + " inheritance";
        }

        public void undo() {
            LandscapeClassObject.this.setInherits(this.m_old);
        }

        public void redo() {
            LandscapeClassObject.this.setInherits(this.m_new);
        }
    }
}

