/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import lsedit.LandscapeEditorCore;
import lsedit.MsgOut;
import lsedit.Util;

class LandscapeEditorFrame
extends JFrame
implements WindowListener {
    protected static final int MAX_WIDTH = 1280;
    protected static final int MAX_HEIGHT = 1024;
    protected static Dimension editorDim = null;
    protected static Dimension diagDim = null;
    protected boolean m_landscapeGeo = false;
    protected int m_frameWidth = 0;
    protected int m_frameHeight = 0;
    protected int m_diagramPercentWidth = 0;
    protected int m_diagramPercentHeight = 0;
    protected String m_use_layouter = null;
    protected int m_handicapped = 0;
    protected LandscapeEditorCore m_app;

    public LandscapeEditorFrame() {
        MsgOut.setVerboseFlag(false);
        MsgOut.setDebugFlag(false);
    }

    public static LandscapeEditorFrame create() {
        return new LandscapeEditorFrame();
    }

    public LandscapeEditorCore getApp() {
        if (this.m_app == null) {
            this.m_app = new LandscapeEditorCore(this);
            if (this.m_use_layouter != null) {
                this.m_app.defaultToLayouter(this.m_use_layouter);
            }
        }
        return this.m_app;
    }

    public void launch() {
        if (this.m_frameWidth <= 0 || this.m_frameHeight <= 0) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            double d = 0.75;
            if (this.m_landscapeGeo) {
                this.m_frameWidth = Math.min(1280, dimension.width);
                this.m_frameHeight = Math.min(1024, dimension.height);
            } else {
                this.m_frameWidth = (int)((double)dimension.width / d);
                this.m_frameHeight = dimension.height - 50;
            }
            this.m_frameWidth = Math.min(this.m_frameWidth, dimension.width);
            this.m_frameHeight = Math.min(this.m_frameHeight, dimension.height);
        }
        this.setBounds(0, 0, this.m_frameWidth, this.m_frameHeight);
        LandscapeEditorCore landscapeEditorCore = this.getApp();
        this.setTitle(landscapeEditorCore.getTitle());
        this.setVisible(true);
        JMenuBar jMenuBar = landscapeEditorCore.genMenu();
        this.setJMenuBar(jMenuBar);
        landscapeEditorCore.init_core(this.m_diagramPercentWidth, this.m_diagramPercentHeight);
        if (this.m_handicapped > 0) {
            landscapeEditorCore.handicapped(this.m_handicapped);
        }
        this.addWindowListener(this);
        this.setBackground(Color.lightGray);
        this.setVisible(true);
    }

    public void setDebugOn() {
        MsgOut.setDebugFlag(true);
        MsgOut.dprintln("Start app: ");
    }

    public void setVerboseOn() {
        MsgOut.setVerboseFlag(true);
    }

    public void setLandscapeGeo() {
        this.m_landscapeGeo = true;
    }

    public boolean setFrameDimension(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.m_frameWidth = n;
            this.m_frameHeight = n2;
            return true;
        }
        return false;
    }

    public boolean setFrameDimension(String string) {
        int n = string.indexOf(120);
        if (n > 0) {
            try {
                int n2 = Util.parseInt(string.substring(0, n));
                int n3 = Util.parseInt(string.substring(n + 1));
                return this.setFrameDimension(n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean setDiagramPercent(int n, int n2) {
        if (n > 0 && n <= 100 && n2 > 0 && n2 <= 100) {
            this.m_diagramPercentWidth = n;
            this.m_diagramPercentHeight = n2;
            return true;
        }
        return false;
    }

    public boolean setDiagramPercent(String string) {
        int n = string.indexOf(120);
        if (n > 0) {
            try {
                int n2 = Util.parseInt(string.substring(0, n));
                int n3 = Util.parseInt(string.substring(n + 1));
                return this.setDiagramPercent(n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void setHandicapped(String string) {
        int n;
        try {
            n = Util.parseInt(string);
        }
        catch (Exception exception) {
            n = 20;
        }
        this.m_handicapped = n;
    }

    public void showToc() {
        LandscapeEditorCore landscapeEditorCore = this.getApp();
        landscapeEditorCore.setTocHiddenState(false);
    }

    public boolean setLayouter(String string) {
        this.m_use_layouter = string;
        return true;
    }

    public boolean setStartEntity(String string) {
        LandscapeEditorCore landscapeEditorCore = this.getApp();
        landscapeEditorCore.m_startEntity = string;
        return true;
    }

    public boolean setSavePath(String string) {
        LandscapeEditorCore landscapeEditorCore = this.getApp();
        landscapeEditorCore.lsSavePath = string;
        return true;
    }

    public boolean setSaveSuffix(String string) {
        LandscapeEditorCore landscapeEditorCore = this.getApp();
        landscapeEditorCore.lsSaveSuffix = string;
        return true;
    }

    public boolean setSaveCommand(String string) {
        LandscapeEditorCore landscapeEditorCore = this.getApp();
        landscapeEditorCore.lsSaveCmd = string;
        return true;
    }

    public void setLsPath(String string) {
        LandscapeEditorCore landscapeEditorCore = this.getApp();
        if (landscapeEditorCore.m_lsPath == null) {
            landscapeEditorCore.m_lsPath = string;
        } else {
            landscapeEditorCore.addLseditHistory(string);
        }
    }

    public static void usage() {
        System.out.println("\nLandscape Editor 7.1.19\n");
        System.out.println("<executor> LandscapeEditorFrame [options] <HTTP or file path>\n");
        System.out.println("-h\t This message");
        System.out.println("-?\t This message");
        System.out.println("-v\t Verbose parsing output");
        System.out.println("");
        System.out.println("-g<width>x<height> Geometry of editor");
        System.out.println("-G<width>x<height> Geometry of diagram");
        System.out.println("");
        System.out.println("-l \"matrix\"   Use the matrix layout algorithm in any initial layout ");
        System.out.println("-l \"simplex\"  Use the network simplex layout algorithm in any initial layout ");
        System.out.println("-l \"sugiyama\" Use the sugiyama layout algorithm in any initial layout ");
        System.out.println("-L\t Start with landscape geometry");
        System.out.println("-V\t Start in viewer mode");
        System.out.println("");
        System.out.println("-P <path>  Optional save path");
        System.out.println("-S <path>  Optional save suffix");
        System.out.println("-X <path>  Optional app to exec on save");
        System.out.println("");
    }

    public boolean setOptions(String[] stringArray) {
        char c;
        int n;
        boolean bl = true;
        for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            c = stringArray[n].charAt(1);
            switch (c) {
                case '?': 
                case 'h': {
                    return false;
                }
            }
        }
        for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            int n2 = stringArray[n].length();
            block19: for (int i = 1; i < n2; ++i) {
                c = stringArray[n].charAt(i);
                switch (c) {
                    case 'd': {
                        this.setDebugOn();
                        continue block19;
                    }
                    case 'b': {
                        this.setHandicapped(stringArray[n].substring(i + 1));
                        continue block19;
                    }
                    case 't': {
                        this.showToc();
                        continue block19;
                    }
                    case 'v': {
                        this.setVerboseOn();
                        continue block19;
                    }
                    case 'g': {
                        if (!this.setFrameDimension(stringArray[n].substring(i + 1))) {
                            System.out.println("Illegal -g option [ignored]");
                            bl = false;
                        }
                        i = n2;
                        continue block19;
                    }
                    case 'G': {
                        if (!this.setDiagramPercent(stringArray[n].substring(i + 1))) {
                            System.out.println("Illegal -G option [must be percentages]");
                            bl = false;
                        }
                        i = n2;
                        continue block19;
                    }
                    case 'L': {
                        this.setLandscapeGeo();
                        continue block19;
                    }
                    case 'l': {
                        if (++n >= stringArray.length || !this.setLayouter(stringArray[n])) {
                            System.out.println("\n-l <string> missing");
                            bl = false;
                        }
                        i = n2;
                        continue block19;
                    }
                    case 'N': {
                        if (++n >= stringArray.length || !this.setStartEntity(stringArray[n])) {
                            System.out.println("\nInvalid use of -N");
                            bl = false;
                        }
                        i = n2;
                        continue block19;
                    }
                    case 'P': {
                        if (++n >= stringArray.length || !this.setSavePath(stringArray[n])) {
                            System.out.println("\nInvalid use of -P");
                            bl = false;
                        }
                        i = n2;
                        continue block19;
                    }
                    case 'S': {
                        if (++n >= stringArray.length || !this.setSaveSuffix(stringArray[n])) {
                            System.out.println("\nInvalid use of -S");
                            bl = false;
                        }
                        i = n2;
                        continue block19;
                    }
                    case 'X': {
                        if (++n >= stringArray.length || !this.setSaveCommand(stringArray[n])) {
                            bl = false;
                        }
                        i = n2;
                    }
                }
            }
        }
        while (n < stringArray.length) {
            this.setLsPath(stringArray[n++]);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        LandscapeEditorFrame landscapeEditorFrame = new LandscapeEditorFrame();
        if (!landscapeEditorFrame.setOptions(stringArray)) {
            LandscapeEditorFrame.usage();
            System.exit(0);
        }
        landscapeEditorFrame.launch();
        MsgOut.dprintln("exit main");
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.m_app != null) {
            this.m_app.testForClose(true);
        }
        this.removeWindowListener(this);
        Runtime.getRuntime().exit(0);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }
}

