/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.LandscapeClassObject;
import lsedit.MyPaintableUndoableEdit;
import lsedit.MyUndoableEdit;
import lsedit.Ta;

public abstract class LandscapeObject {
    public static final String COLOR_ID = "color";
    public static final String LABEL_COLOR_ID = "labelcolor";
    public static final String OPEN_COLOR_ID = "opencolor";
    public static final String STYLE_ID = "style";
    private static final int MAX_RGB = 255;
    public static LandscapeObject g_infoShown = null;
    private LandscapeClassObject m_parentClass;
    private Color m_objectColor = null;
    private int m_style = -1;
    private JComponent m_swingObject;
    private Hashtable m_attributes;

    protected String qt(String string) {
        return AttributeValueItem.qt(string);
    }

    private static String taColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        String string = "(" + n + " " + n2 + " " + n3;
        if (n4 != 255) {
            string = string + " " + n4;
        }
        string = string + ")";
        return string;
    }

    protected boolean logEdit(UndoableEdit undoableEdit) {
        return this.getDiagram().logEdit(undoableEdit);
    }

    protected boolean undoEnabled() {
        return this.getTa().undoEnabled();
    }

    public JComponent getSwingObject() {
        return this.m_swingObject;
    }

    public void setSwingObject(JComponent jComponent) {
        this.m_swingObject = jComponent;
    }

    public LandscapeClassObject getParentClass() {
        return this.m_parentClass;
    }

    public LandscapeClassObject derivedFrom(int n) {
        return n == 0 ? this.m_parentClass : null;
    }

    public void setParentClass(LandscapeClassObject landscapeClassObject) {
        this.m_parentClass = landscapeClassObject;
    }

    public void updateParentClass(LandscapeClassObject landscapeClassObject) {
        LandscapeClassObject landscapeClassObject2 = this.m_parentClass;
        if (landscapeClassObject != landscapeClassObject2) {
            this.setParentClass(landscapeClassObject);
            if (this.undoEnabled()) {
                new SetParentClass(landscapeClassObject2);
            }
        }
    }

    public Ta getTa() {
        return this.m_parentClass.getTa();
    }

    public Diagram getDiagram() {
        return this.m_parentClass.getDiagram();
    }

    public int getStyle() {
        return this.m_style;
    }

    public void setStyle(int n) {
        this.m_style = n;
    }

    public void updateStyle(int n) {
        int n2 = this.m_style;
        if (n != n2) {
            this.setStyle(n);
            if (this.undoEnabled()) {
                new SetStyle(n2);
            }
        }
    }

    public int getInheritedStyle() {
        int n = this.getStyle();
        if (n < 0) {
            LandscapeClassObject landscapeClassObject;
            int n2 = 0;
            while ((landscapeClassObject = this.derivedFrom(n2)) != null && (n = landscapeClassObject.getInheritedStyle()) < 0) {
                ++n2;
            }
        }
        return n;
    }

    public String getStyleName(int n) {
        return "";
    }

    public Color getColorWhenOpen() {
        return null;
    }

    public Color getInheritedColorWhenOpen() {
        return null;
    }

    public void setColorWhenOpen(Color color) {
        System.out.println("Can't setColorWhenOpen(" + color + ") on " + this);
    }

    public Color getObjectColor() {
        return this.m_objectColor;
    }

    public void setObjectColor(Color color) {
        this.m_objectColor = color;
    }

    public Color getInheritedObjectColor() {
        Color color = this.getObjectColor();
        if (color == null) {
            LandscapeClassObject landscapeClassObject;
            int n = 0;
            while ((landscapeClassObject = this.derivedFrom(n)) != null && (color = landscapeClassObject.getInheritedObjectColor()) == null) {
                ++n;
            }
        }
        return color;
    }

    public void updateObjectColor(Color color) {
        Color color2 = this.getObjectColor();
        if (color == null ? color2 == null : color.equals(color2)) {
            return;
        }
        this.setObjectColor(color);
        if (this.undoEnabled()) {
            new SetObjectColor(color2);
        }
    }

    public Color getLabelColor() {
        return null;
    }

    public Color getInheritedLabelColor() {
        return null;
    }

    public void setLabelColor(Color color) {
        System.out.println("Can't setLabelColor(" + color + ") on " + this);
    }

    public void updateLabelColor(Color color) {
        System.out.println("Can't updateLabelColor(" + color + ") on " + this);
    }

    public int getLsAttributesSize() {
        if (this.m_attributes == null) {
            return 0;
        }
        return this.m_attributes.size();
    }

    public Attribute getLsAttribute(String string) {
        if (this.m_attributes != null) {
            return (Attribute)this.m_attributes.get(string);
        }
        return null;
    }

    public Attribute getLsAttributeAt(int n) {
        if (this.m_attributes != null) {
            Enumeration enumeration = this.m_attributes.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (n == 0) {
                    return (Attribute)v;
                }
                --n;
            }
        }
        return null;
    }

    public Enumeration getLsAttributesEnum() {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.elements();
    }

    public void putLsAttribute(Attribute attribute) {
        if (this.m_attributes == null) {
            this.m_attributes = new Hashtable(5);
        }
        this.m_attributes.put(attribute.id, attribute);
    }

    public void addAttribute(Attribute attribute) {
        if (this.processFirstOrder(attribute)) {
            return;
        }
        Attribute attribute2 = this.getLsAttribute(attribute.id);
        if (attribute2 != null) {
            this.m_attributes.remove(attribute.id);
        }
        this.putLsAttribute(attribute);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{hashtable.get(string), object, object2};
        vector.addElement(objectArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, int n) {
        this.regRawAttribute(vector, hashtable, string, Attribute.INT, new Integer(n));
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, double d) {
        this.regRawAttribute(vector, hashtable, string, Attribute.DOUBLE, new Double(d));
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, String string2) {
        this.regRawAttribute(vector, hashtable, string, Attribute.STRING, string2);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, int[] nArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.INT_LIST, nArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, double[] dArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.DOUBLE_LIST, dArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, String[] stringArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.STRING_LIST, stringArray);
    }

    public void regAttributeRaw(Vector vector, Hashtable hashtable, Attribute attribute, boolean bl) {
        if (attribute.avi == null) {
            if (bl) {
                this.regRawAttribute(vector, hashtable, attribute.id, Attribute.NULL, null);
            }
        } else if (bl || !attribute.m_cloneOnAssign) {
            if (attribute.avi.next != null) {
                int n = 0;
                AttributeValueItem attributeValueItem = attribute.avi;
                while (attributeValueItem != null) {
                    attributeValueItem = attributeValueItem.next;
                    ++n;
                }
                String[] stringArray = new String[n];
                attributeValueItem = attribute.avi;
                int n2 = 0;
                attributeValueItem = attribute.avi;
                while (attributeValueItem != null) {
                    stringArray[n2] = attributeValueItem.value;
                    attributeValueItem = attributeValueItem.next;
                    ++n2;
                }
                this.regRawAttribute(vector, hashtable, attribute.id, stringArray);
            } else {
                this.regRawAttribute(vector, hashtable, attribute.id, attribute.avi.value);
            }
        }
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        double[] dArray = new double[]{(double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0};
        this.regRawAttribute(vector, hashtable, string, dArray);
    }

    public boolean processFirstOrder(Attribute attribute) {
        if (attribute.id.equals(COLOR_ID)) {
            this.setObjectColor(attribute.parseColor());
            return true;
        }
        if (attribute.id.equals(LABEL_COLOR_ID)) {
            this.setLabelColor(attribute.parseColor());
            return true;
        }
        if (attribute.id.equals(OPEN_COLOR_ID)) {
            this.setColorWhenOpen(attribute.parseColor());
            return true;
        }
        return false;
    }

    public void replaceAttribute(Attribute attribute) {
        this.addAttribute(attribute);
    }

    public void writeAttributes(PrintStream printStream, LandscapeObject landscapeObject, boolean bl) throws IOException {
        Color color;
        Color color2 = this.getObjectColor();
        if (color2 != null && !color2.equals(color = landscapeObject != null ? landscapeObject.getInheritedObjectColor() : null)) {
            printStream.print(" color = " + LandscapeObject.taColor(color2) + "\n");
        }
        if ((color2 = this.getLabelColor()) != null && !color2.equals(color = landscapeObject != null ? landscapeObject.getInheritedLabelColor() : null)) {
            printStream.print(" labelcolor = " + LandscapeObject.taColor(color2) + "\n");
        }
        if ((color2 = this.getColorWhenOpen()) != null && !(color2 = this.getInheritedColorWhenOpen()).equals(color = landscapeObject != null ? landscapeObject.getInheritedColorWhenOpen() : null)) {
            printStream.print(" opencolor = " + LandscapeObject.taColor(color2) + "\n");
        }
        if (this.m_attributes != null) {
            Enumeration enumeration = this.m_attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                attribute.writeAttribute(printStream, landscapeObject, bl);
            }
        }
    }

    public int getPrimaryAttributeCount() {
        return 0;
    }

    public int getLsAttributeCount() {
        return this.getPrimaryAttributeCount() + this.getLsAttributesSize() + 1;
    }

    public boolean canEditName(int n) {
        int n2 = this.getPrimaryAttributeCount();
        return n >= n2;
    }

    public boolean canEditAttribute(int n) {
        int n2 = this.getPrimaryAttributeCount();
        if (n < n2) {
            return true;
        }
        return (n -= n2) < this.getLsAttributesSize();
    }

    public String getLsAttributeNameAt(int n) {
        if ((n -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attribute = this.getLsAttributeAt(n);
        if (attribute == null) {
            return null;
        }
        return attribute.id;
    }

    public Object getLsAttributeValueAt(int n) {
        if ((n -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attribute = this.getLsAttributeAt(n);
        if (attribute == null) {
            return null;
        }
        return attribute.avi;
    }

    private boolean unknownAttributeName(String string) {
        String string2;
        int n = 0;
        while ((string2 = this.getLsAttributeNameAt(n)) != null) {
            if (string.equals(string2)) {
                System.out.println("Can't rename generic attribute to '" + string + "': attribute already exists");
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setAttributeName(Attribute attribute, String string, String string2) {
        if (string != null) {
            this.m_attributes.remove(string);
        }
        if (string2 != null) {
            attribute.id = string2;
            this.putLsAttribute(attribute);
        } else if (this.getLsAttributesSize() == 0) {
            this.m_attributes = null;
        }
    }

    public boolean updateAttributeNameAt(int n, Object object) {
        int n2 = this.getPrimaryAttributeCount();
        if (n < n2) {
            return false;
        }
        String string = (String)object;
        if ((n -= n2) == this.getLsAttributesSize()) {
            if (string == null || string.equals("")) {
                return false;
            }
            if (!this.unknownAttributeName(string)) {
                return false;
            }
            Attribute attribute = new Attribute(string, null);
            this.setAttributeName(attribute, null, string);
            if (this.undoEnabled()) {
                new SetAttributeName(attribute, null, string);
            }
            return true;
        }
        Attribute attribute = this.getLsAttributeAt(n);
        if (attribute == null) {
            return false;
        }
        if (string.equals("")) {
            this.setAttributeName(attribute, attribute.id, null);
            if (this.undoEnabled()) {
                new SetAttributeName(attribute, attribute.id, null);
            }
            return true;
        }
        if (string.equals(attribute.id)) {
            return false;
        }
        if (!this.unknownAttributeName(string)) {
            return false;
        }
        this.setAttributeName(attribute, attribute.id, string);
        if (this.undoEnabled()) {
            new SetAttributeName(attribute, attribute.id, string);
        }
        return true;
    }

    public void updateAttributeValueAt(int n, Object object) {
        Attribute attribute = this.getLsAttributeAt(n -= this.getPrimaryAttributeCount());
        if (attribute == null) {
            return;
        }
        AttributeValueItem attributeValueItem = attribute.avi;
        attribute.setValue((AttributeValueItem)object);
        if (this.undoEnabled()) {
            new SetAttributeValue(attribute, attributeValueItem);
        }
    }

    public int getLsAttributeTypeAt(int n) {
        if (n < this.getLsAttributeCount() - 1) {
            return 11;
        }
        return 0;
    }

    public int getLsAttributeOffset(String string) {
        int n = 0;
        String string2;
        while ((string2 = this.getLsAttributeNameAt(n)) != null) {
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean defaultValue(String string, Object object) {
        Object object2;
        int n;
        return object != null && (n = this.getLsAttributeOffset(string)) >= 0 && object.equals(object2 = this.getLsAttributeValueAt(n));
    }

    class SetAttributeValue
    extends MyUndoableEdit
    implements UndoableEdit {
        AttributeValueItem m_oldValue;
        AttributeValueItem m_newValue;
        Attribute m_attribute;

        SetAttributeValue(Attribute attribute, AttributeValueItem attributeValueItem) {
            this.m_attribute = attribute;
            this.m_oldValue = attributeValueItem;
            this.m_newValue = attribute.avi;
            LandscapeObject.this.logEdit(this);
        }

        public String getPresentationName() {
            LandscapeObject landscapeObject = LandscapeObject.this;
            if (this.m_newValue == null) {
                return landscapeObject + " remove Attribute " + this.m_attribute.id + " value";
            }
            if (this.m_oldValue == null) {
                return landscapeObject + " add Attribute " + this.m_attribute.id + " value";
            }
            return landscapeObject + " replace Attribute " + this.m_attribute.id + " value";
        }

        public void undo() {
            this.m_attribute.setValue(this.m_oldValue);
        }

        public void redo() {
            this.m_attribute.setValue(this.m_newValue);
        }
    }

    class SetAttributeName
    extends MyUndoableEdit
    implements UndoableEdit {
        Attribute m_attribute;
        String m_oldName;
        String m_newName;

        SetAttributeName(Attribute attribute, String string, String string2) {
            this.m_attribute = attribute;
            this.m_oldName = string;
            this.m_newName = string2;
            LandscapeObject.this.logEdit(this);
        }

        public String getPresentationName() {
            if (this.m_newName == null) {
                return LandscapeObject.this + " delete Attribute " + this.m_oldName;
            }
            if (this.m_oldName == null) {
                return LandscapeObject.this + " create Attribute " + this.m_newName;
            }
            return LandscapeObject.this + " rename Attribute " + this.m_oldName + " to " + this.m_newName;
        }

        public void undo() {
            LandscapeObject.this.setAttributeName(this.m_attribute, this.m_newName, this.m_oldName);
        }

        public void redo() {
            LandscapeObject.this.setAttributeName(this.m_attribute, this.m_oldName, this.m_newName);
        }
    }

    class SetObjectColor
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        Color m_old;
        Color m_new;

        SetObjectColor(Color color) {
            this.m_old = color;
            this.m_new = LandscapeObject.this.getObjectColor();
            LandscapeObject.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeObject.this + " ObjectColor ";
        }

        public void undo() {
            LandscapeObject.this.setObjectColor(this.m_old);
        }

        public void redo() {
            LandscapeObject.this.setObjectColor(this.m_new);
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponentColor(graphics, n, n2, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(LandscapeObject.this);
        }
    }

    class SetStyle
    extends MyUndoableEdit
    implements UndoableEdit {
        int m_old;
        int m_new;

        SetStyle(int n) {
            this.m_old = n;
            this.m_new = LandscapeObject.this.getStyle();
            LandscapeObject.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeObject.this + " Style " + LandscapeObject.this.getStyleName(this.m_new);
        }

        public void undo() {
            LandscapeObject.this.setStyle(this.m_old);
        }

        public void redo() {
            LandscapeObject.this.setStyle(this.m_new);
        }
    }

    class SetParentClass
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeClassObject m_old;
        LandscapeClassObject m_new;

        SetParentClass(LandscapeClassObject landscapeClassObject) {
            this.m_old = landscapeClassObject;
            this.m_new = LandscapeObject.this.m_parentClass;
            LandscapeObject.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeObject.this + " ParentClass " + this.m_new;
        }

        public void undo() {
            LandscapeObject.this.setParentClass(this.m_old);
        }

        public void redo() {
            LandscapeObject.this.setParentClass(this.m_new);
        }
    }
}

