/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.MyPaintableUndoableEdit;
import lsedit.MyUndoableEdit;

public abstract class LandscapeObject3D
extends LandscapeObject {
    private String m_id;
    private String m_description;
    private String m_label;
    private Color m_labelColor = null;
    private Color m_colorWhenOpen = null;

    public String toString() {
        return this.m_id;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public boolean hasId(String string) {
        return this.m_id.equals(string);
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.m_description = string;
    }

    public void updateDescription(String string) {
        String string2 = this.m_description;
        if (string == null ? string2 == null : string.equals(string2)) {
            return;
        }
        this.setDescription(string);
        if (this.undoEnabled()) {
            new SetDescription(string2);
        }
    }

    protected void setLabel(String string) {
        JComponent jComponent = this.getSwingObject();
        this.m_label = string;
        if (jComponent != null) {
            jComponent.setToolTipText(string);
        }
    }

    public void updateLabel(String string) {
        String string2 = this.m_label;
        if (string == null ? string2 == null : string.equals(string2)) {
            return;
        }
        this.setLabel(string);
        if (this.undoEnabled()) {
            new SetLabel(string2);
        }
    }

    protected String getLabel() {
        return this.m_label;
    }

    public Color getLabelColor() {
        return this.m_labelColor;
    }

    public Color getInheritedLabelColor() {
        Color color = this.getLabelColor();
        if (color == null) {
            LandscapeClassObject landscapeClassObject;
            int n = 0;
            while ((landscapeClassObject = this.derivedFrom(n)) != null && (color = landscapeClassObject.getInheritedLabelColor()) == null) {
                ++n;
            }
        }
        return color;
    }

    public void setLabelColor(Color color) {
        this.m_labelColor = color;
    }

    public void updateLabelColor(Color color) {
        Color color2 = this.getLabelColor();
        if (color == null ? color2 == null : color.equals(color2)) {
            return;
        }
        this.setLabelColor(color);
        if (this.undoEnabled()) {
            new SetLabelColor(color2);
        }
    }

    public Color getColorWhenOpen() {
        return this.m_colorWhenOpen;
    }

    public Color getInheritedColorWhenOpen() {
        Color color = this.getColorWhenOpen();
        if (color == null) {
            LandscapeClassObject landscapeClassObject;
            int n = 0;
            while ((landscapeClassObject = this.derivedFrom(n)) != null && (color = landscapeClassObject.getInheritedColorWhenOpen()) == null) {
                ++n;
            }
        }
        return color;
    }

    public void setColorWhenOpen(Color color) {
        this.m_colorWhenOpen = color;
    }

    public void updateColorWhenOpen(Color color) {
        Color color2 = this.getColorWhenOpen();
        if (color == null ? color2 == null : color.equals(color2)) {
            return;
        }
        this.setColorWhenOpen(color);
        if (this.undoEnabled()) {
            new SetColorWhenOpen(color2);
        }
    }

    public boolean canEditAttribute(int n) {
        if (n == 0) {
            return false;
        }
        return super.canEditAttribute(n);
    }

    class SetColorWhenOpen
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        Color m_old;
        Color m_new;

        SetColorWhenOpen(Color color) {
            this.m_old = color;
            this.m_new = LandscapeObject3D.this.getColorWhenOpen();
            LandscapeObject3D.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeObject3D.this + " ColorWhenOpen ";
        }

        public void undo() {
            LandscapeObject3D.this.setColorWhenOpen(this.m_old);
        }

        public void redo() {
            LandscapeObject3D.this.setColorWhenOpen(this.m_new);
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponentColor(graphics, n, n2, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(LandscapeObject3D.this);
        }
    }

    class SetLabelColor
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        Color m_old;
        Color m_new;

        SetLabelColor(Color color) {
            this.m_old = color;
            this.m_new = LandscapeObject3D.this.getLabelColor();
            LandscapeObject3D.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeObject3D.this + " LabelColor ";
        }

        public void undo() {
            LandscapeObject3D.this.setLabelColor(this.m_old);
        }

        public void redo() {
            LandscapeObject3D.this.setLabelColor(this.m_new);
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponentColor(graphics, n, n2, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(LandscapeObject3D.this);
        }
    }

    class SetLabel
    extends MyUndoableEdit
    implements UndoableEdit {
        String m_old;
        String m_new;

        SetLabel(String string) {
            this.m_old = string;
            this.m_new = LandscapeObject3D.this.m_label;
            LandscapeObject3D.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeObject3D.this + " Label " + this.m_new;
        }

        public void undo() {
            LandscapeObject3D.this.setLabel(this.m_old);
        }

        public void redo() {
            LandscapeObject3D.this.setLabel(this.m_new);
        }
    }

    class SetDescription
    extends MyUndoableEdit
    implements UndoableEdit {
        String m_old;
        String m_new;

        SetDescription(String string) {
            this.m_old = string;
            this.m_new = LandscapeObject3D.this.getDescription();
            LandscapeObject3D.this.logEdit(this);
        }

        public String getPresentationName() {
            return LandscapeObject3D.this + " Description";
        }

        public void undo() {
            LandscapeObject3D.this.setDescription(this.m_old);
        }

        public void redo() {
            LandscapeObject3D.this.setDescription(this.m_new);
        }
    }
}

