/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.IOException;
import java.io.InputStream;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.EntityCache;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.LandscapeObject3D;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.TA_StreamTokenizer;
import lsedit.Ta;

public class LandscapeTokenStream
extends TA_StreamTokenizer {
    public static final int SCHEME_TUPLE = 0;
    public static final int SCHEME_ATTRIBUTE = 1;
    public static final int FACT_TUPLE = 2;
    public static final int FACT_ATTRIBUTE = 3;
    public static final int INCLUDE_FILE = 4;
    public static final int ERROR = -1;
    public static final int NONE = -2;
    public static final int EOF = 99;
    protected static final String SCHEME_ID = "SCHEME";
    protected static final String FACT_ID = "FACT";
    protected static final String TUPLE_ID = "TUPLE";
    protected static final String ATTRIBUTE_ID = "ATTRIBUTE";
    protected static final String INCLUDE_ID = "INCLUDE";
    protected EntityCache m_entityCache;
    protected boolean m_fatalError = false;
    protected String m_fileName;
    protected String m_includeFile;
    protected String m_token1;
    protected String m_token2;
    protected int m_ttype3;
    public String m_verb;
    public String m_object;
    public String m_subject;
    public int m_relations;

    protected void skipRecord() throws IOException {
        int n;
        while ((n = this.nextToken()) != -1 && n != 125) {
        }
    }

    protected AttributeValueItem parseList() throws IOException {
        AttributeValueItem attributeValueItem = null;
        AttributeValueItem attributeValueItem2 = null;
        block5: while (true) {
            switch (this.nextToken()) {
                case 41: {
                    return attributeValueItem;
                }
                case 40: {
                    AttributeValueItem attributeValueItem3 = this.parseList();
                    if (attributeValueItem3 == null) continue block5;
                    if (attributeValueItem == null) {
                        attributeValueItem = attributeValueItem3;
                    } else {
                        attributeValueItem2.nextList = attributeValueItem3;
                    }
                    attributeValueItem2 = attributeValueItem3;
                    continue block5;
                }
                case -2: {
                    AttributeValueItem attributeValueItem3 = new AttributeValueItem(this.m_sval);
                    if (attributeValueItem == null) {
                        attributeValueItem = attributeValueItem3;
                    } else {
                        attributeValueItem2.next = attributeValueItem3;
                    }
                    attributeValueItem2 = attributeValueItem3;
                    continue block5;
                }
            }
            break;
        }
        this.error("Expecting list, value, or ')'");
        this.pushBack();
        return null;
    }

    protected AttributeValueItem parseAVI() throws IOException {
        AttributeValueItem attributeValueItem;
        int n = this.nextToken();
        switch (n) {
            case 40: {
                attributeValueItem = this.parseList();
                break;
            }
            case -2: {
                attributeValueItem = new AttributeValueItem(this.m_sval);
                break;
            }
            default: {
                this.error("Expecting attribute value");
                attributeValueItem = null;
            }
        }
        return attributeValueItem;
    }

    protected void parseAttributes(LandscapeObject landscapeObject) throws IOException {
        while (true) {
            AttributeValueItem attributeValueItem;
            int n = this.nextToken();
            switch (n) {
                case 125: {
                    return;
                }
                case -2: {
                    break;
                }
                default: {
                    this.error("Expecting attribute id for " + landscapeObject);
                    return;
                }
            }
            String string = this.m_sval;
            if (this.nextToken() != 61) {
                this.pushBack();
                attributeValueItem = null;
            } else {
                attributeValueItem = this.parseAVI();
                if (attributeValueItem == null) {
                    return;
                }
            }
            Attribute attribute = new Attribute(string, attributeValueItem);
            if (landscapeObject instanceof RelationInstance) {
                ((RelationInstance)landscapeObject).assignAttributes(attribute);
                continue;
            }
            if (landscapeObject instanceof EntityInstance) {
                ((EntityInstance)landscapeObject).assignAttributes(attribute);
                continue;
            }
            if (landscapeObject instanceof RelationClass) {
                ((RelationClass)landscapeObject).addAttribute(attribute);
                continue;
            }
            ((EntityClass)landscapeObject).addAttribute(attribute);
        }
    }

    public LandscapeTokenStream(InputStream inputStream, String string, EntityCache entityCache) {
        this.setInputStream(inputStream);
        this.m_fileName = string;
        this.m_entityCache = entityCache;
    }

    public void errorNS(String string) {
        MsgOut.println("*** Error (" + this.m_fileName + ":" + this.lineno() + "): " + string);
    }

    public void error(String string) {
        MsgOut.println("*** Error (" + this.m_fileName + ":" + this.lineno() + "): " + string + ". Found " + this.m_sval);
    }

    public void warning(String string) {
        MsgOut.println(">>> Warning (" + this.m_fileName + ":" + this.lineno() + "): " + string);
    }

    protected AttributeValueItem parseAttributeValueItem() throws IOException {
        AttributeValueItem attributeValueItem = this.parseAVI();
        int n = this.nextToken();
        if (n != -1) {
            attributeValueItem = null;
        }
        return attributeValueItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextSection() throws IOException {
        String string;
        String string2;
        if (this.m_fatalError) {
            return 99;
        }
        if (this.m_token1 != null) {
            if (this.m_ttype3 != 58) {
                this.error("Expecting section header ':'");
                return -1;
            }
            string2 = this.m_token1;
            string = this.m_token2;
            this.m_token1 = null;
            this.m_token2 = null;
        } else {
            int n = this.nextToken();
            switch (n) {
                case -1: {
                    return 99;
                }
                case -2: {
                    string2 = this.m_sval;
                    if (this.nextToken() != -2) {
                        this.error("Expecting section type id");
                        return -1;
                    }
                    string = this.m_sval;
                    if (this.nextToken() == 58) break;
                    this.error("Expecting ':'");
                    return -1;
                }
                default: {
                    this.error("Expecting graph id");
                    return -1;
                }
            }
        }
        if (string2.equals(SCHEME_ID)) {
            if (string.equals(TUPLE_ID)) {
                return 0;
            }
            if (string.equals(ATTRIBUTE_ID)) {
                return 1;
            }
            this.error("Bad section type");
            return -1;
        }
        if (string2.equals(FACT_ID)) {
            if (string.equals(TUPLE_ID)) {
                return 2;
            }
            if (string.equals(ATTRIBUTE_ID)) {
                return 3;
            }
            this.error("Bad section type");
            return -1;
        }
        if (string2.equals(INCLUDE_ID)) {
            this.m_includeFile = string;
            return 4;
        }
        this.error("Bad section id");
        return -1;
    }

    public String getIncludeFile() {
        return this.m_includeFile;
    }

    public boolean nextSchemaTriple() throws IOException {
        if (!this.m_fatalError) {
            switch (this.nextToken()) {
                case -1: {
                    return false;
                }
                case -2: {
                    break;
                }
                default: {
                    this.error("Expecting word verb token");
                    this.m_fatalError = true;
                    return false;
                }
            }
            this.m_relations = 0;
            this.m_verb = this.m_sval;
            switch (this.nextToken()) {
                case -2: {
                    this.m_object = this.m_sval;
                    break;
                }
                case 40: {
                    this.m_relations |= 1;
                    if (this.nextToken() == -2) {
                        this.m_object = this.m_sval;
                        if (this.nextToken() == 41) break;
                    }
                }
                default: {
                    this.error("Expecting word object token");
                    this.m_fatalError = true;
                    return false;
                }
            }
            switch (this.nextToken()) {
                case 58: {
                    this.m_token1 = this.m_verb;
                    this.m_token2 = this.m_object;
                    this.m_ttype3 = 58;
                    return false;
                }
                case -2: {
                    this.m_subject = this.m_sval;
                    return true;
                }
                case 40: {
                    this.m_relations |= 2;
                    if (this.nextToken() != -2) break;
                    this.m_subject = this.m_sval;
                    if (this.nextToken() != 41) break;
                    return true;
                }
            }
            this.error("Expecting word subject token");
            this.m_fatalError = true;
            return true;
        }
        return false;
    }

    public boolean nextFactTriple() throws IOException {
        if (!this.m_fatalError) {
            int n = this.nextToken();
            switch (n) {
                case -1: {
                    return false;
                }
                case -2: {
                    this.m_verb = this.m_sval;
                    if (this.nextToken() != -2) {
                        this.error("Expecting word token");
                        break;
                    }
                    this.m_object = this.m_sval;
                    n = this.nextToken();
                    if (n == 58) {
                        this.m_token1 = this.m_verb;
                        this.m_token2 = this.m_object;
                        this.m_ttype3 = n;
                        return false;
                    }
                    if (n != -2) {
                        this.error("Error in tuple parse");
                        break;
                    }
                    this.m_subject = this.m_sval;
                    return true;
                }
                default: {
                    this.error("Expecting word token");
                }
            }
            this.m_fatalError = true;
        }
        return false;
    }

    public void processSchemeAttributes(Ta ta) throws IOException {
        LandscapeClassObject landscapeClassObject = null;
        while (!this.m_fatalError) {
            int n = this.nextToken();
            String string = null;
            switch (n) {
                case -1: {
                    return;
                }
                case 40: {
                    n = this.nextToken();
                    if (n != -2) {
                        string = "Expected ( <relation class name>";
                        break;
                    }
                    String string2 = this.m_sval;
                    n = this.nextToken();
                    if (n != 41) {
                        string = "Expected ( " + string2 + "<)>";
                        break;
                    }
                    n = this.nextToken();
                    if (n != 123) {
                        string = "Expected (...) <{>";
                        break;
                    }
                    landscapeClassObject = ta.getRelationClass(string2);
                    if (landscapeClassObject != null) break;
                    landscapeClassObject = ta.addRelationClass(string2);
                    string = ((RelationClass)landscapeClassObject).addParentClass(ta.m_relationBaseClass);
                    break;
                }
                case -2: {
                    String string2 = this.m_sval;
                    n = this.nextToken();
                    if (n != 123) {
                        if (n != -2) {
                            string = "Expecting " + string2 + " <{>";
                            break;
                        }
                        String string3 = this.m_sval;
                        n = this.nextToken();
                        if (n != 58) {
                            string = "Expecting section header or id <{>";
                            break;
                        }
                        this.m_token1 = string2;
                        this.m_token2 = string3;
                        this.m_ttype3 = n;
                        return;
                    }
                    landscapeClassObject = ta.getEntityClass(string2);
                    if (landscapeClassObject != null) break;
                    landscapeClassObject = ta.addEntityClass(string2);
                    string = landscapeClassObject.addParentClass(ta.m_entityBaseClass);
                    break;
                }
                default: {
                    string = "Expecting object id";
                }
            }
            if (string != null) {
                this.errorNS(string);
                this.skipRecord();
                continue;
            }
            this.parseAttributes(landscapeClassObject);
        }
    }

    public void processFactAttributes(Ta ta) throws IOException {
        LandscapeObject landscapeObject = null;
        int n = 0;
        while (!this.m_fatalError) {
            if (++n % 250 == 0) {
                ta.updateProgressCnt();
                ta.showProgress("Attr Records: " + n);
            }
            int n2 = this.nextToken();
            String string = null;
            switch (n2) {
                case -1: {
                    return;
                }
                case 40: {
                    n2 = this.nextToken();
                    if (n2 != -2) {
                        string = "Expected ( <class> src dst )";
                        break;
                    }
                    String string2 = this.m_sval;
                    n2 = this.nextToken();
                    if (n2 != -2) {
                        string = "Expected (" + string2 + " <src> dst)";
                        break;
                    }
                    String string3 = this.m_sval;
                    n2 = this.nextToken();
                    if (n2 != -2) {
                        string = "Expected (" + string2 + " " + string3 + " <dst>)";
                        break;
                    }
                    String string4 = this.m_sval;
                    n2 = this.nextToken();
                    if (n2 != 41) {
                        string = "Expected (" + string2 + " " + string3 + " " + string4 + "<)>";
                        break;
                    }
                    LandscapeObject3D landscapeObject3D = ta.getRelationClass(string2);
                    if (landscapeObject3D == null) {
                        string = "Can't process record. Missing relation class '" + string2 + "'";
                        break;
                    }
                    EntityInstance entityInstance = this.m_entityCache.get(string3);
                    if (entityInstance == null) {
                        string = "Can't process record. Missing src entity '" + string3 + "'";
                        break;
                    }
                    EntityInstance entityInstance2 = this.m_entityCache.get(string4);
                    if (entityInstance2 == null) {
                        string = "Can't process record. Missing dst entity '" + string4 + "'";
                        break;
                    }
                    landscapeObject = entityInstance.getRelation((RelationClass)landscapeObject3D, entityInstance2);
                    if (landscapeObject == null) {
                        string = "Can't process record. Missing relation (" + string2 + " " + string3 + " " + string4 + ")";
                        break;
                    }
                    n2 = this.nextToken();
                    if (n2 == 123) break;
                    string = "Expected (...) <{>";
                    break;
                }
                case -2: {
                    String string3;
                    String string2 = this.m_sval;
                    n2 = this.nextToken();
                    if (n2 != 123) {
                        if (n2 != -2) {
                            string = "Expecting " + string2 + " <{>";
                            break;
                        }
                        string3 = this.m_sval;
                        n2 = this.nextToken();
                        if (n2 != 58) {
                            string = "Expecting section header or id <{>";
                            break;
                        }
                        this.m_token1 = string2;
                        this.m_token2 = string3;
                        this.m_ttype3 = n2;
                        return;
                    }
                    if (string2.equals("$ROOT")) {
                        landscapeObject = ta.getRootInstance();
                        break;
                    }
                    LandscapeObject3D landscapeObject3D = this.m_entityCache.get(string2);
                    if (landscapeObject3D == null) {
                        if (!ta.isUniversalScheme()) {
                            string = "Attributes defined for missing entity '" + string2 + "'";
                        }
                        landscapeObject3D = ta.m_entityBaseClass.newEntity(string2);
                        this.m_entityCache.put((EntityInstance)landscapeObject3D);
                    }
                    landscapeObject = landscapeObject3D;
                    break;
                }
                default: {
                    string = "Expecting object id";
                }
            }
            if (string != null) {
                this.errorNS(string);
                this.skipRecord();
                continue;
            }
            this.parseAttributes(landscapeObject);
        }
    }
}

