/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import lsedit.ClassInherits;
import lsedit.ClosureConstraints;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EditAttribute;
import lsedit.EditConstraints;
import lsedit.EntityChkBox;
import lsedit.EntityClass;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;
import lsedit.RelnChkBox;

public class LegendBox
extends JComponent
implements MouseListener {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    public static final String DEFAULT_LEGEND_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_LEGEND_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_LEGEND_TITLE_FONT_SIZE = 12;
    protected static Font m_titleFont = FontCache.get("Helvetica", 1, 12);
    public static final String DEFAULT_LEGEND_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_LEGEND_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_LEGEND_TEXT_FONT_SIZE = 11;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    public static final String m_helpStr = "This box shows the types of entities and relations that are present in the current landscape.";
    protected JLabel m_ulabel;
    protected JLabel m_elabel1;
    protected JLabel m_elabel2;
    protected JLabel m_rlabel;
    protected JLabel m_clabel;
    protected JLabel m_flabel1;
    protected JLabel m_flabel2;
    protected int m_width;
    protected int m_height;

    public LegendBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.m_ulabel = new JLabel("Entities");
        this.m_ulabel.setForeground(Color.red);
        this.m_ulabel.setFont(m_titleFont);
        this.m_elabel1 = new JLabel("Pass cursor over entity for description.");
        this.m_elabel1.setForeground(Color.black);
        this.m_elabel1.setFont(m_textFont);
        this.m_elabel2 = new JLabel("Right click for menu.");
        this.m_elabel2.setForeground(Color.black);
        this.m_elabel2.setFont(m_textFont);
        this.m_rlabel = new JLabel("Relations");
        this.m_rlabel.setForeground(Color.red);
        this.m_rlabel.setFont(m_titleFont);
        this.m_clabel = new JLabel("Hierarchy");
        this.m_clabel.setForeground(Color.red);
        this.m_clabel.setFont(m_titleFont);
        this.m_flabel1 = new JLabel("Checkboxes select visible relations.");
        this.m_flabel1.setForeground(Color.black);
        this.m_flabel1.setFont(m_textFont);
        this.m_flabel2 = new JLabel("Right click for menu.");
        this.m_flabel2.setForeground(Color.black);
        this.m_flabel2.setFont(m_textFont);
        this.setLayout(null);
        this.setBackground(Diagram.boxColor);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("Legend", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
    }

    public static Font getTitleFont() {
        return m_titleFont;
    }

    public static void setTitleFont(Font font) {
        m_titleFont = font;
    }

    public void titleFontChanged(Font font) {
        this.m_ulabel.setFont(font);
        this.m_rlabel.setFont(font);
        this.fillLegendBox();
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        this.m_elabel1.setFont(font);
        this.m_elabel2.setFont(font);
        this.m_flabel1.setFont(font);
        this.m_flabel2.setFont(font);
        this.fillLegendBox();
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    public void containsClassChanged() {
        this.fillLegendBox();
    }

    protected void add(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n > this.m_width) {
            this.m_width = n;
        }
        jComponent.setBounds(5, this.m_height, n, n2);
        super.add(jComponent);
        this.m_height += n2;
    }

    public void fillLegendBox() {
        Enumeration enumeration;
        Diagram diagram = this.m_ls.getDiagram();
        this.removeAll();
        this.m_width = 0;
        this.m_height = 0;
        boolean bl = false;
        int n = 0;
        int n2 = Do.fontHeight(m_textFont);
        this.m_height += 10;
        this.add(this.m_ulabel);
        if (diagram != null) {
            enumeration = diagram.enumEntityClassesInOrder();
            while (enumeration.hasMoreElements()) {
                EntityClass entityClass = (EntityClass)enumeration.nextElement();
                String string = entityClass.getId();
                this.m_height += 10;
                this.add(new EntityLabel(this, entityClass, ++n, n2));
            }
        }
        if (n == 0) {
            this.m_height += 10;
            this.add(new EntityLabel(this, diagram.m_entityBaseClass, ++n, n2));
        }
        this.m_height += 10;
        this.add(this.m_elabel1);
        this.add(this.m_elabel2);
        this.m_height += 20;
        this.add(this.m_rlabel);
        this.m_height += 5;
        n = 0;
        RelationClass relationClass = null;
        if (diagram != null) {
            enumeration = diagram.enumRelationClassesInOrder();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass2 = (RelationClass)enumeration.nextElement();
                if (!relationClass2.isContainsClass()) {
                    this.add(new VisibleRelnChkBox(this, relationClass2, ++n, m_textFont));
                    continue;
                }
                relationClass = relationClass2;
            }
        }
        if (relationClass != null) {
            this.m_height += 10;
            this.add(this.m_clabel);
            this.m_height += 5;
            this.add(new VisibleRelnChkBox(this, relationClass, -1, m_textFont));
        }
        this.m_height += 20;
        this.add(this.m_flabel1);
        this.add(this.m_flabel2);
        this.m_width += 5;
        this.m_height += 10;
        Dimension dimension = new Dimension(this.m_width, this.m_height);
        this.setPreferredSize(dimension);
        this.setBounds(0, 0, this.m_width, this.m_height);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void toggleRelationVisibility(int n) {
        int n2 = this.getComponentCount();
        boolean bl = true;
        if (n == 0) {
            Component component;
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                component = this.getComponent(n3);
                if (!(component instanceof VisibleRelnChkBox) || ((VisibleRelnChkBox)component).getIndex() != 1) continue;
                bl = !((VisibleRelnChkBox)component).isClassVisible();
                break;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                component = this.getComponent(n3);
                if (!(component instanceof VisibleRelnChkBox) || bl == ((VisibleRelnChkBox)component).isClassVisible()) continue;
                ((VisibleRelnChkBox)component).doClick();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof VisibleRelnChkBox) || ((VisibleRelnChkBox)component).getIndex() != n) continue;
                ((VisibleRelnChkBox)component).doClick();
                break;
            }
        }
    }

    protected void doRightPopup(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        JPopupMenu jPopupMenu = new JPopupMenu("Legend options");
        Do.createClassMenuItem(jPopupMenu, this.m_ls);
        FontCache.setMenuTreeFont(jPopupMenu);
        this.add(jPopupMenu);
        jPopupMenu.show(this, n, n2);
        this.remove(jPopupMenu);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            this.doRightPopup(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class VisibleRelnChkBox
    extends RelnChkBox
    implements ItemListener,
    MouseListener {
        protected LegendBox m_legendBox;
        protected JPopupMenu m_popup;

        public VisibleRelnChkBox(LegendBox legendBox2, RelationClass relationClass, int n, Font font) {
            super(relationClass, n, relationClass.isClassVisible(), font);
            this.m_legendBox = legendBox2;
            this.addItemListener(this);
            this.addMouseListener(this);
        }

        public boolean isClassVisible() {
            return this.m_rc.isClassVisible();
        }

        public void setClassVisible(boolean bl) {
            if (this.isClassVisible() != bl) {
                this.m_rc.setClassVisible(bl);
                LegendBox.this.m_ls.getDiagram().redrawDiagram();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.setClassVisible(itemEvent.getStateChange() == 1);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown()) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Diagram diagram = LegendBox.this.m_ls.getDiagram();
                this.m_popup = new JPopupMenu("Relation menu");
                JMenuItem jMenuItem = new JMenuItem("Edit inheritance rules");
                jMenuItem.addActionListener(new DisplayClassHierarchy(this.m_legendBox, this.m_rc, n, n2));
                this.m_popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Edit class attributes");
                jMenuItem.addActionListener(new EditRelationClassAttributes(LegendBox.this.m_ls, this.m_rc));
                this.m_popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Edit relation constraints");
                jMenuItem.addActionListener(new ShowConstraintsMatrix(diagram, this.m_rc));
                this.m_popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Closure of constraints");
                jMenuItem.addActionListener(new ShowConstraintsClosure(diagram, this.m_rc));
                this.m_popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Show valid attributes");
                jMenuItem.addActionListener(new ShowValidAttributes(this.m_rc));
                this.m_popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Validate attributes");
                jMenuItem.addActionListener(new CheckRelationAttributes(this.m_rc));
                this.m_popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Validate relations");
                jMenuItem.addActionListener(new CheckRelations(this.m_rc));
                this.m_popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Duplicate edges");
                jMenuItem.addActionListener(new DuplicateEdges(LegendBox.this.m_ls, this.m_rc));
                this.m_popup.add(jMenuItem);
                if (!this.m_rc.isContainsClass()) {
                    if (this.m_rc != diagram.m_relationBaseClass) {
                        jMenuItem = new JMenuItem("Delete " + this.m_rc.getLabel());
                        jMenuItem.addActionListener(new DeleteRelationClass(diagram, this.m_rc));
                        this.m_popup.add(jMenuItem);
                    }
                    jMenuItem = new JMenuItem("Create edges of this class");
                    jMenuItem.addActionListener(new SetDefaultRelationClass(diagram, this.m_rc));
                    this.m_popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Forms hierarchy");
                    jMenuItem.addActionListener(new SetContainsRelation(LegendBox.this.m_ls, this.m_rc));
                    this.m_popup.add(jMenuItem);
                }
                FontCache.setMenuTreeFont(this.m_popup);
                this.m_legendBox.add(this.m_popup);
                this.m_popup.show(this, n, n2);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class EntityLabel
    extends EntityChkBox
    implements ItemListener,
    MouseListener {
        protected LegendBox m_legendBox;
        protected JPopupMenu m_popup;

        public EntityLabel(LegendBox legendBox2, EntityClass entityClass, int n, int n2) {
            super(entityClass, n, n2, false);
            this.m_popup = null;
            this.m_legendBox = legendBox2;
            this.setFont(m_textFont);
            this.addItemListener(this);
            this.addMouseListener(this);
        }

        public void setClassShown(boolean bl) {
            if (this.m_ec.isShown() != bl) {
                this.m_ec.setShown(bl);
                LegendBox.this.m_ls.getDiagram().redrawDiagram();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.setClassShown(itemEvent.getStateChange() == 1);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown()) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (this.m_popup == null) {
                    Diagram diagram = LegendBox.this.m_ls.getDiagram();
                    this.m_popup = new JPopupMenu("Class menu");
                    JMenuItem jMenuItem = new JMenuItem("Edit inheritance rules");
                    jMenuItem.addActionListener(new DisplayClassHierarchy(this.m_legendBox, this.m_ec, n, n2));
                    this.m_popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Edit class attributes");
                    jMenuItem.addActionListener(new EditClassAttributes(this.m_ec));
                    this.m_popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Show valid attributes");
                    jMenuItem.addActionListener(new ShowValidAttributes(this.m_ec));
                    this.m_popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Validate attributes");
                    jMenuItem.addActionListener(new CheckEntityAttributes(this.m_ec));
                    this.m_popup.add(jMenuItem);
                    jMenuItem = new JMenuItem("Create entities of this class");
                    jMenuItem.addActionListener(new SetDefaultEntityClass(diagram, this.m_ec));
                    this.m_popup.add(jMenuItem);
                    if (this.m_ec != diagram.m_entityBaseClass) {
                        jMenuItem = new JMenuItem("Delete " + this.m_ec.getLabel());
                        jMenuItem.addActionListener(new DeleteEntityClass(diagram, this.m_ec));
                        this.m_popup.add(jMenuItem);
                    }
                    this.m_legendBox.add(this.m_popup);
                }
                FontCache.setMenuTreeFont(this.m_popup);
                this.m_popup.show(this, n, n2);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class DuplicateEdges
    implements ActionListener {
        private LandscapeEditorCore m_ls;
        private RelationClass m_rc;

        public DuplicateEdges(LandscapeEditorCore landscapeEditorCore, RelationClass relationClass) {
            this.m_ls = landscapeEditorCore;
            this.m_rc = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ls.duplicateEdges(this.m_rc);
        }
    }

    private class SetContainsRelation
    implements ActionListener {
        private LandscapeEditorCore m_ls;
        private RelationClass m_relation;

        public SetContainsRelation(LandscapeEditorCore landscapeEditorCore, RelationClass relationClass) {
            this.m_ls = landscapeEditorCore;
            this.m_relation = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ls.updateContainsRelation(this.m_relation);
        }
    }

    private class SetDefaultRelationClass
    implements ActionListener {
        private Diagram m_diagram;
        private RelationClass m_rc;

        public SetDefaultRelationClass(Diagram diagram, RelationClass relationClass) {
            this.m_diagram = diagram;
            this.m_rc = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_diagram.setDefaultRelationClass(this.m_rc);
        }
    }

    private class SetDefaultEntityClass
    implements ActionListener {
        private Diagram m_diagram;
        private EntityClass m_ec;

        public SetDefaultEntityClass(Diagram diagram, EntityClass entityClass) {
            this.m_diagram = diagram;
            this.m_ec = entityClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_diagram.setDefaultEntityClass(this.m_ec);
        }
    }

    private class ShowConstraintsClosure
    implements ActionListener {
        private Diagram m_diagram;
        private RelationClass m_rc;

        public ShowConstraintsClosure(Diagram diagram, RelationClass relationClass) {
            this.m_diagram = diagram;
            this.m_rc = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClosureConstraints.create(this.m_diagram, this.m_rc);
        }
    }

    private class ShowConstraintsMatrix
    implements ActionListener {
        private Diagram m_diagram;
        private RelationClass m_rc;

        public ShowConstraintsMatrix(Diagram diagram, RelationClass relationClass) {
            this.m_diagram = diagram;
            this.m_rc = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditConstraints.create(this.m_diagram, this.m_rc);
        }
    }

    private class DeleteRelationClass
    implements ActionListener {
        private Diagram m_diagram;
        private RelationClass m_rc;

        public DeleteRelationClass(Diagram diagram, RelationClass relationClass) {
            this.m_diagram = diagram;
            this.m_rc = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RelationClass relationClass = this.m_rc;
            String string = null;
            Enumeration enumeration = this.m_diagram.enumRelationClasses();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass2 = (RelationClass)enumeration.nextElement();
                if (relationClass == relationClass2 || !relationClass2.directlyInheritsFrom(relationClass)) continue;
                string = string != null ? string + ", " : "";
                string = string + relationClass2.getLabel();
            }
            if (string != null) {
                JOptionPane.showConfirmDialog(null, string + " inherit from " + relationClass.getLabel(), "Can't delete class", -1);
                return;
            }
            switch (JOptionPane.showConfirmDialog(null, "Delete class " + relationClass.getLabel(), "Delete all " + relationClass.getLabel() + " edges", 1)) {
                case 0: {
                    LegendBox.this.m_ls.beginUndoRedo("Delete " + relationClass.getLabel() + " relation class");
                    this.m_diagram.updateDeleteAllEdges(relationClass);
                    this.m_diagram.updateRemoveRelationClass(relationClass);
                    LegendBox.this.m_ls.endUndoRedo();
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private class DeleteEntityClass
    implements ActionListener {
        private Diagram m_diagram;
        private EntityClass m_ec;

        public DeleteEntityClass(Diagram diagram, EntityClass entityClass) {
            this.m_diagram = diagram;
            this.m_ec = entityClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EntityClass entityClass = this.m_ec;
            String string = null;
            Enumeration enumeration = this.m_diagram.enumEntityClasses();
            while (enumeration.hasMoreElements()) {
                EntityClass entityClass2 = (EntityClass)enumeration.nextElement();
                if (entityClass == entityClass2 || !entityClass2.directlyInheritsFrom(entityClass)) continue;
                string = string != null ? string + ", " : "";
                string = string + entityClass2.getLabel();
            }
            if (string != null) {
                JOptionPane.showConfirmDialog(null, string + " inherit from " + entityClass.getLabel(), "Can't delete class", -1);
                return;
            }
            switch (JOptionPane.showConfirmDialog(null, "Delete class " + entityClass.getLabel(), "Delete all " + entityClass.getLabel() + " entities", 1)) {
                case 0: {
                    LegendBox.this.m_ls.beginUndoRedo("Delete " + entityClass.getLabel() + " entity class");
                    if (!this.m_diagram.updateDeleteAllEntities(entityClass)) {
                        JOptionPane.showConfirmDialog(null, "Root member of class " + entityClass.getLabel(), "Can't delete root", -1);
                        return;
                    }
                    this.m_diagram.updateRemoveEntityClass(entityClass);
                    this.m_diagram.clearGroupFlags();
                    LegendBox.this.m_ls.endUndoRedo();
                    break;
                }
            }
            LegendBox.this.m_ls.repaint();
        }
    }

    private class EditRelationClassAttributes
    implements ActionListener {
        private LandscapeEditorCore m_ls;
        private RelationClass m_relation;

        public EditRelationClassAttributes(LandscapeEditorCore landscapeEditorCore, RelationClass relationClass) {
            this.m_ls = landscapeEditorCore;
            this.m_relation = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditAttribute.Create(this.m_ls, this.m_relation);
            this.m_ls.repaint();
        }
    }

    private class CheckRelations
    implements ActionListener {
        private RelationClass m_rc;

        public CheckRelations(RelationClass relationClass) {
            this.m_rc = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LegendBox.this.m_ls.validateRelations(this.m_rc);
        }
    }

    private class CheckRelationAttributes
    implements ActionListener {
        private RelationClass m_rc;

        public CheckRelationAttributes(RelationClass relationClass) {
            this.m_rc = relationClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LegendBox.this.m_ls.validateRelationAttributes(this.m_rc);
        }
    }

    private class CheckEntityAttributes
    implements ActionListener {
        private EntityClass m_ec;

        public CheckEntityAttributes(EntityClass entityClass) {
            this.m_ec = entityClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LegendBox.this.m_ls.validateEntityAttributes(this.m_ec);
        }
    }

    private class ShowValidAttributes
    implements ActionListener {
        private LandscapeClassObject m_o;

        public ShowValidAttributes(LandscapeClassObject landscapeClassObject) {
            this.m_o = landscapeClassObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LegendBox.this.m_ls.showValidAttributes(this.m_o);
        }
    }

    private class EditClassAttributes
    implements ActionListener {
        private EntityClass m_entity;

        public EditClassAttributes(EntityClass entityClass) {
            this.m_entity = entityClass;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditAttribute.Create(LegendBox.this.m_ls, this.m_entity);
            LegendBox.this.m_ls.repaint();
        }
    }

    private class DisplayClassHierarchy
    implements ActionListener {
        private LegendBox m_legendBox;
        private LandscapeClassObject m_landscapeClass;
        int m_x;
        int m_y;
        JPopupMenu m_popup = null;

        public DisplayClassHierarchy(LegendBox legendBox2, LandscapeClassObject landscapeClassObject, int n, int n2) {
            this.m_legendBox = legendBox2;
            this.m_landscapeClass = landscapeClassObject;
            this.m_x = n;
            this.m_y = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LandscapeClassObject landscapeClassObject = this.m_landscapeClass;
            ClassInherits classInherits = new ClassInherits(LegendBox.this.m_ls, landscapeClassObject);
            classInherits.setLocation(this.m_x, this.m_y);
            classInherits.setVisible(true);
            Vector vector = classInherits.getResult();
            if (vector != null) {
                landscapeClassObject.updateInherits(vector);
            }
        }
    }
}

