/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Distance;
import lsedit.EditableTa;
import lsedit.EntityInstance;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.TaFeedback;
import lsedit.Util;

public class LsClusterer
implements TaFeedback {
    protected static final double default_attractive_force = 0.05;
    protected static final double default_sparse_factor = 1.0;
    protected static final double default_repulsive_force = 0.01;
    protected static final double default_repulsive_diameter = 0.75;
    protected static final int default_iterations = 1000;
    protected static final int default_timeout = 60;
    protected static final double default_separation_factor = 2.5;
    protected static final double default_margin = 0.05;
    protected static final double default_gap = 0.4;
    protected static final int default_form_clusters = 0;
    protected static final boolean default_remove_contains = true;
    protected static final boolean default_mustbe_related = true;
    protected static final boolean default_feedback = true;
    protected double m_attractive_force = 0.05;
    protected double m_sparse_factor = 1.0;
    protected double m_repulsive_force = 0.01;
    protected double m_repulsive_diameter = 0.75;
    protected int m_iterations = 1000;
    protected int m_timeout = 60;
    protected boolean m_remove_contains = true;
    protected boolean m_mustbe_related = true;
    protected boolean m_feedback = true;
    protected double m_separation_factor = 2.5;
    protected double m_margin = 0.05;
    protected double m_gap = 0.4;
    protected int m_form_clusters = 0;

    protected static void die() {
        System.exit(1);
    }

    protected void log(String string) {
        if (this.m_feedback) {
            System.err.println(Util.toLocaleString() + ": " + string);
        }
    }

    protected void layout(EditableTa editableTa) {
        ClusterNode clusterNode;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        ClusterNode clusterNode2;
        double d6;
        int n;
        EntityInstance entityInstance;
        EntityInstance entityInstance2;
        ClusterNode clusterNode3;
        EntityInstance entityInstance3 = editableTa.getRootInstance();
        Vector vector = new Vector();
        entityInstance3.gatherLeaves(vector);
        int n2 = vector.size();
        if (n2 < 3) {
            return;
        }
        this.log("Clustering " + n2 + " items");
        ClusterNode[] clusterNodeArray = new ClusterNode[n2];
        boolean[][] blArrayArray = new boolean[n2][];
        int n3 = 0;
        while (n3 < n2) {
            clusterNodeArray[n3] = clusterNode3 = new ClusterNode();
            blArrayArray[n3] = new boolean[n2 - n3];
            clusterNode3.m_e = entityInstance2 = (EntityInstance)vector.elementAt(n3);
            clusterNode3.m_x = entityInstance2.xRelLocal();
            clusterNode3.m_y = entityInstance2.yRelLocal();
            clusterNode3.m_cluster = n3++;
            clusterNode3.m_next = null;
            entityInstance2.orMark(0x4000000);
        }
        double d7 = 0.0;
        for (n3 = 0; n3 < n2; ++n3) {
            RelationClass relationClass;
            RelationInstance relationInstance;
            clusterNode3 = clusterNodeArray[n3];
            entityInstance2 = clusterNode3.m_e;
            Enumeration enumeration = entityInstance2.srcRelationElements();
            block2: while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                relationClass = relationInstance.getRelationClass();
                if (!relationClass.isClassVisible() || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                for (n = n3 + 1; n < n2; ++n) {
                    if (entityInstance != clusterNodeArray[n].m_e) continue;
                    blArrayArray[n3][n - n3] = true;
                    continue block2;
                }
            }
            enumeration = entityInstance2.dstRelationElements();
            block4: while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                relationClass = relationInstance.getRelationClass();
                if (!relationClass.isClassVisible() || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                for (n = n3 + 1; n < n2; ++n) {
                    if (entityInstance != clusterNodeArray[n].m_e) continue;
                    blArrayArray[n3][n - n3] = true;
                    continue block4;
                }
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            clusterNode3 = clusterNodeArray[n3];
            entityInstance2 = clusterNode3.m_e;
            d6 = entityInstance2.widthRelLocal();
            double d8 = entityInstance2.heightRelLocal();
            for (n = n3 + 1; n < n2; ++n) {
                if (!blArrayArray[n3][n - n3]) continue;
                clusterNode2 = clusterNodeArray[n];
                entityInstance = clusterNode2.m_e;
                double d9 = entityInstance.widthRelLocal();
                double d10 = entityInstance.heightRelLocal();
                d5 = d6 + d9;
                if (d5 > d7) {
                    d7 = d5;
                }
                if (!((d4 = d8 + d10) > d7)) continue;
                d7 = d4;
            }
        }
        d7 *= this.m_sparse_factor;
        this.log("Iterating over these " + n2 + " items");
        long l = System.currentTimeMillis() + (long)(this.m_timeout * 1000);
        for (int i = this.m_iterations; i > 0; --i) {
            for (n3 = 0; n3 < n2; ++n3) {
                clusterNode3 = clusterNodeArray[n3];
                d3 = clusterNode3.m_x;
                d2 = clusterNode3.m_y;
                for (n = n3 + 1; n < n2; ++n) {
                    clusterNode2 = clusterNodeArray[n];
                    double d11 = clusterNode2.m_x;
                    double d12 = clusterNode2.m_y;
                    d5 = d11 - d3;
                    d4 = d12 - d2;
                    if (d5 == 0.0 && d4 == 0.0) {
                        d5 = n3 % 3 - 1;
                        d4 = d5 == 0.0 ? (double)(n % 2 * 2 - 1) : (double)(n % 3 - 1);
                    }
                    d = Math.sqrt(d5 * d5 + d4 * d4);
                    double d13 = blArrayArray[n3][n - n3] ? (d - d7) * this.m_attractive_force : (d - this.m_repulsive_diameter) * this.m_repulsive_force;
                    d3 += d13 * d5 / d;
                    d2 += d13 * d4 / d;
                    clusterNode2.m_x = d11 -= d13 * d5 / d;
                    clusterNode2.m_y = d12 -= d13 * d4 / d;
                }
                clusterNode3.m_x = d3;
                clusterNode3.m_y = d2;
            }
            if (System.currentTimeMillis() <= l) continue;
            this.log("Timeout after " + (this.m_iterations - i) + " iterations");
            break;
        }
        this.log("Build graph for " + n2 + " items");
        int n4 = n2;
        if (this.m_form_clusters != 1 && this.m_form_clusters < n4) {
            Vector<Distance> vector2 = new Vector<Distance>();
            for (n3 = 0; n3 < n2; ++n3) {
                clusterNode3 = clusterNodeArray[n3];
                d3 = clusterNode3.m_x;
                d2 = clusterNode3.m_y;
                for (n = n3 + 1; n < n2; ++n) {
                    if (this.m_mustbe_related && !blArrayArray[n3][n - n3]) continue;
                    clusterNode2 = clusterNodeArray[n];
                    d5 = clusterNode2.m_x - d3;
                    d4 = clusterNode2.m_y - d2;
                    d = Math.sqrt(d5 * d5 + d4 * d4);
                    vector2.add(new Distance(d, n3, n));
                }
            }
            int n5 = vector2.size();
            this.log("Sorting " + n5 + " of distances");
            SortVector.byDistance(vector2);
            d7 = -1.0;
            for (n3 = 0; n3 < n5; ++n3) {
                Distance distance = (Distance)vector2.elementAt(n3);
                d = distance.m_length;
                if (d > d7 * this.m_separation_factor && this.m_form_clusters == 0 && d7 >= 0.0) break;
                d7 = d;
                clusterNode3 = clusterNodeArray[distance.m_i];
                clusterNode2 = clusterNodeArray[distance.m_j];
                if (clusterNode3.m_cluster == clusterNode2.m_cluster) continue;
                n = clusterNode3.m_cluster;
                clusterNode3 = clusterNodeArray[n];
                clusterNode = clusterNode2 = clusterNodeArray[clusterNode2.m_cluster];
                while (clusterNode.m_next != null) {
                    clusterNode.m_cluster = n;
                    clusterNode = clusterNode.m_next;
                }
                clusterNode.m_cluster = n;
                clusterNode.m_next = clusterNode3.m_next;
                clusterNode3.m_next = clusterNode2;
                if (--n4 <= this.m_form_clusters || n4 < 3) break;
            }
        }
        int n6 = n2 - 1;
        ClusterNode clusterNode4 = null;
        if (n4 > this.m_form_clusters) {
            this.log("Identifying utilities");
            n6 = -1;
            n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                clusterNode3 = clusterNodeArray[n3];
                if (clusterNode3.m_cluster != n3) continue;
                if (clusterNode3.m_next == null) {
                    if (clusterNode4 != null) {
                        clusterNode3.m_cluster = clusterNode4.m_cluster;
                        clusterNode3.m_next = clusterNode4.m_next;
                        clusterNode4.m_next = clusterNode3;
                        continue;
                    }
                    clusterNode4 = clusterNode3;
                }
                ++n4;
                n6 = n3;
            }
        }
        this.log("Reorganising " + n2 + " items into " + n4 + " selected clusters");
        n4 = 0;
        entityInstance = null;
        for (n3 = 0; n3 <= n6; ++n3) {
            double d14;
            double d15;
            clusterNode3 = clusterNodeArray[n3];
            if (clusterNode3.m_cluster != n3) continue;
            entityInstance = editableTa.getNewEntity(null, entityInstance3);
            String string = "Cluster" + ++n4;
            if (clusterNode3 == clusterNode4) {
                string = this.m_form_clusters == 1 ? string + " (Layout)" : string + " (Utilities)";
            }
            entityInstance.setLabel(string);
            int n7 = 0;
            d3 = d15 = clusterNode3.m_x;
            d2 = d14 = clusterNode3.m_y;
            clusterNode = clusterNode3;
            while (clusterNode != null) {
                if (clusterNode.m_x < d3) {
                    d3 = clusterNode.m_x;
                }
                if (clusterNode.m_y < d2) {
                    d2 = clusterNode.m_y;
                }
                if (clusterNode.m_x > d15) {
                    d15 = clusterNode.m_x;
                }
                if (clusterNode.m_y > d14) {
                    d14 = clusterNode.m_y;
                }
                ++n7;
                clusterNode = clusterNode.m_next;
            }
            entityInstance.setDescription("Cluster of " + n7 + " items");
            n7 = (int)Math.ceil(Math.sqrt(n7));
            d6 = (1.0 - this.m_margin) * (1.0 - this.m_gap) / (double)n7;
            d5 = d15 - d3;
            double d16 = d5 == 0.0 ? 0.0 : (1.0 - this.m_margin - d6) / d5;
            double d17 = this.m_margin * 0.5 - d16 * d3;
            d4 = d14 - d2;
            double d18 = d4 == 0.0 ? 0.0 : (1.0 - this.m_margin - d6) / d4;
            double d19 = this.m_margin * 0.5 - d18 * d2;
            while (clusterNode3 != null) {
                entityInstance2 = clusterNode3.m_e;
                d3 = clusterNode3.m_x * d16 + d17;
                d2 = clusterNode3.m_y * d18 + d19;
                entityInstance2.setRelLocal(d3, d2, d6, d6);
                editableTa.moveEntityContainment(entityInstance, entityInstance2);
                entityInstance2.orMark(0x4000000);
                clusterNode3 = clusterNode3.m_next;
            }
        }
        this.log("Finished forming " + n4 + " clusters");
    }

    public LsClusterer(String string, String string2) {
        EditableTa editableTa = new EditableTa(null, this);
        String string3 = editableTa.loadTA(string, System.in);
        if (string3 != null) {
            this.error(string3);
        }
        this.layout(editableTa);
        string3 = editableTa.saveByFile(string2);
        if (string3 != null) {
            this.error(string3);
        }
        System.exit(0);
    }

    public void showProgress(String string) {
        if (this.m_feedback) {
            System.err.println("Progress: " + string + "\n");
        }
    }

    public void updateProgress(int n) {
    }

    public void doFeedback(String string) {
        if (this.m_feedback) {
            System.err.println("Feedback: " + string + "\n");
        }
    }

    public void showInfo(String string) {
        if (this.m_feedback) {
            System.err.println("    Info: " + string + "\n");
        }
    }

    public void error(String string) {
        System.err.println("   Error: " + string + "\n");
        LsClusterer.die();
    }

    public void showCycle(RelationClass relationClass, EntityInstance entityInstance, int n) {
        System.err.println("Cycle detected in contains heirarchy within input TA\n");
        LsClusterer.die();
    }

    public void noContainRelation(String string) {
        System.err.println("No contains relation defined in the input TA\n");
        LsClusterer.die();
    }

    public void hasMultipleParents(RelationClass relationClass, EntityInstance entityInstance) {
        System.err.println("Multiple parents detected in contains heirarchy within input TA\n");
        LsClusterer.die();
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        switch (stringArray.length) {
            case 2: {
                string2 = stringArray[1];
            }
            case 1: {
                string = stringArray[0];
            }
            case 0: {
                break;
            }
            default: {
                System.err.println("usage: java lsedit.LsClusterer [<input> [<output>]]\n");
                LsClusterer.die();
            }
        }
        new LsClusterer(string, string2);
    }

    class ClusterNode {
        public EntityInstance m_e;
        double m_x;
        double m_y;
        int m_cluster;
        ClusterNode m_next;

        ClusterNode() {
        }
    }
}

