/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RelationInstance;
import lsedit.Util;

public class NewEdgeModeHandler
extends LandscapeModeHandler {
    protected DrawOutline m_drawOutline;
    protected EditModeHandler m_parent;
    protected EntityInstance m_from;
    protected EntityInstance m_to;
    protected int m_x;
    protected int m_y;

    protected void stateChange() {
        String string;
        if (this.m_from == null) {
            string = "Click on new Edge's source entity";
        } else if (this.m_to == null) {
            this.m_drawOutline.activate();
            string = "Click on target entity for edge having source entity " + this.m_from;
        } else {
            this.m_ls.updateNewRelation(this.m_from, this.m_to);
            this.m_ls.redrawDg();
            string = "Edge created from " + this.m_from + " to " + this.m_to;
            this.m_parent.cleanup();
        }
        this.m_ls.doFeedback(string);
    }

    public NewEdgeModeHandler(EditModeHandler editModeHandler) {
        super(editModeHandler.m_ls);
        this.m_parent = editModeHandler;
        this.m_drawOutline = new DrawOutline();
    }

    public void cleanup() {
        if (this.m_from != null || this.m_to != null) {
            Diagram diagram = this.m_ls.getDiagram();
            this.m_from = null;
            this.m_to = null;
            this.m_drawOutline.deactivate();
        }
    }

    public void activate(Object object) {
        this.m_parent.cleanup();
        this.m_parent.setSubHandler(this);
        Diagram diagram = this.m_ls.getDiagram();
        Vector vector = diagram.targetEntities(object);
        this.m_from = null;
        this.m_to = null;
        if (vector != null) {
            switch (vector.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.m_from = (EntityInstance)vector.elementAt(0);
                    break;
                }
                case 2: {
                    this.m_from = (EntityInstance)vector.elementAt(0);
                    this.m_to = (EntityInstance)vector.elementAt(1);
                    if (!this.m_from.getGroupKeyFlag()) break;
                    EntityInstance entityInstance = this.m_from;
                    this.m_from = this.m_to;
                    this.m_to = entityInstance;
                }
            }
        }
        this.stateChange();
    }

    public void entityPressed(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        if (this.m_from == null) {
            this.m_from = entityInstance;
        } else {
            this.m_to = entityInstance;
        }
        this.stateChange();
    }

    public void relationPressed(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        this.m_ls.error("Edges must be between two entities -- don't click on relations");
    }

    public void movedOverThing(MouseEvent mouseEvent, Object object, int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        if (this.m_from != null) {
            this.m_drawOutline.repaint();
        }
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.BLACK);
        }

        public void activate() {
            Diagram diagram = NewEdgeModeHandler.this.m_ls.getDiagram();
            this.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
            this.setVisible(true);
            diagram.add((Component)NewEdgeModeHandler.this.m_drawOutline, 0);
        }

        public void deactivate() {
            Diagram diagram = NewEdgeModeHandler.this.m_ls.getDiagram();
            this.setVisible(false);
            diagram.remove(this);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            EntityInstance entityInstance = NewEdgeModeHandler.this.m_from;
            int n = entityInstance.getDiagramX();
            int n2 = entityInstance.getDiagramY();
            int n3 = entityInstance.getWidth();
            int n4 = entityInstance.getHeight();
            int n5 = NewEdgeModeHandler.this.m_x;
            int n6 = NewEdgeModeHandler.this.m_y;
            if (n5 >= n) {
                n = n5 <= n + n3 ? (n += n3 / 2) : (n += n3);
            }
            if (n6 >= n2) {
                n2 = n6 <= n2 + n4 ? (n2 += n4 / 2) : (n2 += n4);
            }
            Util.drawArrow(graphics, NewEdgeModeHandler.this.m_ls, 0, n, n2, n5, n6, 1);
        }
    }
}

