/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.MyUndoableEdit;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.Ta;
import lsedit.Util;

public class RelationClass
extends LandscapeClassObject {
    protected static final String FACTOR_ID = "class_iofactor";
    protected static final String HIERARCHY_ID = "class_hierarchy";
    protected static final String ACTIVE_ID = "class_active";
    protected static final String VISIBLE_ID = "class_visible";
    protected static final String ISCONTAINS_ID = "class_iscontains";
    public static final int ID_ATTR = 0;
    public static final int CLASSLABEL_ATTR = 1;
    public static final int CLASSDESC_ATTR = 2;
    public static final int CLASSSTYLE_ATTR = 3;
    public static final int COLOR_ATTR = 4;
    public static final int LABEL_COLOR_ATTR = 5;
    public static final int FACTOR_ATTR = 6;
    public static final int ATTRS = 7;
    public static final String[] attributeName = new String[]{"id", "class_label", "class_description", "class_style", "color", "labelcolor", "class_iofactor"};
    public static final int[] attributeType = new int[]{3, 3, 12, 14, 8, 7, 2};
    protected static final String RELATION_BASE_CLASS_ID = "$RELATION";
    protected boolean m_active = true;
    protected boolean m_visible = true;
    protected boolean m_contains = false;
    protected double m_iofactor = -1.0;
    protected int m_cIndex = -1;
    protected int m_weight = 1;
    private Vector m_relationList = new Vector();
    protected int m_ordinal;

    public RelationClass(String string, int n, Ta ta) {
        super(ta);
        this.setId(string);
        this.setNid(n);
        this.setLabel(string);
    }

    public int getCIndex() {
        return this.m_cIndex;
    }

    public void setCIndex(int n) {
        this.m_cIndex = n;
    }

    public int getWeight() {
        return this.m_weight;
    }

    public void setWeight(int n) {
        this.m_weight = n;
    }

    public String getStyleName(int n) {
        return Util.getLineStyleName(n);
    }

    public void setContainsClass(boolean bl) {
        if (this.m_contains != bl) {
            this.m_contains = bl;
            this.m_weight = bl || !this.m_visible ? 0 : 1;
        }
    }

    public boolean isContainsClass() {
        return this.m_contains;
    }

    protected boolean processClassAttributes(Attribute attribute) {
        if (attribute.id.equals(HIERARCHY_ID)) {
            this.m_cIndex = Integer.parseInt(attribute.avi.value);
            return true;
        }
        if (attribute.id.equals(FACTOR_ID)) {
            this.m_iofactor = Double.parseDouble(attribute.avi.value);
            return true;
        }
        if (attribute.id.equals(ACTIVE_ID)) {
            this.m_active = Util.parseBoolean(attribute.avi.value);
            return true;
        }
        if (attribute.id.equals(VISIBLE_ID)) {
            this.setClassVisible(Util.parseBoolean(attribute.avi.value));
            return true;
        }
        if (attribute.id.equals(ISCONTAINS_ID)) {
            this.setContainsClass(Util.parseBoolean(attribute.avi.value));
            return true;
        }
        return super.processClassAttributes(attribute);
    }

    public void reportClassAttributes(ResultBox resultBox) {
        resultBox.addText(HIERARCHY_ID);
        resultBox.addText(FACTOR_ID);
        resultBox.addText(ACTIVE_ID);
        resultBox.addText(VISIBLE_ID);
        resultBox.addText(ISCONTAINS_ID);
        super.reportClassAttributes(resultBox);
    }

    public Vector getRelationList() {
        return this.m_relationList;
    }

    public void addRelation(EntityClassPair entityClassPair) {
        this.m_relationList.addElement(entityClassPair);
    }

    public void addRelation(EntityClass entityClass, EntityClass entityClass2) {
        if (this.m_relationList == null) {
            this.m_relationList = new Vector();
        } else {
            Enumeration enumeration = this.m_relationList.elements();
            while (enumeration.hasMoreElements()) {
                EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
                if (!entityClassPair.equals(entityClass, entityClass2)) continue;
                return;
            }
        }
        this.addRelation(new EntityClassPair(entityClass, this, entityClass2));
    }

    public void removeRelation(EntityClassPair entityClassPair) {
        Vector vector = this.m_relationList;
        if (vector != null) {
            vector.remove(entityClassPair);
        }
    }

    public boolean[][] getInheritedRelationArray() {
        EntityClass entityClass;
        Ta ta = this.getTa();
        int n = 0;
        Enumeration enumeration = ta.enumEntityClassesInOrder();
        while (enumeration.hasMoreElements()) {
            entityClass = (EntityClass)enumeration.nextElement();
            entityClass.setOrderedId(n);
            ++n;
        }
        int n2 = n;
        boolean[][] blArrayArray = new boolean[n2][];
        for (n = 0; n < n2; ++n) {
            boolean[] blArray = new boolean[n2];
            blArrayArray[n] = blArray;
            for (int i = 0; i < n2; ++i) {
                blArray[i] = false;
            }
        }
        Vector vector = this.getClassAndSuperclasses();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            Enumeration enumeration2 = relationClass.m_relationList.elements();
            while (enumeration2.hasMoreElements()) {
                EntityClassPair entityClassPair = (EntityClassPair)enumeration2.nextElement();
                Vector vector2 = ta.getClassAndSubclasses(entityClassPair.m_entityClass1);
                Vector vector3 = ta.getClassAndSubclasses(entityClassPair.m_entityClass2);
                Enumeration enumeration3 = vector2.elements();
                while (enumeration3.hasMoreElements()) {
                    entityClass = (EntityClass)enumeration3.nextElement();
                    int n3 = entityClass.getOrderedId();
                    Enumeration enumeration4 = vector3.elements();
                    while (enumeration4.hasMoreElements()) {
                        EntityClass entityClass2 = (EntityClass)enumeration4.nextElement();
                        int n4 = entityClass2.getOrderedId();
                        blArrayArray[n3][n4] = true;
                    }
                }
            }
        }
        return blArrayArray;
    }

    public RelationInstance newRelation(EntityInstance entityInstance, EntityInstance entityInstance2) {
        RelationInstance relationInstance = new RelationInstance(this, entityInstance, entityInstance2);
        return relationInstance;
    }

    public void writeRelations(PrintStream printStream) throws IOException {
        Enumeration enumeration = this.m_relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            printStream.print(this.qt(this.getId()) + " " + this.qt(entityClassPair.m_entityClass1.getId()) + " " + this.qt(entityClassPair.m_entityClass2.getId()) + "\n");
        }
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        if (this.getNid() >= 2) {
            printStream.print("(" + this.qt(this.getId()) + ") {\n");
            if (this.m_cIndex >= 0) {
                printStream.print("class_hierarchy = " + this.m_cIndex + " ");
            }
            if (this.m_iofactor >= 0.0) {
                printStream.print("class_iofactor = " + this.m_iofactor + " ");
            }
            if (!this.m_active) {
                printStream.print("class_active = false ");
            }
            if (!this.m_visible) {
                printStream.print("class_visible = false ");
            }
            if (this.m_contains) {
                printStream.print("class_iscontains = true ");
            }
            super.writeAttributes(printStream);
            printStream.print("}\n\n");
        }
    }

    public boolean isClassVisible() {
        return this.m_visible && !this.m_contains;
    }

    public void setClassVisible(boolean bl) {
        if (this.m_visible != bl) {
            this.m_visible = bl;
            this.m_weight = this.m_contains || !bl ? 0 : 1;
        }
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActiveState(boolean bl) {
        this.m_active = bl;
    }

    public void setOrdinal(int n) {
        this.m_ordinal = n;
    }

    public double getIOfactor() {
        if (this.m_iofactor >= 0.0) {
            return this.m_iofactor;
        }
        Diagram diagram = this.getDiagram();
        if (diagram.allowElision()) {
            double d = diagram.numVisibleRelationClasses();
            return (double)(this.m_ordinal + 1) / (d + 1.0);
        }
        double d = diagram.numRelationClasses();
        return d > 2.0 ? (double)(this.getNid() - 1) / (d - 1.0) : 0.5;
    }

    public void setIOfactor(double d) {
        this.m_iofactor = d;
    }

    public void updateIOfactor(double d) {
        double d2 = this.m_iofactor;
        if (d2 != d) {
            this.setIOfactor(d);
            if (this.undoEnabled()) {
                new SetIOfactor(d2);
            }
        }
    }

    public int getPrimaryAttributeCount() {
        return 7;
    }

    public String getLsAttributeNameAt(int n) {
        String string = n < 7 ? attributeName[n] : super.getLsAttributeNameAt(n);
        return string;
    }

    public int getLsAttributeTypeAt(int n) {
        int n2 = n < 7 ? attributeType[n] : super.getLsAttributeTypeAt(n);
        return n2;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.getLabel();
                break;
            }
            case 2: {
                object = this.getDescription();
                break;
            }
            case 3: {
                object = new Integer(this.getStyle());
                break;
            }
            case 4: {
                object = this.getObjectColor();
                break;
            }
            case 5: {
                object = this.getLabelColor();
                break;
            }
            case 6: {
                object = new Double(this.m_iofactor);
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void updateAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.updateLabel((String)object);
                break;
            }
            case 2: {
                this.updateDescription((String)object);
                break;
            }
            case 3: {
                this.updateStyle((Integer)object);
                break;
            }
            case 4: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 5: {
                this.updateLabelColor((Color)object);
                break;
            }
            case 6: {
                this.updateIOfactor((Double)object);
                break;
            }
            default: {
                super.updateAttributeValueAt(n, object);
            }
        }
    }

    class SetIOfactor
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_old;
        double m_new;

        SetIOfactor(double d) {
            this.m_old = d;
            this.m_new = RelationClass.this.m_iofactor;
            RelationClass.this.logEdit(this);
        }

        public String getPresentationName() {
            return RelationClass.this + " Change IO factor";
        }

        public void undo() {
            RelationClass.this.setIOfactor(this.m_old);
        }

        public void redo() {
            RelationClass.this.setIOfactor(this.m_new);
        }
    }
}

