/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.ArrowDimensions;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Util;

public class RelationComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    protected static final Color HIGHLIGHT_COLOR = Color.yellow;
    protected static final int HIGHLIGHT_DIM = 4;
    protected static final int RECURSIVE_LOOP_DOTTED_ANGLE = 8;
    protected static final int RECURSIVE_LOOP_DOTTED_SPACE = 10;
    protected static final int NEAR_POINT_THRESHOLD = 1;
    protected static final int NEAR_LINE_THRESHOLD2 = 1;
    protected static final int NEAR_LOOP_THRESHOLD = 1;
    public static final int DRAW_TAIL_MARK = 1;
    public static final int DRAW_CENTRE_MARK = 2;
    public static final int DRAW_ARROW_MARK = 4;
    protected static int[] m_arc_xp = new int[]{0, 0, 0};
    protected static int[] m_arc_yp = new int[]{0, 0, 0};
    private RelationInstance m_relationInstance;
    private Object m_drawInfo;
    private int timeStamp = -1;

    protected LandscapeEditorCore getLs() {
        return this.m_relationInstance.getLs();
    }

    public static void getLineBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n <= n3) {
            n8 = n;
            n7 = n3;
        } else {
            n8 = n3;
            n7 = n;
        }
        if (n2 <= n4) {
            n6 = n2;
            n5 = n4;
        } else {
            n6 = n4;
            n5 = n2;
        }
        if (ArrowDimensions.m_line_width > 1) {
            int n9 = n7 - n8;
            int n10 = n5 - n6;
            int n11 = ArrowDimensions.m_line_width / 2;
            if (n10 > 2 * n9) {
                n8 -= n11;
                n7 += n11;
            }
            if (n9 >= 2 * n10) {
                n6 -= n11;
                n5 += n11;
            }
        }
        rectangle.setBounds(n8, n6, n7 - n8, n5 - n6);
    }

    public static void includeTailBounds(int n, int n2, Rectangle rectangle) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = n3 + rectangle.width;
        int n6 = n4 + rectangle.height;
        int n7 = n - 3;
        int n8 = n2 - 3;
        if (n7 < n3) {
            n3 = n7;
        }
        if (n8 < n4) {
            n4 = n8;
        }
        n8 += 6;
        if ((n7 += 6) > n5) {
            n5 = n7;
        }
        if (n8 > n6) {
            n6 = n8;
        }
        rectangle.setBounds(n3, n4, n5 - n3, n6 - n4);
    }

    public static void includeCentreBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width;
        int n8 = n6 + rectangle.height;
        int n9 = (n + n3 - 4) / 2;
        int n10 = (n2 + n4 - 4) / 2;
        if (n9 < n5) {
            n5 = n9;
        }
        if (n10 < n6) {
            n6 = n10;
        }
        n10 += 4;
        if ((n9 += 4) > n7) {
            n7 = n9;
        }
        if (n10 > n8) {
            n8 = n10;
        }
        rectangle.setBounds(n5, n6, n7 - n5, n8 - n6);
    }

    public void includeArrowBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width;
        int n8 = n6 + rectangle.height;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (Util.getArrow(n, n2, n3, n4, nArray, nArray2, this.m_relationInstance.getFrequency()) != 0.0) {
            for (int i = 0; i < 3; ++i) {
                int n9 = nArray[i];
                int n10 = nArray2[i];
                if (n9 < n5) {
                    n5 = n9;
                }
                if (n10 < n6) {
                    n6 = n10;
                }
                if (n9 > n7) {
                    n7 = n9;
                }
                if (n10 <= n8) continue;
                n8 = n10;
            }
        }
        rectangle.setBounds(n5, n6, n7 - n5, n8 - n6);
    }

    public static boolean nearPoint(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 > 1) {
            return false;
        }
        n5 = n4 - n2;
        if (n5 < 0) {
            n5 = -n5;
        }
        return n5 <= 1;
    }

    public static boolean nearLine(int n, int n2, int n3, int n4, int n5, int n6) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (n == n3 && n2 == n4) {
            return RelationComponent.nearPoint(n, n2, n5, n6);
        }
        double d6 = n5;
        double d7 = n3 - n;
        double d8 = n6;
        double d9 = n4 - n2;
        double d10 = ((d6 - (double)n) * d7 + (d8 - (double)n2) * d9) / (d7 * d7 + d9 * d9);
        return d10 >= 0.0 && d10 <= 1.0 && (d5 = (d4 = d6 - (d3 = (double)n + d10 * d7)) * d4 + (d2 = d8 - (d = (double)n2 + d10 * d9)) * d2) <= 1.0;
    }

    protected Vector points() {
        EdgeInfo edgeInfo;
        EntityInstance entityInstance;
        EntityInstance entityInstance2;
        EntityInstance entityInstance3;
        EntityInstance entityInstance4;
        boolean bl;
        RelationInstance relationInstance = this.m_relationInstance;
        Diagram diagram = relationInstance.getDiagram();
        EntityInstance entityInstance5 = diagram.getDrawRoot();
        EntityInstance entityInstance6 = relationInstance.getDrawSrc();
        EntityInstance entityInstance7 = relationInstance.getDrawDst();
        RelationClass relationClass = relationInstance.getRelationClass();
        OutElidedInfo outElidedInfo = null;
        InElidedInfo inElidedInfo = null;
        boolean bl2 = !entityInstance5.hasDescendantOrSelf(entityInstance6);
        boolean bl3 = bl = !entityInstance5.hasDescendantOrSelf(entityInstance7);
        if (!bl2 && !bl) {
            entityInstance3 = entityInstance4 = entityInstance6.commonAncestor(entityInstance7);
        } else if (bl2) {
            entityInstance4 = entityInstance6.getContainedBy();
            entityInstance3 = entityInstance5.getContainedBy();
        } else {
            entityInstance4 = entityInstance5.getContainedBy();
            entityInstance3 = entityInstance7.getContainedBy();
        }
        if (entityInstance4 == null) {
            System.out.println("C Error: " + relationInstance + " " + bl2 + " " + bl);
            return null;
        }
        if (entityInstance3 == null) {
            System.out.println("S Error: " + relationInstance + " " + bl2 + " " + bl);
            return null;
        }
        Vector<DrawInfo> vector = new Vector<DrawInfo>();
        Vector<DrawInfo> vector2 = new Vector<DrawInfo>();
        int n = diagram.getEdgeMode();
        EntityInstance entityInstance8 = entityInstance6;
        while ((entityInstance2 = entityInstance8.getContainedBy()) != entityInstance4) {
            entityInstance8 = entityInstance2;
        }
        EntityInstance entityInstance9 = entityInstance7;
        while ((entityInstance2 = entityInstance9.getContainedBy()) != entityInstance3) {
            entityInstance9 = entityInstance2;
        }
        Rectangle rectangle = entityInstance8.getDiagramBounds();
        Rectangle rectangle2 = entityInstance9.getDiagramBounds();
        int n2 = relationInstance.getSrc() != entityInstance6 || relationInstance.getDst() != entityInstance7 ? 2 : relationInstance.getInheritedStyle();
        int n3 = 1;
        if (relationInstance.isMarked(512)) {
            n3 |= 2;
        }
        EdgePoint edgePoint = null;
        EdgePoint edgePoint2 = null;
        EntityInstance entityInstance10 = entityInstance6;
        while (entityInstance10 != entityInstance4) {
            if (entityInstance10 == null) {
                MsgOut.println("Error in points: (" + relationClass.getId() + " " + relationInstance + ")");
                return null;
            }
            entityInstance = entityInstance10.getContainedBy();
            edgePoint = entityInstance10.getOutPoint(relationInstance, n, rectangle, rectangle2);
            if (edgePoint2 != null) {
                if (entityInstance10.isExitingRelationElided(relationClass)) {
                    outElidedInfo = new OutElidedInfo();
                    outElidedInfo.setOutElidedInfo(edgePoint, edgePoint2);
                    outElidedInfo.setStyle(n2);
                    vector.addElement(outElidedInfo);
                    break;
                }
                edgeInfo = new EdgeInfo();
                edgeInfo.setEdgeInfo(edgePoint2, edgePoint);
                edgeInfo.setStyle(n2);
                edgeInfo.setEmbellished(n3);
                n3 &= 0xFFFFFFFE;
                vector.addElement(edgeInfo);
            }
            edgePoint2 = edgePoint;
            entityInstance10 = entityInstance;
        }
        n3 &= 0xFFFFFFFE;
        n3 |= 4;
        EdgePoint edgePoint3 = null;
        edgePoint2 = null;
        entityInstance10 = entityInstance7;
        while (entityInstance10 != entityInstance3) {
            entityInstance = entityInstance10.getContainedBy();
            edgePoint3 = entityInstance10.getOutPoint(relationInstance, n, rectangle2, rectangle);
            if (edgePoint2 != null) {
                if (entityInstance10.isEnteringRelationElided(relationClass)) {
                    inElidedInfo = new InElidedInfo();
                    inElidedInfo.setInElidedInfo(edgePoint2, edgePoint3);
                    inElidedInfo.setStyle(n2);
                    vector2.addElement(inElidedInfo);
                    break;
                }
                edgeInfo = new EdgeInfo();
                edgeInfo.setEdgeInfo(edgePoint3, edgePoint2);
                edgeInfo.setStyle(n2);
                edgeInfo.setEmbellished(n3);
                n3 &= 0xFFFFFFFB;
                vector2.addElement(edgeInfo);
            }
            edgePoint2 = edgePoint3;
            entityInstance10 = entityInstance;
        }
        if (outElidedInfo == null && inElidedInfo == null) {
            edgeInfo = new EdgeInfo();
            edgeInfo.setEdgeInfo(edgePoint, edgePoint3);
            edgeInfo.setStyle(n2);
            vector.addElement(edgeInfo);
        } else if (inElidedInfo == null) {
            vector2.removeAllElements();
        } else if (outElidedInfo == null) {
            vector.removeAllElements();
        }
        for (int i = vector2.size() - 1; i >= 0; --i) {
            vector.addElement((DrawInfo)vector2.elementAt(i));
        }
        return vector;
    }

    public RelationComponent(RelationInstance relationInstance) {
        this.setLayout(null);
        this.m_relationInstance = relationInstance;
        relationInstance.setSwingObject(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected int arrowWeight() {
        return LandscapeObject.g_infoShown == this.m_relationInstance || ArrowDimensions.isWeightedArrowhead() ? this.m_relationInstance.getFrequency() : 1;
    }

    public void computeBounds(Rectangle rectangle) {
        if (this.m_drawInfo == null) {
            rectangle.setBounds(0, 0, 0, 0);
        } else if (this.m_drawInfo instanceof DrawInfo) {
            ((DrawInfo)this.m_drawInfo).getBounds(rectangle);
        } else {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
            while (enumeration.hasMoreElements()) {
                int n5;
                DrawInfo drawInfo = (DrawInfo)enumeration.nextElement();
                drawInfo.getBounds(rectangle);
                int n6 = rectangle.x;
                if (n6 < n) {
                    n = n6;
                }
                if ((n5 = rectangle.y) < n3) {
                    n3 = n5;
                }
                n5 += rectangle.height;
                if ((n6 += rectangle.width) > n2) {
                    n2 = n6;
                }
                if (n5 <= n4) continue;
                n4 = n5;
            }
            rectangle.setBounds(n, n3, n2 - n, n4 - 1);
        }
    }

    public boolean contains(int n, int n2) {
        if (super.contains(n, n2)) {
            n += this.getX();
            n2 += this.getY();
            if (this.m_drawInfo != null) {
                if (this.m_drawInfo instanceof DrawInfo) {
                    return ((DrawInfo)this.m_drawInfo).contains(n, n2);
                }
                Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
                while (enumeration.hasMoreElements()) {
                    if (!((DrawInfo)enumeration.nextElement()).contains(n, n2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EdgePoint mouseOverEdgePoint(int n, int n2) {
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                return ((DrawInfo)this.m_drawInfo).mouseOverEdgePoint(n, n2);
            }
            Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
            while (enumeration.hasMoreElements()) {
                EdgePoint edgePoint = ((DrawInfo)enumeration.nextElement()).mouseOverEdgePoint(n, n2);
                if (edgePoint == null) continue;
                return edgePoint;
            }
        }
        return null;
    }

    public void validate() {
        super.validate();
        RelationInstance relationInstance = this.m_relationInstance;
        if (!relationInstance.isMarked(51)) {
            return;
        }
        EntityInstance entityInstance = relationInstance.getDrawSrc();
        if (entityInstance == null) {
            return;
        }
        EntityInstance entityInstance2 = relationInstance.getDrawDst();
        if (entityInstance2 == null) {
            return;
        }
        int n = relationInstance.getSrc() != entityInstance || relationInstance.getDst() != entityInstance2 ? 2 : relationInstance.getInheritedStyle();
        Diagram diagram = relationInstance.getDiagram();
        int n2 = diagram.getEdgeMode();
        if (relationInstance.isMarked(1)) {
            if (this.m_drawInfo == null || !(this.m_drawInfo instanceof ArcInfo)) {
                this.m_drawInfo = new ArcInfo();
            }
            ((ArcInfo)this.m_drawInfo).setStyle(n);
            int n3 = 4;
            if (relationInstance.isMarked(512)) {
                n3 |= 2;
            }
            ((ArcInfo)this.m_drawInfo).setEmbellished(n3);
            ((ArcInfo)this.m_drawInfo).computePosition();
        } else if (!relationInstance.isMarked(48) && n2 != 2 && n2 != 3 && entityInstance.getContainedBy() != entityInstance2.getContainedBy() && relationInstance.isMarked(4)) {
            this.m_drawInfo = this.points();
        } else {
            Rectangle rectangle = entityInstance.getDiagramBounds();
            Rectangle rectangle2 = entityInstance2.getDiagramBounds();
            EdgePoint edgePoint = null;
            EdgePoint edgePoint2 = null;
            if (entityInstance.hasDescendant(entityInstance2)) {
                if (n2 == 3) {
                    edgePoint2 = entityInstance.getLeftOutPoint(relationInstance);
                    edgePoint = entityInstance2.getLeftOutPoint(relationInstance);
                } else {
                    edgePoint2 = entityInstance.getTopOutPoint(relationInstance);
                    edgePoint = entityInstance2.getTopOutPoint(relationInstance);
                }
            } else if (entityInstance2.hasDescendant(entityInstance)) {
                if (n2 == 3) {
                    edgePoint2 = entityInstance.getRightOutPoint(relationInstance);
                    edgePoint = entityInstance2.getRightOutPoint(relationInstance);
                } else {
                    edgePoint2 = entityInstance.getBottomOutPoint(relationInstance);
                    edgePoint = entityInstance2.getBottomOutPoint(relationInstance);
                }
            } else {
                edgePoint2 = entityInstance.getOutPoint(relationInstance, n2, rectangle, rectangle2);
                edgePoint = entityInstance2.getOutPoint(relationInstance, n2, rectangle2, rectangle);
            }
            if (relationInstance.isMarked(48)) {
                DrawInfo drawInfo;
                Enumeration enumeration;
                OutElidedInfo outElidedInfo = null;
                InElidedInfo inElidedInfo = null;
                if (relationInstance.isMarked(16)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof OutElidedInfo) {
                            outElidedInfo = (OutElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            enumeration = ((Vector)this.m_drawInfo).elements();
                            while (enumeration.hasMoreElements()) {
                                drawInfo = (DrawInfo)enumeration.nextElement();
                                if (!(drawInfo instanceof OutElidedInfo)) continue;
                                outElidedInfo = (OutElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (outElidedInfo == null) {
                        outElidedInfo = new OutElidedInfo();
                    }
                    outElidedInfo.setOutElidedInfo(edgePoint2, edgePoint);
                    outElidedInfo.setStyle(relationInstance.getInheritedStyle());
                }
                if (relationInstance.isMarked(32)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof InElidedInfo) {
                            inElidedInfo = (InElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            enumeration = ((Vector)this.m_drawInfo).elements();
                            while (enumeration.hasMoreElements()) {
                                drawInfo = (DrawInfo)enumeration.nextElement();
                                if (!(drawInfo instanceof InElidedInfo)) continue;
                                inElidedInfo = (InElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (inElidedInfo == null) {
                        inElidedInfo = new InElidedInfo();
                    }
                    inElidedInfo.setInElidedInfo(edgePoint2, edgePoint);
                    inElidedInfo.setStyle(relationInstance.getInheritedStyle());
                }
                if (outElidedInfo == null) {
                    this.m_drawInfo = inElidedInfo;
                } else if (inElidedInfo == null) {
                    this.m_drawInfo = outElidedInfo;
                } else {
                    if (this.m_drawInfo instanceof Vector) {
                        ((Vector)this.m_drawInfo).removeAllElements();
                    } else {
                        this.m_drawInfo = new Vector();
                    }
                    ((Vector)this.m_drawInfo).addElement(outElidedInfo);
                    ((Vector)this.m_drawInfo).addElement(inElidedInfo);
                }
            } else {
                if (this.m_drawInfo == null || !(this.m_drawInfo instanceof EdgeInfo)) {
                    this.m_drawInfo = new EdgeInfo();
                }
                EdgeInfo edgeInfo = (EdgeInfo)this.m_drawInfo;
                edgeInfo.setEdgeInfo(edgePoint2, edgePoint);
                edgeInfo.setStyle(n);
                int n4 = 4;
                if (relationInstance.isMarked(512)) {
                    n4 |= 2;
                }
                edgeInfo.setEmbellished(n4);
            }
        }
        if (this.m_drawInfo != null) {
            Rectangle rectangle = new Rectangle();
            this.computeBounds(rectangle);
            ++rectangle.width;
            ++rectangle.height;
            this.setBounds(rectangle);
            this.repaint();
        }
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getX();
        int n2 = this.getY();
        graphics.setColor(this.m_relationInstance.getInheritedObjectColor());
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                ((DrawInfo)this.m_drawInfo).paintComponent(graphics, n, n2);
            } else {
                Enumeration enumeration = ((Vector)this.m_drawInfo).elements();
                while (enumeration.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)enumeration.nextElement();
                    drawInfo.paintComponent(graphics, n, n2);
                }
            }
        }
    }

    public String toString() {
        return "RelationComponent: " + this.m_relationInstance;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseEntered();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseExited();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_relationInstance.mousePressed(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseReleased(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseDragged(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.m_relationInstance.mouseMoved(mouseEvent, mouseEvent.getX() + this.getX(), mouseEvent.getY() + this.getY());
    }

    class EdgeInfo
    extends DrawInfo {
        private EdgePoint m_src;
        private EdgePoint m_dst;

        EdgeInfo() {
        }

        public void setEdgeInfo(EdgePoint edgePoint, EdgePoint edgePoint2) {
            this.m_src = edgePoint;
            this.m_dst = edgePoint2;
        }

        public void getBounds(Rectangle rectangle) {
            RelationComponent.getLineBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
            if ((this.m_embellished & 1) != 0) {
                RelationComponent.includeTailBounds((int)this.m_src.getX(), (int)this.m_src.getY(), rectangle);
            }
            if ((this.m_embellished & 2) != 0) {
                RelationComponent.includeCentreBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
            }
            if ((this.m_embellished & 4) != 0) {
                RelationComponent.this.includeArrowBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
            }
        }

        public boolean contains(int n, int n2) {
            return RelationComponent.nearLine((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2);
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            if (RelationComponent.nearPoint((int)this.m_src.getX(), (int)this.m_src.getY(), n, n2)) {
                return this.m_src;
            }
            if (RelationComponent.nearPoint((int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2)) {
                return this.m_dst;
            }
            return null;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            int n3 = (int)(this.m_src.getX() - (double)n);
            int n4 = (int)(this.m_src.getY() - (double)n2);
            int n5 = (int)(this.m_dst.getX() - (double)n);
            int n6 = (int)(this.m_dst.getY() - (double)n2);
            if ((this.m_embellished & 4) != 0) {
                Util.drawArrow(graphics, RelationComponent.this.getLs(), this.m_style, n3, n4, n5, n6, RelationComponent.this.arrowWeight());
            } else {
                Util.drawSegment(graphics, this.m_style, n3, n4, n5, n6);
            }
            if ((this.m_embellished & 1) != 0) {
                graphics.fillOval(n3 - 3, n4 - 3, 6, 6);
            }
            if ((this.m_embellished & 2) != 0) {
                Color color = graphics.getColor();
                graphics.setColor(HIGHLIGHT_COLOR);
                graphics.fillRect((n3 + n5 - 4) / 2, (n4 + n6 - 4) / 2, 4, 4);
                graphics.setColor(color);
            }
        }

        public String toString() {
            return "EdgeInfo: " + this.m_src + "->" + this.m_dst + " style=" + this.m_style + " embellished=" + this.m_embellished;
        }
    }

    class InElidedInfo
    extends ElidedInfo {
        int m_srcX;
        int m_srcY;
        private EdgePoint m_dst;

        InElidedInfo() {
        }

        public void setInElidedInfo(EdgePoint edgePoint, EdgePoint edgePoint2) {
            double d = edgePoint2.getX();
            double d2 = edgePoint2.getY();
            double d3 = edgePoint.getX() - d;
            double d4 = edgePoint.getY() - d2;
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            this.m_srcX = (int)(edgePoint2.getX() + d3 * 2.0 * ArrowDimensions.m_arrow_length / d5);
            this.m_srcY = (int)(edgePoint2.getY() + d4 * 2.0 * ArrowDimensions.m_arrow_length / d5);
            this.m_dst = edgePoint2;
        }

        public void getBounds(Rectangle rectangle) {
            this.getBounds(this.m_srcX, this.m_srcY, (int)this.m_dst.getX(), (int)this.m_dst.getY(), rectangle);
        }

        public boolean contains(int n, int n2) {
            return RelationComponent.nearLine(this.m_srcX, this.m_srcY, (int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2);
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            if (RelationComponent.nearPoint((int)this.m_dst.getX(), (int)this.m_dst.getY(), n, n2)) {
                return this.m_dst;
            }
            return null;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponent(graphics, this.m_srcX - n, this.m_srcY - n2, (int)(this.m_dst.getX() - (double)n), (int)(this.m_dst.getY() - (double)n2));
        }
    }

    class OutElidedInfo
    extends ElidedInfo {
        private EdgePoint m_src;
        int m_dstX;
        int m_dstY;

        OutElidedInfo() {
        }

        public void setOutElidedInfo(EdgePoint edgePoint, EdgePoint edgePoint2) {
            double d = edgePoint.getX();
            double d2 = edgePoint.getY();
            double d3 = d - edgePoint2.getX();
            double d4 = d2 - edgePoint2.getY();
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            this.m_dstX = (int)(d - d3 * 2.0 * ArrowDimensions.m_arrow_length / d5);
            this.m_dstY = (int)(d2 - d4 * 2.0 * ArrowDimensions.m_arrow_length / d5);
            this.m_src = edgePoint;
        }

        public void getBounds(Rectangle rectangle) {
            this.getBounds((int)this.m_src.getX(), (int)this.m_src.getY(), this.m_dstX, this.m_dstY, rectangle);
        }

        public boolean contains(int n, int n2) {
            return RelationComponent.nearLine((int)this.m_src.getX(), (int)this.m_src.getY(), this.m_dstX, this.m_dstY, n, n2);
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            if (RelationComponent.nearPoint((int)this.m_src.getX(), (int)this.m_src.getY(), n, n2)) {
                return this.m_src;
            }
            return null;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponent(graphics, (int)(this.m_src.getX() - (double)n), (int)(this.m_src.getY() - (double)n2), this.m_dstX - n, this.m_dstY - n2);
        }
    }

    class ElidedInfo
    extends DrawInfo {
        ElidedInfo() {
        }

        public void getBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
            RelationComponent.getLineBounds(n, n2, n3, n4, rectangle);
            RelationComponent.this.includeArrowBounds(n, n2, n3, n4, rectangle);
        }

        public void paintComponent(Graphics graphics, int n, int n2, int n3, int n4) {
            Util.drawArrow(graphics, RelationComponent.this.getLs(), this.m_style, n, n2, n3, n4, 1);
        }
    }

    class ArcInfo
    extends DrawInfo {
        int m_x;
        int m_y;
        int m_x_radius;
        int m_y_radius;
        int m_angle;

        public void computePosition() {
            int n;
            int n2;
            RelationInstance relationInstance = RelationComponent.this.m_relationInstance;
            RelationClass relationClass = relationInstance.getRelationClass();
            int n3 = relationClass.getNid();
            EntityInstance entityInstance = relationInstance.getDrawSrc();
            int n4 = entityInstance.getWidth();
            int n5 = entityInstance.getHeight();
            switch (n3 / 8) {
                case 0: {
                    n2 = n4;
                    n = 0;
                    this.m_angle = 3;
                    break;
                }
                case 1: {
                    n2 = n4;
                    n = n5;
                    this.m_angle = 2;
                    break;
                }
                case 2: {
                    n2 = 0;
                    n = n5;
                    this.m_angle = 1;
                    break;
                }
                default: {
                    n2 = 0;
                    n = 0;
                    this.m_angle = 0;
                }
            }
            n3 = n3 % 8 + 1;
            this.m_x = n2 + entityInstance.getDiagramX();
            this.m_y = n + entityInstance.getDiagramY();
            this.m_x_radius = n3 * n4 / 36;
            this.m_y_radius = n3 * n5 / 36;
        }

        public void getBounds(Rectangle rectangle) {
            rectangle.setBounds(this.m_x - this.m_x_radius, this.m_y - this.m_y_radius, this.m_x_radius * 2, this.m_y_radius * 2);
        }

        public boolean contains(int n, int n2) {
            int n3 = n2 - this.m_y;
            int n4 = n - this.m_x;
            switch (this.m_angle) {
                case 0: {
                    if (n3 < 0 || n4 < 0) break;
                    return false;
                }
                case 1: {
                    if (n3 > 0 || n4 < 0) break;
                    return false;
                }
                case 2: {
                    if (n4 > 0 || n3 > 0) break;
                    return false;
                }
                default: {
                    if (n4 > 0 || n3 < 0) break;
                    return false;
                }
            }
            double d = (double)n4 / (double)this.m_x_radius;
            double d2 = (double)n3 / (double)this.m_y_radius;
            return (d = d * d + d2 * d2) > 0.95 && d < 1.05;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (this.m_style != 2) {
                graphics.drawArc(0, 0, this.m_x_radius * 2, this.m_y_radius * 2, this.m_angle * 90, 270);
            } else {
                for (int i = this.m_angle * 90; i < this.m_angle * 90 + 270; i += 18) {
                    graphics.drawArc(0, 0, this.m_x_radius * 2, this.m_y_radius * 2, i, 8);
                }
            }
            switch (this.m_angle) {
                case 0: {
                    n6 = 2 * this.m_x_radius - 1;
                    n5 = 0;
                    n4 = n6;
                    n3 = this.m_y_radius - 1;
                    break;
                }
                case 1: {
                    n6 = 2 * this.m_x_radius - 1;
                    n5 = 2 * this.m_y_radius - 1;
                    n4 = n6;
                    n3 = this.m_y_radius - 1;
                    break;
                }
                case 2: {
                    n6 = 0;
                    n5 = 2 * this.m_y_radius - 1;
                    n4 = 0;
                    n3 = this.m_y_radius - 1;
                    break;
                }
                default: {
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                    n3 = this.m_y_radius - 1;
                }
            }
            Util.drawArrowHead(graphics, RelationComponent.this.getLs(), n6, n5, n4, n3, 1);
            if ((this.m_embellished & 2) != 0) {
                Color color = graphics.getColor();
                graphics.setColor(HIGHLIGHT_COLOR);
                n6 = this.m_angle < 2 ? 0 : 2 * this.m_x_radius - 4;
                graphics.fillRect(n6, this.m_y_radius - 2, 4, 4);
            }
        }
    }

    class DrawInfo {
        int m_style = 0;
        protected int m_embellished;

        DrawInfo() {
        }

        public void setStyle(int n) {
            this.m_style = n;
        }

        public void setEmbellished(int n) {
            this.m_embellished = n;
        }

        public void getBounds(Rectangle rectangle) {
            rectangle.setBounds(0, 0, 0, 0);
        }

        public boolean contains(int n, int n2) {
            return false;
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
        }

        public boolean overEdgePoint(int n, int n2) {
            return false;
        }

        public EdgePoint mouseOverEdgePoint(int n, int n2) {
            return null;
        }
    }
}

