/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import lsedit.Arrow;
import lsedit.RelationClass;

class RelnChkBox
extends JComponent {
    public static final int GAP = 5;
    public static final int WIDTH = 45;
    public static final int HEIGHT = 20;
    protected JCheckBox m_checkbox;
    protected RelationClass m_rc;
    protected int m_index;

    public RelnChkBox(RelationClass relationClass, int n, boolean bl, Font font) {
        JCheckBox jCheckBox;
        FlowLayout flowLayout = new FlowLayout(0);
        this.setLayout(flowLayout);
        this.m_rc = relationClass;
        this.m_index = n;
        Color color = relationClass.getInheritedObjectColor();
        this.m_checkbox = jCheckBox = new JCheckBox();
        jCheckBox.setBorderPaintedFlat(false);
        if (this.m_index < 0) {
            jCheckBox.setSelected(false);
            jCheckBox.setEnabled(false);
            jCheckBox.setVisible(false);
        } else {
            jCheckBox.setSelected(bl);
            jCheckBox.setEnabled(true);
            jCheckBox.setVisible(true);
        }
        this.add(jCheckBox);
        Arrow arrow = new Arrow(45, 20);
        arrow.setBackground(color);
        arrow.setStyle(relationClass.getInheritedStyle());
        this.add(arrow);
        color = relationClass.getInheritedLabelColor();
        String string = relationClass.getLabel();
        if (n >= 0) {
            string = string + " (" + n + ")";
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(color);
        jLabel.setFont(font);
        this.add(jLabel);
        this.setToolTipText(relationClass.getDescription());
    }

    public void addItemListener(ItemListener itemListener) {
        this.m_checkbox.addItemListener(itemListener);
    }

    public boolean isSelected() {
        return this.m_checkbox.isSelected();
    }

    public void doClick() {
        if (this.m_index >= 0) {
            this.m_checkbox.doClick();
        }
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean isContainsClass() {
        return this.m_rc.isContainsClass();
    }
}

