/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.HiArc;
import lsedit.HiChildren;
import lsedit.HiGraph;
import lsedit.HiGraphCoordinates;
import lsedit.HiGraphException;
import lsedit.HiGroup;
import lsedit.HiRank;
import lsedit.HiRow;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SimplexLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int XGAP = 0;
    protected static final int YGAP = 1;
    protected static final int SIMPLEX = 2;
    protected static final int CROSSINGS = 3;
    protected static final int BORDER = 4;
    protected static final String[] m_textfield_tags = new String[]{"simplex:xgap[", "simplex:ygap[", "simplex:simplex[", "simplex:crossings[", "simplex:border["};
    protected static final String[] m_textfield_titles = new String[]{"Minimum horizontal gap between nodes:", "Minimum vertical gap between nodes:", "Maximum allowed simplex pivots:", "Maximum reorderings of a row:", "Percentage for border"};
    protected static final String[] m_textfield_resets = new String[]{"20", "20", "10000", "125", "0.08"};
    protected static String[] m_textfield_defaults = new String[]{"20", "20", "10000", "125", "0.08"};
    protected static String[] m_textfield_currents = new String[]{"20", "20", "10000", "125", "0.08"};
    private static int m_xgap = 20;
    private static int m_ygap = 20;
    private static int m_simplex = 10000;
    private static int m_crossings = 125;
    private static double m_border = 0.08;
    protected static final int FIXEDRATIO = 0;
    protected static final String[] m_checkbox_tags = new String[]{"simplex:fixedratio["};
    protected static final String[] m_checkbox_titles = new String[]{"Scale using fixed ratio"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{true};
    protected static boolean[] m_checkbox_currents = new boolean[]{true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_DEFAULT = 3;
    protected static final int BUTTON_SET = 4;
    protected static final int BUTTON_RESET = 5;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Use remembered default", "Set default to current", "Set default to initial"};
    public static final int horizMargin = 2;
    public static final int vertMargin = 2;
    private static int m_weight_1dummy = 0;
    private static int m_weight_2dummy = 0;
    private static int m_outside_bias = 1;
    private static int m_group_children = 0;
    private static boolean m_fixedRatio;
    private static boolean m_bends;
    String m_message;

    protected static boolean parameterBoolean(int n) {
        return m_checkbox_currents[n];
    }

    protected void setParameter(int n, String string) {
        string = string.trim();
        try {
            switch (n) {
                case 4: {
                    double d;
                    m_border = d = Double.parseDouble(string);
                    break;
                }
                default: {
                    int n2 = Integer.parseInt(string);
                    switch (n) {
                        case 0: {
                            m_xgap = n2;
                            break;
                        }
                        case 1: {
                            m_ygap = n2;
                            break;
                        }
                        case 2: {
                            m_simplex = n2;
                            break;
                        }
                        case 3: {
                            m_crossings = n2;
                        }
                    }
                    SimplexLayout.m_textfield_currents[n] = string;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getTag() {
        return "simplex:";
    }

    public void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    SimplexLayout.m_textfield_defaults[n] = string;
                }
                case 1: {
                    this.setParameter(n, string);
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    SimplexLayout.m_checkbox_defaults[n] = bl;
                }
                case 1: {
                    SimplexLayout.m_checkbox_currents[n] = bl;
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    public static void setBends(boolean bl) {
        if (bl) {
            m_weight_1dummy = 2;
            m_weight_2dummy = 8;
        } else {
            m_weight_1dummy = 0;
            m_weight_2dummy = 0;
        }
        m_bends = bl;
    }

    public static boolean hasBends() {
        return m_bends;
    }

    public static int xgap() {
        return m_xgap;
    }

    public static boolean xgap(int n) {
        if (n >= 1) {
            m_xgap = n;
            return true;
        }
        return false;
    }

    public static int ygap() {
        return m_ygap;
    }

    public static boolean ygap(int n) {
        if (n >= 1) {
            m_ygap = n;
            return true;
        }
        return false;
    }

    public static int simplex() {
        return m_simplex;
    }

    public static boolean simplex(int n) {
        if (n >= 0) {
            m_simplex = n;
            return true;
        }
        return false;
    }

    public static int crossing() {
        return m_crossings;
    }

    public static boolean crossing(int n) {
        if (n >= 0) {
            m_crossings = n;
            return true;
        }
        return false;
    }

    public static double border() {
        return m_border;
    }

    public static void border(double d) {
        m_border = d;
    }

    public static boolean fixedRatio() {
        return m_fixedRatio;
    }

    public static void fixedRatio(boolean bl) {
        m_fixedRatio = bl;
    }

    public static int weight_1dummy() {
        return m_weight_1dummy;
    }

    public static boolean weight_1dummy(int n) {
        if (n >= 1) {
            m_weight_1dummy = n;
            return true;
        }
        return false;
    }

    public static int weight_2dummy() {
        return m_weight_2dummy;
    }

    public static boolean weight_2dummy(int n) {
        if (n >= 1) {
            m_weight_2dummy = n;
            return true;
        }
        return false;
    }

    public static int outside_bias() {
        return m_outside_bias;
    }

    public static boolean outside_bias(int n) {
        if (n >= 0) {
            m_outside_bias = n;
            return true;
        }
        return false;
    }

    public static int group_children() {
        return m_group_children;
    }

    public static boolean group_children(int n) {
        if (n >= -1 && n <= 1) {
            m_group_children = n;
            return true;
        }
        return false;
    }

    public static int xmargin() {
        return 2;
    }

    public static int ymargin() {
        return 2;
    }

    public boolean coordinates(HiGraph hiGraph) {
        try {
            HiGraphCoordinates.coordinates(this, hiGraph);
            return true;
        }
        catch (HiGraphException hiGraphException) {
            System.out.println("HiGraph error in HiGraphCoordinates: " + hiGraphException.getMessage());
            hiGraphException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Error during HiGraph layout in HiGraphCoordinates: " + exception.getMessage());
            exception.printStackTrace();
        }
        return false;
    }

    public boolean layout(HiGraph hiGraph) {
        try {
            HiGroup.group(hiGraph, SimplexLayout.group_children());
            HiRank.compute(hiGraph, SimplexLayout.simplex());
            HiChildren.order(hiGraph, SimplexLayout.outside_bias());
            HiRow.order(this, hiGraph);
            boolean bl = this.coordinates(hiGraph);
            return bl;
        }
        catch (HiGraphException hiGraphException) {
            System.out.println("HiGraph error in " + hiGraph + ": " + hiGraphException.getMessage());
            hiGraphException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Error during HiGraph layout in " + hiGraph + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of memory error during simplex layout in " + hiGraph + ": " + outOfMemoryError.getMessage());
            outOfMemoryError.printStackTrace();
        }
        return false;
    }

    public SimplexLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Simplex";
    }

    public String getMenuLabel() {
        return "Layout using Simplex algorithm";
    }

    protected static int edgesBetween(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3;
        int n = 0;
        Enumeration enumeration = entityInstance.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            RelationClass relationClass = relationInstance.getRelationClass();
            if (!relationClass.isClassVisible() || !entityInstance2.hasDescendantOrSelf(entityInstance3 = relationInstance.getDrawDst())) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance3 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesBetween(entityInstance3, entityInstance2);
            }
        }
        return n;
    }

    protected static int edgesFromClient(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        int n = 0;
        Enumeration enumeration = entityInstance.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDrawSrc();
            if (!entityInstance2.isMarked(2)) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesFromClient(entityInstance2);
            }
        }
        return n;
    }

    protected static int edgesToSupplier(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        int n = 0;
        Enumeration enumeration = entityInstance.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDrawDst();
            if (!entityInstance2.isMarked(4)) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesToSupplier(entityInstance2);
            }
        }
        return n;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        SimplexConfigure simplexConfigure = new SimplexConfigure(landscapeEditorCore);
        boolean bl = simplexConfigure.ok();
        simplexConfigure.dispose();
        return bl;
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
        HiGraph hiGraph;
        int n;
        HiGraph hiGraph2;
        HiArc hiArc;
        EntityInstance entityInstance2;
        m_fixedRatio = SimplexLayout.parameterBoolean(0);
        double d = SimplexLayout.border();
        switch (vector.size()) {
            case 0: {
                return;
            }
            case 1: {
                EntityInstance entityInstance3 = (EntityInstance)vector.firstElement();
                double d2 = 1.0 - d;
                double d3 = 1.0 - d;
                double d4 = (1.0 - d2) / 2.0;
                double d5 = (1.0 - d3) / 2.0;
                entityInstance3.updateRelLocal(d4, d5, d2, d3);
                return;
            }
        }
        Diagram diagram = this.m_ls.getDiagram();
        int n2 = diagram.getWidth();
        int n3 = diagram.getHeight();
        HiGraph hiGraph3 = new HiGraph(null, "root", 0, n3);
        double d6 = 0.0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            d6 += entityInstance2.heightRelLocal();
        }
        d6 /= (double)vector.size();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            hiGraph3.newChild(entityInstance2, entityInstance2.getEntityLabel(), (int)(entityInstance2.widthRelLocal() * (double)n2), (int)(d6 * (double)n3));
        }
        boolean bl = false;
        Vector vector2 = hiGraph3.children();
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                EntityInstance entityInstance4;
                HiArc hiArc2 = (HiArc)enumeration2.nextElement();
                if (hiArc2 == hiArc || (n = SimplexLayout.edgesBetween(entityInstance2, entityInstance4 = (hiGraph = hiArc2.to()).getReferencedObject())) <= 0) continue;
                bl = true;
                hiArc = hiGraph.newInputArc(hiGraph2);
                hiArc.setWeight(n);
                hiArc.setMinlength(1);
            }
        }
        HiGraph hiGraph4 = null;
        HiGraph hiGraph5 = null;
        if (bl && entityInstance != this.m_ls.getDiagram().getRootInstance()) {
            if (this.m_ls.isShowClients()) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    hiArc = (HiArc)enumeration.nextElement();
                    hiGraph = hiArc.to();
                    entityInstance2 = hiGraph.getReferencedObject();
                    if (entityInstance2 == null || (n = SimplexLayout.edgesFromClient(entityInstance2)) <= 0) continue;
                    if (hiGraph4 == null) {
                        hiGraph4 = hiGraph3.newChild(null, "client", 0, 0);
                    }
                    hiArc = this.m_ls.isTopClients() ? hiGraph.newInputArc(hiGraph4) : hiGraph4.newInputArc(hiGraph);
                    hiArc.setWeight(n);
                    hiArc.setMinlength(1);
                }
            }
            if (this.m_ls.isShowSuppliers()) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    hiArc = (HiArc)enumeration.nextElement();
                    hiGraph2 = hiArc.to();
                    entityInstance2 = hiGraph2.getReferencedObject();
                    if (entityInstance2 == null || (n = SimplexLayout.edgesToSupplier(entityInstance2)) <= 0) continue;
                    if (hiGraph5 == null) {
                        hiGraph5 = hiGraph3.newChild(null, "supplier", 0, 0);
                    }
                    hiArc = this.m_ls.isTopClients() ? hiGraph5.newInputArc(hiGraph2) : hiGraph2.newInputArc(hiGraph5);
                    hiArc.setWeight(n);
                    hiArc.setMinlength(1);
                }
            }
        }
        if (!this.layout(hiGraph3)) {
            hiGraph3 = null;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                if (!(entityInstance2.xRelLocal() < 0.0 || entityInstance2.yRelLocal() < 0.0 || entityInstance2.widthRelLocal() <= 0.0) && !(entityInstance2.heightRelLocal() <= 0.0)) continue;
                this.m_ls.m_layspring.doLayout1(vector, entityInstance);
                this.m_message = "Simplex algorithm failed -- used spring layout instead";
                return;
            }
            this.m_message = "Simplex layout algorithm failed - layout unchanged";
            return;
        }
        System.out.println("Done layout");
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        vector2 = hiGraph3.children();
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            if (entityInstance2 == null) continue;
            int n8 = hiGraph2.x() - hiGraph2.width() / 2;
            int n9 = n8 + hiGraph2.width();
            int n10 = hiGraph2.y() - hiGraph2.height() / 2;
            int n11 = n10 + hiGraph2.height();
            if (n8 < n5) {
                n5 = n8;
            }
            if (n9 > n7) {
                n7 = n9;
            }
            if (n10 < n4) {
                n4 = n10;
            }
            if (n11 <= n6) continue;
            n6 = n11;
        }
        double d7 = n7 - n5;
        double d8 = (double)n5 - d7 * d / 2.0;
        d7 += d7 * d;
        double d9 = n6 - n4;
        double d10 = (double)n4 - d9 * d / 2.0;
        d9 += d9 * d;
        if (d7 <= 0.0 || d9 <= 0.0) {
            return;
        }
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 1.0;
        if (SimplexLayout.fixedRatio()) {
            d13 = d7 * (double)n3 / (d9 * (double)n2);
            if (d13 <= 1.0) {
                d11 = (1.0 - d13) / 2.0;
            } else {
                d14 = 1.0 / d13;
                d13 = 1.0;
                d12 = (1.0 - d14) / 2.0;
            }
            d7 /= d13;
            d9 /= d14;
        }
        enumeration = hiGraph3.children().elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            if (entityInstance2 == null) continue;
            double d15 = (double)hiGraph2.width() / d7;
            double d16 = (double)hiGraph2.height() / d9;
            double d17 = ((double)hiGraph2.x() - d8) / d7;
            double d18 = ((double)hiGraph2.y() - d10) / d9;
            entityInstance2.updateRelLocal(d17 += d11 - d15 / 2.0, d18 += d12 - d16 / 2.0, d15, d16);
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_message = "Graph redrawn using Network Simplex algorithm";
        this.m_ls.setLayouter(this);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Simplex algorithm requires that all things laid out share same parent";
        }
        this.m_ls.setCursor(3);
        diagram.beginUndoRedo("Simplex layout");
        this.doLayout1(vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return this.m_message;
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    static {
        m_bends = false;
    }

    class SimplexConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public SimplexConfigure(LandscapeEditorCore landscapeEditorCore) {
            JLabel jLabel;
            int n;
            super(landscapeEditorCore.getFrame(), "Set Simplex Algorithm parameters", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(6, 1);
            gridLayout.setVgap(10);
            jPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(6, 1);
            gridLayout.setVgap(10);
            jPanel3.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 20);
                jTextField.addActionListener(this);
                jTextField.setFont(font);
                jPanel3.add(jTextField);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                JCheckBox jCheckBox;
                jLabel = new JLabel(m_checkbox_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                this.m_checkboxes[n] = jCheckBox = new JCheckBox("", m_checkbox_currents[n]);
                jCheckBox.setFont(font);
                jPanel3.add(jCheckBox);
            }
            jPanel.add("West", jPanel2);
            jPanel.add("East", jPanel3);
            Container container = this.getContentPane();
            container.add("North", jPanel);
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            container.add("Center", this.m_message);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                this.m_buttons[n] = jButton = new JButton(m_button_titles[n]);
                jButton.setFont(font2);
                String string = m_button_tips[n];
                if (string != null) {
                    jButton.setToolTipText(string);
                }
                jButton.addActionListener(this);
                jPanel4.add(jButton);
            }
            container.add("South", jPanel4);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SimplexLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        SimplexLayout.m_checkbox_defaults[n] = m_checkbox_resets[n];
                    }
                }
                case 3: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                    }
                    return;
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SimplexLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        SimplexLayout.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                    }
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SimplexLayout.this.m_ls.getFrame(), "Gap\n  Minimum number of pixels between entities\nBorder\n  Fraction of diagram to reserve for border\n  Must be a value between 0 and 1\nPivots\n  Maximum number of simplex pivots to perform\nReorderings\n  Maximumn number of horizontal reorderings", "Help", 0);
                    return;
                }
            }
            block25: for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField = this.m_textfields[n];
                if (object != jTextField && n2 != 0) continue;
                String string = jTextField.getText();
                string = string.trim();
                String string2 = m_textfield_titles[n];
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        try {
                            int n3 = Integer.parseInt(string);
                            if (n3 >= 0) continue block25;
                            this.m_message.setText(string2 + " may not be negative");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not an integer value");
                            return;
                        }
                    }
                    case 4: {
                        try {
                            double d = Double.parseDouble(string);
                            if (!(d < 0.0) && !(d >= 1.0)) continue block25;
                            this.m_message.setText(string2 + " must be in the range 0 to 1.0");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (n2) {
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SimplexLayout.this.setParameter(n, this.m_textfields[n].getText());
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        SimplexLayout.m_checkbox_currents[n] = this.m_checkboxes[n].isSelected();
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

