/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SpringLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int ATTRACTIVE_FORCE = 0;
    protected static final int SPARSE_FACTOR = 1;
    protected static final int CLIENT_FORCE = 2;
    protected static final int CLIENT_FACTOR = 3;
    protected static final int SUPPLIER_FORCE = 4;
    protected static final int SUPPLIER_FACTOR = 5;
    protected static final int REPULSIVE_FORCE = 6;
    protected static final int REPULSIVE_DIAMETER = 7;
    protected static final int ITERATIONS = 8;
    protected static final int TIMEOUT = 9;
    protected static final String[] m_textfield_tags = new String[]{"spring:attraction[", "spring:sparse[", "spring:clientforce[", "spring:clientfactor[", "spring:supplierforce[", "spring:supplierfactor[", "spring:repulsion[", "spring:diameter[", "spring:iterations[", "spring:timeout["};
    protected static final String[] m_textfield_titles = new String[]{"Related force", "Sparseness factor", "Client force", "Client factor", "Supplier force", "Supplier factor", "Unrelated force", "Repulsive range", "Iterations", "Time out"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "1.0", "0.05", "0.5", "0.05", "0.5", "0.01", "0.75", "1000", "300"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "1.0", "0.05", "0.5", "0.05", "0.5", "0.01", "0.75", "1000", "300"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "1.0", "0.05", "0.5", "0.05", "0.5", "0.01", "0.75", "1000", "300"};
    static double m_attractive_force = 0.05;
    static double m_sparse_factor = 1.0;
    static double m_client_force = 0.05;
    static double m_client_factor = 0.5;
    static double m_supplier_force = 0.05;
    static double m_supplier_factor = 0.5;
    static double m_repulsive_force = 0.01;
    static double m_repulsive_diameter = 0.75;
    static int m_iterations = 1000;
    static int m_timeout = 300;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};

    public String getTag() {
        return "spring:";
    }

    protected void setParameter(int n, String string) {
        string = string.trim();
        try {
            switch (n) {
                case 8: 
                case 9: {
                    int n2 = Integer.parseInt(string);
                    switch (n) {
                        case 8: {
                            m_iterations = n2;
                            break;
                        }
                        case 9: {
                            m_timeout = n2;
                        }
                    }
                    break;
                }
                default: {
                    double d = Double.parseDouble(string);
                    switch (n) {
                        case 0: {
                            m_attractive_force = d;
                            break;
                        }
                        case 1: {
                            m_sparse_factor = d;
                            break;
                        }
                        case 2: {
                            m_client_force = d;
                            break;
                        }
                        case 3: {
                            m_client_factor = d;
                            break;
                        }
                        case 4: {
                            m_supplier_force = d;
                            break;
                        }
                        case 5: {
                            m_supplier_factor = d;
                            break;
                        }
                        case 6: {
                            m_repulsive_force = d;
                            break;
                        }
                        case 7: {
                            m_repulsive_diameter = d;
                        }
                    }
                }
            }
            SpringLayout.m_textfield_currents[n] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load(String string) {
        for (int i = 0; i < m_textfield_tags.length; ++i) {
            String string2 = m_textfield_tags[i];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n) {
                case 0: {
                    SpringLayout.m_textfield_defaults[i] = string;
                }
                case 1: {
                    this.setParameter(i, string);
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        String[] stringArray2 = m_textfield_defaults;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < m_textfield_tags.length; ++j) {
                String string = stringArray2[j];
                if (string.equals(stringArray[j])) continue;
                String string2 = m_textfield_tags[j];
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            stringArray2 = m_textfield_currents;
        }
    }

    public SpringLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Old Spring";
    }

    public String getMenuLabel() {
        return "Layout using old spring algorithm";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        SpringConfigure springConfigure = new SpringConfigure();
        boolean bl = springConfigure.ok();
        springConfigure.dispose();
        return bl;
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
        double d;
        double d2;
        int n;
        EntityInstance entityInstance2;
        SpringNode springNode;
        int n2;
        double d3 = m_attractive_force;
        double d4 = m_sparse_factor;
        double d5 = m_client_force;
        double d6 = m_client_factor;
        double d7 = m_supplier_force;
        double d8 = m_supplier_factor;
        double d9 = m_repulsive_force;
        double d10 = m_repulsive_diameter;
        int n3 = m_iterations;
        long l = m_timeout;
        int n4 = vector.size();
        switch (n4) {
            case 0: {
                return;
            }
            case 1: {
                EntityInstance entityInstance3 = (EntityInstance)vector.firstElement();
                double d11 = 0.5;
                double d12 = 0.5;
                double d13 = (1.0 - d11) / 2.0;
                double d14 = (1.0 - d12) / 2.0;
                entityInstance3.updateRelLocal(d13, d14, d11, d12);
                return;
            }
        }
        SpringNode[] springNodeArray = new SpringNode[n4];
        boolean bl = this.m_ls.isTopClients();
        boolean[][] blArrayArray = new boolean[n4][];
        for (n2 = 0; n2 < n4; ++n2) {
            springNodeArray[n2] = springNode = new SpringNode();
            blArrayArray[n2] = new boolean[n4 - n2];
            springNode.m_e = entityInstance2 = (EntityInstance)vector.elementAt(n2);
            springNode.m_x = entityInstance2.xRelLocal();
            springNode.m_y = entityInstance2.yRelLocal();
            springNode.m_xmax = 1.0 - entityInstance2.widthRelLocal();
            springNode.m_ymax = 1.0 - entityInstance2.heightRelLocal();
            springNode.m_clients = false;
            springNode.m_suppliers = false;
            entityInstance2.orMark(0x4000000);
        }
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        for (n2 = 0; n2 < n4; ++n2) {
            double d18;
            double d19;
            EntityInstance entityInstance4;
            RelationClass relationClass;
            RelationInstance relationInstance;
            springNode = springNodeArray[n2];
            entityInstance2 = springNode.m_e;
            double d20 = entityInstance2.widthRelLocal();
            double d21 = entityInstance2.heightRelLocal();
            Enumeration enumeration = entityInstance2.srcLiftedRelationElements();
            block6: while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                relationClass = relationInstance.getRelationClass();
                if (!relationClass.isClassVisible()) continue;
                entityInstance4 = relationInstance.getDrawDst();
                if (entityInstance4.isMarked(6)) {
                    springNode.m_suppliers = true;
                }
                if (!entityInstance4.isMarked(0x4000000)) continue;
                for (n = n2 + 1; n < n4; ++n) {
                    if (entityInstance4 != springNodeArray[n].m_e) continue;
                    blArrayArray[n2][n - n2] = true;
                    blArrayArray[n2][0] = true;
                    blArrayArray[n][0] = true;
                    d19 = entityInstance4.widthRelLocal();
                    d18 = entityInstance4.heightRelLocal();
                    d2 = d20 + d19;
                    if (d2 > d15) {
                        d15 = d2;
                    }
                    if (!((d = d21 + d18) > d15)) continue block6;
                    d15 = d;
                    continue block6;
                }
            }
            enumeration = entityInstance2.dstLiftedRelationElements();
            block8: while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                relationClass = relationInstance.getRelationClass();
                if (!relationClass.isClassVisible()) continue;
                entityInstance4 = relationInstance.getDrawSrc();
                if (entityInstance4.isMarked(6)) {
                    springNode.m_clients = true;
                }
                if (!entityInstance4.isMarked(0x4000000)) continue;
                for (n = n2 + 1; n < n4; ++n) {
                    if (entityInstance4 != springNodeArray[n].m_e) continue;
                    blArrayArray[n2][n - n2] = true;
                    blArrayArray[n2][0] = true;
                    blArrayArray[n][0] = true;
                    d19 = entityInstance4.widthRelLocal();
                    d18 = entityInstance4.heightRelLocal();
                    d2 = d20 + d19;
                    if (d2 > d15) {
                        d15 = d2;
                    }
                    if (!((d = d21 + d18) > d15)) continue block8;
                    d15 = d;
                    continue block8;
                }
            }
            if (springNode.m_clients || springNode.m_suppliers) {
                if (springNode.m_clients & springNode.m_suppliers) {
                    springNode.m_clients = false;
                    springNode.m_suppliers = false;
                } else if (!bl) {
                    boolean bl2 = springNode.m_clients;
                    springNode.m_clients = springNode.m_suppliers;
                    springNode.m_suppliers = bl2;
                }
            }
            entityInstance2.nandMark(0x4000000);
        }
        d16 = d15 * d6;
        d17 = d15 * d8;
        d15 *= d4;
        l = System.currentTimeMillis() + l * 1000L;
        for (int i = n3; i > 0; --i) {
            for (n2 = 0; n2 < n4; ++n2) {
                springNode = springNodeArray[n2];
                double d22 = springNode.m_x;
                double d23 = springNode.m_y;
                double d24 = springNode.m_xmax;
                double d25 = springNode.m_ymax;
                if (springNode.m_suppliers || springNode.m_clients) {
                    d23 = springNode.m_suppliers ? (d23 += (d25 - d23 - d17) * d7) : (d23 += (d16 - d23) * d5);
                    if (d23 > d25) {
                        d23 = d25;
                    }
                    if (d23 < 0.0) {
                        d23 = 0.0;
                    }
                }
                for (n = n2 + 1; n < n4; ++n) {
                    SpringNode springNode2 = springNodeArray[n];
                    double d26 = springNode2.m_x;
                    double d27 = springNode2.m_y;
                    double d28 = springNode2.m_xmax;
                    double d29 = springNode2.m_ymax;
                    d2 = d26 - d22;
                    d = d27 - d23;
                    if (d2 == 0.0 && d == 0.0) {
                        d2 = n2 % 3 - 1;
                        d = d2 == 0.0 ? (double)(n % 2 * 2 - 1) : (double)(n % 3 - 1);
                    }
                    double d30 = Math.sqrt(d2 * d2 + d * d);
                    double d31 = blArrayArray[n2][n - n2] ? (d30 - d15) * d3 : (d30 - d10) * d9;
                    d22 += d31 * d2 / d30;
                    d26 -= d31 * d2 / d30;
                    d23 += d31 * d / d30;
                    d27 -= d31 * d / d30;
                    if (d22 > d24) {
                        d26 += d24 - d22;
                        d22 = d24;
                    }
                    if (d26 > d28) {
                        d22 += d28 - d26;
                        d26 = d28;
                    }
                    if (d22 < 0.0) {
                        d26 -= d22;
                        d22 = 0.0;
                    }
                    if (d26 < 0.0) {
                        d22 -= d26;
                        d26 = 0.0;
                    }
                    if (d22 > d24) {
                        d22 = d24;
                    }
                    if (d26 > d28) {
                        d26 = d28;
                    }
                    if (d23 > d25) {
                        d27 += d25 - d23;
                        d23 = d25;
                    }
                    if (d27 > d29) {
                        d23 += d29 - d27;
                        d27 = d29;
                    }
                    if (d23 < 0.0) {
                        d27 -= d23;
                        d23 = 0.0;
                    }
                    if (d27 < 0.0) {
                        d23 -= d27;
                        d27 = 0.0;
                    }
                    if (d23 > d25) {
                        d23 = d25;
                    }
                    if (d27 > d29) {
                        d27 = d29;
                    }
                    springNode2.m_x = d26;
                    springNode2.m_y = d27;
                }
                springNode.m_x = d22;
                springNode.m_y = d23;
            }
            if (System.currentTimeMillis() <= l) continue;
            System.out.println(Util.toLocaleString() + ": Timeout after " + (n3 - i) + " iterations");
            break;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            springNode = springNodeArray[n2];
            entityInstance2 = springNode.m_e;
            entityInstance2.updateRelLocal(springNode.m_x, springNode.m_y, entityInstance2.widthRelLocal(), entityInstance2.heightRelLocal());
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        this.m_ls.setCursor(3);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Spring layout requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Spring layout");
        this.doLayout1(vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Spring Layout";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class SpringNode {
        public EntityInstance m_e;
        double m_x;
        double m_y;
        double m_xmax;
        double m_ymax;
        boolean m_clients;
        boolean m_suppliers;

        SpringNode() {
        }
    }

    class SpringConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public SpringConfigure() {
            int n;
            super(SpringLayout.this.getLs().getFrame(), "SpringLayout Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JPanel jPanel4 = new JPanel();
            JPanel jPanel5 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel4.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel5.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                JPanel jPanel6;
                JPanel jPanel7;
                if (n % 2 == 0) {
                    jPanel7 = jPanel2;
                    jPanel6 = jPanel3;
                } else {
                    jPanel7 = jPanel4;
                    jPanel6 = jPanel5;
                }
                JLabel jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel7.add(jLabel);
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 20);
                jTextField.setFont(font);
                jTextField.addActionListener(this);
                jPanel6.add(jTextField);
            }
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BorderLayout());
            jPanel8.add("West", jPanel2);
            jPanel8.add("East", jPanel3);
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BorderLayout());
            jPanel9.add("West", jPanel4);
            jPanel9.add("East", jPanel5);
            jPanel.add("West", jPanel8);
            jPanel.add("East", jPanel9);
            Container container = this.getContentPane();
            container.add("North", jPanel);
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            container.add("Center", this.m_message);
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                String string = m_button_titles[n];
                if (string == null) {
                    string = SpringLayout.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string);
                jButton.setFont(font2);
                String string2 = m_button_tips[n];
                if (string2 != null) {
                    jButton.setToolTipText(string2);
                }
                jButton.addActionListener(this);
                jPanel10.add(jButton);
            }
            container.add("South", jPanel10);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SpringLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    return;
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SpringLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore landscapeEditorCore = SpringLayout.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(SpringLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SpringLayout.this.m_ls.getFrame(), "Attractive force\n  Scales size of jumps towards ideal distance for related nodes.\n  Actual jump is proportional to difference from ideal distance\nRepulsive force\n  Scales size of jumps towards repulsive diameter for unrelated nodes\n  Actual jump is proportional to difference from repulsive diameter\nClient force\n  Scales size of jumps towards ideal distance from clients\nSupplier force\n  Scales size of jumps towards ideal distance from suppliers\n\nSparse factor\n  The maximum width/height of any two distinct nodes is multiplied\n  by the sparse factor to give the ideal distance\nClient factor\n  The maximum width/height of any two distinct nodes is multiplied\n  by the client factor to give the ideal distance from clients\nSupplier factor\n  The maximum width/height of any two distinct nodes is multiplied\n  by the supplier factor to give the ideal distance from suppliers\nRepulsive diameter\n  Ideal ratio of distance between unrelated nodes to screen size\nIterations\n  Number of times to iterate over the algorithm\nTimeout\n  Maximum number of seconds to spend iterating", "Help", 0);
                    return;
                }
            }
            block22: for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField = this.m_textfields[n];
                if (object != jTextField && n2 != 0) continue;
                String string = jTextField.getText();
                string = string.trim();
                String string2 = m_textfield_titles[n];
                switch (n) {
                    case 8: 
                    case 9: {
                        try {
                            int n3 = Integer.parseInt(string);
                            if (n3 > 0) continue block22;
                            this.m_message.setText(string2 + " must be positive");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not an integer value");
                            return;
                        }
                    }
                    default: {
                        try {
                            Double.parseDouble(string);
                            continue block22;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (n2) {
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SpringLayout.this.setParameter(n, this.m_textfields[n].getText());
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

