/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SpringNode;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SpringLayout2
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int STIFFNESS = 0;
    protected static final int REPULSION = 1;
    protected static final int CLIENT_WEIGHT = 2;
    protected static final int SUPPLIER_WEIGHT = 3;
    protected static final int GAP = 4;
    protected static final int BORDER = 5;
    protected static final int ITERATIONS = 6;
    protected static final int TIMEOUT = 7;
    protected static final String[] m_textfield_tags = new String[]{"spring2:stiffness[", "spring2:repulsion[", "spring2:clientweight[", "spring2:supplierfactor[", "spring2:gap[", "spring2:border[", "spring2:iterations[", "spring2:timeout["};
    protected static final String[] m_textfield_titles = new String[]{"Edge stiffness", "Collision repulsion", "Client weight", "Supplier weight", "Ideal gap", "Border", "Iterations", "Time out"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "0.025", "1.0", "1.0", "0.01", "0.01", "1000", "300"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "0.025", "1.0", "1.0", "0.01", "0.01", "1000", "300"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "0.025", "1.0", "1.0", "0.01", "0.01", "1000", "300"};
    protected double m_stiffness = 0.05;
    protected double m_repulsion = 0.025;
    protected double m_client_weight = 1.0;
    protected double m_supplier_weight = 1.0;
    protected double m_gap = 0.01;
    protected double m_border = 0.01;
    protected int m_iterations = 1000;
    protected long m_timeout = 300L;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};

    public String getTag() {
        return "spring2:";
    }

    protected void setParameter(int n, String string) {
        string = string.trim();
        try {
            switch (n) {
                case 6: 
                case 7: {
                    int n2 = Integer.parseInt(string);
                    switch (n) {
                        case 6: {
                            this.m_iterations = n2;
                            break;
                        }
                        case 7: {
                            this.m_timeout = n2;
                        }
                    }
                    break;
                }
                default: {
                    double d = Double.parseDouble(string);
                    switch (n) {
                        case 0: {
                            this.m_stiffness = d;
                            break;
                        }
                        case 1: {
                            this.m_repulsion = d;
                            break;
                        }
                        case 2: {
                            this.m_client_weight = d;
                            break;
                        }
                        case 3: {
                            this.m_supplier_weight = d;
                            break;
                        }
                        case 4: {
                            this.m_gap = d;
                            break;
                        }
                        case 5: {
                            this.m_border = d;
                        }
                    }
                }
            }
            SpringLayout2.m_textfield_currents[n] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load(String string) {
        for (int i = 0; i < m_textfield_tags.length; ++i) {
            String string2 = m_textfield_tags[i];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n) {
                case 0: {
                    SpringLayout2.m_textfield_defaults[i] = string;
                }
                case 1: {
                    this.setParameter(i, string);
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        String[] stringArray2 = m_textfield_defaults;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < m_textfield_tags.length; ++j) {
                String string = stringArray2[j];
                if (string.equals(stringArray[j])) continue;
                String string2 = m_textfield_tags[j];
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            stringArray2 = m_textfield_currents;
        }
    }

    public SpringLayout2(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Spring";
    }

    public String getMenuLabel() {
        return "Layout using Springs";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        SpringConfigure springConfigure = new SpringConfigure();
        boolean bl = springConfigure.ok();
        springConfigure.dispose();
        return bl;
    }

    public static void place(SpringNode[] springNodeArray, boolean[][] blArray, int n, double d, double d2, double d3, double d4, double d5, double d6, long l) {
        double d7;
        double d8;
        double d9;
        double d10;
        EntityInstance entityInstance;
        SpringNode springNode;
        int n2;
        int n3 = springNodeArray.length;
        double d11 = -1.0;
        int n4 = 0;
        int n5 = 100;
        boolean bl = false;
        boolean bl2 = false;
        if (d5 < 0.0) {
            bl = true;
            d5 = -d5;
        }
        if (d6 < 0.0) {
            bl2 = true;
            d6 = -d6;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            springNode = springNodeArray[n2];
            entityInstance = springNode.m_e;
            d10 = entityInstance.xRelLocal();
            d9 = entityInstance.yRelLocal();
            d8 = entityInstance.widthRelLocal();
            d7 = entityInstance.heightRelLocal();
            if (d10 < 0.0) {
                d10 = 0.5;
            }
            if (d9 < 0.0) {
                d9 = 0.5;
            }
            if (d8 < 0.0 || d7 < 0.0) {
                int n6;
                if (d11 < 0.0 && (d11 = ((1.0 - d2 * 2.0) / (double)(n6 = (int)Math.ceil(Math.sqrt(n3))) - d) / 2.0) < 0.0) {
                    d = 0.0;
                    d11 = (1.0 - d2 * 2.0) / (double)n6 / 2.0;
                }
                if (d8 < 0.0 && d10 + (d8 = d11) > 1.0) {
                    d10 = 1.0 - d8;
                }
                if (d7 < 0.0 && d9 + (d7 = d11) > 1.0) {
                    d9 = 1.0 - d7;
                }
                entityInstance.setWidthRelLocal(d8);
                entityInstance.setHeightRelLocal(d7);
            }
            springNode.m_x = d10 + d8 / 2.0;
            springNode.m_y = d9 + d7 / 2.0;
        }
        long l2 = System.currentTimeMillis() + l * 1000L;
        n5 = 100;
        block11: for (int i = n; i > 0; --i) {
            double d12;
            double d13;
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            double d19;
            double d20;
            double d21;
            double d22;
            double d23;
            double d24;
            double d25;
            EntityInstance entityInstance2;
            SpringNode springNode2;
            int n7;
            for (n2 = 0; n2 < n3; ++n2) {
                springNode = springNodeArray[n2];
                springNode.m_xForce = 0.0;
                springNode.m_yForce = 0.0;
            }
            springNode = springNodeArray[0];
            entityInstance = springNode.m_e;
            d10 = springNode.m_x;
            d9 = springNode.m_y;
            d8 = entityInstance.widthRelLocal();
            d7 = entityInstance.heightRelLocal();
            double d26 = d10 - d8 / 2.0;
            double d27 = d10 + d8 / 2.0;
            double d28 = d9 - d7 / 2.0;
            double d29 = d9 + d7 / 2.0;
            for (n2 = 0; n2 < n3; ++n2) {
                double d30;
                double d31;
                springNode = springNodeArray[n2];
                entityInstance = springNode.m_e;
                d10 = springNode.m_x;
                d9 = springNode.m_y;
                d8 = entityInstance.widthRelLocal();
                d7 = entityInstance.heightRelLocal();
                for (n7 = n2 + 1; n7 < n3; ++n7) {
                    double d32;
                    springNode2 = springNodeArray[n7];
                    entityInstance2 = springNode2.m_e;
                    d25 = springNode2.m_x;
                    d24 = springNode2.m_y;
                    d23 = entityInstance2.widthRelLocal();
                    d22 = entityInstance2.heightRelLocal();
                    d21 = d10 - d25;
                    d20 = d9 - d24;
                    if (d21 == 0.0 && d20 == 0.0) {
                        switch (++n4) {
                            case 1: {
                                d21 = 0.0;
                                d20 = -d;
                                break;
                            }
                            case 2: {
                                d21 = d;
                                d20 = -d;
                                break;
                            }
                            case 3: {
                                d21 = d;
                                d20 = 0.0;
                                break;
                            }
                            case 4: {
                                d21 = d;
                                d20 = d;
                                break;
                            }
                            case 5: {
                                d21 = 0.0;
                                d20 = d;
                                break;
                            }
                            case 6: {
                                d21 = -d;
                                d20 = d;
                                break;
                            }
                            case 7: {
                                d21 = -d;
                                d20 = 0.0;
                                break;
                            }
                            case 8: {
                                d21 = -d;
                                d20 = -d;
                                n4 = 0;
                            }
                        }
                    }
                    double d33 = Math.sqrt(d21 * d21 + d20 * d20);
                    d19 = d21;
                    if (d19 < 0.0) {
                        d19 = -d19;
                    }
                    if ((d18 = d20) < 0.0) {
                        d18 = -d18;
                    }
                    d17 = (d8 + d23) / 2.0 + d;
                    d16 = (d7 + d22) / 2.0 + d;
                    if (d19 <= d17 && d18 <= d16 && d4 > 0.0) {
                        double d34 = d4;
                        d32 = d34 * (d21 / d33);
                        springNode.m_xForce += d32;
                        springNode2.m_xForce -= d32;
                        d32 = d34 * (d20 / d33);
                        springNode.m_yForce += d32;
                        springNode2.m_yForce -= d32;
                        d32 = d34 * (d20 / d33);
                        springNode.m_xForce -= d32;
                        d32 = d34 * (d21 / d33);
                        springNode.m_yForce += d32;
                        continue;
                    }
                    if (!blArray[n2][n7 - n2]) continue;
                    d19 = d17 + d;
                    double d35 = Math.sqrt(d19 * d19 + d20 * d20);
                    d32 = d3 * (d33 - d35) * (d21 / d33);
                    springNode.m_xForce -= d32;
                    springNode2.m_xForce += d32;
                    d18 = d16 + d;
                    d35 = Math.sqrt(d18 * d18 + d21 * d21);
                    d32 = d3 * (d33 - d35) * (d20 / d33);
                    springNode.m_yForce -= d32;
                    springNode2.m_yForce += d32;
                }
                d10 += springNode.m_xForce;
                d9 += springNode.m_yForce;
                int n8 = springNode.m_clients;
                int n9 = springNode.m_suppliers;
                if (n8 != 0 && bl) {
                    n8 = 1;
                }
                if (n9 != 0 && bl2) {
                    n9 = 1;
                }
                if ((d31 = d5 * (double)n8) > (d30 = d6 * (double)n9)) {
                    d9 += d3 * (d2 + d7 / 2.0 + (1.0 - d31 / (d31 + d30)) - d9);
                } else if (d31 < d30) {
                    d9 += d3 * (1.0 - d2 - d7 / 2.0 - d31 / (d31 + d30) - d9);
                }
                springNode.m_x = d10;
                springNode.m_y = d9;
                d7 /= 2.0;
                d25 = d10 - (d8 /= 2.0);
                if (d25 < d26) {
                    d26 = d25;
                }
                if ((d25 = d10 + d8) > d27) {
                    d27 = d25;
                }
                if ((d24 = d9 - d7) < d28) {
                    d28 = d24;
                }
                if (!((d24 = d9 + d7) > d29)) continue;
                d29 = d24;
            }
            if (d27 - d26 <= 1.0 - 2.0 * d2) {
                d15 = 1.0;
                d14 = (1.0 - (d27 - d26)) / 2.0 - d26;
            } else {
                d15 = (1.0 - 2.0 * d2) / (d27 - d26);
                d14 = d2 - d15 * d26;
            }
            if (d29 - d28 <= 1.0 - 2.0 * d2) {
                d13 = 1.0;
                d12 = (1.0 - (d29 - d28)) / 2.0 - d28;
            } else {
                d13 = (1.0 - 2.0 * d2) / (d29 - d28);
                d12 = d2 - d13 * d28;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                springNode = springNodeArray[n2];
                springNode.m_x = d15 * springNode.m_x + d14;
                springNode.m_y = d13 * springNode.m_y + d12;
            }
            if (i > 1 && System.currentTimeMillis() > l2) {
                System.out.println(Util.toLocaleString() + ": Timeout after " + (n - i) + " iterations");
                i = 1;
            }
            block16: for (n2 = 0; i < 2 && n2 < n3; ++n2) {
                if (--n5 <= 0) {
                    System.out.println(Util.toLocaleString() + ": Can't avoid overlap");
                    continue block11;
                }
                springNode = springNodeArray[n2];
                entityInstance = springNode.m_e;
                d10 = springNode.m_x;
                d9 = springNode.m_y;
                d8 = entityInstance.widthRelLocal();
                d7 = entityInstance.heightRelLocal();
                for (n7 = n2 + 1; n7 < n3; ++n7) {
                    springNode2 = springNodeArray[n7];
                    entityInstance2 = springNode2.m_e;
                    d25 = springNode2.m_x;
                    d24 = springNode2.m_y;
                    d23 = entityInstance2.widthRelLocal();
                    d22 = entityInstance2.heightRelLocal();
                    d21 = d10 - d25;
                    d20 = d9 - d24;
                    d19 = d21;
                    if (d19 < 0.0) {
                        d19 = -d19;
                    }
                    if ((d18 = d20) < 0.0) {
                        d18 = -d18;
                    }
                    d17 = (d8 + d23) / 2.0 + d;
                    d16 = (d7 + d22) / 2.0 + d;
                    if (!(d19 <= d17) || !(d18 <= d16)) continue;
                    i = 2;
                    continue block16;
                }
            }
        }
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        SpringNode springNode;
        int n;
        double d = this.m_stiffness;
        double d2 = this.m_repulsion;
        double d3 = this.m_client_weight;
        double d4 = this.m_supplier_weight;
        double d5 = this.m_gap;
        double d6 = this.m_border;
        int n2 = this.m_iterations;
        long l = this.m_timeout;
        int n3 = vector.size();
        switch (n3) {
            case 0: {
                return;
            }
            case 1: {
                EntityInstance entityInstance3 = (EntityInstance)vector.firstElement();
                entityInstance3.updateRelLocal(0.25, 0.25, 0.5, 0.5);
                return;
            }
        }
        SpringNode[] springNodeArray = new SpringNode[n3];
        boolean[][] blArrayArray = new boolean[n3][];
        boolean bl = this.m_ls.isTopClients();
        for (n = 0; n < n3; ++n) {
            springNodeArray[n] = springNode = new SpringNode();
            blArrayArray[n] = new boolean[n3 - n];
            springNode.m_e = entityInstance2 = (EntityInstance)vector.elementAt(n);
            springNode.m_clients = 0;
            springNode.m_suppliers = 0;
            entityInstance2.orMark(0x4000000);
        }
        for (n = 0; n < n3; ++n) {
            int n4;
            EntityInstance entityInstance4;
            RelationClass relationClass;
            RelationInstance relationInstance;
            springNode = springNodeArray[n];
            entityInstance2 = springNode.m_e;
            Enumeration enumeration = entityInstance2.srcLiftedRelationElements();
            block6: while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                relationClass = relationInstance.getRelationClass();
                if (!relationClass.isClassVisible()) continue;
                entityInstance4 = relationInstance.getDrawDst();
                if (entityInstance4.isMarked(4)) {
                    ++springNode.m_suppliers;
                }
                if (!entityInstance4.isMarked(0x4000000)) continue;
                for (n4 = n + 1; n4 < n3; ++n4) {
                    if (entityInstance4 != springNodeArray[n4].m_e) continue;
                    blArrayArray[n][n4 - n] = true;
                    continue block6;
                }
            }
            enumeration = entityInstance2.dstLiftedRelationElements();
            block8: while (enumeration.hasMoreElements()) {
                relationInstance = (RelationInstance)enumeration.nextElement();
                relationClass = relationInstance.getRelationClass();
                if (!relationClass.isClassVisible()) continue;
                entityInstance4 = relationInstance.getDrawSrc();
                if (entityInstance4.isMarked(2) && !entityInstance4.isMarked(4)) {
                    ++springNode.m_clients;
                }
                if (!entityInstance4.isMarked(0x4000000)) continue;
                for (n4 = n + 1; n4 < n3; ++n4) {
                    if (entityInstance4 != springNodeArray[n4].m_e) continue;
                    blArrayArray[n][n4 - n] = true;
                    continue block8;
                }
            }
            if (!bl) {
                int n5 = springNode.m_clients;
                springNode.m_clients = springNode.m_suppliers;
                springNode.m_suppliers = n5;
            }
            entityInstance2.nandMark(0x4000000);
        }
        SpringLayout2.place(springNodeArray, blArrayArray, n2, d5, d6, d, d2, d3, d4, l);
        for (n = 0; n < n3; ++n) {
            springNode = springNodeArray[n];
            entityInstance2 = springNode.m_e;
            double d7 = entityInstance2.widthRelLocal();
            double d8 = entityInstance2.heightRelLocal();
            entityInstance2.updateRelLocal(springNode.m_x - d7 / 2.0, springNode.m_y - d8 / 2.0, d7, d8);
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        this.m_ls.setCursor(3);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Spring layout requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Spring layout");
        this.doLayout1(vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Spring Layout";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class SpringConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public SpringConfigure() {
            int n;
            super(SpringLayout2.this.getLs().getFrame(), "Spring Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JPanel jPanel4 = new JPanel();
            JPanel jPanel5 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel4.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            jPanel5.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                JPanel jPanel6;
                JPanel jPanel7;
                if (n % 2 == 0) {
                    jPanel7 = jPanel2;
                    jPanel6 = jPanel3;
                } else {
                    jPanel7 = jPanel4;
                    jPanel6 = jPanel5;
                }
                JLabel jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel7.add(jLabel);
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 20);
                jTextField.setFont(font);
                jTextField.addActionListener(this);
                jPanel6.add(jTextField);
            }
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BorderLayout());
            jPanel8.add("West", jPanel2);
            jPanel8.add("East", jPanel3);
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BorderLayout());
            jPanel9.add("West", jPanel4);
            jPanel9.add("East", jPanel5);
            jPanel.add("West", jPanel8);
            jPanel.add("East", jPanel9);
            Container container = this.getContentPane();
            container.add("North", jPanel);
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            container.add("Center", this.m_message);
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                String string = m_button_titles[n];
                if (string == null) {
                    string = SpringLayout2.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string);
                jButton.setFont(font2);
                String string2 = m_button_tips[n];
                if (string2 != null) {
                    jButton.setToolTipText(string2);
                }
                jButton.addActionListener(this);
                jPanel10.add(jButton);
            }
            container.add("South", jPanel10);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SpringLayout2.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    return;
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SpringLayout2.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore landscapeEditorCore = SpringLayout2.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(SpringLayout2.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SpringLayout2.this.m_ls.getFrame(), "Stiffness\n  The stiffness of edges connecting related nodes\n  A larger value increases the force between related nodes\nRepulsive force\n  The repulsive force between overlapping nodes\n  A larger value thrusts overlapping nodes further apart\n  0     => disable collision detection\nClient and Supplier weight\n  Specifies the significance of edges to clients/suppliers\n  0     => no significance\n  |1.0| => same significance as other edges\n  -ve   => consider all edges to clients/suppliers one edge\nIdeal gap\n  Fractional space between entities\nBorder\n  Fractional space to leave for border of diagram\nIterations\n  Number of times to iterate over the algorithm\nTimeout\n  Maximum number of seconds to spend iterating", "Help", 0);
                    return;
                }
            }
            block22: for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField = this.m_textfields[n];
                if (object != jTextField && n2 != 0) continue;
                String string = jTextField.getText();
                string = string.trim();
                String string2 = m_textfield_titles[n];
                switch (n) {
                    case 6: 
                    case 7: {
                        try {
                            int n3 = Integer.parseInt(string);
                            if (n3 > 0) continue block22;
                            this.m_message.setText(string2 + " must be positive");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not an integer value");
                            return;
                        }
                    }
                    default: {
                        try {
                            Double.parseDouble(string);
                            continue block22;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (n2) {
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SpringLayout2.this.setParameter(n, this.m_textfields[n].getText());
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

