/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.Graph;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SugiyamaLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int BORDER = 0;
    protected static final int XGAP = 1;
    protected static final int YGAP = 2;
    protected static final String[] m_textfield_tags = new String[]{"sugiyama:border[", "sugiyama:xgap[", "sugiyama:ygap["};
    protected static final String[] m_textfield_titles = new String[]{"Border fraction of total:", "Horizontal whitespace fraction of grid:", "Vertical whitespace fraction of grid:"};
    protected static final String[] m_textfield_resets = new String[]{"0.0333", "0.2", "0.2"};
    protected static String[] m_textfield_defaults = new String[]{"0.0333", "0.2", "0.2"};
    protected static String[] m_textfield_currents = new String[]{"0.0333", "0.2", "0.2"};
    protected double m_border = 0.0333;
    protected double m_xgap = 0.2;
    protected double m_ygap = 0.2;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_DEFAULT = 3;
    protected static final int BUTTON_SET = 4;
    protected static final int BUTTON_RESET = 5;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Use remembered default", "Set default to current", "Set default to initial"};

    protected void setParameter(int n, String string) {
        string = string.trim();
        try {
            double d = Double.parseDouble(string);
            switch (n) {
                case 0: {
                    this.m_border = d;
                    break;
                }
                case 1: {
                    this.m_xgap = d;
                    break;
                }
                case 2: {
                    this.m_ygap = d;
                }
            }
            SugiyamaLayout.m_textfield_currents[n] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getTag() {
        return "sugiyama:";
    }

    public void load(String string) {
        for (int i = 0; i < m_textfield_tags.length; ++i) {
            String string2 = m_textfield_tags[i];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n) {
                case 0: {
                    SugiyamaLayout.m_textfield_defaults[i] = string;
                }
                case 1: {
                    this.setParameter(i, string);
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        String[] stringArray2 = m_textfield_defaults;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < m_textfield_tags.length; ++j) {
                String string = stringArray2[j];
                if (string.equals(stringArray[j])) continue;
                String string2 = m_textfield_tags[j];
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            stringArray2 = m_textfield_currents;
        }
    }

    public SugiyamaLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Sugiyama";
    }

    public String getMenuLabel() {
        return "Layout using Sugiyama algorithm";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        SugiyamaConfigure sugiyamaConfigure = new SugiyamaConfigure();
        boolean bl = sugiyamaConfigure.ok();
        sugiyamaConfigure.dispose();
        return bl;
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
        double d;
        double d2;
        double d3;
        double d4;
        Enumeration enumeration;
        Vector vector2;
        int n;
        EntityInstance entityInstance2;
        double d5 = this.m_border;
        double d6 = this.m_xgap;
        double d7 = this.m_ygap;
        int n2 = 0;
        int n3 = vector.size();
        Diagram diagram = this.m_ls.getDiagram();
        int n4 = diagram.getWidth();
        int n5 = diagram.getHeight();
        Graph graph = new Graph(n3);
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration2.nextElement();
            graph.addVertex(entityInstance2.widthRelLocal());
            entityInstance2.orMark(0x400000);
        }
        enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration2.nextElement();
            Enumeration enumeration3 = entityInstance2.srcRelationElements();
            while (enumeration3.hasMoreElements()) {
                EntityInstance entityInstance3;
                RelationInstance relationInstance = (RelationInstance)enumeration3.nextElement();
                RelationClass relationClass = (RelationClass)relationInstance.getParentClass();
                if (relationClass != null && !relationClass.isClassVisible() || (entityInstance3 = relationInstance.getDst()) == entityInstance2 || !entityInstance3.isMarked(0x400000)) continue;
                for (n = 0; n < vector.size() && entityInstance3 != vector.elementAt(n); ++n) {
                }
                graph.addEdge(n2, n);
            }
            ++n2;
        }
        enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration2.nextElement();
            entityInstance2.nandMark(0x400000);
        }
        Vector vector3 = graph.doCoffmanGrahamSugiyama();
        int n6 = 0;
        enumeration2 = vector3.elements();
        while (enumeration2.hasMoreElements()) {
            vector2 = (Vector)enumeration2.nextElement();
            int n7 = vector2.size();
            if (n7 <= n6) continue;
            n6 = n7;
        }
        int n8 = (int)((1.0 - d5) * (double)n4);
        int n9 = (int)((1.0 - d5) * (double)n5);
        int n10 = n6 < 2 ? 0 : (int)(d6 * (double)n8 / (double)(n6 - 1));
        int n11 = vector3.size();
        int n12 = n11 < 2 ? 0 : (int)(d7 * (double)n9 / (double)(n11 - 1));
        int n13 = 0;
        int n14 = 0;
        enumeration2 = vector3.elements();
        while (enumeration2.hasMoreElements()) {
            vector2 = (Vector)enumeration2.nextElement();
            int n15 = 0;
            int n16 = 0;
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                int n17 = (Integer)enumeration.nextElement();
                if (n17 >= n3) continue;
                entityInstance2 = (EntityInstance)vector.elementAt(n17);
                d4 = entityInstance2.widthRelLocal();
                d3 = entityInstance2.heightRelLocal();
                n15 += n10 + (int)(d4 * (double)n4);
                int n18 = (int)(d3 * (double)n5);
                if (n18 <= n16) continue;
                n16 = n18;
            }
            if ((n15 -= n10) > n13) {
                n13 = n15;
            }
            n14 += n12 + n16;
        }
        n14 -= n12;
        double d8 = (double)n8 / (double)n13;
        if (d8 > 1.0) {
            d8 = 1.0;
        }
        if ((d2 = (double)n9 / (double)n14) > 1.0) {
            d2 = 1.0;
            d = ((double)n5 - (double)n14) / (2.0 * (double)n5);
        } else {
            d = d5 / 2.0;
        }
        d6 = d8 * (double)n10 / (double)n4;
        d7 = d2 * (double)n12 / (double)n5;
        n = vector3.size();
        while (n > 0) {
            int n19;
            vector2 = (Vector)vector3.elementAt(--n);
            double d9 = 0.0;
            double d10 = 0.0;
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                n19 = (Integer)enumeration.nextElement();
                if (n19 >= n3) continue;
                entityInstance2 = (EntityInstance)vector.elementAt(n19);
                d9 += entityInstance2.widthRelLocal() * d8 + d6;
            }
            d9 -= d6;
            if ((d9 = (1.0 - d9) / 2.0) < 0.0) {
                d9 = 0.0;
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                n19 = (Integer)enumeration.nextElement();
                if (n19 >= n3) continue;
                entityInstance2 = (EntityInstance)vector.elementAt(n19);
                d4 = entityInstance2.widthRelLocal() * d8;
                d3 = entityInstance2.heightRelLocal() * d2;
                entityInstance2.updateRelLocal(d9, d, d4, d3);
                d9 += d4 + d6;
                if (!(d3 > d10)) continue;
                d10 = d3;
            }
            d += d10 + d7;
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Sugiyama requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Sugiyama layout");
        this.doLayout1(vector, entityInstance);
        diagram.endUndoRedo();
        return "Graph redrawn with Coffman-Graham-Sugiyama method";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class SugiyamaConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected LayoutImage m_layoutImage;
        protected JLabel m_message;
        protected JButton[] m_buttons;
        protected boolean m_ret;

        public SugiyamaConfigure() {
            int n;
            super(SugiyamaLayout.this.getLs().getFrame(), "Sugiyama Whitespace", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(3, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(3, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                JLabel jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 20);
                jTextField.addActionListener(this);
                jTextField.setFont(font);
                jPanel3.add(jTextField);
            }
            jPanel.add("West", jPanel2);
            jPanel.add("East", jPanel3);
            Container container = this.getContentPane();
            container.add("North", jPanel);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            this.m_layoutImage = new LayoutImage();
            jPanel4.add("North", this.m_layoutImage);
            this.m_layoutImage.validate();
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            jPanel4.add("South", this.m_message);
            container.add("Center", jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                this.m_buttons[n] = jButton = new JButton(m_button_titles[n]);
                jButton.setFont(font2);
                String string = m_button_tips[n];
                if (string != null) {
                    jButton.setToolTipText(string);
                }
                jButton.addActionListener(this);
                jPanel5.add(jButton);
            }
            container.add("South", jPanel5);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SugiyamaLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                }
                case 3: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    break;
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SugiyamaLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    break;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SugiyamaLayout.this.m_ls.getFrame(), "Border\n  Fraction of diagram to reserve for border\n  Must be a value between 0 and 1\nGap\n  Fraction of diagram to reserve for whitespace", "Help", 0);
                    return;
                }
                default: {
                    block19: for (n = 0; n < m_textfield_tags.length; ++n) {
                        JTextField jTextField = this.m_textfields[n];
                        if (object != jTextField && n2 != 0) continue;
                        String string = jTextField.getText();
                        string = string.trim();
                        String string2 = m_textfield_titles[n];
                        switch (n) {
                            case 0: 
                            case 1: 
                            case 2: {
                                try {
                                    double d = Double.parseDouble(string);
                                    if (d < 0.0) {
                                        this.m_message.setText(string2 + " may not be negative");
                                        return;
                                    }
                                    if (!(d >= 1.0)) continue block19;
                                    this.m_message.setText(string2 + " must be less than 1.0");
                                    return;
                                }
                                catch (Throwable throwable) {
                                    this.m_message.setText(string2 + " not a double precision value");
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            switch (n2) {
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        SugiyamaLayout.this.setParameter(n, this.m_textfields[n].getText());
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    this.m_layoutImage.validate();
                    this.m_layoutImage.repaint();
                    return;
                }
            }
            this.setVisible(false);
        }

        class LayoutImage
        extends JComponent
        implements MouseListener {
            Rectangle[] m_boxs;
            int m_rows = 2;
            boolean m_validated;

            public LayoutImage() {
                Dimension dimension = new Dimension(400, 240);
                this.setLayout(null);
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.setMaximumSize(dimension);
                this.setSize(dimension);
                this.m_boxs = new Rectangle[25];
                this.m_validated = false;
                this.addMouseListener(this);
                this.setVisible(true);
            }

            public void validate() {
                Rectangle[] rectangleArray = this.m_boxs;
                int n = rectangleArray.length;
                int n2 = this.m_rows;
                int n3 = this.getWidth();
                int n4 = this.getHeight();
                double d = SugiyamaLayout.this.m_border;
                double d2 = SugiyamaLayout.this.m_xgap;
                double d3 = SugiyamaLayout.this.m_ygap;
                int n5 = (int)((double)n3 * d / 2.0);
                int n6 = (int)((double)n4 * d / 2.0);
                int n7 = n3 - 2 * n5;
                int n8 = n4 - 2 * n6;
                this.m_validated = false;
                if (n7 < 1 || n8 < 1) {
                    return;
                }
                int n9 = n2 - 1;
                double d4 = n9;
                int n10 = (int)(d2 * (double)n7 / d4);
                int n11 = (int)(d3 * (double)n8 / d4);
                int n12 = (n7 - n10 * n9) / n2;
                int n13 = (n8 - n11 * n9) / n2;
                if (n12 < 1 || n13 < 1) {
                    return;
                }
                int n14 = 0;
                int n15 = 0;
                n = n2 * n2;
                for (int i = 0; i < n; ++i) {
                    Rectangle rectangle = rectangleArray[i];
                    if (rectangle == null) {
                        rectangleArray[i] = rectangle = new Rectangle();
                    }
                    rectangle.x = n5;
                    if (n14 != 0) {
                        rectangle.x += n14 * (n12 + n10);
                    }
                    rectangle.y = n6;
                    if (n15 != 0) {
                        rectangle.y += n15 * (n13 + n11);
                    }
                    rectangle.width = n12;
                    rectangle.height = n13;
                    if (++n14 != n2) continue;
                    ++n15;
                    n14 = 0;
                }
                this.m_validated = true;
            }

            public void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
                if (this.m_validated) {
                    Rectangle[] rectangleArray = this.m_boxs;
                    graphics.setColor(Color.blue);
                    int n3 = this.m_rows;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = n3 * n3;
                    for (int i = 0; i < n6; ++i) {
                        if (n5 >= n4) {
                            Rectangle rectangle = rectangleArray[i];
                            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (++n4 != n3) continue;
                        ++n5;
                        n4 = 0;
                    }
                    if (n3 == 2) {
                        String string = "Click to change dimensions";
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        int n7 = fontMetrics.stringWidth(string);
                        graphics.setColor(Color.black);
                        graphics.drawString(string, (n - n7) / 2, n2 / 2);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isMetaDown()) {
                    --this.m_rows;
                    if (this.m_rows < 2) {
                        this.m_rows = 5;
                    }
                } else {
                    ++this.m_rows;
                    if (this.m_rows > 5) {
                        this.m_rows = 2;
                    }
                }
                this.validate();
                this.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        }
    }
}

