/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JPanel;
import lsedit.Diagram;
import lsedit.EntityCache;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeTokenStream;
import lsedit.MsgOut;
import lsedit.NoFeedback;
import lsedit.OrderedHashTableEnumeration;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.StringCache;
import lsedit.TaFeedback;
import lsedit.Util;
import lsedit.Version;

public class Ta
extends JPanel
implements TaFeedback {
    public static final String INSTANCE_ID = "$INSTANCE";
    public static final String INHERIT_RELN = "$INHERIT";
    public static final String CONTAIN_ID = "contain";
    public static final String ROOT_ID = "$ROOT";
    public static final int UPDATE_FREQ = 250;
    protected TaFeedback m_taFeedback;
    protected static TaFeedback m_noFeedback = null;
    private Diagram m_diagram;
    protected EntityCache m_entityCache;
    protected RelationClass m_defaultContainsClass;
    protected EntityInstance m_rootInstance;
    protected RelationClass m_containsClass;
    protected int m_cIndex;
    protected boolean m_undoEnabled = false;
    protected Hashtable m_entityClasses = new Hashtable(10);
    protected Hashtable m_relationClasses = new Hashtable(5);
    private Vector m_numToRel = new Vector(10);
    public RelationClass m_relationBaseClass;
    public EntityClass m_entityBaseClass;
    protected RelationClass m_defaultRelationClass = null;
    protected int m_numRelationClasses = 0;
    protected EntityClass m_defaultEntityClass = null;
    private int m_numEntityClasses = 0;
    private boolean m_universalScheme = false;
    private Object m_context;
    private String m_zipEntry;
    boolean m_uses_local_coordinates;
    private boolean m_schemeSetup = false;
    protected String m_resString = null;
    protected int m_progressCount;
    protected boolean m_changedFlag = false;
    protected int m_numberRelations;

    protected Diagram getDiagram() {
        return null;
    }

    public boolean getChangedFlag() {
        return this.m_changedFlag;
    }

    public boolean undoEnabled() {
        return this.m_undoEnabled;
    }

    public void updateProgressCnt() {
        this.m_taFeedback.updateProgress(++this.m_progressCount);
    }

    public Vector getClassAndSubclasses(EntityClass entityClass) {
        return entityClass.getClassAndSubclasses(this.m_entityClasses);
    }

    public EntityClass getEntityClass(String string) {
        return (EntityClass)this.m_entityClasses.get(string);
    }

    protected EntityClass addEntityClass(String string) {
        EntityClass entityClass = this.getEntityClass(string);
        if (entityClass == null) {
            entityClass = new EntityClass(string, this.m_numEntityClasses++, this);
            this.m_entityClasses.put(string, entityClass);
            if (this.m_defaultEntityClass == null) {
                this.setDefaultEntityClass(entityClass);
            }
        }
        return entityClass;
    }

    public EntityInstance getRootInstance() {
        return this.m_rootInstance;
    }

    public Vector getClassAndSubclasses(RelationClass relationClass) {
        return relationClass.getClassAndSubclasses(this.m_relationClasses);
    }

    public RelationClass getRelationClass(String string) {
        return (RelationClass)this.m_relationClasses.get(string);
    }

    public void setDefaultRelationClass(RelationClass relationClass) {
        this.m_defaultRelationClass = relationClass;
    }

    protected RelationClass addRelationClass(String string) {
        RelationClass relationClass = this.getRelationClass(string);
        if (relationClass == null) {
            relationClass = new RelationClass(string, this.m_numRelationClasses, this);
            this.m_relationClasses.put(string, relationClass);
            this.m_numToRel.addElement(relationClass);
            ++this.m_numRelationClasses;
            if (this.m_defaultRelationClass == null) {
                this.setDefaultRelationClass(relationClass);
            }
        }
        return relationClass;
    }

    public void addEdge(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass) {
        RelationInstance relationInstance = relationClass.newRelation(entityInstance, entityInstance2);
        entityInstance.addSrcRelation(relationInstance);
        entityInstance2.addDstRelation(relationInstance);
    }

    protected int getMaxCIndex() {
        int n = -1;
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            int n2 = relationClass.getCIndex();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected int getCIndex(RelationClass relationClass) {
        int n = relationClass.getCIndex();
        if (n < 0) {
            n = this.getMaxCIndex();
            relationClass.setCIndex(++n);
        }
        return n;
    }

    public boolean isUniversalScheme() {
        return this.m_universalScheme;
    }

    private void setupUniversalScheme() {
        this.m_relationBaseClass.addRelation(this.m_entityBaseClass, this.m_entityBaseClass);
        this.m_universalScheme = true;
    }

    private void processSchemeTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        RelationClass relationClass;
        EntityClass entityClass;
        while (landscapeTokenStream.nextSchemaTriple()) {
            EntityClass entityClass2;
            String string = landscapeTokenStream.m_verb;
            String string2 = landscapeTokenStream.m_object;
            if (string.equals(INHERIT_RELN)) {
                switch (landscapeTokenStream.m_relations) {
                    case 0: {
                        if (string2.equals("$ENTITY")) {
                            landscapeTokenStream.errorNS("Improper use of $ENTITY with $INHERIT");
                            break;
                        }
                        entityClass = this.addEntityClass(string2);
                        String string3 = entityClass.addParentClass(entityClass2 = this.addEntityClass(landscapeTokenStream.m_subject));
                        if (string3 == null) break;
                        landscapeTokenStream.errorNS(string3);
                        break;
                    }
                    case 1: 
                    case 2: {
                        landscapeTokenStream.errorNS("Mismatched entity/relation with $INHERIT -- presuming both relations");
                    }
                    case 3: {
                        RelationClass relationClass2;
                        if (string2.equals("$RELATION")) {
                            landscapeTokenStream.errorNS("Improper use of $RELATION with $INHERIT");
                            break;
                        }
                        relationClass = this.addRelationClass(string2);
                        String string3 = relationClass.addParentClass(relationClass2 = this.addRelationClass(landscapeTokenStream.m_subject));
                        if (string3 == null) break;
                        landscapeTokenStream.errorNS(string3);
                    }
                }
                continue;
            }
            if (landscapeTokenStream.m_relations != 0) {
                landscapeTokenStream.errorNS("Cannot create relationships between relationships");
                continue;
            }
            entityClass = this.addEntityClass(string2);
            entityClass2 = this.addEntityClass(landscapeTokenStream.m_subject);
            relationClass = this.addRelationClass(string);
            relationClass.addRelation(entityClass, entityClass2);
        }
        Enumeration enumeration = this.m_entityClasses.elements();
        while (enumeration.hasMoreElements()) {
            entityClass = (EntityClass)enumeration.nextElement();
            if (entityClass == this.m_entityBaseClass || entityClass.getParentCnt() != 0) continue;
            entityClass.addParentClass(this.m_entityBaseClass);
        }
        enumeration = this.m_relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass == this.m_relationBaseClass || relationClass.getParentCnt() != 0) continue;
            relationClass.addParentClass(this.m_relationBaseClass);
        }
    }

    private void processFactTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        int n = 0;
        int n2 = 0;
        MsgOut.vprint("\nFACT TUPLE : ");
        while (landscapeTokenStream.nextFactTriple()) {
            LandscapeClassObject landscapeClassObject;
            String string = landscapeTokenStream.m_verb;
            String string2 = landscapeTokenStream.m_object;
            String string3 = landscapeTokenStream.m_subject;
            if (string.equals(INSTANCE_ID)) {
                EntityInstance entityInstance;
                if (++n % 250 == 0) {
                    MsgOut.vprint(".");
                    this.updateProgressCnt();
                    this.m_taFeedback.showProgress("Entities: " + n);
                }
                if ((entityInstance = this.getCache(string2)) == null) {
                    landscapeClassObject = this.getEntityClass(string3);
                    if (landscapeClassObject == null && this.isUniversalScheme()) {
                        landscapeClassObject = this.m_entityBaseClass;
                    }
                    if (landscapeClassObject != null) {
                        entityInstance = ((EntityClass)landscapeClassObject).newEntity(string2);
                        this.putCache(entityInstance);
                        continue;
                    }
                    landscapeTokenStream.errorNS("EntityClass '" + string3 + "' has not been declared");
                    continue;
                }
                landscapeClassObject = entityInstance.getEntityClass();
                if (landscapeClassObject.hasId(string3)) {
                    landscapeTokenStream.warning("Redeclaration of " + entityInstance.toString());
                    continue;
                }
                landscapeTokenStream.errorNS("Attempt to declare " + entityInstance.getId() + " as instanceof " + string3 + ". Currently declared as instanceof " + landscapeClassObject.getId());
                continue;
            }
            if (++n2 % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgressCnt();
                this.m_taFeedback.showProgress("Relations: " + n2);
            }
            landscapeClassObject = this.getRelationClass(string);
            EntityInstance entityInstance = this.getCache(string2);
            EntityInstance entityInstance2 = this.getCache(string3);
            if (this.m_universalScheme) {
                if (landscapeClassObject == null) {
                    landscapeClassObject = this.m_relationBaseClass;
                }
                if (entityInstance == null) {
                    entityInstance = this.m_entityBaseClass.newEntity(string2);
                    this.putCache(entityInstance);
                }
                if (entityInstance2 == null) {
                    entityInstance2 = this.m_entityBaseClass.newEntity(string3);
                    this.putCache(entityInstance2);
                }
            }
            if (landscapeClassObject == null) {
                landscapeTokenStream.errorNS("Can't process: (" + string + " " + string2 + " " + string3 + ") - Missing '" + string + "'");
                continue;
            }
            if (entityInstance == null) {
                landscapeTokenStream.errorNS("Can't process: (" + string + " " + string2 + " " + string3 + ") - Missing '" + string2 + "'");
                continue;
            }
            if (entityInstance2 == null) {
                landscapeTokenStream.errorNS("Can't process: (" + string + " " + string2 + " " + string3 + ") - Missing '" + string3 + "'");
                continue;
            }
            this.addEdge(entityInstance, entityInstance2, (RelationClass)landscapeClassObject);
        }
        this.m_numberRelations = n2;
    }

    public void writeSchemeTuples(PrintStream printStream) throws IOException {
        RelationClass relationClass;
        Enumeration enumeration;
        printStream.print("SCHEME TUPLE :\n\n// The ERD\n\n");
        Enumeration enumeration2 = this.enumEntityClassesInOrder();
        while (enumeration2.hasMoreElements()) {
            EntityClass entityClass = (EntityClass)enumeration2.nextElement();
            if (entityClass == this.m_entityBaseClass) continue;
            enumeration = entityClass.getParentElements();
            while (enumeration.hasMoreElements()) {
                EntityClass entityClass2 = (EntityClass)enumeration.nextElement();
                if (entityClass2 == this.m_entityBaseClass) continue;
                printStream.print("$INHERIT " + entityClass.getId() + " " + entityClass2.getId() + "\n");
            }
        }
        enumeration2 = this.enumRelationClassesInOrder();
        while (enumeration2.hasMoreElements()) {
            relationClass = (RelationClass)enumeration2.nextElement();
            if (relationClass == this.m_relationBaseClass) continue;
            enumeration = relationClass.getParentElements();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass2 = (RelationClass)enumeration.nextElement();
                if (relationClass2 == this.m_relationBaseClass) continue;
                printStream.print("$INHERIT (" + relationClass.getId() + ") (" + relationClass2.getId() + ")\n");
            }
        }
        printStream.print("\n");
        enumeration2 = this.enumRelationClassesInOrder();
        while (enumeration2.hasMoreElements()) {
            relationClass = (RelationClass)enumeration2.nextElement();
            relationClass.writeRelations(printStream);
        }
    }

    public void writeSchemeAttributes(PrintStream printStream) throws IOException {
        LandscapeClassObject landscapeClassObject;
        printStream.print("\n\nSCHEME ATTRIBUTE :\n\n");
        printStream.print("// EntityClass attributes\n\n");
        Enumeration enumeration = this.m_entityClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            ((EntityClass)landscapeClassObject).writeAttributes(printStream);
        }
        enumeration = this.m_relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            ((RelationClass)landscapeClassObject).writeAttributes(printStream);
        }
    }

    private void writeFactAttributes(PrintStream printStream) throws IOException {
        printStream.print("\n\nFACT ATTRIBUTE :\n\n");
        this.m_rootInstance.writeOptionsAttributes(printStream);
        Enumeration enumeration = this.m_rootInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeAttributes(printStream, this.m_cIndex);
        }
    }

    private void writeFactTuples(PrintStream printStream) throws IOException {
        EntityInstance entityInstance;
        printStream.print("\n\nFACT TUPLE :\n\n");
        printStream.print("// Instances of entity classes\n\n");
        Enumeration enumeration = this.m_rootInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeInstances(printStream);
        }
        enumeration = this.m_rootInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.writeRelations(printStream);
        }
    }

    public int getCIndex() {
        return this.m_cIndex;
    }

    public RelationClass getContainsClass() {
        return this.m_containsClass;
    }

    public String getContainsId() {
        return this.m_containsClass.getLabel();
    }

    protected RelationInstance getNewRelation(RelationClass relationClass, EntityInstance entityInstance, EntityInstance entityInstance2) {
        if (relationClass == null && (relationClass = this.m_defaultRelationClass) == null) {
            relationClass = this.m_relationBaseClass;
        }
        RelationInstance relationInstance = new RelationInstance(relationClass, entityInstance, entityInstance2);
        entityInstance.addSrcRelation(relationInstance);
        entityInstance2.addDstRelation(relationInstance);
        return relationInstance;
    }

    public boolean entityExists(String string) {
        return this.getCache(string) != null;
    }

    private void computeRelCoordinates() {
        this.m_rootInstance.computeRelCoordinates(this.m_rootInstance.xRelLocal(), this.m_rootInstance.yRelLocal(), this.m_rootInstance.widthRelLocal(), this.m_rootInstance.heightRelLocal());
    }

    public void setDefaultEntityClass(EntityClass entityClass) {
        this.m_defaultEntityClass = entityClass;
    }

    public void noDiagram() {
        this.m_uses_local_coordinates = false;
        this.m_schemeSetup = true;
        this.setupUniversalScheme();
        this.setDefaultEntityClass(this.m_entityBaseClass);
        this.setDefaultRelationClass(this.m_relationBaseClass);
        this.setContainsClass(this.m_defaultContainsClass);
        this.m_rootInstance = null;
    }

    public void emptyDiagram() {
        this.m_uses_local_coordinates = false;
        this.m_schemeSetup = true;
        this.setupUniversalScheme();
        this.setDefaultEntityClass(this.m_entityBaseClass);
        this.setDefaultRelationClass(this.m_relationBaseClass);
        EntityInstance entityInstance = this.m_entityBaseClass.newEntity(ROOT_ID);
        this.putCache(entityInstance);
        this.m_rootInstance = entityInstance;
        this.switchContainsClass(this.m_defaultContainsClass, null);
    }

    private void parseStream(InputStream inputStream, String string, URL uRL) {
        MsgOut.vprintln("Parse TA file: " + string);
        this.m_uses_local_coordinates = false;
        this.m_cIndex = 0;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            LandscapeTokenStream landscapeTokenStream = new LandscapeTokenStream(bufferedInputStream, string, this.m_entityCache);
            while (true) {
                int n;
                if ((n = landscapeTokenStream.nextSection()) == 99) {
                    MsgOut.vprintln("");
                    break;
                }
                try {
                    switch (n) {
                        case 0: {
                            this.m_schemeSetup = true;
                            this.m_universalScheme = false;
                            this.processSchemeTuples(landscapeTokenStream);
                            this.updateProgressCnt();
                            break;
                        }
                        case 1: {
                            if (!this.m_schemeSetup) {
                                this.m_schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            landscapeTokenStream.processSchemeAttributes(this);
                            this.updateProgressCnt();
                            break;
                        }
                        case 2: {
                            if (!this.m_schemeSetup) {
                                this.m_schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processFactTuples(landscapeTokenStream);
                            break;
                        }
                        case 3: {
                            landscapeTokenStream.processFactAttributes(this);
                            break;
                        }
                        case 4: {
                            if (this.m_context == null ? !this.parseFile(landscapeTokenStream.getIncludeFile(), null, false) : !this.parseURL(landscapeTokenStream.getIncludeFile(), uRL, false)) {
                                return;
                            }
                            MsgOut.vprintln("Back to TA file: " + string);
                        }
                    }
                }
                catch (IOException iOException) {
                    MsgOut.println("IO error reading landscape");
                    this.m_resString = iOException.toString();
                    break;
                }
            }
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            System.out.println("Parse error: " + this.m_resString);
        }
    }

    private InputStream decompress(InputStream inputStream, String string, String string2) {
        InputStream inputStream2 = inputStream;
        int n = string.length();
        if (n > 4) {
            String string3 = string.substring(n - 4);
            if (string3.equalsIgnoreCase(".zip")) {
                ZipInputStream zipInputStream;
                try {
                    zipInputStream = new ZipInputStream(inputStream);
                    while (true) {
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (string2 != null && !string2.equalsIgnoreCase(zipEntry.getName())) {
                            zipInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + (string2 == null ? "" : "#" + string2) + " as zip file failed");
                    this.m_resString = exception.toString();
                    zipInputStream = null;
                }
                return zipInputStream;
            }
            if (string3.equalsIgnoreCase(".jar")) {
                JarInputStream jarInputStream;
                try {
                    jarInputStream = new JarInputStream(inputStream);
                    while (true) {
                        ZipEntry zipEntry = jarInputStream.getNextEntry();
                        if (string2 != null && !string2.equalsIgnoreCase(zipEntry.getName())) {
                            jarInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + (string2 == null ? "" : "#" + string2) + " as jar file failed");
                    this.m_resString = exception.toString();
                    jarInputStream = null;
                }
                return jarInputStream;
            }
            if (n > 5 && (string3 = string.substring(n - 5)).equalsIgnoreCase(".gzip")) {
                GZIPInputStream gZIPInputStream;
                try {
                    gZIPInputStream = new GZIPInputStream(inputStream);
                }
                catch (Exception exception) {
                    System.out.println("Attempt to open " + string + " as gzip file failed");
                    this.m_resString = exception.toString();
                    gZIPInputStream = null;
                }
                return gZIPInputStream;
            }
        }
        return inputStream;
    }

    private boolean parseURL(String string, URL uRL, boolean bl) {
        URL uRL2;
        int n;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        String string2 = null;
        if (n2 > 2 && c == ']' && (n = string.lastIndexOf(91)) > 0 && n < n2 - 2) {
            string2 = string.substring(n + 1, n2 - 1);
            string = string.substring(0, n);
            if (this.m_zipEntry == null) {
                this.m_zipEntry = string2;
            }
            n2 = n;
            c = string.charAt(n2 - 1);
        }
        if (c == File.separatorChar) {
            string = string.substring(0, n2 - 1);
        }
        this.m_progressCount = 0;
        this.updateProgressCnt();
        try {
            uRL2 = uRL == null ? new URL(string) : new URL(uRL, string);
            MsgOut.dprintln("Opening URL: " + string);
            InputStream inputStream = uRL2.openStream();
            inputStream = this.decompress(inputStream, string, string2);
            if (inputStream == null) {
                return false;
            }
            MsgOut.dprintln("opened");
            this.parseStream(inputStream, string, uRL2);
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            return false;
        }
        if (bl) {
            this.setContext(uRL2);
        }
        return true;
    }

    public boolean parseFile(String string, Object object, boolean bl) {
        String string2 = null;
        int n = string.length();
        File file = null;
        if (n > 0) {
            int n2;
            char c = string.charAt(n - 1);
            if (n > 2 && c == ']' && (n2 = string.lastIndexOf(91)) > 0 && n2 < n - 2) {
                string2 = string.substring(n2 + 1, n - 1);
                if (this.m_zipEntry == null) {
                    this.m_zipEntry = string2;
                }
                string = string.substring(0, n2);
                n = n2;
                c = string.charAt(n - 1);
            }
            if (c == File.separatorChar) {
                string = string.substring(0, n - 1);
            }
        }
        this.m_progressCount = 0;
        this.updateProgressCnt();
        try {
            InputStream inputStream = null;
            if (n == 0) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                }
            } else {
                if (object instanceof File) {
                    String string3 = this.getDir((File)object);
                    file = new File(string3, string);
                } else {
                    file = new File(string);
                }
                if (file != null) {
                    inputStream = new FileInputStream(file);
                    inputStream = this.decompress(inputStream, string, string2);
                }
            }
            if (inputStream == null) {
                this.m_resString = "No input stream specified";
                return false;
            }
            this.parseStream(inputStream, string, null);
            inputStream.close();
        }
        catch (Exception exception) {
            this.m_resString = exception.toString();
            return false;
        }
        if (bl && file != null) {
            this.setContext(file);
        }
        return true;
    }

    protected void createRootInstance() {
        this.m_rootInstance = new EntityInstance(this.m_entityBaseClass, ROOT_ID);
        this.m_rootInstance.setRelLocal(0.0, 0.0, 1.0, 1.0);
    }

    public Ta(TaFeedback taFeedback) {
        if (taFeedback == null) {
            if (m_noFeedback == null) {
                m_noFeedback = new NoFeedback();
            }
            taFeedback = m_noFeedback;
        }
        this.m_taFeedback = taFeedback;
        this.m_entityCache = new EntityCache();
        this.m_diagram = this.getDiagram();
        this.m_rootInstance = null;
        this.m_entityBaseClass = new EntityClass("$ENTITY", this.m_numEntityClasses++, this);
        this.m_entityBaseClass.setStyle(0);
        this.m_entityBaseClass.setObjectColor(Color.blue);
        this.m_entityBaseClass.setLabelColor(Color.cyan);
        this.m_entityClasses.put("$ENTITY", this.m_entityBaseClass);
        this.m_relationBaseClass = new RelationClass("$RELATION", this.m_numRelationClasses++, this);
        this.m_relationBaseClass.setIOfactor(0.5);
        this.m_relationBaseClass.setStyle(0);
        this.m_relationBaseClass.setObjectColor(Color.black);
        this.m_relationClasses.put("$RELATION", this.m_relationBaseClass);
        this.m_numToRel.addElement(this.m_relationBaseClass);
        RelationClass relationClass = new RelationClass(CONTAIN_ID, this.m_numRelationClasses++, this);
        relationClass.setCIndex(0);
        this.m_defaultContainsClass = relationClass;
        this.m_relationClasses.put(CONTAIN_ID, relationClass);
        this.m_numToRel.addElement(relationClass);
    }

    public EntityInstance getCache(String string) {
        return this.m_entityCache.get(string);
    }

    public void removeCache(EntityInstance entityInstance) {
        this.m_entityCache.remove(entityInstance);
    }

    public void putCache(EntityInstance entityInstance) {
        this.m_entityCache.put(entityInstance);
    }

    public Enumeration enumRelationClasses() {
        return this.m_relationClasses.elements();
    }

    public Enumeration enumRelationClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_relationClasses);
    }

    public int numRelationClasses() {
        return this.m_numRelationClasses;
    }

    public Enumeration enumEntityClasses() {
        return this.m_entityClasses.elements();
    }

    public Enumeration enumEntityClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_entityClasses);
    }

    public int numEntityClasses() {
        return this.m_entityClasses.size();
    }

    public Object getContext() {
        return this.m_context;
    }

    public void setContext(Object object) {
        this.m_context = object;
    }

    public String getContextName() {
        String string = this.m_context instanceof File ? Util.nameFromPath(((File)this.m_context).getPath()) : (this.m_rootInstance == null ? null : this.m_rootInstance.getEntityLabel());
        if (this.m_zipEntry != null) {
            string = string + "[" + this.m_zipEntry + "]";
        }
        return string;
    }

    public String getDir(File file) {
        if (file.isAbsolute()) {
            return file.getParent();
        }
        return new File(file.getAbsolutePath()).getParent();
    }

    public String getDir() {
        return this.getDir((File)this.m_context);
    }

    public String getAbsolutePath() {
        if (this.m_context != null && this.m_context instanceof File) {
            return ((File)this.m_context).getAbsolutePath();
        }
        return null;
    }

    public RelationClass numToRelationClass(int n) {
        return (RelationClass)this.m_numToRel.elementAt(n);
    }

    public void saveDiagram(OutputStream outputStream, boolean bl) throws IOException {
        if (this.m_rootInstance != null) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            printStream.print("// Landscape TA file written by LSEdit " + Version.Number() + "\n\n");
            this.writeSchemeTuples(printStream);
            this.writeSchemeAttributes(printStream);
            this.writeFactTuples(printStream);
            this.writeFactAttributes(printStream);
            if (bl) {
                printStream.print("END\n");
            }
            printStream.flush();
            printStream.close();
            this.m_changedFlag = false;
        }
    }

    public void prepostorder() {
        this.m_rootInstance.prepostorder(1);
    }

    public void setContainsClass(RelationClass relationClass) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass2;
            relationClass2.setContainsClass((relationClass2 = (RelationClass)enumeration.nextElement()) == relationClass);
        }
        this.m_containsClass = relationClass;
    }

    public Vector getForest() {
        RelationClass relationClass = this.m_containsClass;
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        Enumeration enumeration = this.m_rootInstance.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            RelationClass relationClass2 = relationInstance.getRelationClass();
            if (relationClass2 != relationClass) continue;
            vector.addElement(relationInstance.getDst());
        }
        return vector;
    }

    protected Vector establishForest(RelationClass relationClass) {
        boolean bl;
        RelationClass relationClass2 = this.m_containsClass;
        String string = relationClass.getLabel();
        this.removeCache(this.m_rootInstance);
        EntityInstance entityInstance = null;
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        int n = this.m_entityCache.size();
        EntityInstance entityInstance2 = this.m_entityCache.someEntity();
        if (entityInstance2 == null) {
            bl = true;
        } else {
            bl = false;
            while (entityInstance2 != null) {
                int n2 = 0;
                while (true) {
                    if (n2 > n) {
                        this.m_taFeedback.showCycle(relationClass, entityInstance2, n);
                        entityInstance2 = null;
                        break;
                    }
                    EntityInstance entityInstance3 = entityInstance2.getContainedBy(relationClass);
                    if (entityInstance3 == null || entityInstance3 == this.m_rootInstance) break;
                    entityInstance2 = entityInstance3;
                    ++n2;
                }
                if (entityInstance2 == null || (n2 = entityInstance2.cntNodesInSubtree(relationClass)) < 0) break;
                vector.addElement(entityInstance2);
                if ((n -= n2) == 0) {
                    bl = true;
                    break;
                }
                entityInstance = this.m_entityCache.getFirst();
                while (entityInstance != null && entityInstance.isMarked(0x100000)) {
                    entityInstance = this.m_entityCache.getNext();
                }
                entityInstance2 = entityInstance;
            }
        }
        this.putCache(this.m_rootInstance);
        this.m_rootInstance.clearTreeMark();
        if (!bl) {
            vector = null;
        }
        return vector;
    }

    public String loadTA(String string, Object object) {
        this.m_containsClass = null;
        this.m_resString = null;
        this.m_zipEntry = null;
        if (string == null) {
            this.noDiagram();
        } else {
            int n = string.length();
            if (n == 0 && object == null) {
                this.emptyDiagram();
            } else {
                boolean bl;
                this.createRootInstance();
                if (object instanceof URL || Util.isHTTP(string)) {
                    MsgOut.dprintln("Parse a URL");
                    bl = this.parseURL(string, (URL)object, true);
                } else {
                    MsgOut.dprintln("Parse a file");
                    bl = this.parseFile(string, object, true);
                }
                if (!bl) {
                    if (this.m_resString == null) {
                        this.m_resString = "Unknown error parsing " + object;
                    }
                    this.m_rootInstance = null;
                    return this.m_resString;
                }
                this.putCache(this.m_rootInstance);
            }
        }
        if (this.m_defaultEntityClass == null) {
            this.setDefaultEntityClass(this.m_entityBaseClass);
        }
        if (this.m_defaultRelationClass == null) {
            this.setDefaultRelationClass(this.m_relationBaseClass);
        }
        StringCache.clear();
        RelationClass relationClass = null;
        Enumeration enumeration = this.m_relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass2 = (RelationClass)enumeration.nextElement();
            if (!relationClass2.isContainsClass()) continue;
            if (relationClass != null) {
                relationClass.setContainsClass(false);
            }
            relationClass = relationClass2;
        }
        if (relationClass == null) {
            relationClass = this.getRelationClass(CONTAIN_ID);
        }
        if (relationClass == null) {
            this.m_taFeedback.noContainRelation(string);
            return "No contains relation class defined";
        }
        Vector vector = this.establishForest(relationClass);
        if (vector == null) {
            return "Contains class does not form a forest";
        }
        this.switchContainsClass(relationClass, vector);
        if (this.m_uses_local_coordinates) {
            this.computeRelCoordinates();
        }
        if (this.m_context == null) {
            return this.m_resString;
        }
        return null;
    }

    public int getNumberEntitiesLoaded() {
        return this.m_entityCache.size();
    }

    public int getNumberRelationsLoaded() {
        return this.m_numberRelations;
    }

    protected String saveByFile(String string) {
        try {
            OutputStream outputStream;
            if (string != null && string.length() == 0) {
                outputStream = System.out;
            } else {
                File file = (File)this.getContext();
                if (string == null) {
                    String string2 = file.getPath();
                    file.renameTo(new File(string2 + ".old"));
                } else {
                    file = new File(string);
                    this.setContext(file);
                }
                outputStream = new FileOutputStream(file);
            }
            this.saveDiagram(outputStream, false);
            return null;
        }
        catch (IOException iOException) {
            return "IOException on file open";
        }
    }

    protected void switchContainsClass(RelationClass relationClass, Vector vector) {
        int n;
        EntityInstance entityInstance = this.m_rootInstance;
        this.setContainsClass(relationClass);
        entityInstance.removeAllEdges();
        if (vector != null) {
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                EntityInstance entityInstance2 = (EntityInstance)vector.elementAt(i);
                this.getNewRelation(relationClass, this.m_rootInstance, entityInstance2);
            }
        }
        if ((n = this.getCIndex(relationClass)) != this.m_cIndex) {
            int n2 = this.getMaxCIndex() + 1;
            this.m_rootInstance.exchangePositioning(this.m_cIndex, n, n2);
            this.m_cIndex = n;
        }
        relationClass.setActiveState(false);
        if (this.m_defaultRelationClass == relationClass) {
            this.setDefaultRelationClass(this.m_relationBaseClass);
        }
        this.prepostorder();
    }

    public void showProgress(String string) {
        this.m_taFeedback.showProgress(string);
    }

    public void updateProgress(int n) {
        this.m_taFeedback.updateProgress(n);
    }

    public void doFeedback(String string) {
        this.m_taFeedback.doFeedback(string);
    }

    public void showInfo(String string) {
        this.m_taFeedback.showInfo(string);
    }

    public void error(String string) {
        this.m_taFeedback.error(string);
    }

    public void showCycle(RelationClass relationClass, EntityInstance entityInstance, int n) {
        this.m_taFeedback.showCycle(relationClass, entityInstance, n);
    }

    public void noContainRelation(String string) {
        this.m_taFeedback.noContainRelation(string);
    }

    public void hasMultipleParents(RelationClass relationClass, EntityInstance entityInstance) {
        this.m_taFeedback.hasMultipleParents(relationClass, entityInstance);
    }
}

