/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;
import lsedit.Clipboard;
import lsedit.ClipboardEnumerator;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.MyUndoableEdit;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.TaFeedback;
import lsedit.TaListener;
import lsedit.UndoableTa;

public class TemporalTa
extends UndoableTa {
    public TemporalTa(TaListener taListener, TaFeedback taFeedback) {
        super(taListener, taFeedback);
    }

    public EntityInstance updateNewEntity(EntityClass entityClass, EntityInstance entityInstance, Rectangle rectangle, boolean bl) {
        EntityInstance entityInstance2 = this.getNewEntity(entityClass, entityInstance);
        if (this.undoEnabled()) {
            new NewEntity(entityInstance, entityInstance2);
        }
        if (bl) {
            if (rectangle == null) {
                this.setInitialLocation(entityInstance2, entityInstance);
            } else {
                entityInstance2.updateDiagramBounds(rectangle);
            }
        }
        return entityInstance2;
    }

    public RelationInstance updateNewRelation(RelationClass relationClass, EntityInstance entityInstance, EntityInstance entityInstance2) {
        RelationInstance relationInstance = this.getNewRelation(relationClass, entityInstance, entityInstance2);
        if (this.undoEnabled()) {
            new NewRelation(relationInstance);
        }
        return relationInstance;
    }

    public boolean updateCutEntity(EntityInstance entityInstance) {
        boolean bl = this.cutEntity(entityInstance);
        if (bl && this.undoEnabled()) {
            new CutEntity(entityInstance);
        }
        return bl;
    }

    public void updateDeleteAllEntities(EntityClass entityClass, EntityInstance entityInstance) {
        if (entityInstance.getEntityClass() == entityClass) {
            this.updateCutEntity(entityInstance);
            return;
        }
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            this.updateDeleteAllEntities(entityClass, entityInstance2);
        }
    }

    public boolean updateDeleteAllEntities(EntityClass entityClass) {
        if (this.m_rootInstance.getEntityClass() == entityClass) {
            return false;
        }
        this.updateDeleteAllEntities(entityClass, this.m_rootInstance);
        return true;
    }

    public void updateDeleteAllEdges(RelationClass relationClass, EntityInstance entityInstance) {
        Vector vector = entityInstance.getDstRelList();
        int n = vector.size();
        while (n > 0) {
            RelationInstance relationInstance;
            if ((relationInstance = (RelationInstance)vector.elementAt(--n)).getRelationClass() != relationClass) continue;
            relationInstance.updateDeleteEdge();
        }
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            this.updateDeleteAllEdges(relationClass, entityInstance2);
        }
    }

    public void updateDeleteAllEdges(RelationClass relationClass) {
        this.updateDeleteAllEdges(relationClass, this.m_rootInstance);
    }

    public boolean updateCutClipboard(Clipboard clipboard, Clipboard clipboard2) {
        boolean bl = this.cutClipboard(clipboard2);
        if (bl && this.undoEnabled()) {
            new CutClipboard(clipboard, clipboard2);
        }
        return bl;
    }

    public void updatePasteClipboard(Clipboard clipboard, EntityInstance entityInstance) {
        this.pasteClipboard(clipboard, entityInstance);
        if (this.undoEnabled()) {
            new PasteClipboard(clipboard, entityInstance);
        }
    }

    public void updateMoveEntityContainment(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3 = entityInstance2.getContainedBy();
        if (this.moveEntityContainment(entityInstance, entityInstance2) && this.undoEnabled()) {
            new MoveEntityContainment(entityInstance3, entityInstance2);
        }
    }

    public void updateDeleteContainer(EntityInstance entityInstance) {
        this.deleteContainer(entityInstance);
        if (this.undoEnabled()) {
            new UpdateDeleteContainer(entityInstance);
        }
    }

    public EntityInstance updateClusterEntity(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3 = this.clusterEntity(entityInstance, entityInstance2);
        if (this.undoEnabled()) {
            new ClusterEntity(entityInstance, entityInstance3);
        }
        return entityInstance3;
    }

    public EntityInstance updateImportEntity(EntityInstance entityInstance, EntityInstance entityInstance2, EntityInstance entityInstance3) {
        EntityInstance entityInstance4;
        if (!this.undoEnabled()) {
            entityInstance4 = this.importEntity(entityInstance, entityInstance2, entityInstance3);
        } else {
            ImportEntity importEntity = new ImportEntity(entityInstance, entityInstance2, entityInstance3);
            entityInstance4 = importEntity.getEntity();
        }
        return entityInstance4;
    }

    public void updateRemoveEntityClass(EntityClass entityClass) {
        if (this.undoEnabled()) {
            new RemoveEntityClass(entityClass);
        }
        this.removeEntityClass(entityClass);
    }

    public void updateRemoveRelationClass(RelationClass relationClass) {
        if (this.undoEnabled()) {
            new RemoveRelationClass(relationClass);
        }
        this.removeRelationClass(relationClass);
    }

    public void updateSwitchContainsClass(RelationClass relationClass, Vector vector) {
        this.m_taListener.containsClassChanging();
        this.switchContainsClass(relationClass, vector);
        if (this.undoEnabled()) {
            this.beginUndoRedo("Switch to " + relationClass.getLabel() + " hierarchy");
            new SwitchContainsClass(relationClass, vector);
            this.endUndoRedo();
        }
        this.m_taListener.containsClassChanged();
    }

    class SwitchContainsClass
    extends MyUndoableEdit
    implements UndoableEdit {
        RelationClass m_oldContainsClass;
        RelationClass m_newContainsClass;
        Vector m_oldForest;
        Vector m_newForest;

        SwitchContainsClass(RelationClass relationClass, Vector vector) {
            this.m_oldContainsClass = TemporalTa.this.m_containsClass;
            this.m_oldForest = TemporalTa.this.getForest();
            this.m_newContainsClass = relationClass;
            this.m_newForest = vector;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return "Switch hierarchy from " + this.m_oldContainsClass.getLabel() + " to " + this.m_newContainsClass.getLabel();
        }

        public void undo() {
            TemporalTa.this.switchContainsClass(this.m_oldContainsClass, this.m_oldForest);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.switchContainsClass(this.m_newContainsClass, this.m_newForest);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }

    class RemoveRelationClass
    extends MyUndoableEdit
    implements UndoableEdit {
        RelationClass m_rc;
        RelationClass m_oldDefaultRelationClass;

        RemoveRelationClass(RelationClass relationClass) {
            this.m_rc = relationClass;
            this.m_oldDefaultRelationClass = TemporalTa.this.m_defaultRelationClass;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return " Remove relation class " + this.m_rc.getLabel();
        }

        public void undo() {
            TemporalTa.this.m_relationClasses.put(this.m_rc.getId(), this.m_rc);
            if (TemporalTa.this.m_defaultRelationClass != this.m_oldDefaultRelationClass) {
                TemporalTa.this.setDefaultRelationClass(this.m_oldDefaultRelationClass);
            }
            TemporalTa.this.m_taListener.classChanges();
        }

        public void redo() {
            TemporalTa.this.removeRelationClass(this.m_rc);
        }
    }

    class RemoveEntityClass
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityClass m_ec;
        EntityClass m_oldDefaultEntityClass;
        Vector m_eps;

        private void cacheEntityClassPairs(EntityClass entityClass) {
            entityClass = this.m_ec;
            Vector<EntityClassPair> vector = null;
            Enumeration enumeration = TemporalTa.this.m_relationClasses.elements();
            while (enumeration.hasMoreElements()) {
                RelationClass relationClass = (RelationClass)enumeration.nextElement();
                Vector vector2 = relationClass.getRelationList();
                if (vector2 == null) continue;
                int n = vector2.size();
                while (n > 0) {
                    EntityClassPair entityClassPair = (EntityClassPair)vector2.elementAt(--n);
                    if (entityClassPair.m_entityClass1 != entityClass && entityClassPair.m_entityClass2 != entityClass) continue;
                    if (vector == null) {
                        vector = new Vector<EntityClassPair>();
                    }
                    vector.addElement(entityClassPair);
                }
            }
            this.m_eps = vector;
        }

        RemoveEntityClass(EntityClass entityClass) {
            this.m_ec = entityClass;
            this.m_oldDefaultEntityClass = TemporalTa.this.m_defaultEntityClass;
            if (TemporalTa.this.logEdit(this)) {
                this.cacheEntityClassPairs(entityClass);
            }
        }

        public String getPresentationName() {
            return " Remove entity class " + this.m_ec.getLabel();
        }

        public void undo() {
            TemporalTa.this.m_entityClasses.put(this.m_ec.getId(), this.m_ec);
            Vector vector = this.m_eps;
            if (vector != null) {
                int n = vector.size();
                while (n > 0) {
                    EntityClassPair entityClassPair = (EntityClassPair)vector.elementAt(--n);
                    entityClassPair.m_rc.addRelation(entityClassPair);
                }
            }
            if (TemporalTa.this.m_defaultEntityClass != this.m_oldDefaultEntityClass) {
                TemporalTa.this.setDefaultEntityClass(this.m_oldDefaultEntityClass);
            }
            TemporalTa.this.m_taListener.classChanges();
        }

        public void redo() {
            TemporalTa.this.removeEntityClass(this.m_ec);
        }
    }

    class ImportEntity
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_container;
        EntityInstance m_e;
        EntityInstance m_match;
        EntityInstance m_ret;
        EntityClass m_old_match_parentClass;
        EntityInstance m_old_match_containedBy;
        double m_old_match_x;
        double m_old_match_y;
        double m_old_match_width;
        double m_old_match_height;

        ImportEntity(EntityInstance entityInstance, EntityInstance entityInstance2, EntityInstance entityInstance3) {
            this.m_container = entityInstance;
            this.m_e = entityInstance2;
            this.m_match = entityInstance3;
            this.m_old_match_parentClass = (EntityClass)entityInstance3.getParentClass();
            this.m_old_match_containedBy = entityInstance3.getContainedBy();
            this.m_old_match_x = entityInstance3.xRelLocal();
            this.m_old_match_y = entityInstance3.yRelLocal();
            this.m_old_match_width = entityInstance3.widthRelLocal();
            this.m_old_match_height = entityInstance3.heightRelLocal();
            this.m_ret = TemporalTa.this.importEntity(entityInstance, entityInstance2, entityInstance3);
            TemporalTa.this.logEdit(this);
        }

        public EntityInstance getEntity() {
            return this.m_ret;
        }

        public String getPresentationName() {
            return "Import entity " + this.m_e;
        }

        public void undo() {
            EntityInstance entityInstance = this.m_match;
            entityInstance.setRelLocal(this.m_old_match_x, this.m_old_match_y, this.m_old_match_width, this.m_old_match_height);
            TemporalTa.this.moveEntityContainment(this.m_old_match_containedBy, entityInstance);
            entityInstance.setParentClass(this.m_old_match_parentClass);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            this.m_ret = TemporalTa.this.importEntity(this.m_container, this.m_e, this.m_match);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }

    class ClusterEntity
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_container;
        EntityInstance m_e;

        ClusterEntity(EntityInstance entityInstance, EntityInstance entityInstance2) {
            this.m_container = entityInstance;
            this.m_e = entityInstance2;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return "Create cluster " + this.m_e;
        }

        public void undo() {
            TemporalTa.this.cutEntity(this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.pasteEntity(this.m_container, this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }

    class UpdateDeleteContainer
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_e;

        UpdateDeleteContainer(EntityInstance entityInstance) {
            this.m_e = entityInstance;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return "Deleting container " + this.m_e;
        }

        public void undo() {
            TemporalTa.this.undeleteContainer(this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.deleteContainer(this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }

    class MoveEntityContainment
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_containedByOld;
        EntityInstance m_containedByNew;
        EntityInstance m_e;

        MoveEntityContainment(EntityInstance entityInstance, EntityInstance entityInstance2) {
            this.m_containedByOld = entityInstance;
            this.m_containedByNew = entityInstance2.getContainedBy();
            this.m_e = entityInstance2;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return this.m_e + " moved from " + this.m_containedByOld + " to " + this.m_containedByNew;
        }

        public void undo() {
            TemporalTa.this.moveEntityContainment(this.m_containedByOld, this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.moveEntityContainment(this.m_containedByNew, this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }

    class PasteClipboard
    extends MyUndoableEdit
    implements UndoableEdit {
        Clipboard m_saved_clipboard;
        EntityInstance m_container;

        PasteClipboard(Clipboard clipboard, EntityInstance entityInstance) {
            this.m_saved_clipboard = clipboard;
            this.m_container = entityInstance;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return "Paste";
        }

        public void undo() {
            RelationClass relationClass = TemporalTa.this.getContainsClass();
            int n = 0;
            ClipboardEnumerator clipboardEnumerator = this.m_saved_clipboard.clipboardElements();
            while (clipboardEnumerator.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)clipboardEnumerator.nextElement();
                TemporalTa.this.cutEntity(entityInstance);
                EntityInstance entityInstance2 = clipboardEnumerator.oldContainer();
                RelationInstance relationInstance = entityInstance.getContainedByRelation(relationClass);
                if (relationInstance == null || relationInstance.getSrc() != entityInstance2) {
                    if (relationInstance != null) {
                        relationInstance.removeEdge();
                    }
                    relationInstance = relationClass.newRelation(entityInstance2, entityInstance);
                    entityInstance.addDstRelation(relationInstance);
                }
                ++n;
            }
            TemporalTa.this.m_diagram.setClipboard(this.m_saved_clipboard);
            TemporalTa.this.prepostorder();
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.pasteClipboard(this.m_saved_clipboard, this.m_container);
        }
    }

    class CutClipboard
    extends MyUndoableEdit
    implements UndoableEdit {
        Clipboard m_old_clipboard;
        Clipboard m_new_clipboard;

        CutClipboard(Clipboard clipboard, Clipboard clipboard2) {
            this.m_old_clipboard = clipboard;
            this.m_new_clipboard = clipboard2;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            if (this.m_new_clipboard.getExtendsClipboard() == null) {
                return "Cut " + this.m_new_clipboard;
            }
            return "Cut additional";
        }

        public void undo() {
            Clipboard clipboard = this.m_new_clipboard;
            int n = clipboard.size();
            while (n > 0) {
                EntityInstance entityInstance = (EntityInstance)clipboard.elementAt(--n);
                TemporalTa.this.pasteEntity(null, entityInstance);
            }
            TemporalTa.this.m_diagram.setClipboard(this.m_old_clipboard);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.cutClipboard(this.m_new_clipboard);
        }
    }

    class CutEntity
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_e;

        CutEntity(EntityInstance entityInstance) {
            this.m_e = entityInstance;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return this.m_e + " Deleted";
        }

        public void undo() {
            TemporalTa.this.pasteEntity(null, this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.cutEntity(this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }

    class NewRelation
    extends MyUndoableEdit
    implements UndoableEdit {
        RelationInstance m_ri = null;

        NewRelation(RelationInstance relationInstance) {
            this.m_ri = relationInstance;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return "Create relation " + this.m_ri;
        }

        public void undo() {
            this.m_ri.getSrc().removeSrcRelation(this.m_ri);
            this.m_ri.getDst().removeDstRelation(this.m_ri);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            this.m_ri.getSrc().addSrcRelation(this.m_ri);
            this.m_ri.getDst().addDstRelation(this.m_ri);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }

    class NewEntity
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_container;
        EntityInstance m_e;

        NewEntity(EntityInstance entityInstance, EntityInstance entityInstance2) {
            this.m_container = entityInstance;
            this.m_e = entityInstance2;
            TemporalTa.this.logEdit(this);
        }

        public String getPresentationName() {
            return "Create entity " + this.m_e;
        }

        public void undo() {
            TemporalTa.this.cutEntity(this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }

        public void redo() {
            TemporalTa.this.pasteEntity(this.m_container, this.m_e);
            TemporalTa.this.m_diagram.redrawDiagram();
        }
    }
}

