/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lsedit.Clipboard;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;
import lsedit.MyTreePath;
import lsedit.SortVector;

public class TextTree
extends JComponent
implements TreeModel,
MouseListener,
MouseMotionListener,
TreeWillExpandListener {
    public static final String m_helpStr = "Right click for menu.";
    protected static final String[] m_say = new String[]{"Table of contents is hidden", "Press Alt-v or click to show TOC"};
    protected static final int margin = 10;
    protected static final int say_height = 30;
    protected static final Color titleColor = Color.red.darker();
    public static final String DEFAULT_TOC_FONT_NAME = "Helvetica";
    public static final int DEFAULT_TOC_FONT_STYLE = 0;
    public static final int DEFAULT_TOC_FONT_SIZE = 11;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    protected static Hashtable m_childVectors;
    protected LandscapeEditorCore m_ls;
    protected MyTree m_tree;
    protected JPanel m_say_panel;
    protected JComponent m_use;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected JLabel[] m_say_labels;
    protected boolean m_firsttime = true;
    protected Vector m_treeModelListeners;

    public TextTree(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.setLayout(null);
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.m_say_panel = new JPanel();
        this.m_say_panel.setLayout(new GridLayout(0, 1));
        int n = m_say.length;
        this.m_say_labels = new JLabel[n];
        for (int i = 0; i < n; ++i) {
            JLabel jLabel;
            this.m_say_labels[i] = jLabel = new JLabel(m_say[i]);
            jLabel.setBackground(Diagram.boxColor);
            jLabel.setForeground(Color.red);
            jLabel.setFont(m_textFont);
            jLabel.setVisible(true);
            this.m_say_panel.add(jLabel);
        }
        this.m_say_panel.setSize(this.m_say_panel.getPreferredSize());
        this.fillTOC();
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(0, 0, jTabbedPane.getWidth(), jTabbedPane.getHeight());
        this.setBounds(0, 0, jTabbedPane.getWidth(), jTabbedPane.getHeight());
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("TOC", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        for (JLabel jLabel : this.m_say_labels) {
            jLabel.setFont(font);
        }
        this.m_tree.setFont(font);
        this.fillTOC();
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        super.paintComponent(graphics);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n, n2);
    }

    public void firstTime() {
        this.m_firsttime = true;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    protected JPopupMenu buildPopup(EntityInstance entityInstance) {
        MyMenuItem myMenuItem;
        Diagram diagram = this.m_ls.getDiagram();
        JPopupMenu jPopupMenu = new JPopupMenu("TOC options");
        if (entityInstance != null) {
            myMenuItem = Do.navigateMenuItem(jPopupMenu, this.m_ls, entityInstance);
        }
        if (this.m_use != null && this.m_use == this.m_tree && diagram != null) {
            Clipboard clipboard = diagram.getClipboard();
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            if (treePathArray != null && treePathArray.length > 0) {
                myMenuItem = Do.cutMenuItem(jPopupMenu, this.m_ls);
                myMenuItem.setObject(this);
            }
            if (clipboard != null && !clipboard.isEmpty() && treePathArray != null && treePathArray.length == 1) {
                myMenuItem = Do.pasteMenuItem(jPopupMenu, this.m_ls);
                myMenuItem.setObject(this);
            }
        }
        Do.openCloseTOCMenuItem(jPopupMenu, this.m_ls);
        Do.alignTOCMenuItem(jPopupMenu, this.m_ls);
        this.m_ls.hideTOCMenuItem(jPopupMenu, this.m_ls);
        FontCache.setMenuTreeFont(jPopupMenu);
        return jPopupMenu;
    }

    public Vector getGroup() {
        int n;
        TreePath[] treePathArray;
        Vector<EntityInstance> vector = null;
        if (this.m_use != null && this.m_use == this.m_tree && (treePathArray = this.m_tree.getSelectionPaths()) != null && (n = treePathArray.length) > 0) {
            vector = new Vector<EntityInstance>(n);
            for (int i = 0; i < n; ++i) {
                EntityInstance entityInstance = (EntityInstance)treePathArray[i].getLastPathComponent();
                vector.add(entityInstance);
            }
        }
        return vector;
    }

    public EntityInstance targetEntity() {
        TreePath[] treePathArray;
        if (this.m_use != null && this.m_use == this.m_tree && (treePathArray = this.m_tree.getSelectionPaths()) != null && treePathArray.length == 1) {
            EntityInstance entityInstance = (EntityInstance)treePathArray[0].getLastPathComponent();
            return entityInstance;
        }
        return null;
    }

    public void emptyTOC() {
        this.removeAll();
        this.m_use = null;
        this.m_tree = null;
        m_childVectors = null;
    }

    protected void fillTOC() {
        JComponent jComponent;
        Diagram diagram = this.m_ls.getDiagram();
        this.emptyTOC();
        if (diagram == null) {
            return;
        }
        EntityInstance entityInstance = diagram.getRootInstance();
        if (entityInstance == null) {
            return;
        }
        if (this.m_firsttime && this.m_ls.isTocHidden()) {
            this.m_ls.setTocHiddenState(false);
            this.m_firsttime = false;
        }
        if (this.m_ls.isTocHidden()) {
            jComponent = this.m_say_panel;
        } else {
            this.m_treeModelListeners = null;
            this.m_tree = new MyTree(this);
            this.m_tree.addTreeWillExpandListener(this);
            jComponent = this.m_tree;
        }
        this.setSize(jComponent.getPreferredSize());
        this.add(jComponent);
        this.m_use = jComponent;
        jComponent.setVisible(true);
        this.repaint();
    }

    public MyTreePath getTreePath(EntityInstance entityInstance) {
        if (this.m_use != null && this.m_use == this.m_tree) {
            return new MyTreePath(entityInstance);
        }
        return null;
    }

    public void insertTOC(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = entityInstance.getContainedBy();
        if (entityInstance2 != null) {
            MyTreePath myTreePath;
            if (m_childVectors != null) {
                m_childVectors.remove(entityInstance2.getId());
            }
            if ((myTreePath = this.getTreePath(entityInstance2)) != null) {
                int[] nArray = new int[]{this.getIndexOfChild(entityInstance2, entityInstance)};
                Object[] objectArray = new Object[]{entityInstance};
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, myTreePath, nArray, objectArray);
                int n = this.m_treeModelListeners.size();
                while (n > 0) {
                    TreeModelListener treeModelListener = (TreeModelListener)this.m_treeModelListeners.elementAt(--n);
                    treeModelListener.treeNodesInserted(treeModelEvent);
                }
            }
        }
    }

    public void deleteTOC(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = entityInstance.getContainedBy();
        if (entityInstance2 != null) {
            MyTreePath myTreePath;
            if (m_childVectors != null) {
                m_childVectors.remove(entityInstance2.getId());
            }
            if ((myTreePath = this.getTreePath(entityInstance2)) != null) {
                int[] nArray = new int[]{this.getIndexOfChild(entityInstance2, entityInstance)};
                Object[] objectArray = new Object[]{entityInstance};
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, myTreePath, nArray, objectArray);
                int n = this.m_treeModelListeners.size();
                while (n > 0) {
                    TreeModelListener treeModelListener = (TreeModelListener)this.m_treeModelListeners.elementAt(--n);
                    treeModelListener.treeNodesRemoved(treeModelEvent);
                }
            }
        }
    }

    public void containerCut(EntityInstance entityInstance, EntityInstance entityInstance2) {
        if (entityInstance != null) {
            MyTreePath myTreePath;
            if (m_childVectors != null) {
                m_childVectors.remove(entityInstance.getId());
                m_childVectors.remove(entityInstance2.getId());
            }
            if ((myTreePath = this.getTreePath(entityInstance)) != null) {
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, myTreePath);
                int n = this.m_treeModelListeners.size();
                while (n > 0) {
                    TreeModelListener treeModelListener = (TreeModelListener)this.m_treeModelListeners.elementAt(--n);
                    treeModelListener.treeStructureChanged(treeModelEvent);
                }
            }
        }
    }

    public void containerUncut(EntityInstance entityInstance) {
        this.containerCut(entityInstance.getContainedBy(), entityInstance);
    }

    public Dimension getPreferredSize() {
        if (this.m_use != null) {
            return this.m_use.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.m_use != null) {
            this.m_use.setBounds(n, n2, n3, n4);
        }
    }

    protected void closeAll() {
        int n;
        int n2 = n = this.m_tree.getRowCount();
        while (n2 > 0) {
            this.m_tree.collapseRow(--n2);
        }
    }

    protected void expandTo(EntityInstance entityInstance) {
        this.closeAll();
        this.m_tree.clearSelection();
        if (entityInstance != null) {
            for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
                TreePath treePath = this.m_tree.getPathForRow(i);
                EntityInstance entityInstance2 = (EntityInstance)treePath.getLastPathComponent();
                if (entityInstance2 == null) continue;
                if (entityInstance2 == entityInstance) {
                    this.m_tree.setSelectionRow(i);
                    this.m_tree.scrollRowToVisible(i);
                    this.m_tree.expandRow(i);
                    break;
                }
                if (!entityInstance2.hasDescendant(entityInstance)) continue;
                this.m_tree.expandRow(i);
            }
        }
    }

    public void toc_path() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            this.m_ls.setTocHidden(false);
            this.activate();
            EntityInstance entityInstance = diagram.getDrawRoot();
            this.expandTo(entityInstance);
        }
    }

    protected void expandAll() {
        for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
            this.m_tree.expandRow(i);
        }
    }

    public void switch_TOC() {
        this.m_ls.setTocHidden(false);
        this.activate();
        int n = this.m_tree.getRowCount();
        if (n > 1) {
            this.closeAll();
        } else {
            this.expandAll();
        }
    }

    void rebuildTOC() {
        if (this.m_use != null && this.m_use == this.m_tree) {
            this.fillTOC();
        }
    }

    protected void doRightPopup(MouseEvent mouseEvent, EntityInstance entityInstance) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        JPopupMenu jPopupMenu = this.buildPopup(entityInstance);
        this.add(jPopupMenu);
        jPopupMenu.show(this, n, n2);
        this.remove(jPopupMenu);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.m_treeModelListeners == null) {
            this.m_treeModelListeners = new Vector();
        }
        this.m_treeModelListeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.m_treeModelListeners != null) {
            this.m_treeModelListeners.remove(treeModelListener);
            if (this.m_treeModelListeners.isEmpty()) {
                this.m_treeModelListeners = null;
            }
        }
    }

    public int getChildCount(Object object) {
        return ((EntityInstance)object).numChildren();
    }

    protected Vector sortedChildren(EntityInstance entityInstance) {
        String string;
        Vector vector;
        if (m_childVectors == null) {
            m_childVectors = new Hashtable(1024);
        }
        if ((vector = (Vector)m_childVectors.get(string = entityInstance.getId())) == null) {
            vector = new Vector();
            entityInstance.addChildren(vector);
            SortVector.byString(vector, true);
            m_childVectors.put(string, vector);
        }
        return vector;
    }

    public Object getChild(Object object, int n) {
        EntityInstance entityInstance = (EntityInstance)object;
        if (!this.m_ls.isSortTOC()) {
            return entityInstance.getChild(n);
        }
        Vector vector = this.sortedChildren(entityInstance);
        return vector.elementAt(n);
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object != null) {
            EntityInstance entityInstance = (EntityInstance)object;
            if (!this.m_ls.isSortTOC()) {
                return entityInstance.getIndexOfChild(object2);
            }
            Vector vector = this.sortedChildren(entityInstance);
            int n = vector.size();
            while (n > 0) {
                if ((entityInstance = (EntityInstance)vector.elementAt(--n)) != object2) continue;
                return n;
            }
        }
        return -1;
    }

    public Object getRoot() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            return null;
        }
        return diagram.getRootInstance();
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            if (this.m_ls.isTocHidden()) {
                this.m_ls.setTocHidden(false);
            }
        } else {
            this.doRightPopup(mouseEvent, null);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        if (m_childVectors != null) {
            EntityInstance entityInstance = (EntityInstance)treeExpansionEvent.getPath().getLastPathComponent();
            String string = entityInstance.getId();
            m_childVectors.remove(string);
        }
    }

    public String toString() {
        return "TextTree";
    }

    class MyTree
    extends JTree
    implements MouseListener {
        protected boolean removeDescendantSelectedPaths(TreePath treePath, boolean bl) {
            super.removeDescendantSelectedPaths(treePath, bl);
            return false;
        }

        public MyTree(TreeModel treeModel) {
            super(treeModel);
            this.setBackground(Diagram.boxColor);
            this.setFont(m_textFont);
            this.setEditable(false);
            this.setShowsRootHandles(true);
            MyTreeCellRenderer myTreeCellRenderer = new MyTreeCellRenderer();
            myTreeCellRenderer.setBackgroundNonSelectionColor(Diagram.boxColor);
            this.setCellRenderer(myTreeCellRenderer);
            this.setDragEnabled(true);
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown()) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TreePath treePath = this.getPathForLocation(n, n2);
                EntityInstance entityInstance = null;
                if (treePath == null) {
                    TextTree.this.mouseClicked(mouseEvent);
                } else {
                    entityInstance = (EntityInstance)treePath.getLastPathComponent();
                }
                TextTree.this.doRightPopup(mouseEvent, entityInstance);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        class MyTreeCellRenderer
        extends DefaultTreeCellRenderer {
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                EntityInstance entityInstance;
                int n2;
                Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof EntityInstance && (n2 = (entityInstance = (EntityInstance)object).numChildren()) > 1) {
                    this.setText(entityInstance.getEntityLabel() + " (" + n2 + ")");
                }
                return component;
            }
        }
    }
}

