/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;

public class Vista
implements Pageable,
Printable {
    static final String[] m_names = new String[]{"All", "Diagram", "TOC", "Results", "Legend", "Map", "Query", "Attribute"};
    static final String[] m_text = new String[]{"Maximum pages : ", "Maximum across: ", "Maximum down  : "};
    public static final int PRINT_ALL = 0;
    public static final int PRINT_DIAGRAM = 1;
    public static final int PRINT_TOC = 2;
    public static final int PRINT_RESULT = 3;
    public static final int PRINT_LEGEND = 4;
    public static final int PRINT_MAP = 5;
    public static final int PRINT_QUERY = 6;
    public static final int PRINT_ATTRIBUTE = 7;
    private int m_printing;
    private JComponent m_Component;
    private int m_NumPagesX;
    private int m_NumPagesY;
    private int m_NumPages;
    private int m_pixels_per_page_x;
    private int m_pixels_per_page_y;
    private PrinterJob m_printerJob;
    private PageFormat m_Format;
    private double m_ScaleX;
    private double m_ScaleY;

    public Vista(LandscapeEditorCore landscapeEditorCore) {
        PrintWhat printWhat = new PrintWhat(landscapeEditorCore);
        this.m_printing = printWhat.getPrinting();
        JComponent jComponent = printWhat.getComponent();
        if (jComponent == null) {
            landscapeEditorCore.doFeedback("No component selected to print");
            return;
        }
        this.m_Component = jComponent;
        double d = jComponent.getWidth();
        double d2 = jComponent.getHeight();
        if (d < 1.0 || d2 < 1.0) {
            landscapeEditorCore.doFeedback("Component has no size");
            return;
        }
        int n = printWhat.getPages();
        int n2 = printWhat.getMaxX();
        int n3 = printWhat.getMaxY();
        switch (n) {
            case 0: {
                return;
            }
            case -2: {
                landscapeEditorCore.doFeedback("Invalid number of print pages specified");
                return;
            }
        }
        switch (n2) {
            case 0: {
                return;
            }
            case -2: {
                landscapeEditorCore.doFeedback("Invalid maximum pages across");
                return;
            }
        }
        switch (n3) {
            case 0: {
                return;
            }
            case -2: {
                landscapeEditorCore.doFeedback("Invalid maximum pages down");
                return;
            }
        }
        this.m_printerJob = PrinterJob.getPrinterJob();
        this.m_printerJob.setPageable(this);
        try {
            if (this.m_printerJob.printDialog()) {
                this.m_Format = this.m_printerJob.defaultPage();
                this.m_Format = this.m_printerJob.pageDialog(this.m_Format);
                double d3 = this.m_Format.getImageableWidth();
                double d4 = this.m_Format.getImageableHeight();
                if (d3 < 1.0 || d4 < 1.0) {
                    landscapeEditorCore.doFeedback("Output pages have no size");
                    return;
                }
                double d5 = d3 / d;
                double d6 = d4 / d2;
                this.m_NumPagesX = 1;
                this.m_NumPagesY = 1;
                if (n != -1 || n2 != -1 || n3 != -1) {
                    block20: while (true) {
                        if (d5 <= d6) {
                            if (n != -1 && (this.m_NumPagesX + 1) * this.m_NumPagesY > n) break;
                            switch (n2) {
                                case -1: {
                                    ++this.m_NumPagesX;
                                    d5 = (double)this.m_NumPagesX * d3 / d;
                                    continue block20;
                                }
                            }
                            if (this.m_NumPagesX >= n2) break;
                            ++this.m_NumPagesX;
                            d5 = (double)this.m_NumPagesX * d3 / d;
                            continue;
                        }
                        if (n != -1 && (this.m_NumPagesY + 1) * this.m_NumPagesX > n) break;
                        switch (n3) {
                            case -1: {
                                ++this.m_NumPagesY;
                                d6 = (double)this.m_NumPagesY * d4 / d2;
                                continue block20;
                            }
                        }
                        if (this.m_NumPagesY >= n3) break;
                        ++this.m_NumPagesY;
                        d6 = (double)this.m_NumPagesY * d4 / d2;
                    }
                }
                if (d5 < d6) {
                    this.m_pixels_per_page_x = 1 + (jComponent.getWidth() - 1) / this.m_NumPagesX;
                    this.m_pixels_per_page_y = (int)((double)this.m_pixels_per_page_x * (d4 / d3));
                    d6 = d5;
                } else {
                    this.m_pixels_per_page_y = 1 + (jComponent.getHeight() - 1) / this.m_NumPagesY;
                    this.m_pixels_per_page_x = (int)((double)this.m_pixels_per_page_y * (d3 / d4));
                    d5 = d6;
                }
                this.m_ScaleX = d5;
                this.m_ScaleY = d6;
                this.m_NumPages = this.m_NumPagesX * this.m_NumPagesY;
                PrintConfirm printConfirm = new PrintConfirm(landscapeEditorCore);
                if (printConfirm.isOk()) {
                    landscapeEditorCore.doFeedback("Printing " + this.m_NumPages + " pages (" + this.m_NumPagesX + " across " + this.m_NumPagesY + " down)");
                    this.m_printerJob.print();
                } else {
                    landscapeEditorCore.doFeedback("Printing cancelled");
                }
            }
        }
        catch (PrinterException printerException) {
            System.out.println(printerException);
        }
    }

    public int getNumberOfPages() {
        if (this.m_NumPages < 0) {
            return -1;
        }
        return this.m_NumPages;
    }

    protected PageFormat getPageFormat() {
        return this.m_Format;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n >= this.m_NumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.m_NumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 0 && n < this.m_NumPages) {
            int n2;
            int n3 = n / this.m_NumPagesX;
            int n4 = n - n3 * this.m_NumPagesX;
            int n5 = n4 * this.m_pixels_per_page_x;
            int n6 = n3 * this.m_pixels_per_page_y;
            int n7 = this.m_Component.getWidth() - n5;
            if (n7 > this.m_pixels_per_page_x) {
                n7 = this.m_pixels_per_page_x;
            }
            if ((n2 = this.m_Component.getHeight() - n6) > this.m_pixels_per_page_y) {
                n2 = this.m_pixels_per_page_y;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(this.m_Format.getImageableX() - (double)n5, this.m_Format.getImageableY() - (double)n6);
            graphics2D.scale(this.m_ScaleX, this.m_ScaleY);
            boolean bl = this.m_Component.isDoubleBuffered();
            this.m_Component.setDoubleBuffered(false);
            this.m_Component.paint(graphics2D);
            this.m_Component.setDoubleBuffered(bl);
            return 0;
        }
        return 1;
    }

    public class PrintConfirm
    extends JDialog
    implements ActionListener {
        protected JButton m_ok;
        protected JButton m_cancel;
        protected boolean m_isOk;

        public PrintConfirm(LandscapeEditorCore landscapeEditorCore) {
            super(landscapeEditorCore.getFrame(), "Confirm", true);
            this.m_isOk = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            JFrame jFrame = landscapeEditorCore.getFrame();
            this.setLocation(jFrame.getX() + 200, jFrame.getY() + 300);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            Container container = this.getContentPane();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1));
            block24: for (int i = 0; i < 17; ++i) {
                String string;
                block0 : switch (i) {
                    case 0: {
                        string = "Printing: " + m_names[Vista.this.m_printing];
                        break;
                    }
                    case 1: {
                        string = "To: " + Vista.this.m_printerJob.getPrintService();
                        break;
                    }
                    case 2: {
                        string = "Orient: ";
                        switch (Vista.this.m_Format.getOrientation()) {
                            case 1: {
                                string = string + "Portrait";
                                break block0;
                            }
                            case 0: {
                                string = string + "Landscape";
                                break block0;
                            }
                            case 2: {
                                string = string + "Reverse Landscape";
                                break block0;
                            }
                        }
                        string = string + "??";
                        break;
                    }
                    case 3: {
                        string = "Width: " + Vista.this.m_Format.getWidth() / 72.0 + " inches";
                        break;
                    }
                    case 4: {
                        string = "Height: " + Vista.this.m_Format.getHeight() / 72.0 + " inches";
                        break;
                    }
                    case 5: {
                        int n = Vista.this.m_printerJob.getCopies();
                        if (n == 1) continue block24;
                        string = "Copies: " + n;
                        break;
                    }
                    case 6: {
                        if (Vista.this.m_NumPages == 1) continue block24;
                        string = "Shape: " + Vista.this.m_NumPagesX + " x " + Vista.this.m_NumPagesY + " pages";
                        break;
                    }
                    case 7: {
                        string = "Pages: " + Vista.this.m_NumPages;
                        break;
                    }
                    case 8: {
                        string = "Scale: " + Vista.this.m_ScaleX;
                        break;
                    }
                    case 9: {
                        string = "";
                        break;
                    }
                    case 10: {
                        string = "Component width: " + Vista.this.m_Component.getWidth() + " pixels";
                        break;
                    }
                    case 11: {
                        string = "Component height: " + Vista.this.m_Component.getHeight() + " pixels";
                        break;
                    }
                    case 12: {
                        string = "Imageable x: " + Vista.this.m_Format.getImageableX() / 72.0 + " inches";
                        break;
                    }
                    case 13: {
                        string = "Imageable y: " + Vista.this.m_Format.getImageableY() / 72.0 + " inches";
                        break;
                    }
                    case 14: {
                        string = "Imageable width: " + Vista.this.m_Format.getImageableWidth() / 72.0 + " inches";
                        break;
                    }
                    case 15: {
                        string = "Imageable height: " + Vista.this.m_Format.getImageableHeight() / 72.0 + " inches";
                        break;
                    }
                    case 16: {
                        string = "";
                        break;
                    }
                    default: {
                        string = "????";
                    }
                }
                JLabel jLabel = new JLabel(string);
                jLabel.setFont(font);
                jPanel.add(jLabel);
            }
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            this.m_ok.setFont(font2);
            jPanel2.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            this.m_cancel.setFont(font2);
            jPanel2.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            container.add((Component)jPanel2, "South");
            this.pack();
            this.setVisible(true);
        }

        public boolean isOk() {
            return this.m_isOk;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.m_ok) {
                this.m_isOk = true;
                this.setVisible(false);
                return;
            }
            if (object == this.m_cancel) {
                this.setVisible(false);
                return;
            }
        }
    }

    public class PrintWhat
    extends JDialog
    implements ActionListener {
        protected LandscapeEditorCore m_ls;
        protected ButtonGroup m_buttonGroup;
        protected JRadioButton[] m_radioButtons;
        protected JTextField[] m_pages;
        protected JButton m_ok;
        protected JButton m_cancel;
        protected int m_printing;
        protected int[] m_print_pages;

        public PrintWhat(LandscapeEditorCore landscapeEditorCore) {
            JPanel jPanel;
            int n;
            super(landscapeEditorCore.getFrame(), "Print", true);
            this.m_printing = -1;
            this.m_print_pages = new int[]{-2, -2, -2};
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.m_ls = landscapeEditorCore;
            JFrame jFrame = landscapeEditorCore.getFrame();
            this.setLocation(jFrame.getX() + 200, jFrame.getY() + 300);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            Container container = this.getContentPane();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(0, 1));
            this.m_pages = new JTextField[3];
            for (n = 0; n < 3; ++n) {
                jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                JLabel jLabel = new JLabel(m_text[n]);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                this.m_pages[n] = new JTextField("", 5);
                this.m_pages[n].setFont(font);
                jPanel.add(this.m_pages[n]);
                jPanel2.add(jPanel);
            }
            int n2 = m_names.length;
            this.m_buttonGroup = new ButtonGroup();
            this.m_radioButtons = new JRadioButton[n2];
            for (n = 0; n < n2; ++n) {
                JRadioButton jRadioButton;
                this.m_radioButtons[n] = jRadioButton = new JRadioButton(m_names[n]);
                jRadioButton.setFont(font2);
                this.m_buttonGroup.add(jRadioButton);
                jPanel2.add(jRadioButton);
            }
            container.add((Component)jPanel2, "Center");
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            this.m_ok.setFont(font2);
            jPanel.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            this.m_cancel.setFont(font2);
            jPanel.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            container.add((Component)jPanel, "South");
            this.pack();
            this.setVisible(true);
        }

        public int getPages() {
            return this.m_print_pages[0];
        }

        public int getMaxX() {
            return this.m_print_pages[1];
        }

        public int getMaxY() {
            return this.m_print_pages[2];
        }

        public int getPrinting() {
            return this.m_printing;
        }

        public JComponent getComponent() {
            LandscapeEditorCore landscapeEditorCore = this.m_ls;
            JComponent jComponent = null;
            switch (this.m_printing) {
                case 0: {
                    jComponent = landscapeEditorCore.getContentPane();
                    break;
                }
                case 1: {
                    jComponent = landscapeEditorCore.getDiagram();
                    break;
                }
                case 2: {
                    jComponent = landscapeEditorCore.getTocBox();
                    break;
                }
                case 3: {
                    jComponent = landscapeEditorCore.getResultBox();
                    break;
                }
                case 4: {
                    jComponent = landscapeEditorCore.getLegendBox();
                    break;
                }
                case 5: {
                    jComponent = landscapeEditorCore.getMapBox();
                    break;
                }
                case 6: {
                    jComponent = landscapeEditorCore.getQueryBox();
                    break;
                }
                case 7: {
                    jComponent = landscapeEditorCore.getAttributeBox();
                }
            }
            return jComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.m_ok) {
                int n;
                for (n = 0; n < 3; ++n) {
                    String string = this.m_pages[n].getText();
                    if ((string = string.trim()).length() == 0) {
                        this.m_print_pages[n] = -1;
                        continue;
                    }
                    try {
                        this.m_print_pages[n] = Integer.parseInt(string);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.m_print_pages[n] = -2;
                    }
                }
                int n2 = m_names.length;
                for (n = 0; n < n2; ++n) {
                    JRadioButton jRadioButton = this.m_radioButtons[n];
                    if (!jRadioButton.isSelected()) continue;
                    this.m_printing = n;
                    break;
                }
                this.setVisible(false);
                return;
            }
            if (object == this.m_cancel) {
                this.m_printing = -2;
                this.setVisible(false);
                return;
            }
        }
    }
}

