package lsedit;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.Scrollable;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ShowLabel extends JLabel
{
	public ShowLabel(String value)
	{
		super(value);

		int width, width1;

		setHorizontalAlignment(LEFT);
		setHorizontalTextPosition(LEFT);
		setFont(AttributeBox.m_textFont);
}	}


class ShowAttributeColor extends ShowLabel {

	public ShowAttributeColor(Color color) 
	{
		super("COLOR");
		// The text COLOR helps distinguish white from null
		// Null's don't seem to get painted

		if (color == null) {
			setBackground(Color.WHITE);
			setForeground(Color.BLACK);
		} else {
			setBackground(color);
			setForeground(ColorCache.getInverse(color.getRGB()));
}	}	}

class ShowImage extends ShowLabel {

	int		m_image;

	public ShowImage(int image) 
	{
		super("  ");
		m_image = image;
	}

	public void paintComponent(Graphics g) 
	{
		int		width	= getWidth();
		int		height	= getHeight();
		int		size	= width;

		if (height < size) {
			size = height;
		}
		g.setColor(Color.BLACK);
		EntityComponent.paintImage(g, m_image, (width - size)/2, (height-size)/2, size, size);
}	}

class AttributeBoxPanel extends JPanel
{
	AttributeBox	m_attributeBox;

	// ------------------
	// JComponent methods
	// ------------------

/*
	public Component add(Component comp)
	{
		super.add(comp);

		System.out.println("AttributeBoxPanel add " + comp + " " + comp.getBounds());
	
		return(comp);
	}
*/

	public Dimension getPreferredSize()
	{
		return(getSize());
	}

/*
	public void paintComponent(Graphics g)
	{
		int	width, height;

		super.paintComponent(g);

		width   = getWidth();
		height  = getHeight();

		System.out.println("AttributeBoxPanel paintComponent " + width + "x" + height);

		
		// For debugging
		g.setColor(Color.green);
		g.drawLine(0, 0, width, height);
		g.drawLine(0, height, width, 0);
	}
 */
	// Paints rows in alternating backgrounds

	public void paintBorder(Graphics g)
	{
		super.paintBorder(g);

		int			width = getWidth();
		int			cnt   = getComponentCount();
		int			i, y, height;
		Component	component;
		boolean		flag;

		g.setColor(Diagram.lighterBoxColor);
		flag = false;
		for (i = 0; i < cnt; ++i) {
			component = getComponent(i);
			if (!(component instanceof JLabel)) {
				flag = false;
				continue;
			}
			if (!flag) {
				flag = true;
			} else {
				y         = component.getY();
				height    = component.getHeight();
				g.fillRect(0, y, width, height);
				flag = false;
	}	}	}

	public AttributeBoxPanel(AttributeBox attributeBox)
	{
		super();
		m_attributeBox = attributeBox;
		setLayout(null);
	}
}	

// Can't be a subclass of TabBox 

public class AttributeBox extends MySplitPane implements ChangeListener
{
	protected static final  int GAP = 20;

	protected static final Color	m_titleColor = Color.red.darker();

	public final static String DEFAULT_ATTRIBUTE_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_ATTRIBUTE_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_ATTRIBUTE_TITLE_FONT_SIZE  = 14;


	protected static Font	   m_titleFont  = FontCache.get(DEFAULT_ATTRIBUTE_TITLE_FONT_NAME, DEFAULT_ATTRIBUTE_TITLE_FONT_STYLE, DEFAULT_ATTRIBUTE_TITLE_FONT_SIZE);

	public final static String DEFAULT_ATTRIBUTE_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_ATTRIBUTE_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_ATTRIBUTE_TEXT_FONT_SIZE  = 11;

	public    static       Font		m_textFont	 = FontCache.get(DEFAULT_ATTRIBUTE_TEXT_FONT_NAME, DEFAULT_ATTRIBUTE_TEXT_FONT_STYLE, DEFAULT_ATTRIBUTE_TEXT_FONT_SIZE);
	protected static final String	m_indent     = "    ";

	protected static final String	m_helpStr    = "Hold shift down to freeze";

	protected static final int	horizontal_margin    = 10;
	protected static final int	vertical_indent      = 10;

	protected LandscapeEditorCore	m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;
	protected GridLayout			m_layout;
	protected JPanel				m_left;
	protected JPanel				m_right;

	protected LandscapeObject		m_object = null;

	protected int					m_leftWidth  = 0;
	protected int					m_rightWidth = 0;
	protected int					m_height     = 0;

	// ------------------
	// JComponent methods
	// ------------------

	public Dimension getPreferredSize()
	{
		return(getSize());
	}

/*
	public void paintComponent(Graphics g)
	{
		int	width, height;

		super.paintComponent(g);

		width   = getWidth();
		height  = getHeight();

		System.out.println("AttributeBox paintComponent " + width + "x" + height);

		
		// For debugging
		g.setColor(Color.green);
		g.drawLine(0, 0, width, height);
		g.drawLine(0, height, width, 0);
	}
*/

	// --------------
	// Public methods 
	// --------------

	public AttributeBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		super(JSplitPane.HORIZONTAL_SPLIT);

		Dimension d;
		BoxLayout layout;
		int		  width, height;

		m_ls         = ls;
		m_tabbedPane = tabbedPane;

		m_left  = new AttributeBoxPanel(this);
		m_right = new AttributeBoxPanel(this);

		m_left.setBackground(Diagram.boxColor);
		m_right.setBackground(Diagram.boxColor);
		
		setLeftComponent(m_left);
		setRightComponent(m_right);
		setOneTouchExpandable(true);
		setDividerLocation(0.5);

		width        = tabbedPane.getWidth();
		height       = tabbedPane.getHeight();
		m_scrollPane = new JScrollPane();
		m_scrollPane.setBounds(0, 0, width, height);
		d            = m_scrollPane.getSize();
		setSize(d);
		setPreferredSize(d);

		setToolTipText(m_helpStr);
		m_scrollPane.setViewportView(this);

		tabbedPane.addTab("Attrs", null, m_scrollPane, m_helpStr);
		tabbedPane.addChangeListener(this);
	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public int preferredWidth()
	{
		Insets	insets	= m_scrollPane.getInsets();

		return m_scrollPane.getWidth() - insets.left - insets.right;
	}

	public int preferredLeftWidth()
	{
		return m_leftWidth;
	}

	public int preferredRightWidth()
	{
		return m_rightWidth;
	}

	public int preferredHeight()
	{
		return m_height;
	}

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		
		if (isVisible()) {
			Component active;

			active = m_tabbedPane.getSelectedComponent();
			return(m_scrollPane == active);
		}
		return(false);
	}

	public int	addBoth(JComponent left, JComponent right, int height)
	{
		ShowLabel	label;
		int			leftWidth, rightWidth, leftHeight, rightHeight, height1;
		Dimension	dim;

		if (right == null) {
			label = new ShowLabel("null");
			label.setForeground(Color.red);
			right = label;
		}
		dim = left.getPreferredSize();

		leftWidth   = dim.width;
		leftHeight  = dim.height;

		dim = right.getPreferredSize();

		rightWidth  = dim.width;
		rightHeight = dim.height;

		if (leftHeight < rightHeight) {
			height1 = rightHeight;
		} else {
			height1 = leftHeight;
		}

		if (leftWidth > m_leftWidth) {
			m_leftWidth = leftWidth;
		}
		if (rightWidth > m_rightWidth) {
			m_rightWidth = rightWidth;
		}

//		System.out.println("Height=" + height + " left=" + leftWidth + " right=" + rightWidth + " height=" + height1);

		left.setBounds(0,  height, leftWidth,  height1);
		right.setBounds(0, height, rightWidth, height1);

		m_left.add(left);
		m_right.add(right);

		return (height + height1);
	}

	public void fill(LandscapeObject object)
	{
		ShowLabel		label;
		int				attributes = 0;

		int			height, leftHeight, rightHeight;
		int			i, primary, type;
		String		name;
		Object		value;
		JComponent	left, right;
		Color		foreground;

		attributes = object.getLsAttributeCount();
		primary    = object.getPrimaryAttributeCount();
		height     = m_height;

		for (i = 0; i < attributes; ++i) {
			type  = object.getLsAttributeTypeAt(i);
			if (type == Attribute.NULL_TYPE) {
				break;
			}

			name  = object.getLsAttributeNameAt(i);
			label = new ShowLabel(name);

			if (i < primary) {
				foreground = Color.blue;
			} else {
				foreground = Color.red;
			}
			label.setForeground(foreground);
			label.setFont(m_textFont);
			left = label;

			right = null;
			value = object.getLsAttributeValueAt(i);
			if (value != null) {
				switch (type) {
				case Attribute.STRING_TYPE:
				case Attribute.TEXT_TYPE:
				case Attribute.DOUBLE_TYPE:
				case Attribute.INT_TYPE:
				case Attribute.ENTITY_CLASS_TYPE:
				case Attribute.RELATION_CLASS_TYPE:
				case Attribute.ATTR_TYPE:
					right = new ShowLabel(value.toString());
					break;
				case Attribute.COLOR_TYPE:
				case Attribute.COLOR_OR_NULL_TYPE:
					right = new ShowAttributeColor((Color) value);
					right.setOpaque(true); // MUST do this for background to show up.
					break;
				case Attribute.ENTITY_IMAGE_TYPE:
					right = new ShowImage(((Integer) value).intValue());
					break;
				case Attribute.ENTITY_STYLE_TYPE:
				{
					int		style = ((Integer) value).intValue();
					String	description;

					if (style < 0 || style >= EntityClass.styleName.length) {
						description = "" + style;
					} else {
						description = EntityClass.styleName[style];
					}
					right = new ShowLabel(description);
					break;
				}
				case Attribute.REL_STYLE_TYPE:
				{
					int		style;
					String	description;

					style = ((Integer) value).intValue();

					if (style < 0 || style >= Util.lineStyleName.length) {
						description = "" + style;
					} else {
						description = Util.lineStyleName[style];
					}
					right = new ShowLabel(description);
					break;
				}
				default:
					right = new ShowLabel("");
			}	}

			height = addBoth(left, right, height);
		}	

		height += 10;

		label = new ShowLabel("Attributes");
		label.setForeground(Color.GREEN);
		left  = label;
		right = new ShowLabel("" + attributes);

		m_height = height = addBoth(left, right, height);

		LandscapeObject parent;

		if (object instanceof LandscapeObject3D) {
			name = ((LandscapeObject3D) object).getId();
		} else {
			name = "Relation";
		}

		for (i = 0; (parent = object.derivedFrom(i)) != null; ++i) {
			height += GAP;
			left  = new ShowLabel("Superclass of");
			right = new ShowLabel(name);

			m_height = addBoth(left, right, height);

			fill(parent);
		}
	}

	public void fill()
	{
		JPanel			left   = m_left;
		JPanel			right  = m_right;

		left.removeAll();
		right.removeAll();

//		System.out.println("AttributeBox fill " + isActive() + " " + m_object);

		if (isActive()) {
			LandscapeObject object = m_object;
			int				i, leftWidth, rightWidth, width, height;
			Component		component;
			double			divider;

			m_leftWidth  = 0;
			m_rightWidth = 0;
			m_height     = 0;
			if (object == null) {
				ShowLabel		leftlabel;
				ShowLabel		rightlabel;
				
				leftlabel  = new ShowLabel("No object");
				rightlabel = new ShowLabel("");
				m_height = addBoth(leftlabel, rightlabel, 10);
			} else {
				fill(object);
			}
			leftWidth  = m_leftWidth;
			rightWidth = m_rightWidth;
			height     = m_height;

			for (i = left.getComponentCount(); --i >= 0; ) {
				component = left.getComponent(i);
				component.setSize(leftWidth, component.getHeight());
			}
			for (i = right.getComponentCount(); --i >= 0; ) {
				component = right.getComponent(i);
				component.setSize(rightWidth, component.getHeight());
			}

			width = leftWidth + rightWidth + 10;

			setBounds(0, 0, width, height);
			left.setBounds(0,  0, leftWidth,  height);
			right.setBounds(0, 0, rightWidth, height);


/*
			width = preferredWidth();

			leftWidth += GAP;

			if (width > 0 && leftWidth < width) {
				divider = ((double) leftWidth) / ((double) width);
			} else {
				divider = 0.5;
			}

			setDividerLocation(divider);
*/
/*
			JViewport viewPort = m_scrollPane.getViewport();

			viewPort.setViewPosition(new Point());
 */
			repaint();
	}	}

	public void show(LandscapeObject object)
	{
		if (m_object != object) {
			m_object = object;
			fill();
	}	}

	// ChangeListener interface

	public void stateChanged(ChangeEvent e) 
	{
//		System.out.println("AttributeBox stateChanged " + isActive());
		fill();
	}
}






