package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

import javax.swing.JComponent;

class Cardinal extends JComponent {

	protected final static int MARGIN = 5; 

	protected int	m_cnt;
	protected int	m_w;	// Width and height of text

	public final static String DEFAULT_CARDINAL_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_CARDINAL_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_CARDINAL_FONT_SIZE  = 9;

	public    static	Font		m_font = FontCache.get(DEFAULT_CARDINAL_FONT_NAME, DEFAULT_CARDINAL_FONT_STYLE, DEFAULT_CARDINAL_FONT_SIZE);

	public	  static	FontMetrics	m_fm   = null;
	public	  static	int			m_h;
	
	public Cardinal()
	{
		super();
		setFont(m_font);
	}

	public static void setDefaultFont(Font font)
	{
		m_font = font;
		m_fm   = null;
	}

	public void reset()
	{
		m_cnt = 0;
	}

	public void sum(RelationInstance ri)
	{
		m_cnt += ri.getFrequency();
	}

	public void known()
	{
		setToolTipText("" + m_cnt);
	}

	public int getCnt()
	{
		return(m_cnt);
	}
	
	public void setBackground(Color color)
	{	
		super.setBackground(color);
		setForeground(ColorCache.getInverse(color.getRGB()));
	}

	// Center at top the cardinal

	public void setCenterTop(int x, int y, int width, int height, double factor)
	{
//		System.out.println("setCenterTop ");

		setFont(m_font);

		if (m_fm == null) {
			m_fm = getFontMetrics(getFont());
			m_h  = m_fm.getAscent();
		}
		x   += ((double) width) * factor;
		y   += height + MARGIN;
		m_w  = m_fm.stringWidth("" + m_cnt);
		this.setBounds(x - (m_w/2) - 2, y, m_w + 4, m_h + 4);
	}

	public void paintComponent(Graphics g)
	{
		int width, height;

//		System.out.println("Cardinal.paint cardinal Component()");
		
		width  = getWidth();
		height = getHeight();

		g.setFont(m_font);
		g.setColor(getBackground());
		g.fillOval(0, 0, width, height);
		g.setColor(Color.black);
		g.drawOval(0, 0, width-1, height-1);
		g.setColor(getForeground());
		g.drawString(""+m_cnt, 2, m_h - 2);

//		System.out.println("Cardinal.paintComponent() done");
	}

	public void removeNotify()
	{
		super.removeNotify();
		setSize(0,0);
	}
	
	public String toString()
	{
		return("Cardinal " + m_cnt);
	}
}
