package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

// Used by legend box

class EntityChkBox extends JComponent
{
	protected static final int GAP    = 5; 
	protected static final int WIDTH  = 45;
	protected static final int HEIGHT = 20;

	protected   JCheckBox			m_checkbox;
	protected	EntityClass			m_ec;
	protected	EntityInstance		m_e;
	protected	int					m_index;
	protected	JLabel				m_label;

	public EntityChkBox(EntityClass ec, int index, int count, int height, boolean value) 
	{
		FlowLayout	flowLayout;
		JCheckBox	checkbox;
		EntityComponent	entityComponent;
		JLabel		label;
		Dimension	d;
		int			bh  = height*2;
		int			bw  = (bh*4)/3;
		String		string;

		flowLayout = new FlowLayout(FlowLayout.LEFT);
		flowLayout.setHgap(GAP);
		setLayout(new FlowLayout(FlowLayout.LEFT));

		m_ec    = ec;
		m_index = index;

		m_checkbox = checkbox = new JCheckBox();
//		checkbox.setBackground(Color.WHITE);
		checkbox.setBorderPaintedFlat(false);
		checkbox.setSelected(ec.isShown());
		checkbox.setEnabled(true);
		checkbox.setVisible(true);
		add(checkbox);

		m_e = ec.newEntity("");

		// This entity isn't counted as part of the set of members in its class
		ec.decrementMembers();
		
		// Explicitly create entity component as a plain component without listeners etc
		// Otherwise automagical creation of this component might assign it listeners,
		// tooltips etc that were not required
		entityComponent = m_e.neededPlainComponent();

		entityComponent.setSize(bw, bh);
		entityComponent.setLocation(0,0);
		entityComponent.setPreferredSize(new Dimension(bw, bh));
		add(entityComponent);

		string = ec.getLabel();
		if (count >= 0) {
			string += " [" + count + "]";
		}

		m_label = label = new JLabel(string);
		if (!ArrowDimensions.isLegendLabelBlack()) {
			label.setForeground(ec.getInheritedLabelColor());
		}
		add(label);

		setToolTipText(ec.getDescription());
	}

	public void setFont(Font font)
	{
		m_label.setFont(font);
	}

	public void addItemListener(ItemListener listener)
	{
		m_checkbox.addItemListener(listener);
	}

	public boolean isSelected()
	{
		return(m_checkbox.isSelected());
	}

	public void doClick()
	{
		m_checkbox.doClick();
	}

	public int getIndex()
	{
		return(m_index);
	}

	public String toString()
	{
		return "EntityChkBox " + m_label.getText();
	}
}
