package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Find extends Object 
{
	protected Vector m_results = new Vector();
	protected int	 m_ind     = 0;

	protected void find(Pattern pattern, EntityClass entityClass, EntityInstance e) 
	{
		Enumeration en;
		EntityInstance	ce;
		Matcher	m;

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();

			if (pattern != null) {
				m = pattern.matcher(ce.getEntityLabel());
				if (!m.matches()) {
					continue;
			}	}
			if (entityClass != null) {
				if (entityClass != ce.getEntityClass()) {
					continue;
			}	}
//			System.out.println("Found " + ce);
			m_results.addElement(ce);
		}	
		for (en = e.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			find(pattern, entityClass, ce);
		}
	}

	/*
	 * Public methods
	 */

	public Find(Pattern pattern, EntityClass entityClass, EntityInstance root) 
	{
		find(pattern, entityClass, root);
	}

	public void clear()
	{
		m_results = null;
	}

	public boolean isEmpty() 
	{
		return m_results.isEmpty();
	}

	public boolean atEnd()
	{
		return (m_ind >= m_results.size());
	}

	public boolean atBeginning()
	{
		return (m_ind <= 0);
	}
	
	public void reset() 
	{
		m_ind = 0;
	}

	public Vector nextResult() 
	{
		if (m_ind < 0 || m_ind >= m_results.size()) {
			return null;
		}

		Vector v = new Vector();
		EntityInstance e  = (EntityInstance) m_results.elementAt(m_ind);
		EntityInstance pe = e.getContainedBy();

		for (; m_ind < m_results.size(); ++m_ind) {
			e = (EntityInstance) m_results.elementAt(m_ind);
			if (e.getContainedBy() != pe) {
				break;
			}
			v.addElement(e);
		} 
		return v;
	}

	public boolean regress() 
	{
		if (m_ind >  0) {
			int orgInd = m_ind;

			// Move back before the start of the last group returned

			EntityInstance e  = (EntityInstance) m_results.elementAt(--m_ind);
			EntityInstance pe = e.getContainedBy();

			for (; --m_ind >= 0; ) {
				e = (EntityInstance) m_results.elementAt(m_ind);
				if (e.getContainedBy() != pe) {
					pe = e.getContainedBy();
					// Move back to the start of the group we want to return
					for (; --m_ind >= 0; ) {
						e = (EntityInstance) m_results.elementAt(m_ind);
						if (e.getContainedBy() != pe) {
							break;
					}	}
					++m_ind;
					return true;
			}	}
			m_ind = orgInd;
		} 
		return false;
	}

	public boolean entityCut()
	{
		int				i, size, newsize;
		EntityInstance	e;

		size = newsize = m_results.size();
		for (i = 0; i < newsize; ) {
			e = (EntityInstance) m_results.elementAt(i);
			if (e.isMarked(EntityInstance.DELETED_MARK)) {
				m_results.remove(i);
				--newsize;
				continue;
			}
			++i;
		}
		if (m_ind > newsize) {
			m_ind = newsize;
		}
		return (size != newsize);
	}
}

