package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import java.util.Enumeration;
import java.util.regex.Pattern;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FindBox extends JDialog implements ActionListener
{
	protected LandscapeEditorCore	m_ls;
	protected JButton				m_findButton, m_helpButton, m_canButton;
	protected JTextField			m_inputField;
	protected JComboBox				m_classes;
	protected JCheckBox				m_caseSensitive;

	protected static String	m_input = "";
	protected Pattern		m_pattern;
	protected EntityClass	m_entityClass;

	public FindBox(JFrame f, LandscapeEditorCore ls, Diagram diagram)
	{
		super(f, "Find Landscape Entities", true);

		JLabel		label;
		EntityClass	entityClass;
		Container	contentPane = getContentPane();
		Font		font, bold;
		Enumeration	e;

		m_ls          = ls;
		m_pattern     = null;
		m_entityClass = null;

		font          = FontCache.getDialogFont();
		bold          = font.deriveFont(Font.BOLD);

		// Create a dialog 

		contentPane.setLayout(new BorderLayout());

		setFont(font);

		label = new JLabel("Any java.util.regex.Pattern:");
		label.setFont(font);
		contentPane.add(label, BorderLayout.NORTH);

		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());

		// Create input component and add it to the window

		m_inputField = new JTextField(m_input, 30);
		m_inputField.setFont(font);
		m_inputField.addActionListener(this);
		p.add(m_inputField, BorderLayout.NORTH);

		m_classes = new JComboBox();
		m_classes.addItem("");
		for (e = diagram.enumEntityClassesInOrder(); e.hasMoreElements(); ) { 
			entityClass = (EntityClass) e.nextElement();
			m_classes.addItem(entityClass);
		}
		p.add(m_classes, BorderLayout.CENTER);

		m_caseSensitive = new JCheckBox("Case sensitive");
		m_caseSensitive.setFont(bold);
		m_caseSensitive.setSelected(true);
		p.add(m_caseSensitive, BorderLayout.SOUTH);

		contentPane.add(p, BorderLayout.CENTER);

		p = new JPanel();
		p.setLayout(new FlowLayout());

		m_findButton = new JButton("Find");
		m_findButton.setFont(bold);
		p.add(m_findButton);
		m_findButton.addActionListener(this);

		m_helpButton = new JButton("Help");
		m_helpButton.setFont(bold);
		p.add(m_helpButton);
		m_helpButton.addActionListener(this);

		m_canButton = new JButton("Cancel");
		m_canButton.setFont(bold);
		p.add(m_canButton);
		m_canButton.addActionListener(this);

		contentPane.add(p, BorderLayout.SOUTH);

		// Resize the window to the preferred size of its components

		this.pack();

		if (f != null) {	// ie. not an applet
			setLocation(f.getX()+200, f.getY()+300);
		}
		setVisible(true);
	}

	public Pattern pattern() 
	{
		return(m_pattern);
	}

	public boolean parsePattern() 
	{
		String	input = m_input;
		boolean	ret   = true;
		Pattern pattern;
		int		flags;

		pattern = null;
		if (input != null && !input.equals("") && !input.equals("*")) {
			try {
				if (m_caseSensitive.isSelected()) {
					flags = 0;
				} else {
					flags = Pattern.CASE_INSENSITIVE;
				}
				flags |= Pattern.DOTALL;
				
				pattern = Pattern.compile(input, flags);
			} catch (Exception e) {

				JOptionPane.showMessageDialog(this, "Syntax error is regular expression '" + input + "'", "Error", JOptionPane.OK_OPTION);
				pattern = null;
				ret     = false;
		}	}
		m_pattern = pattern;
		return ret;
	}

	public EntityClass entityClass()
	{
		return m_entityClass;
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object	source;

		// Pop down the window when the button is clicked.
		// System.out.println("event: " + ev);

		source = ev.getSource();

		if (source == m_helpButton) {
			m_ls.showURL("http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html", LsLink.TARGET_HELP);
			return;
		}

		if (source == m_inputField || source == m_findButton || source == m_canButton) {
			m_input = m_inputField.getText();
			if (source != m_canButton) {
				int	selected;

				if (!parsePattern()) {
					return;
				}
				selected  = m_classes.getSelectedIndex();
				if (selected > 0) {
					m_entityClass = (EntityClass) m_classes.getSelectedItem();
			}	}
			this.setVisible(false);
		}
		return;
	}
}

