package lsedit;

import java.util.Enumeration;



public class FlipLayoutHorizontally extends LandscapeLayouter implements ToolBarEventHandler {

	public FlipLayoutHorizontally(LandscapeEditorCore ls) 
	{
		super(ls);
	}

	public String getName()
	{
		return "FlipHorizontal";
	}

	public String getMenuLabel() 
	{
		return "Flip layout horizontally";
	}

	public String doLayout(Diagram diagram) 
	{
		EntityInstance pe = diagram.getDrawRoot();
		Enumeration en;
		EntityInstance ce;

		diagram.beginUndoRedo("Flip Layout Horizontally");
		for (en = pe.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			diagram.updateXRelLocal(ce, 1.0 - ce.xRelLocal() - ce.widthRelLocal());
		}
		diagram.endUndoRedo();
		return "Layout flipped horizontally";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram				dg;
		String				rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
	}	}
}

