package lsedit;

import java.util.Enumeration;



public class FlipLayoutVertically extends LandscapeLayouter  implements ToolBarEventHandler 
{
	public FlipLayoutVertically(LandscapeEditorCore ls) 
	{
		super(ls);
	}

	public String getName()
	{
		return "FlipVertical";
	}

	public String getMenuLabel() 
	{
		return "Flip layout vertically";
	}

	public String doLayout(Diagram diagram) 
	{
		EntityInstance pe = diagram.getDrawRoot();
		Enumeration en;
		EntityInstance ce;

		for (en = pe.getChildren(); en.hasMoreElements();) {
			ce = (EntityInstance) en.nextElement();
			diagram.updateYRelLocal(ce, 1.0 - ce.yRelLocal() - ce.heightRelLocal());
		}
		return "Layout flipped vertically";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			dg.beginUndoRedo("Flip Vertically");
			rmsg = doLayout(dg);
			dg.endUndoRedo();
			m_ls.doFeedback(rmsg);
	}	}

}

