package lsedit;

import java.awt.Container;
import java.awt.Color;
import java.awt.BorderLayout;

import javax.swing.JApplet;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
Subject: Solution to how one debugs a Java applet

c:\j2sdk1.4.2_04\bin\appletviewer.exe -debug index.htm

This brings the java applet up in the htm file, while bring the invoker of
this command up inside jdb.  One can then breakpoint the execution al-la
a normal java program.  Worth knowing... Ian
*/

public class LandscapeViewer extends JApplet {

	static String parameter_info[][] = 
	{
		{"test",		"string",	"test applet can display string"},
		{"lsfile",		"url",		"load this ta file"},
		{"init",		"url",		"load this init file"},
		{"toolabout",	"url",		"URL linked to F11"},
		{"toolhelp",	"url",		"URL linked to F12"},
		{"startEntity",	"string",	"Entity to first show"},
		{"lsfile_bg0",  "url",		"URL of additional loadable TA file"},
		{"lsfile_bg<n>","url",	    "URL of additional loadable TA files"}
	};

	/* Implements the browser version of the editor */

	LandscapeEditorCore	m_ls;

	private void createGUI()
	{
		String	msg = null;

		try {
			msg = getParameter("test");

			if (msg == null) {

				int			num;

				m_ls = new LandscapeEditorCore(this);
				setJMenuBar(m_ls.genMenu());

				// Obtain the arguments (passed as applet tag params) 

				m_ls.m_lsPath = getParameter("lsfile");
				m_ls.m_lsInit = getParameter("init");

				for (num = 0;;++num) {
					String f = getParameter("lsfile_bg" + num);
					if (f == null || f.length() == 0) {
						break;
					}
//					System.out.println(f);
					m_ls.addLseditHistory(f);
				}
		
				m_ls.m_aboutURL    = getParameter("toolabout");
				m_ls.m_helpURL	   = getParameter("toolhelp");
				m_ls.m_startEntity = getParameter("startEntity");

				m_ls.init_core(0, 0);
			}
		} catch (Exception e) {
			StackTraceElement[] stack = e.getStackTrace();
			int					i;

			msg = e.toString() + "\n\n";
			for (i = stack.length; i > 0; ) {
				msg += stack[--i].toString() + "\n";
			}
		}

		if (msg != null) {

			Container	contentPane;
			int			w, h;

			contentPane = getContentPane();
			contentPane.removeAll();
			w = contentPane.getWidth();
			h = contentPane.getHeight();

			JScrollPane scrollPane =  new JScrollPane();	// Set null to disable scrolling

			JTextArea textArea = new JTextArea(msg);
			textArea.setBackground(Color.pink);
			textArea.setToolTipText(msg);
			textArea.setEditable(false);
			textArea.setLineWrap(true);
			textArea.setWrapStyleWord(true);
			textArea.setSize(w, h);

			if (scrollPane != null) {
				scrollPane.setSize(w, h);
				scrollPane.setViewportView(textArea);
				contentPane.add(scrollPane,BorderLayout.CENTER);
			} else {
				contentPane.add(textArea,BorderLayout.CENTER);
		}	}
		setVisible(true);
	}

	public void init() 
	{
		if (m_ls == null) {
			//Execute a job on the event-dispatching thread:
			//creating this applet's GUI.
			try {
				javax.swing.SwingUtilities.invokeAndWait(
					new Runnable() 
					{
						public void run() 
						{
							createGUI();
						}
					});
			} catch (Exception e) {
				System.err.println("createGUI didn't successfully complete");
		}	}
	}

	/*
		Returns information about this applet. An applet should override this method to return a String containing information 
		about the author, version, and copyright of the applet. 
	 */

	public String getAppletInfo()
	{
		return Version.authorsAndCopyright();
	}

	public String[][] getParameterInfo()
	{
		return parameter_info;
	}
}
