package lsedit;

import java.util.Vector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import java.util.Enumeration;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DisplayClassHierarchy implements ActionListener
{
	private	LandscapeEditorCore		m_ls;
	private LandscapeClassObject	m_landscapeClass;
	int								m_x;
	int								m_y;
	JPopupMenu						m_popup = null;


	public DisplayClassHierarchy(LandscapeEditorCore ls, LandscapeClassObject landscapeClass, int x, int y)
	{
		m_ls             = ls;
		m_landscapeClass = landscapeClass;
		m_x				 = x;
		m_y				 = y;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore	ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_editInheritanceRules_text)) {
				return;
		}	}

		LandscapeClassObject	o      = m_landscapeClass;
		ClassInherits			dialog = new ClassInherits(m_ls, o);

		dialog.setLocation(m_x, m_y);
		dialog.setVisible(true);

		Vector	value   = dialog.getResult();

		if (value != null) {
			Diagram		diagram = ls.getDiagram();

			diagram.doUpdateInherits(o, value);
		}
}	}

class EditClassAttributes implements ActionListener
{
	private	LandscapeEditorCore	m_ls;
	private EntityClass			m_entity;

	public EditClassAttributes(LandscapeEditorCore ls, EntityClass entity)
	{
		m_ls        = ls;
		m_entity    = entity;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore	ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_editClassAttributes_text)) {
				return;
		}	}

		EditAttribute.Create(ls, m_entity);
		ls.repaint();
}	}

class ShowValidAttributes implements ActionListener
{
	private	LandscapeEditorCore	 m_ls;
	private LandscapeClassObject m_o;

	public ShowValidAttributes(LandscapeEditorCore ls, LandscapeClassObject o)
	{
		m_ls = ls;
		m_o  = o;
	}

	public void actionPerformed(ActionEvent ev)
	{
		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (m_ls.processMetaKeyEvent(LegendBox.g_showValidAttributes_text)) {
				return;
		}	}
		m_ls.showValidAttributes(m_o);
}	}

class CheckEntityAttributes implements ActionListener
{
	private	LandscapeEditorCore	m_ls;
	private EntityClass			m_ec;

	public CheckEntityAttributes(LandscapeEditorCore ls, EntityClass ec)
	{
		m_ls = ls;
		m_ec = ec;
	}

	public void actionPerformed(ActionEvent ev)
	{
		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (m_ls.processMetaKeyEvent(LegendBox.g_validateAttributes_text)) {
				return;
		}	}
		m_ls.validateEntityAttributes(m_ec);
}	}

class CheckRelationAttributes implements ActionListener
{
	private	LandscapeEditorCore	m_ls;
	private RelationClass		m_rc;

	public CheckRelationAttributes(LandscapeEditorCore ls, RelationClass rc)
	{
		m_ls = ls;
		m_rc = rc;
	}

	public void actionPerformed(ActionEvent ev)
	{
		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (m_ls.processMetaKeyEvent(LegendBox.g_validateAttributes_text)) {
				return;
		}	}
		m_ls.validateRelationAttributes(m_rc);
}	}

class CheckRelations implements ActionListener
{
	private	LandscapeEditorCore	m_ls;
	private RelationClass		m_rc;

	public CheckRelations(LandscapeEditorCore ls, RelationClass rc)
	{
		m_ls = ls;
		m_rc = rc;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore	ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_validateRelations_text)) {
				return;
		}	}
		ls.validateRelationAttributes(m_rc);
		ls.validateRelations(m_rc);
}	}


class EditRelationClassAttributes implements ActionListener
{
	private LandscapeEditorCore		m_ls;
	private RelationClass			m_relation;

	public EditRelationClassAttributes(LandscapeEditorCore ls, RelationClass relation)
	{
		m_ls	   = ls;
		m_relation = relation;
	}

	public void actionPerformed(ActionEvent ev)
	{
		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (m_ls.processMetaKeyEvent(LegendBox.g_editClassAttributes_text)) {
				return;
		}	}
		EditAttribute.Create(m_ls, m_relation);
		m_ls.repaint();
}	}

class DeleteEntityClass implements ActionListener
{
	private LandscapeEditorCore	m_ls;
	private EntityClass			m_ec;

	public DeleteEntityClass(LandscapeEditorCore ls, EntityClass ec)
	{
		m_ls = ls;
		m_ec = ec;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;
		EntityClass ec      = m_ec;
		Diagram		diagram = ls.getDiagram();
		EntityInstance rootInstance;
		Enumeration en;
		EntityClass	ec1;
		String		message = null;
		int			cnt;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent("Delete Entity Class")) {
				return;
		}	}

		for (en = diagram.enumEntityClasses(); en.hasMoreElements(); ) {
			ec1 = (EntityClass) en.nextElement();
			if (ec != ec1 && ec1.directlyInheritsFrom(ec)) {
				if (message != null) {
					message += ", ";
				} else {
					message = "";
				}
				message += ec1.getLabel();
		}	}
		if (message != null) {
			message += " inherit from " + ec.getLabel();
		} else {
			rootInstance = diagram.getRootInstance();
			if (rootInstance != null && rootInstance.getEntityClass() == ec) {
				message = "Root instance has class " + ec.getLabel();
			} else {
				diagram.recomputeCounts();
				cnt = ec.countMembers();

				if (cnt != 0) {
					message = ec.getLabel() + " has " + cnt + " instantiations";
		}	}	}
	
		if (message != null) {
			JOptionPane.showConfirmDialog(null, message, "Can't delete entity class", JOptionPane.DEFAULT_OPTION);
			return;
		}

		switch (JOptionPane.showConfirmDialog(null, "Delete class " + ec.getLabel(), "Delete all " + ec.getLabel() + " entities", JOptionPane.YES_NO_CANCEL_OPTION)) {
		case JOptionPane.YES_OPTION:
			diagram.doUpdateRemoveEntityClass(ec);
			break;
		case JOptionPane.NO_OPTION:
			break;
		}
		ls.repaint();
}	}

class DeleteRelationClass implements ActionListener
{
	private LandscapeEditorCore	m_ls;
	private RelationClass		m_rc;

	public DeleteRelationClass(LandscapeEditorCore ls, RelationClass rc)
	{
		m_ls = ls;
		m_rc = rc;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent("Delete Relation Class")) {
				return;
		}	}


		RelationClass	rc      = m_rc;
		Diagram			diagram = ls.getDiagram();
		Enumeration		en;
		RelationClass	rc1;
		int				cnt;
		String			message = null;


		for (en = diagram.enumRelationClasses(); en.hasMoreElements(); ) {
			rc1 = (RelationClass) en.nextElement();
			if (rc != rc1 && rc1.directlyInheritsFrom(rc)) {
				if (message != null) {
					message += ", ";
				} else {
					message  = "";
				}
				message += rc1.getLabel();
		}	}
		if (message != null) {
			message += " inherit from " + rc.getLabel();
		} else {
			diagram.recomputeCounts();
			cnt = rc.countMembers();
			if (cnt != 0) {
				message = rc.getLabel() + " has " + cnt + " instantiations";
		}	}

		if (message != null) {
			JOptionPane.showConfirmDialog(null, message, "Can't delete relation class", JOptionPane.DEFAULT_OPTION);
			return;
		}

		switch (JOptionPane.showConfirmDialog(null, "Delete class " + rc.getLabel(), "Delete all " + rc.getLabel() + " edges", JOptionPane.YES_NO_CANCEL_OPTION)) {
		case JOptionPane.YES_OPTION:
			diagram.doUpdateRemoveRelationClass(rc);
			break;
		case JOptionPane.NO_OPTION:
			return;
		default:
			return;
		}
}	}

class ShowConstraintsMatrix implements ActionListener
{
	private LandscapeEditorCore	m_ls;
	private RelationClass		m_rc;

	public ShowConstraintsMatrix(LandscapeEditorCore ls, RelationClass rc)
	{
		m_ls = ls;
		m_rc = rc;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_editRelationConstraints_text)) {
				return;
		}	}

		EditConstraints.create(ls.getDiagram(), m_rc);
}	}

class ShowConstraintsClosure implements ActionListener
{
	private LandscapeEditorCore	m_ls;
	private RelationClass		m_rc;

	public ShowConstraintsClosure(LandscapeEditorCore ls, RelationClass rc)
	{
		m_ls = ls;
		m_rc = rc;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_closureOfConstraints_text)) {
				return;
		}	}

		ClosureConstraints.create(ls.getDiagram(), m_rc);
}	}


class SetDefaultEntityClass implements ActionListener
{
	private LandscapeEditorCore	m_ls;
	private EntityClass			m_ec;

	public SetDefaultEntityClass(LandscapeEditorCore ls, EntityClass ec)
	{
		m_ls = ls;
		m_ec = ec;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_createEntitiesOfThisClass_text)) {
				return;
		}	}

		ls.getDiagram().setDefaultEntityClass(m_ec);
}	}

class SetDefaultRelationClass implements ActionListener
{
	private LandscapeEditorCore	m_ls;
	private RelationClass		m_rc;

	public SetDefaultRelationClass(LandscapeEditorCore ls, RelationClass rc)
	{
		m_ls = ls;
		m_rc = rc;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_createEdgesOfThisClass_text)) {
				return;
		}	}

		ls.getDiagram().setDefaultRelationClass(m_rc);
}	}


class SetContainsRelation implements ActionListener
{
	private LandscapeEditorCore	m_ls;
	private RelationClass		m_relation;

	public SetContainsRelation(LandscapeEditorCore ls, RelationClass relation)
	{
		m_ls	   = ls;
		m_relation = relation;
	}

	public void actionPerformed(ActionEvent ev)
	{
		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (m_ls.processMetaKeyEvent(LegendBox.g_formsHierarchy_text)) {
				return;
		}	}
		m_ls.updateContainsRelation(m_relation);
	}
}

class DisplayEditElisions implements ActionListener
{
	private	LandscapeEditorCore	m_ls;

	public DisplayEditElisions(LandscapeEditorCore ls)
	{
		m_ls = ls;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore	ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(LegendBox.g_editElisionRules_text)) {
				return;
		}	}

		EditElisions dialog = new EditElisions(ls.getFrame(), ls);

		dialog.dispose();
}	}

class ShownEntityChkBox extends EntityChkBox implements ItemListener, MouseListener
{
	private		LegendBox			m_legendBox;
	protected	JPopupMenu			m_popup = null;

	public ShownEntityChkBox(LegendBox legendBox, EntityClass ec, int index, int count, int h, Font font) 
	{
		super(ec, index, count, h, false);

		m_legendBox = legendBox;
		setFont(font);
		addItemListener(this);
		addMouseListener(this);
	}

	public boolean isActive()
	{
		return m_ec.isShown();
	}

	public void setActive(boolean value)
	{
		if (m_ec.isShown() != value) {
			m_ec.setShown(value);
			m_legendBox.getLs().refillDiagram();
	}	}

	public void itemStateChanged(ItemEvent ev)
	{
//		System.out.println("ShownEntityChkBox.itemStateChanged " + ev.getStateChange() + " " + isSelected());
		setActive(ev.getStateChange() == ItemEvent.SELECTED);
	}


	// MouseListener interface

	public void mouseClicked(MouseEvent e)
	{
	}

	public void mouseEntered(MouseEvent e)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
		if (ev.isMetaDown()) {
			int					x  = ev.getX();
			int					y  = ev.getY();

			if (m_popup == null) {
				LegendBox			legendBox = m_legendBox;
				LandscapeEditorCore	ls        = legendBox.getLs();
				Diagram				diagram   = ls.getDiagram();
				EntityClass			ec        = m_ec;
				JMenuItem	mi;

				m_popup = new JPopupMenu("Class menu");

				mi = new JMenuItem(LegendBox.g_editInheritanceRules_text);
				mi.addActionListener(new DisplayClassHierarchy(ls, ec, x, y)); 
				m_popup.add(mi);

				mi = new JMenuItem(LegendBox.g_editClassAttributes_text);
				mi.addActionListener(new EditClassAttributes(ls, ec)); 
				m_popup.add(mi);

				mi = new JMenuItem(LegendBox.g_showValidAttributes_text);
				mi.addActionListener(new ShowValidAttributes(ls, ec)); 
				m_popup.add(mi);

				mi = new JMenuItem(LegendBox.g_validateAttributes_text);
				mi.addActionListener(new CheckEntityAttributes(ls, ec)); 
				m_popup.add(mi);

				mi = new JMenuItem(LegendBox.g_createEntitiesOfThisClass_text);
				mi.addActionListener(new SetDefaultEntityClass(ls, ec));
				m_popup.add(mi);

				if (m_ec != diagram.m_entityBaseClass) {
					mi = new JMenuItem("Delete entity class " + ec.getLabel());
					mi.addActionListener(new DeleteEntityClass(ls, ec));
					m_popup.add(mi);
				}
				legendBox.add(m_popup);
			}
			FontCache.setMenuTreeFont(m_popup); 

//			Do.dump_menu(m_popup);
			m_popup.show(this, x, y);
	}	}

	public void mouseReleased(MouseEvent ev) 
	{
	}
}
	
class ShownRelnChkBox extends RelnChkBox /* extends JComponent */ implements ItemListener, MouseListener
{
	protected	LegendBox	m_legendBox;
	protected	JPopupMenu	m_popup;

	public ShownRelnChkBox(LegendBox legendBox, RelationClass rc,  int index, int count, Font font) 
	{
		super(rc, index, count, rc.isClassShown(), font); 
		m_legendBox = legendBox;

		addItemListener(this);
		addMouseListener(this);
	}

	public boolean isContainsClass()
	{
		return (m_rc.isContainsClass());
	}

	public boolean isActive()
	{
		return(m_rc.isClassShown());
	}

	public void setActive(boolean value)
	{
		if (isActive() != value) {
			m_rc.setShown(value);
			m_legendBox.getLs().refillDiagram();
	}	}

	public void itemStateChanged(ItemEvent ev)
	{
//		System.out.println("ShownRelnChkBox.itemStateChanged " + ev.getStateChange() + " " + isSelected());
		setActive(ev.getStateChange() == ItemEvent.SELECTED);
	}

	// MouseListener interface

	public void mouseClicked(MouseEvent e)
	{
	}

	public void mouseEntered(MouseEvent e)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
		if (ev.isMetaDown()) {

			LegendBox			legendBox = m_legendBox;
			LandscapeEditorCore	ls        = legendBox.getLs();
			Diagram				diagram   = ls.getDiagram();
			int					x         = ev.getX();
			int					y         = ev.getY();
			RelationClass		rc        = m_rc;

			JMenuItem	mi;

			m_popup = new JPopupMenu("Relation menu");

			mi = new JMenuItem(LegendBox.g_editInheritanceRules_text);
			mi.addActionListener(new DisplayClassHierarchy(ls, rc, x, y)); 
			m_popup.add(mi);

			mi = new JMenuItem(LegendBox.g_editClassAttributes_text);
			mi.addActionListener(new EditRelationClassAttributes(ls, rc)); 
			m_popup.add(mi);

			mi = new JMenuItem(LegendBox.g_editRelationConstraints_text);
			mi.addActionListener(new ShowConstraintsMatrix(ls, rc));
			m_popup.add(mi);

			mi = new JMenuItem(LegendBox.g_closureOfConstraints_text);
			mi.addActionListener(new ShowConstraintsClosure(ls, rc));
			m_popup.add(mi);

			mi = new JMenuItem(LegendBox.g_showValidAttributes_text);
			mi.addActionListener(new ShowValidAttributes(ls, rc)); 
			m_popup.add(mi);

			mi = new JMenuItem(LegendBox.g_validateAttributes_text);
			mi.addActionListener(new CheckRelationAttributes(ls, rc)); 
			m_popup.add(mi);

			mi = new JMenuItem(LegendBox.g_validateRelations_text);
			mi.addActionListener(new CheckRelations(ls, rc)); 
			m_popup.add(mi);

			if (!rc.isContainsClass()) {

				if (rc != diagram.m_relationBaseClass) {
					mi = new JMenuItem("Delete relation class " + rc.getLabel());
					mi.addActionListener(new DeleteRelationClass(ls, rc));
					m_popup.add(mi);
				}

				mi = new JMenuItem(LegendBox.g_createEdgesOfThisClass_text);
				mi.addActionListener(new SetDefaultRelationClass(ls, rc));
				m_popup.add(mi);

				mi = new JMenuItem(LegendBox.g_formsHierarchy_text);
				mi.addActionListener(new SetContainsRelation(ls, rc)); 
				m_popup.add(mi);
			}

			FontCache.setMenuTreeFont(m_popup); 
			legendBox.add(m_popup);
//			Do.dump_menu(m_popup);
			m_popup.show(this, x, y);
	}	}
	
	public void mouseReleased(MouseEvent ev) 
	{
	}
}

public class LegendBox extends TabBox /* extends JComponent */ implements ChangeListener, TaListener, MouseListener 
{
	public static final String g_editInheritanceRules_text		= "Edit inheritance rules";
	public static final String g_editClassAttributes_text		= "Edit Class Attributes";
	public static final String g_showValidAttributes_text		= "Show valid attributes";
	public static final String g_validateAttributes_text		= "Validate attributes";
	public static final String g_empty_classes					= "Empty Classes";
	public static final String g_member_counts					= "Member Counts";
	public static final String g_createEntitiesOfThisClass_text = "Create entities of this class";
	public static final String g_editRelationConstraints_text   = "Edit relation constraints";
	public static final String g_closureOfConstraints_text		= "Closure of constraints";
	public static final String g_validateRelations_text			= "Validate relations";
	public static final String g_createEdgesOfThisClass_text	= "Create relations of this class";
	public static final String g_formsHierarchy_text			= "Forms Hierarchy";
	public static final String g_editElisionRules_text          = "Edit Elision Rules";

	protected static final int MARGIN = 5;
	protected static final int GAP    = 5; 

	public final static String DEFAULT_LEGEND_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_LEGEND_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_LEGEND_TITLE_FONT_SIZE  = 12;

	protected static Font	m_titleFont  = FontCache.get(DEFAULT_LEGEND_TITLE_FONT_NAME, DEFAULT_LEGEND_TITLE_FONT_STYLE, DEFAULT_LEGEND_TITLE_FONT_SIZE);

	public final static String DEFAULT_LEGEND_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_LEGEND_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_LEGEND_TEXT_FONT_SIZE  = 11;

	protected static Font   m_textFont	 = FontCache.get(DEFAULT_LEGEND_TEXT_FONT_NAME, DEFAULT_LEGEND_TEXT_FONT_STYLE, DEFAULT_LEGEND_TEXT_FONT_SIZE);

	public    static final String m_helpStr	 = "This box shows the types of entities and relations that are present in the current landscape.";

	protected JLabel				m_ulabel;	// TODO underline it
	protected JLabel				m_elabel1;
	protected JLabel				m_elabel2;
	protected JLabel				m_rlabel;	// TODO underline it
	protected JLabel				m_clabel;
	protected JLabel				m_flabel1;
	protected JLabel				m_flabel2;

	protected int					m_width;
	protected int					m_height;

	protected boolean				m_refill  = false;
	protected boolean				m_badcnts = false;

	// ------------------
	// JComponent methods
	// ------------------

/*
	public void setBounds(int x, int y, int width, int height)
	{
		super.setBounds(x,y,width,height);
		System.out.println("Legend size " + getBounds());
		return;
	}
*/
	public Dimension getPreferredSize()
	{
		return(getSize());
	}

/*
	public Dimension getMinimumSize()
	{
		return(getSize());
	}
*/
	
	public Dimension getMaximumSize()
	{
		return(getSize());
	}

	protected void add(JComponent component)
	{
		Dimension	d;
		int			width, height;

		d      = component.getPreferredSize();
		width  = d.width;
		height = d.height;
		if (width > m_width) {
//			System.out.println("Width=" + width + " for " + component);
			m_width = width;
		}
		component.setBounds(MARGIN, m_height, width, height);
		super.add(component);
		m_height += height;
	}

	// --------------
	// Public methods 
	// --------------

	public LegendBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		super(ls, tabbedPane, "Legend", m_helpStr);

		m_ulabel = new JLabel("Entity Classes");
		m_ulabel.setForeground(Color.red);
		m_ulabel.setFont(m_titleFont);

		m_elabel1 = new JLabel("Pass cursor over entity for description.");
		m_elabel1.setForeground(Color.black);
		m_elabel1.setFont(m_textFont);

		m_elabel2 = new JLabel("Right click for menu.");
		m_elabel2.setForeground(Color.black);
		m_elabel2.setFont(m_textFont);

		m_rlabel = new JLabel("Relation Classes");
		m_rlabel.setForeground(Color.red);
		m_rlabel.setFont(m_titleFont);

		m_clabel = new JLabel("Hierarchy");
		m_clabel.setForeground(Color.red);
		m_clabel.setFont(m_titleFont);

		m_flabel1 = new JLabel("Checkboxes select visible relations.");
		m_flabel1.setForeground(Color.black);
		m_flabel1.setFont(m_textFont);

		m_flabel2 = new JLabel("Right click for menu.");
		m_flabel2.setForeground(Color.black);
		m_flabel2.setFont(m_textFont);

		tabbedPane.addChangeListener(this);
		addMouseListener(this);
	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public void titleFontChanged(Font font)
	{
		m_ulabel.setFont(font);
		m_rlabel.setFont(font);
		fill();
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void textFontChanged(Font font)
	{
		m_elabel1.setFont(font);
		m_elabel2.setFont(font);
		m_flabel1.setFont(font);
		m_flabel2.setFont(font);
		fill();
	}

	public void fill()
	{
/*		System.out.println("LegendBox.fill()");
		java.lang.Thread.dumpStack();
		System.out.println("-----");
*/

		removeAll();
		m_width  = 0;
		m_height = 0;

		if (isActive()) {
			LandscapeEditorCore	ls             = m_ls;
			Diagram				diagram        = ls.getDiagram();
			FontMetrics			fontMetrics;
			Enumeration			en;
			int					item,n,h;
			JViewport			viewport;
			int					width, height;
			RelationClass		contains;
			int					cnt;
			boolean				isHideEmpty    = m_ls.isHideEmpty();
			boolean				isMemberCounts = m_ls.isMemberCounts();
			boolean				usesCounts     = isHideEmpty || isMemberCounts;
			Font				textFont       = m_textFont;

			if (usesCounts) {
				diagram.recomputeCounts();
			}

			// Draw legend for entities

			item = 0;
			n	 = 0;

			fontMetrics = getFontMetrics(textFont);
			h           = fontMetrics.getHeight();

			EntityClass ec;

			m_height += 10;
			add(m_ulabel);
			cnt       = -1;

			if (diagram != null) {
				for (en = diagram.enumEntityClassesInOrder(); en.hasMoreElements(); ) {
					ec = (EntityClass) en.nextElement();

					if (usesCounts) {
						cnt = ec.countMembers();
						if (isHideEmpty && cnt == 0) {
							continue;
						}
						if (!isMemberCounts) {
							cnt = -1;
					}	}
					m_height += 10;
					add(new ShownEntityChkBox(this, ec, ++n, cnt, h, textFont));
			}	}

			m_height += 10;
			add(m_elabel1);
			add(m_elabel2);
			m_height += 20;
			add(m_rlabel);

			// Draw legend for relations

			m_height += GAP;

			n = 0;
			contains = null;
			if (diagram != null) {
				for (en = diagram.enumRelationClassesInOrder(); en.hasMoreElements(); ) {
					RelationClass rc = (RelationClass) en.nextElement();

					if (rc.isContainsClass()) {
						contains = rc;
					} else {
						if (usesCounts) {
							cnt = rc.countMembers();
							if (isHideEmpty && cnt == 0) {
								continue;
							}
							if (!isMemberCounts) {
								cnt = -1;
						}	}
						add(new ShownRelnChkBox(this, rc, ++n, cnt, m_textFont));
			}	}	}

			if (contains != null) {
				m_height += 10;
				add(m_clabel);
				m_height += GAP;
				add(new ShownRelnChkBox(this, contains, -1, -1, m_textFont));
			}

			m_height += 20;
			add(m_flabel1);
			add(m_flabel2);

			// Max width is computed in the add() method
			m_width  += MARGIN;
			m_height += 10;
		}
		setBounds(0, 0, m_width, m_height);
	}	

	public void toggleRelationVisibility(int key) 
	{
		int				cnt = getComponentCount();
		int				i;
		Component		c;
		boolean			ns;

		ns = true;
		if (key == 0) {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ShownRelnChkBox) {
					if ( ((ShownRelnChkBox) c).getIndex() == 1) {
						// Change everything the same way as the way the first one changed
						ns = !((ShownRelnChkBox) c).isActive();
						break;
			}	}	}

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ShownRelnChkBox) {
					if (ns != ((ShownRelnChkBox) c).isActive()) {
						((ShownRelnChkBox) c).doClick();
			}	}	}
		} else {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ShownRelnChkBox) {
					if (((ShownRelnChkBox) c).getIndex() == key) {
						((ShownRelnChkBox) c).doClick();
						break;
		}	}	}	}
	}

	private class SetEntitiesShown implements ActionListener
	{
		boolean	m_active;

		public SetEntitiesShown(boolean active)
		{
			m_active = active;
		}

		public void actionPerformed(ActionEvent ev)
		{
			if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
				if (m_ls.processMetaKeyEvent("Set Entities Shown")) {
					return;
			}	}

			int				cnt    = getComponentCount();
			boolean			active = m_active;
			int				i;
			Component		c;
			ShownEntityChkBox	box;

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ShownEntityChkBox) {
					box = (ShownEntityChkBox) c;
					if (box.isActive() != active) {
						box.doClick();
		}	}	}	}	
	}

	private class SetRelationsShown implements ActionListener
	{
		boolean	m_active;

		public SetRelationsShown(boolean active)
		{
			m_active = active;
		}

		public void actionPerformed(ActionEvent ev)
		{
			if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
				if (m_ls.processMetaKeyEvent("Set Relations Shown")) {
					return;
			}	}

			int				cnt    = getComponentCount();
			boolean			active = m_active;
			int				i;
			Component		c;
			ShownRelnChkBox	box;

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ShownRelnChkBox) {
					box = (ShownRelnChkBox) c;
					if (!box.isContainsClass() && box.isActive() != active) {
						box.doClick();
		}	}	}	}	
	}

	class ToggleEmptyClasses implements ActionListener
	{
		public ToggleEmptyClasses()
		{
		}

		public void actionPerformed(ActionEvent ev)
		{
			if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
				if (m_ls.processMetaKeyEvent(g_empty_classes)) {
					return;
			}	}
			m_ls.setHideEmpty(!m_ls.isHideEmpty());
			fill();
	}	}

	class ToggleMemberCounts implements ActionListener
	{
		public ToggleMemberCounts()
		{
		}

		public void actionPerformed(ActionEvent ev)
		{
			if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
				if (m_ls.processMetaKeyEvent(g_member_counts)) {
					return;
			}	}
			m_ls.setMemberCounts(!m_ls.isMemberCounts());
			fill();
	}	}

	// ChangeListener interface

	public void stateChanged(ChangeEvent e) 
	{
//		System.out.println("LegendBox stateChanged " + isActive());
		fill();
	}

	// TaListener interface

	public void diagramChanged(Diagram diagram)
	{
		fill();
	}

	public void updateBegins()
	{
	}

	public void updateEnds()
	{
		if (m_badcnts) {
			m_badcnts = false;
			if (!m_refill) {
				LandscapeEditorCore ls = m_ls;

				if (!ls.isMemberCounts() && !ls.isHideEmpty()) {
					return;
			}	}
		} else if (!m_refill) {
			return;
		}

		m_refill = false;
		fill();
	}		

	public void entityClassChanged(EntityClass ec, int signal)
	{
		m_refill = true;
	}

	public void relationClassChanged(RelationClass rc, int signal)
	{
		m_refill = true;
	}

	public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal)
	{
		m_badcnts = true;
	}

	public void relationParentChanged(RelationInstance ri, int signal)
	{
		m_badcnts = true;
	}

/*
	public void entityInstanceChanged(EntityInstance e, int signal)
	{
	}

	public void relationInstanceChanged(RelationInstance ri, int signal)
	{
	}
*/

	// Generic 	MouseListener interface

	protected void doRightPopup(MouseEvent ev)
	{
		LandscapeEditorCore	ls  = m_ls;
		Diagram			diagram = ls.getDiagram();
		Enumeration		en;
		EntityClass		ec;
		RelationClass	rc;
		int				x, y;
		JPopupMenu		popupMenu;
		JMenuItem		mi;
		String			string;
				
		x         = ev.getX();
		y         = ev.getY();
		popupMenu = new JPopupMenu("Legend options");

		for (en = diagram.enumEntityClasses(); en.hasMoreElements(); ) {
			ec = (EntityClass) en.nextElement();
			if (ec.isShown()) {
				mi = new JMenuItem("No entities shown");
				mi.addActionListener(new SetEntitiesShown(false));
				popupMenu.add(mi);
				break;
		}	}

		for (en = diagram.enumEntityClasses(); en.hasMoreElements(); ) {
			ec = (EntityClass) en.nextElement();
			if (!ec.isShown()) {				
				mi = new JMenuItem("All entities shown");
				mi.addActionListener(new SetEntitiesShown(true));
				popupMenu.add(mi);
				break;
		}	}
	
		for (en = diagram.enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			if (!rc.isContainsClass() && rc.isShown()) {
				mi = new JMenuItem("No relations shown");
				mi.addActionListener(new SetRelationsShown(false));
				popupMenu.add(mi);
				break;
		}	}

		for (en = diagram.enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			if (!rc.isContainsClass() && !rc.isShown()) {
				mi = new JMenuItem("All relations shown");
				mi.addActionListener(new SetRelationsShown(true));
				popupMenu.add(mi);
				break;
		}	}

		Do.createClassMenuItem(popupMenu, ls);

		if (ls.isHideEmpty()) {
			string = "Show ";
		} else {
			string = "Hide ";
		}

		mi = new JMenuItem(string + g_empty_classes);
		mi.addActionListener(new ToggleEmptyClasses());
		popupMenu.add(mi);

		if (ls.isMemberCounts()) {
			string = "Hide ";
		} else {
			string = "Show ";
		}

		mi = new JMenuItem(string + g_member_counts);
		mi.addActionListener(new ToggleMemberCounts());
		popupMenu.add(mi);

		mi = new JMenuItem(g_editElisionRules_text);
		mi.addActionListener(new DisplayEditElisions(ls));
		popupMenu.add(mi);

		FontCache.setMenuTreeFont(popupMenu); 
		add(popupMenu);
		popupMenu.show(this, x, y);
//		Do.dump_menu(popupMenu);
		remove(popupMenu);
	}

	public void mouseClicked(MouseEvent ev)
	{
		
		if (ev.isMetaDown()) {
			doRightPopup(ev);
	}	}

	public void mouseEntered(MouseEvent ev)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
	}

	public void mouseReleased(MouseEvent ev)
	{
	}
}



