package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import java.util.Enumeration;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SetEntitiesActive implements ActionListener
{
	private	QueryBox	m_queryBox;
	private boolean		m_active;

	public SetEntitiesActive(QueryBox queryBox, boolean active)
	{
		m_queryBox = queryBox;
		m_active   = active;
	}

	public void actionPerformed(ActionEvent ev)
	{
		QueryBox queryBox = m_queryBox;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (queryBox.getLs().processMetaKeyEvent("Set Entities Active")) {
				return;
		}	}

		int				cnt    = queryBox.getComponentCount();
		boolean			active = m_active;
		int				i;
		Component		c;
		ActiveEntityChkBox box;

		for (i = 0; i < cnt; ++i) {
			c = queryBox.getComponent(i);
			if (c instanceof ActiveEntityChkBox) {
				box = (ActiveEntityChkBox) c;
				if (box.isActive() != active) {
					box.doClick();
	}	}	}	}	
}

class SetRelationsActive implements ActionListener
{
	QueryBox	m_queryBox;
	boolean		m_active;

	public SetRelationsActive(QueryBox queryBox, boolean active)
	{
		m_queryBox = queryBox;
		m_active   = active;
	}

	public void actionPerformed(ActionEvent ev)
	{
		QueryBox	queryBox = m_queryBox;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (queryBox.getLs().processMetaKeyEvent("Set Relations Active")) {
				return;
		}	}

		int				cnt    = queryBox.getComponentCount();
		boolean			active = m_active;
		int				i;
		Component		c;
		ActiveRelnChkBox box;

		for (i = 0; i < cnt; ++i) {
			c = queryBox.getComponent(i);
			if (c instanceof ActiveRelnChkBox) {
				box = (ActiveRelnChkBox) c;
				if (!box.isContainsClass() && box.isActive() != active) {
					box.doClick();
	}	}	}	}	
}

class LiftEntityClassEdges implements ActionListener
{
	private LandscapeEditorCore	m_ls;

	public LiftEntityClassEdges(LandscapeEditorCore ls)
	{
		m_ls = ls;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(QueryBox.g_liftActiveRelations)) {
				return;
		}	}

		switch (JOptionPane.showConfirmDialog(null, "Raise active edges in active entities", "Lift edges to parent else delete", JOptionPane.YES_NO_CANCEL_OPTION)) {
		case JOptionPane.YES_OPTION:
		{
			Diagram		diagram = ls.getDiagram();

			ls.beginUndoRedo(QueryBox.g_liftActiveRelations);
			diagram.updateLiftEdges();
			ls.endUndoRedo();
			break;
		}
		case JOptionPane.NO_OPTION:
			break;
		}
}	}

class DeleteActiveEntities implements ActionListener
{
	private LandscapeEditorCore	m_ls;

	public DeleteActiveEntities(LandscapeEditorCore	ls)
	{
		m_ls = ls;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(QueryBox.g_deleteActiveEntities)) {
				return;
		}	}

		switch (JOptionPane.showConfirmDialog(null, "Delete active entities below draw root", "Delete entities", JOptionPane.YES_NO_CANCEL_OPTION)) {
		case JOptionPane.YES_OPTION:
		{
			Diagram		diagram = ls.getDiagram();

			ls.beginUndoRedo(QueryBox.g_deleteActiveEntities);
			diagram.updateDeleteActiveEntities();
			ls.endUndoRedo();
			break;
		}
		case JOptionPane.NO_OPTION:
			break;
		}
}	}

class DeleteActiveContainers implements ActionListener
{
	private LandscapeEditorCore	m_ls;

	public DeleteActiveContainers(LandscapeEditorCore	ls)
	{
		m_ls = ls;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore	ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(QueryBox.g_deleteActiveContainers)) {
				return;
		}	}

		switch (JOptionPane.showConfirmDialog(null, "Delete active containers below draw root", "Delete containers", JOptionPane.YES_NO_CANCEL_OPTION)) {
		case JOptionPane.YES_OPTION:
		{
			Diagram		diagram = ls.getDiagram();

			ls.beginUndoRedo(QueryBox.g_deleteActiveContainers);
			diagram.updateDeleteActiveContainers();
			ls.endUndoRedo();
			break;
		}
		case JOptionPane.NO_OPTION:
			break;
		}
}	}

class DuplicateEdges implements ActionListener
{
	LandscapeEditorCore	m_ls;
	RelationClass		m_rc;

	public DuplicateEdges(LandscapeEditorCore ls, RelationClass rc)
	{
		m_ls = ls;
		m_rc = rc;
	}

	public void actionPerformed(ActionEvent ev)
	{	
		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (m_ls.processMetaKeyEvent(QueryBox.g_duplicateRelations)) {
				return;
		}	}
		m_ls.duplicateEdges(m_rc);
	}
}

class DeleteActiveEdges implements ActionListener
{
	private	LandscapeEditorCore	m_ls;

	public DeleteActiveEdges(LandscapeEditorCore	ls)
	{
		m_ls = ls;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore	ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(QueryBox.g_deleteActiveRelations)) {
				return;
		}	}

		switch (JOptionPane.showConfirmDialog(null, "Delete active relations in active entities below draw root", "Delete edges", JOptionPane.YES_NO_CANCEL_OPTION)) {
		case JOptionPane.YES_OPTION:
		{
			Diagram		diagram = ls.getDiagram();

			ls.beginUndoRedo(QueryBox.g_deleteActiveRelations);
			diagram.updateDeleteActiveEdges();
			ls.endUndoRedo();
			break;
		}
		case JOptionPane.NO_OPTION:
			break;
		}
}	}

class ResetIOpoints implements ActionListener
{
	private	LandscapeEditorCore	m_ls;

	public ResetIOpoints(LandscapeEditorCore	ls)
	{
		m_ls = ls;
	}

	public void actionPerformed(ActionEvent ev)
	{
		LandscapeEditorCore	ls = m_ls;

		if ((ev.getModifiers() & ActionEvent.META_MASK) != 0) {
			if (ls.processMetaKeyEvent(QueryBox.g_resetIOpoints)) {
				return;
		}	}
		Diagram diagram = ls.getDiagram();
		if (diagram != null) {
			ls.beginUndoRedo(QueryBox.g_resetIOpoints);
			diagram.resetIOpoints();
			ls.endUndoRedo();
			diagram.repaint();
}	}	}

class ActiveEntityChkBox extends EntityChkBox implements ItemListener
{
	public ActiveEntityChkBox(QueryBox queryBox, EntityClass ec, int index, int h) 
	{
		super(ec, index, -1, h, false);

		setFont(queryBox.getTextFont());
		addItemListener(this);
	}

	public boolean isActive()
	{
		return(m_ec.isActive());
	}

	public void setActive(boolean value)
	{
		if (m_ec.isActive() != value) {
			m_ec.setActive(value);
			repaint();
	}	}

	public void itemStateChanged(ItemEvent ev)
	{
//		System.out.println("EntityLabel.itemStateChanged " + ev.getStateChange() + " " + isSelected());
		setActive(ev.getStateChange() == ItemEvent.SELECTED);
}	}

class ActiveRelnChkBox extends RelnChkBox /* extends JComponent */ implements ItemListener, MouseListener
{
	protected	QueryBox			m_queryBox;
	protected	JPopupMenu			m_popup;

	public ActiveRelnChkBox(QueryBox queryBox, RelationClass rc,  int index, int count, Font font) 
	{
		super(rc, index, count, rc.isActive(), font);
		m_queryBox = queryBox;
		addItemListener(this);
		addMouseListener(this);
	}

	public boolean isActive()
	{
		return(m_rc.isActive());
	}

	public void setActive(boolean value)
	{
		if (m_rc.isActive() != value) {
			m_rc.setActive(value);
			repaint();
	}	}

	public void itemStateChanged(ItemEvent ev)
	{
		setActive(ev.getStateChange() == ItemEvent.SELECTED);
	}

	// MouseListener interface

	public void mouseClicked(MouseEvent e)
	{
	}

	public void mouseEntered(MouseEvent e)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
		if (ev.isMetaDown()) {
			QueryBox			queryBox = m_queryBox;
			LandscapeEditorCore	ls       = queryBox.getLs();
			Diagram				diagram  = ls.getDiagram();
			int					x        = ev.getX();
			int					y        = ev.getY();
			JMenuItem			mi;

			m_popup = new JPopupMenu("Relation menu");

			mi = new JMenuItem(QueryBox.g_duplicateRelations);
			mi.addActionListener(new DuplicateEdges(ls, m_rc));
			m_popup.add(mi);

			FontCache.setMenuTreeFont(m_popup); 
			queryBox.add(m_popup);
//			Do.dump_menu(m_popup);
			m_popup.show(this, x, y);
	}	}
	
	public void mouseReleased(MouseEvent ev) 
	{
	}
}

class GrpChkBox extends JCheckBox implements ItemListener
{
	LandscapeEditorCore	m_ls;

	GrpChkBox(LandscapeEditorCore ls)
	{
		super("Group with queries");

		m_ls = ls;
		setSelected(ls.isGroupQuery());
		addItemListener(this);
	}

	protected void grpStateInfo() 
	{
		LandscapeEditorCore ls = m_ls;

		ls.doFeedback("Entities " + (ls.isGroupQuery() ? "are" : "aren't") + " grouped with queries");
	}

	public void itemStateChanged(ItemEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		ls.setGroupQuery(isSelected()); 
		grpStateInfo();
		ls.requestFocus();
	}
}	

class QueryPersistsChkBox extends JCheckBox implements ItemListener
{
	LandscapeEditorCore	m_ls;

	QueryPersistsChkBox(LandscapeEditorCore ls)
	{
		super("Queries persist");

		m_ls = ls;
		setSelected(ls.isQueryPersists());
		addItemListener(this);
	}

	protected void queryPersistsStateInfo() 
	{
		LandscapeEditorCore ls = m_ls;

		ls.doFeedback("Queries " + (ls.isQueryPersists() ? "are" : "aren't") + " persisted");
	}

	public void itemStateChanged(ItemEvent ev)
	{
		LandscapeEditorCore ls = m_ls;

		ls.setQueryPersists(isSelected()); 
		queryPersistsStateInfo();
		ls.requestFocus();
	}
}	

public class QueryBox extends TabBox /* extends JComponent */ implements ChangeListener, TaListener, MouseListener
{
	public final static String g_duplicateRelations			= "Duplicate Relations";
	public final static String g_liftActiveRelations		= "Lift Active Relations";
	public final static String g_deleteActiveEntities       = "Delete Active Entities";
	public final static String g_deleteActiveContainers     = "Delete Active Containers";
	public final static String g_deleteActiveRelations      = "Delete Active Relations";
	public final static String g_resetIOpoints				= "Reset IO points";

	public final static String DEFAULT_QUERY_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_QUERY_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_QUERY_TITLE_FONT_SIZE  = 12;

	protected static Font m_titleFont   = FontCache.get(DEFAULT_QUERY_TITLE_FONT_NAME, DEFAULT_QUERY_TITLE_FONT_STYLE, DEFAULT_QUERY_TITLE_FONT_SIZE);

	public final static String DEFAULT_QUERY_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_QUERY_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_QUERY_TEXT_FONT_SIZE  = 11;

	protected static Font m_textFont    = FontCache.get(DEFAULT_QUERY_TEXT_FONT_NAME, DEFAULT_QUERY_TEXT_FONT_STYLE, DEFAULT_QUERY_TEXT_FONT_SIZE);

	public    static final String m_helpStr = "This box shows the active entities and relations during update and queries";

	protected static final int MARGIN = 5;
	protected static final int GAP    = 5; 

	// Objects used in layout

	protected JLabel				m_ulabel;
	protected JLabel				m_elabel2;
	protected JLabel				m_rlabel;
	protected JLabel				m_clabel;
	protected JLabel				m_footer1;
	protected JLabel				m_footer2;

	protected int					m_width;
	protected int					m_height;

	protected GrpChkBox				m_grpChk;
	protected QueryPersistsChkBox	m_queryPersistsChk;

	private	  boolean				m_refill = false;

	// ------------------
	// JComponent methods
	// ------------------

	public Dimension getPreferredSize()
	{
		return(getSize());
	}

	protected void add(JComponent component)
	{
		Dimension	d;
		int			width, height;

		d         = component.getPreferredSize();
		width     = d.width;
		height    = d.height;
		if (width > m_width) {
//			System.out.println("Width=" + width + " for " + component);
			m_width = width;
		}
		component.setBounds(MARGIN, m_height, width, height);
		super.add(component);
		m_height += height;
	}

	// --------------
	// Public methods 
	// --------------

	public QueryBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		super(ls, tabbedPane, "Query", m_helpStr);

		Font	textFont  = m_textFont;
		Font	titleFont = m_titleFont;

		m_ulabel = new JLabel("Active Entities");
		m_ulabel.setForeground(Color.red);
		m_ulabel.setFont(titleFont);

		m_elabel2 = new JLabel("Right click for menu.");
		m_elabel2.setForeground(Color.black);
		m_elabel2.setFont(textFont);

		m_rlabel = new JLabel("Active Relations");
		m_rlabel.setForeground(Color.red);
		m_rlabel.setFont(titleFont);

		m_clabel = new JLabel("Hierarchy");
		m_clabel.setForeground(Color.red);
		m_clabel.setFont(titleFont);

		m_footer1 = new JLabel("Checkboxes select query relations.");
		m_footer1.setForeground(Color.black);
		m_footer1.setFont(textFont);

		m_footer2 = new JLabel("Click relation arrow for description.");
		m_footer2.setForeground(Color.black);
		m_footer2.setFont(textFont);

		m_grpChk = new GrpChkBox(m_ls);
		m_grpChk.setForeground(Color.black);
		m_grpChk.setFont(textFont);

		m_queryPersistsChk = new QueryPersistsChkBox(m_ls);
		m_queryPersistsChk.setForeground(Color.black);
		m_queryPersistsChk.setFont(textFont);

		tabbedPane.addChangeListener(this);
		addMouseListener(this);
	}

	public void setGroupQuery(boolean value)
	{
		if (m_grpChk.isSelected() != value) {
			m_grpChk.setSelected(value);
	}	}

	public void setQueryPersists(boolean value)
	{
		if (m_queryPersistsChk.isSelected() != value) {
			m_queryPersistsChk.setSelected(value);
	}	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public void titleFontChanged(Font font)
	{
		m_ulabel.setFont(font);
		fill();
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void textFontChanged(Font font)
	{
		m_footer1.setFont(font);
		m_footer2.setFont(font);
		m_grpChk.setFont(font);
		m_queryPersistsChk.setFont(font);
		fill();
	}

	public void fill() 
	{
		removeAll();
		m_width  = 0;
		m_height = 0;

		if (isActive()) {
			Diagram				diagram;
			FontMetrics			fontMetrics;
			Enumeration			en;
			int					item,n,h;
			RelationClass		rc, contains;
			Color				color;
			ActiveRelnChkBox	relnChk;

			diagram  = m_ls.getDiagram();



			// Draw legend for entities

			item = 0;
			n	 = 0;

			fontMetrics = getFontMetrics(m_textFont);
			h           = fontMetrics.getHeight();

			EntityClass ec;
			String		id;

			m_height += 10;
			add(m_ulabel);

			if (diagram != null) {
				for (en = diagram.enumEntityClassesInOrder(); en.hasMoreElements(); ) {
					ec = (EntityClass) en.nextElement();
					m_height += 10;
					add(new ActiveEntityChkBox(this, ec, ++n, h));
			}	}

			m_height += 10;
			add(m_elabel2);
			m_height += 20;
			add(m_rlabel);

			// Draw legend for relations

			m_height += GAP;

			contains = null;
			if (diagram != null) {
				m_height += GAP;
				for (en = diagram.enumRelationClassesInOrder(); en.hasMoreElements(); ) {

					rc = (RelationClass) en.nextElement();

					if (!rc.isContainsClass()) {
						add(new ActiveRelnChkBox(this, rc, ++n, -1, m_textFont));
					} else {
						contains = rc;
			}	}	}
			
			if (contains != null) {
				m_height += 10;
				add(m_clabel);
				m_height += GAP;
				add(new ActiveRelnChkBox(this, contains, ++n, -1, m_textFont));
			}

			m_height += 20;
			add(m_footer1);
			add(m_footer2);
			m_height += 10;
			add(m_grpChk);
			m_height += 10;
			add(m_queryPersistsChk);
		}
		setBounds(0, 0, m_width, m_height);
	}	

	public void toggleRelationActivity(int key) 
	{
		int				cnt = getComponentCount();
		int				i;
		Component		c;
		boolean			ns;
		ActiveRelnChkBox box;

		if (key == 0) {
			ns = true;
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					box = (ActiveRelnChkBox) c;
					if (box.getIndex() == 1) {
						// Set everything same way as first
						ns = !box.isActive();
						break;
			}	}	}

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					box = (ActiveRelnChkBox) c;
					if (box.isActive() != ns) {
						if (!box.isContainsClass()) {
							box.doClick();
			}	}	}	}
		} else {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					if (((ActiveRelnChkBox) c).getIndex() == key) {
						((ActiveRelnChkBox) c).doClick();
						break;
		}	}	}	}
	}

	protected void doRightPopup(MouseEvent ev)
	{
		LandscapeEditorCore	ls      = m_ls;
		Diagram				diagram = ls.getDiagram();
		Enumeration			en;
		EntityClass			ec;
		RelationClass		rc;
		int					x, y;
		JPopupMenu			popupMenu;
		JMenuItem			mi;
		String				string;


		if (diagram == null) {
			return;
		}

		x         = ev.getX();
		y         = ev.getY();
		popupMenu = new JPopupMenu("Update options");

		for (en = diagram.enumEntityClasses(); en.hasMoreElements(); ) {
			ec = (EntityClass) en.nextElement();
			if (ec.isActive()) {
				mi = new JMenuItem("No entities active");
				mi.addActionListener(new SetEntitiesActive(this, false));
				popupMenu.add(mi);
				break;
		}	}

		for (en = diagram.enumEntityClasses(); en.hasMoreElements(); ) {
			ec = (EntityClass) en.nextElement();
			if (!ec.isActive()) {
				mi = new JMenuItem("All entities active");
				mi.addActionListener(new SetEntitiesActive(this, true));
				popupMenu.add(mi);
				break;
		}	}
	
		for (en = diagram.enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			if (!rc.isContainsClass() && rc.isActive()) {
				mi = new JMenuItem("No relations active");
				mi.addActionListener(new SetRelationsActive(this, false));
				popupMenu.add(mi);
				break;
		}	}

		for (en = diagram.enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			if (!rc.isContainsClass() && !rc.isActive()) {
				mi = new JMenuItem("All relations active");
				mi.addActionListener(new SetRelationsActive(this, true));
				popupMenu.add(mi);
				break;
		}	}

		mi = new JMenuItem(QueryBox.g_liftActiveRelations);
		mi.addActionListener(new LiftEntityClassEdges(ls));
		popupMenu.add(mi);

		mi = new JMenuItem(g_deleteActiveEntities);
		mi.addActionListener(new DeleteActiveEntities(ls));
		popupMenu.add(mi);

		mi = new JMenuItem(g_deleteActiveContainers);
		mi.addActionListener(new DeleteActiveContainers(ls));
		popupMenu.add(mi);

		mi = new JMenuItem(g_deleteActiveRelations);
		mi.addActionListener(new DeleteActiveEdges(ls));
		popupMenu.add(mi);

		mi = new JMenuItem(g_resetIOpoints);
		mi.addActionListener(new ResetIOpoints(ls));
		popupMenu.add(mi);

		FontCache.setMenuTreeFont(popupMenu); 
		add(popupMenu);
		popupMenu.show(this, x, y);
//		Do.dump_menu(popupMenu);
		remove(popupMenu);
	}

	// ChangeListener interface

	public void stateChanged(ChangeEvent e) 
	{
//		System.out.println("QueryBox stateChanged " + isActive());
		fill();
	}

	// TaListener interface

	public void diagramChanged(Diagram diagram)
	{
		fill();
	}

	public void updateBegins()
	{
	}

	public void updateEnds()
	{
		if (m_refill) {
			m_refill = false;
			fill();
		}
	}

	public void entityClassChanged(EntityClass ec, int signal)
	{
		m_refill = true;
	}

	public void relationClassChanged(RelationClass rc, int signal)
	{
		m_refill = true;
	}

/*
	public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal)
	{
	}

	public void relationParentChanged(RelationInstance ri, int signal)
	{
	}

	public void entityInstanceChanged(EntityInstance e, int signal)
	{
	}

	public void relationInstanceChanged(RelationInstance ri, int signal)
	{
	}
*/

	// MouseListener interface

	public void mouseClicked(MouseEvent ev)
	{
		if (ev.isMetaDown()) {
			doRightPopup(ev);
	}	}

	public void mouseEntered(MouseEvent ev)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
	}

	public void mouseReleased(MouseEvent ev)
	{
	}
}

