package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RelationClass extends LandscapeClassObject /* extends LandscapeObject3D extends LandscapeObject */ {

	protected static final String FACTOR_ID      = "class_iofactor";
	protected static final String HIERARCHY_ID   = "class_hierarchy";
	protected static final String ACTIVE_ID      = "class_active";
	protected static final String VISIBLE_ID     = "class_visible";
	protected static final String ISCONTAINS_ID  = "class_iscontains";

	public static final int	ID_ATTR				= 0;
	public static final int	CLASSLABEL_ATTR		= 1;
	public static final int	CLASSDESC_ATTR		= 2;
	public static final int	CLASSSTYLE_ATTR		= 3;
	public static final int	COLOR_ATTR			= 4;
	public static final int	LABEL_COLOR_ATTR	= 5;
	public static final int	FACTOR_ATTR			= 6;
	public static final int ARROWCOLOR_ATTR     = 7;
	public static final int ATTRS               = 8;

	public static final String[] attributeName =
	{
		"id",
		CLASSLABEL_ID,
		CLASSDESC_ID,
		CLASSSTYLE_ID,
		COLOR_ID,
		LABEL_COLOR_ID,
		FACTOR_ID,
		ARROWCOLOR_ID
	};

	public static final int[] attributeType =
	{
		Attribute.STRING_TYPE,
		Attribute.STRING_TYPE,
		Attribute.TEXT_TYPE,
		Attribute.REL_STYLE_TYPE,
		Attribute.COLOR_OR_NULL_TYPE,
		Attribute.COLOR_TYPE,
		Attribute.DOUBLE_TYPE,
		Attribute.COLOR_OR_NULL_TYPE
	};

	protected static final String RELATION_BASE_CLASS_ID = "$RELATION";

	protected boolean m_contains = false;	// True if this is the currently active contains class

	protected double  m_iofactor   = -1;	// Where the relation should intersect entities as a percentage
	protected int	  m_cIndex     = -1;	// What is the offset of EntityShape[] for entity shape using this relation as contains
	protected int	  m_weight     = 1;
	protected Color	  m_arrowColor = null;

	// Permitted relations

	// This is the list of Entity class pairs that can participate in relations of this relation class
	// It can be presumed to be quite small.

	private Vector	m_relationList = new Vector();
		 
	protected int	m_ordinal;		// 0 is first relation

	// --------------
	// Public methods
	// --------------

	public RelationClass(String id, int nid, Ta ta)
	{
		super(ta);
		setId(id);						// The string name of this relation class
		setNid(nid);					// The numeric id
		setLabel(id);					// The label of this relation
	}

	public int getCIndex()
	{
		return m_cIndex;
	}

	public void setCIndex(int value)
	{
		m_cIndex = value;
	}

	public int getWeight()
	{
		return m_weight;
	}

	public void setWeight(int value)
	{
		m_weight = value;
	}

	public String getStyleName(int style) 
	{
		return Util.getLineStyleName(style);
	}

	public void setContainsClass(boolean contains)
	{
		if (m_contains != contains) {
			m_contains = contains;
			m_weight   = ((contains || !m_shown) ? 0 : 1);
	}	}

	public Color getArrowColor()
	{
		return m_arrowColor;
	}

	public void setArrowColor(Color arrowColor)
	{
		m_arrowColor = arrowColor;
	}

	// Is this the contains relation

	public boolean isContainsClass() 
	{
		return m_contains;
	}

	public boolean processFirstOrder(String id, String value) 
	{
		if (id.equals(ARROWCOLOR_ID)) {
			setArrowColor(Attribute.parseColorValue(value, this, ARROWCOLOR_ID));
			return true;
		}
		if (id.equals(HIERARCHY_ID)) {
			if (value != null) {
				m_cIndex = Attribute.parseIntValue(value, m_cIndex);
			}
			return true;
		}
		if (id.equals(FACTOR_ID)) {
			if (value != null) {
				m_iofactor = Attribute.parseDoubleValue(value, m_iofactor);
			}
			return true;
		}
		if (id.equals(ACTIVE_ID)) {
			if (value != null) {
				m_active = Attribute.parseBooleanValue(value, true);
			}
			return true;
		}
		if (id.equals(VISIBLE_ID)) {
			if (value != null) {
				setShown(Attribute.parseBooleanValue(value, true));
			}
			return true;
		}
		if (id.equals(ISCONTAINS_ID)) {
			if (value != null) {
				setContainsClass(Attribute.parseBooleanValue(value, false));
			}
			return true;
		}
		return super.processFirstOrder(id, value);
	}

	public void reportClassAttributes(ResultBox resultBox)
	{
		resultBox.addText(HIERARCHY_ID);
		resultBox.addText(FACTOR_ID);
		resultBox.addText(ACTIVE_ID);
		resultBox.addText(VISIBLE_ID);
		resultBox.addText(ISCONTAINS_ID);

		super.reportClassAttributes(resultBox);
	}

	// If new, add an edge to the ERD (permitted relation)

	public Vector getRelationList()
	{
		return m_relationList;
	}

	public void addRelationConstraint(EntityClassPair ep)
	{
		m_relationList.addElement(ep);
	}

	public void addRelationConstraint(EntityClass ec1, EntityClass ec2) 
	{
		if (m_relationList == null) {
			m_relationList = new Vector();
		} else {
			Enumeration		en;
			EntityClassPair ep;

			for (en = m_relationList.elements(); en.hasMoreElements(); ) {
				ep = (EntityClassPair) en.nextElement();
				if (ep.equals(ec1, ec2)) {
					return;
				}
		}	}

		addRelationConstraint(new EntityClassPair(ec1, this, ec2));
	}

	public void removeRelation(EntityClassPair ep) 
	{
		Vector relationList;

		relationList = m_relationList;
		if (relationList != null) {
			relationList.remove(ep);
	}	}

	public boolean[][] getInheritedRelationArray()
	{
		Ta				ta = getTa();
		boolean[][]		array;
		boolean[]		row;
		Enumeration		en, en1, en2, en3;
		RelationClass	rc;
		int				i, j, size;
		Vector			srcs, dsts;
		EntityClassPair	ep;
		EntityClass		src1, dst1;
		int				from, to;

		i = 0;
		for (en = ta.enumEntityClassesInOrder(); en.hasMoreElements(); ++i) {
			src1 = (EntityClass) en.nextElement();
			src1.setOrderedId(i);
		}
		size = i;

		array = new boolean[size][];
		for (i = 0; i < size; ++i) {
			array[i] = row = new boolean[size];
			for (j = 0; j < size; ++j) {
				row[j] = false;
		}	}

		Vector	rcs     = getClassAndSuperclasses();
		for (en = rcs.elements(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			for (en1 = rc.m_relationList.elements(); en1.hasMoreElements(); ) {
				ep = (EntityClassPair) en1.nextElement();
				srcs = ta.getClassAndSubclasses(ep.m_entityClass1);
				dsts = ta.getClassAndSubclasses(ep.m_entityClass2);
				for (en2 = srcs.elements(); en2.hasMoreElements(); ) {
					src1 = (EntityClass) en2.nextElement();
					from = src1.getOrderedId();
					for (en3 = dsts.elements(); en3.hasMoreElements(); ) {
						dst1 = (EntityClass) en3.nextElement();
						to   = dst1.getOrderedId();
						array[from][to] = true;
		}	}	}	}
		return array;
	}

	public void writeRelations(PrintStream ps) throws IOException 
	{
		Enumeration en;
		EntityClassPair ep;

		for (en = m_relationList.elements(); en.hasMoreElements(); ) {
			ep = (EntityClassPair) en.nextElement();
			ps.print(qt(getId()) + " " + qt(ep.m_entityClass1.getId()) + " " + qt(ep.m_entityClass2.getId()) + "\n");
		}
	}

	public void writeAttributes(PrintStream ps) throws IOException 
	{
		if (getNid() >= 2) {
			ps.print("(" + qt(getId()) + ") {\n");

			if (m_cIndex >= 0) {
				ps.print(HIERARCHY_ID + " = " + m_cIndex + " ");
			}
			if (m_iofactor >= 0) {
				ps.print(FACTOR_ID + " = " + m_iofactor + " ");
			}
			if (!m_active) {
				ps.print(ACTIVE_ID + " = false ");
			}
			if (!m_shown) {
				ps.print(VISIBLE_ID + " = false ");
			}
			if (m_contains) {
				ps.print(ISCONTAINS_ID + " = true ");
			}

			Color color = getArrowColor();
			if (color != null) { 
				ps.print(ARROWCOLOR_ID + " = " + Util.taColor(color) + "\n");
			}
			
			super.writeAttributes(ps);
			ps.print("}\n\n");
		}
	}

	// Accessor functions

	public boolean isClassShown() 
	{
		return m_shown && !m_contains;
	}

	public void setShown(boolean state) 
	{
		if (m_shown != state) {
			if (!state) {
				getDiagram().clearRelationClassGroupFlags(this);
				m_weight = 0;
			} else {
				m_weight = (m_contains ? 0 : 1); 
			}
			m_shown = state;
	}	}

	public int	getOrdinal()
	{
		return m_ordinal;
	}

	public void setOrdinal(int ord) 
	{
		m_ordinal = ord;
	}

	public double getIOfactor()
	{
		return m_iofactor;
	}

	public double getLogicalIOfactor() 
	{
		if (m_iofactor >= 0) {
			return m_iofactor;
		}
		
		Diagram diagram = getDiagram();

		if (diagram.allowElision()) {
			double num = diagram.numVisibleRelationClasses();
			return (m_ordinal+1)/(num+1);
		}
		double num = diagram.numRelationClasses();
		return ((num > 2) ? (getNid()-1)/(num-1) : 0.5);
	}

	public void setIOfactor(double value)
	{
		m_iofactor = value;
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(ATTRS);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		if (index < ATTRS) {
			name = attributeName[index];
		} else {
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
	
		if (index < ATTRS) {
			ret = attributeType[index];
		} else {
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case ID_ATTR:
			value = getId();
			break;
		case CLASSLABEL_ATTR:
			value = getLabel();
			break;
		case CLASSDESC_ATTR:
			value = getDescription();
			break;
		case CLASSSTYLE_ATTR:
			value = new Integer(getStyle());
			break;
		case COLOR_ATTR:
			value = getObjectColor();
			break;
		case LABEL_COLOR_ATTR:
			value = getLabelColor();
			break;
		case FACTOR_ATTR:
			value = new Double(m_iofactor);
			break;
		case ARROWCOLOR_ATTR:
			value = getArrowColor();
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

}

