package lsedit;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ResultBox extends TabBox /* extends JComponent */ implements ChangeListener, TaListener, Scrollable 
{
	protected static final Color	m_titleColor = Color.red.darker();

	public final static String DEFAULT_RESULT_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_RESULT_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_RESULT_TITLE_FONT_SIZE  = 14;


	protected static       Font		m_titleFont  = FontCache.get(DEFAULT_RESULT_TITLE_FONT_NAME, DEFAULT_RESULT_TITLE_FONT_STYLE, DEFAULT_RESULT_TITLE_FONT_SIZE);

	public final static String DEFAULT_RESULT_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_RESULT_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_RESULT_TEXT_FONT_SIZE  = 11;

	protected static       Font		m_textFont	 = FontCache.get(DEFAULT_RESULT_TEXT_FONT_NAME, DEFAULT_RESULT_TEXT_FONT_STYLE, DEFAULT_RESULT_TEXT_FONT_SIZE);
	protected static final String	m_indent     = "    ";

	// <entity name> [<entity class name>]

	class ResultLabel extends JLabel
	{
		public ResultLabel()
		{
			super();
			setHorizontalAlignment(LEFT);
			setHorizontalTextPosition(LEFT);
			setFont(m_textFont);
		}

		public String toString()
		{
			return(getText());
		}
	}

	// <entity> [ {<class>} ]

	class ResultEntity extends ResultLabel implements MouseListener
	{
		protected EntityInstance		m_entity;

		public ResultEntity(String indent, EntityInstance entity, boolean showClass)
		{
			super();

			String		text;
			
			m_entity  = entity;
			text     = indent + entity.getEntityLabel();
			if (showClass) {
				text += " {" + entity.getClassLabel() + "}";
			}
			setText(text);
			setForeground(Color.blue);
			setToolTipText(entity.getDescription());
			addMouseListener(this);
		}

		public void paintComponent(Graphics g)
		{
			Color	color;

			if (m_entity.isMarked(EntityInstance.DELETED_MARK)) {
				color = Color.black;
			} else {
				color = Color.blue;
			}
			setForeground(color);
			super.paintComponent(g);
		}

		// MouseListener interface

		public void mouseClicked(MouseEvent e)
		{
		}

		public void mouseEntered(MouseEvent e)
		{
			if (!m_entity.isMarked(EntityInstance.DELETED_MARK)) {
				setForeground(Color.red);
				repaint();
		}	}

		public void mouseExited(MouseEvent e)
		{
			if (!m_entity.isMarked(EntityInstance.DELETED_MARK)) {
				setForeground(Color.blue);
				repaint();
		}	}

		public void mousePressed(MouseEvent ev)
		{
		}

		public void mouseReleased(MouseEvent ev)
		{
			if (!m_entity.isMarked(EntityInstance.DELETED_MARK)) {
				setForeground(Color.blue);
				m_ls.followLink(m_entity, true);
		}	}
	}

	class ResultAttribute extends ResultLabel
	{
		public ResultAttribute(String indent, Attribute attribute)
		{
			super();

			String		text;
			
			text     = indent + attribute.toString();
			setText(text);
//			setForeground(Color.black);
		}
	}

	class HorizontalResult extends JComponent
	{
		public HorizontalResult()
		{	
			super();
			setAlignmentX(LEFT_ALIGNMENT);
			setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		}

		public String toString()
		{
			int			i, cnt;
			Component	component;
			String		string;

			cnt      = getComponentCount();
			string   = "";
			for (i = 0; i < cnt; ++i) {
				component = getComponent(i);
				string += component.toString();
			}
			return string;
		}
	}

	class VerticalResult extends JComponent
	{
		public VerticalResult()
		{
			super();
			setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		}

		public String toString()
		{
			int			i, cnt;
			Component	component;
			String		string;

			cnt      = getComponentCount();
			string   = "";
			for (i = 0; i < cnt; ++i) {
				component = getComponent(i);
				string   += component.toString() + "\n";
			}
			return string;
		}
	}

	//  <Entity name> [<relation class>] <Entity name>

	class ResultRelation extends HorizontalResult
	{
		protected RelationInstance		m_relation;

		public ResultRelation(String indent, RelationInstance relation, boolean hideRc)
		{	
			super();

			ResultEntity	resultEntity;
			ResultLabel		rc;

			m_relation = relation;
			resultEntity = new ResultEntity(indent, relation.getSrc(), false);
			add(resultEntity);
			if (!hideRc) {
				rc = new ResultLabel();
				rc.setText(" " + relation.getClassLabel());
				rc.setHorizontalAlignment(JLabel.CENTER);
				add(rc);
			}
			resultEntity = new ResultEntity(" ", relation.getDst(), false);
			add(resultEntity);
		}

		public boolean matches(RelationInstance relation)
		{
			return(m_relation.matches(relation));
		}
	}

	// <ResultEntity> <rc> [*|?] 
	// [*|?] <rc> <ResultEntity>

	class ResultSetHeader extends HorizontalResult
	{
		public ResultSetHeader(EntityInstance entity, RelationClass relationClass, boolean forward, boolean closure)
		{
			super();

			Enumeration			en;
			ResultEntity		resultEntity;
			ResultLabel			rc, label;
			Object				object;
			EntityInstance		e;
			RelationInstance	r;
			String				type;

			if (closure) {
				type = "*";
			} else {
				type = "?";
			}

			if (relationClass == null) {
				rc  = null;
			} else {
				rc           = new ResultLabel();
				rc.setText(" " + relationClass.getLabel());
				rc.setHorizontalAlignment(JLabel.CENTER);
			}
			label        = new ResultLabel();
			label.setHorizontalAlignment(JLabel.LEFT);

			if (forward) {
				resultEntity = new ResultEntity("", entity, false);
				add(resultEntity);
				if (rc != null) {
					add(rc);
				}
				label.setText(" " + type);
				add(label);
			} else {
				label.setText(type);
				add(label);
				if (rc != null) {
					add(rc);
				}
				resultEntity = new ResultEntity(" ", entity, false);
				add(resultEntity);
			}
		}

		public ResultSetHeader(EntityInstance entity, Vector list)
		{
			super();

			ResultEntity	resultEntity;
			ResultLabel		label;

			resultEntity = new ResultEntity("", entity, false);
			label        = new ResultLabel();
			label.setText(" contains (" + list.size() + " items):");
			add(resultEntity);
			add(label);
		}
	}

	/*
		<entity> <relation class> ?
			<entity>
			...
			<entity>
	 */

	class ResultSet extends VerticalResult
	{
		public ResultSet(EntityInstance entity, RelationClass relationClass, Vector entities, boolean forward, boolean closure)
		{
			super();

			Enumeration			en;
			ResultEntity		resultEntity;
			ResultRelation		resultRelation;
			Object				object;
			EntityInstance		e;
			RelationInstance	r;

			add(new ResultSetHeader(entity, relationClass, forward, closure));
			for (en = entities.elements(); en.hasMoreElements(); ) {
				object = en.nextElement();
				if (object instanceof EntityInstance) {
					e = (EntityInstance) object;
					resultEntity = new ResultEntity(m_indent, e, false);
					add(resultEntity);
				} else {
					r = (RelationInstance) object;
					resultRelation = new ResultRelation(m_indent, r, true);
					add(resultRelation); 
			}	}
		}
	}

	/*
		<entity> <relation class> ?
			<entity>
			...
			<entity>
	 */

	class ResultContents extends VerticalResult
	{
		public ResultContents(EntityInstance entity, Vector entities)
		{
			super();

			Enumeration			en;
			ResultEntity		resultEntity;
			Object				object;
			EntityInstance		e;

			add(new ResultSetHeader(entity, entities));
			for (en = entities.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				resultEntity = new ResultEntity(m_indent, e, true);
				add(resultEntity);
			}
		}
	}

	protected static final int	horizontal_margin    = 10;
	protected static final int	vertical_indent      = 10;

	public    static final String m_helpStr = "This box shows the results of queries, and groupings";

	protected BoxLayout				m_boxLayout;
	private	  boolean				m_refill = false;

	// --------------
	// Object methods
	// --------------

	public String toString()
	{
		int			i, cnt;
		Component	component;
		String		string;

		cnt      = getComponentCount();
		string   = "";
		for (i = 0; i < cnt; ++i) {
			component = getComponent(i);
			string += component.toString() + "\n---\n";
		}
		return string;
	}

	// ------------------
	// JComponent methods
	// ------------------

/*
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);

		int	width, height;

		width   = getWidth();
		height  = getHeight();
		
		// For debugging
		g.setColor(Color.green);
		g.drawLine(0, 0, width, height);
		g.drawLine(0, height, width, 0);
	}
*/
	// --------------
	// Public methods 
	// --------------

	public ResultBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		super(ls, tabbedPane, "Results", m_helpStr);

		m_boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);
		setLayout(m_boxLayout);
		
		Dimension d;

		d            = tabbedPane.getSize();
		setLocation(0,0);
		setSize(d);
		setPreferredSize(d);

		tabbedPane.addChangeListener(this);
	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void clear() 
	{
		removeAll();
		revalidate();
		repaint();
	}

	public void addResultTitle(String title)
	{
		if (title != null) {
			ResultLabel	label = new ResultLabel();
			label.setText(title);
			label.setHorizontalAlignment(JLabel.LEFT);
			label.setFont(m_titleFont);
			label.setForeground(m_titleColor);
			add(label);
			add(Box.createVerticalStrut(5));
	}	}

	public void setResultTitle(String title)
	{
		clear();
		addResultTitle(title);
	}

	public void addResultEntity(EntityInstance e)
	{
//		activate();
		add(new ResultEntity("", e, false));
	}

	public void addResultAttribute(Attribute attribute)
	{
		add(new ResultAttribute("  ", attribute));
	}

	public void addRelation(RelationInstance r)
	{
//		activate();
		add(new ResultRelation("", r, false));
	}

	public void addRelation(String indent, RelationInstance r)
	{
//		activate();
		add(new ResultRelation(indent, r, false));
	}

	public void addRelations(EntityInstance e, RelationClass rc, Vector list, boolean isForwards, boolean withClosure)
	{
//		activate();
		add(new ResultSet(e, rc, list, isForwards, withClosure));
	}

	protected void addContents(EntityInstance e, Vector list)
	{
//		activate();
		add(new ResultContents(e, list));
	}

	public void addText(String message)
	{
		if (message != null) {
//			activate();
			ResultLabel	label = new ResultLabel();
			label.setText(message);
			label.setHorizontalAlignment(JLabel.LEFT);
			label.setForeground(Color.black);
			add(label);
	}	}

	public void done(String footer)
	{
		if (footer != null) {
			add(Box.createVerticalStrut(10));
			addText(footer);
		}
		setPreferredSize(m_boxLayout.preferredLayoutSize(this));
		validate();

		m_scrollPane.revalidate();
	}

	/* Show a list of entity labels vertically in order contained in vector 
	 * Used by GROUP ALL and FIND
	 */

	public void showResults(String title, Vector v, String footer) 
	{
		setResultTitle(title);

		if (v.size() > 0) {
			Enumeration		en;
			EntityInstance	e;

			for (en = v.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				addResultEntity(e);
			}
		} else {
			footer = "No entities";
		}
		done(footer);
	}

	// ChangeListener interface

	public void stateChanged(ChangeEvent e) 
	{
//		System.out.println("ResultBox stateChanged " + isActive());
		if (isActive()) {
			repaint();
	}	}

	// TaListener interface

	public void diagramChanged(Diagram diagram)
	{
		clear();
	}

	public void updateBegins()
	{
	}

	public void updateEnds()
	{
		if (m_refill) {
			m_refill = false;
			repaint();
	}	}

	public void entityClassChanged(EntityClass ec, int signal)
	{
	}

	public void relationClassChanged(RelationClass rc, int signal)
	{
	}

	public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal)
	{
		m_refill = true;
	}

/*
	public void relationParentChanged(RelationInstance ri, int signal)
	{
	}

	public void entityInstanceChanged(EntityInstance e, int signal)
	{
	}

	public void relationInstanceChanged(RelationInstance ri, int signal)
	{
	}
 */
	// Old TaListener interface 

	public void entityCut(EntityInstance e)
	{
	}

	// Scrollable interface
	// We need to implement this to stop iterative size changes..
	// The resultbox knows what size it wants to be and sets it on every validate
	// If we don't disable it the viewport tries to change the size to fit the window every time it validates

	public Dimension getPreferredScrollableViewportSize()
	{
		return(getSize());
	}
	 
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(50);
	}
	 
	public boolean getScrollableTracksViewportHeight() 
	{
		return(false);
	}

	public boolean getScrollableTracksViewportWidth() 
	{
		return(false);
	}

	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(10);
	} 
}






