#include <assert.h>
#include <alloca.h>
#include <string.h>
#include <stdio.h>
#include "util.h"
#include "object.h"
#include "classmember.h"
#include "template.h"
#include "class.h"
#include "signature_buffer.h"
#include "signature.h"

/* static */ unsigned int
Cclassmember::hash(const char *nameP)
{
	int		ret  = 0;
	int		c;
	const	char *P;

	for (P = nameP; (c = *P) ; ++P) {
		ret  += c;
		ret <<= 1;
		if (ret & HASHSIZE) {
			ret |= 1;
	}	}
	return(ret & (HASHSIZE-1));
}

extern Csignature	g_signature;

/* static */ void
Cclassmember::find_class(char *mangled_nameP, Cclass **classPP, Ctemplate **templatePP)
{
	Cclass		*classP;
	char		*classnameP, *templatenameP;

	*classPP = 0;
	if (templatePP) {
		*templatePP = 0;
	}
	if (g_signature.signature(mangled_nameP)) {
		classnameP = g_signature.get_classname();
		if (classnameP) {
			classP     = Cclass::locate(classnameP);
			*classPP = classP;
		}
		if (templatePP) {
			templatenameP = g_signature.get_template();
			if (templatenameP) {
				*templatePP = Ctemplate::locate(templatenameP);
}	}	}	}

Cclassmember::Cclassmember(const char *nameP)
{
	Cclass		*classP;
	Ctemplate	*templateP;

	name(nameP);
	m_fileP   = 0;
	m_lineno  = 0;
	m_parentP = 0;
	m_flags   = 0;
    m_vtable  = NOT_IN_VTABLE;
	// Create the class for this member
	Cclassmember::find_class(m_nameP, &classP, &templateP);
}

void
Cclassmember::emit_class(void) const
{
	Cclass		*classP;
	Ctemplate	*templateP;

	if (!(m_flags & AddressesX)) {
		Cclassmember::find_class(m_nameP, &classP, &templateP);
		if (classP) {
			fputs("M ", stdout);
			classP->emit_id();
			fputc(' ', stdout);
			emit_id();
			fputc('\n', stdout);
		}
		if (templateP) {
			fputs("MT ", stdout);
			templateP->emit_id();
			fputc(' ', stdout);
			emit_id();
			fputc('\n', stdout);
}	}	}

