#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "util.h"
#include "object.h"
#include "directory.h"
#include "source.h"
#include "file.h"

Cfile		*Cfile::g_headP     = 0;
int			Cfile::g_cnt        = 0;

Cfile::Cfile(Centity *sourceP, int number, char *filenameP)
{
	name(filenameP);
	m_parentP = sourceP;
	m_number  = number;
	m_nextP     = g_headP;
	g_headP = this;
	++g_cnt;
}

Cfile *
Cfile::locate(Centity *sourceP, int number)
{
	Cfile	*fileP;

	for (fileP = g_headP; fileP; fileP = fileP->m_nextP) {
		if (fileP->m_parentP != sourceP) {
			continue;
		}
		if (fileP->m_number == number) {
			break;
	}	}
	return(fileP);
}

/* virtual */ objectE
Cfile::type(void) const
{
	return(fileE);
}

/* virtual */ void
Cfile::emit_id(void) const
{
	fprintf(stdout, "R%u", m_id);
}

/* virtual */ void
Cfile::emit_instance(void) const
{
	fputs("$INSTANCE ", stdout);
	emit_id();
	fputs(" R\n", stdout);
}

/* virtual */ void
Cfile::emit_attributes(void) const
{
}

/* virtual */ void
Cfile::print(void) const
{
	fprintf(stdout, "(%d)%s", m_number, m_nameP);
}
