typedef enum 
{
	SIGNATURE_substitution,
	SIGNATURE_number,
	SIGNATURE_compact_number,
	SIGNATURE_discriminator,
	SIGNATURE_call_offset,
	SIGNATURE_identifier,
	SIGNATURE_data_member_prefix,
	SIGNATURE_source_name,
	SIGNATURE_digit,
	SIGNATURE_operator_name,
	SIGNATURE_ctor_dtor_name,
	SIGNATURE_closure_type_name,
	SIGNATURE_unnamed_type_name,
	SIGNATURE_unqualified_name,
	SIGNATURE_template_template_param,
	SIGNATURE_template_param,
	SIGNATURE_expr_primary,
	SIGNATURE_template_prefix,
	SIGNATURE_template_arg,
	SIGNATURE_template_args,
	SIGNATURE_simple_id,
	SIGNATURE_destructor_name,
	SIGNATURE_base_unresolved_name,
	SIGNATURE_decltype,
	SIGNATURE_unresolved_type,
	SIGNATURE_unresolved_qualifier_level,
	SIGNATURE_unresolved_name,
	SIGNATURE_cv_qualifiers,
	SIGNATURE_function_param,
	SIGNATURE_initializer,
	SIGNATURE_expression,
	SIGNATURE_prefix,
	SIGNATURE_nested_name,
	SIGNATURE_local_name,
	SIGNATURE_St,
	SIGNATURE_unscoped_name,
	SIGNATURE_unscoped_template_name,
	SIGNATURE_name,
	SIGNATURE_class_enum_type,
	SIGNATURE_function_type,
	SIGNATURE_array_type,
	SIGNATURE_pointer_to_member_type,
	SIGNATURE_fixed_point_type,
	SIGNATURE_vector_type,
	SIGNATURE_type,
	SIGNATURE_bare_function_type,
	SIGNATURE_java_resource,
	SIGNATURE_special_name,
	SIGNATURE_encoding,
	SIGNATURE_mangled_name,
	SIGNATURE_root
} signature_typeE;

struct operatorT {
	const char 	*codeP;
	const char	*nameP;
	int			lth;
	int			args;
};

class Csignature_node {
public:
	signature_typeE		m_type;
	const char 			*m_startP;	// Start of production
	const char			*m_endP;	// End of production
	Csignature_node		*m_parentP;	// My parent node
	Csignature_node		*m_childP;	// First child
	Csignature_node		*m_siblingP;// Next sibling
	Csignature_node		*m_nextP;	// For chaining into dictionary
	long				m_value;

	void				reverse(void);
	void				dump(FILE *F, int entering, int indent, int levels);
};

class Csignature_node;

class Csignature {
friend class Cnew_node;
private:
	Csignature_node	*m_nodesP;		// Start of array of nodes
	Csignature_node	*m_nodes_endP;	// Current end (decrements)
	int				m_nodes_max;	// Number of nodes

	Csignature_node	*m_headP;	// Linked list of substitutions
	Csignature_node	*m_tailP;	// End of dictionary linked list

	Csignature_node	*m_nodeP;	// Our node in the parse tree
	const char		*m_atP;		// Where we are at in parsing the signature

	Csignature_buffer	m_classname;
	Csignature_buffer	m_template;
	Csignature_buffer	m_function;
	Csignature_buffer	m_function_name;

	static void 	fail(void);

	const static operatorT *lookup_operator(char c1, char c2);

	Csignature_node *get_node(void);
	void			all_seen(signature_typeE type);
	void			last_seen(signature_typeE type);

	void 	add_dictionary(Csignature_node *nodeP);
	void 	substitution(void);

	long	number(void);
	long	compact_number(void);
	void	discriminator(void);
	void 	call_offset(void);

	void	identifier(long lth);
	void	source_name(void);
	int		digit();

	int		operator_name(void);
	void	ctor_dtor_name(void);
	void	unqualified_name(int maybe_data_member_prefix);
	void	closure_type_name(void);
	void	unnamed_type_name(void);
	void	template_param(void);
	void	expr_primary(void);
	void	template_arg(void);
	void	template_args(void);
	void	simple_id(void);
	void	destructor_name(void);
	void	base_unresolved_name(void);
	void	decltype1(void);
	void	unresolved_type(void);
	void	unresolved_qualifier_level(void);
	void	unresolved_name(void);
	void	cv_qualifiers(void);
	void	function_param(void);
	void	initializer(void);
	void	expression(void);
	void	prefix(void);
	void	nested_name(void);
	void	local_name(void);
	void	St(void);
	void	unscoped_name(void);
	int		name(void);
	int		class_enum_type(void);
	void	function_type(void);
	void	array_type(void);
	void	pointer_to_member_type(void);
	void	fixed_point_type(void);
	void	vector_type(void);
	void	type(void);
	void	bare_function_type(void);
	void	java_resource(void);
	void	special_name(void);
	void	encoding(void);
	void	mangled_name(void);

public:
	Csignature(void);
	~Csignature(void);

	void 		dump(FILE *F);

	const char *signature(const char *startP);
	int			dictionary_count(void);
	char		*get_classname(void);
	char		*get_template(void);
	char		*get_function(void);
	char		*get_function_name(void);

	int	 		same_class(Csignature *signatureP);
	int	 		same_function(Csignature *signatureP);
	int	 		same_function_name(Csignature *signatureP);

	int			is_function(const char *startP);
};

