#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "util.h"
#include "object.h"
#include "directory.h"
#include "source.h"
#include "file.h"
#include "template.h"
#include "classmember.h"

#define basename FUDGE_BASENAME
#include "demangle.h"
#undef basename

Ctemplate		*Ctemplate::g_headP     = 0;
unsigned int	Ctemplate::g_cnt        = 0;

Ctemplate::Ctemplate(char *nameP)
{
	name(nameP);
	m_parentP = 0;
	m_nextP   = g_headP;
	g_headP   = this;
	++g_cnt;
	m_fileP   = 0;
	m_lineno  = 0;
	m_flags   = 0;
}

void
Ctemplate::reset(void)
{
	Ctemplate	*templateP;

	for (templateP = g_headP; templateP; templateP = templateP->m_nextP) {
		// Hide all templates after a reset
		templateP->m_flags |= InvisibleX;
}	}

Ctemplate *
Ctemplate::find(char *nameP)
{
	Ctemplate	*templateP;

	for (templateP = g_headP; templateP; templateP = templateP->m_nextP) {
		if (!strcmp(templateP->m_nameP, nameP)) {
			if (!(templateP->m_flags & InvisibleX)) {
				break;
	}	}	}
	return(templateP);
}

Ctemplate *
Ctemplate::locate(char *nameP)
{
	Ctemplate	*templateP;

	templateP = find(nameP);
	if (!templateP) {
		templateP = new Ctemplate(nameP);
	}
	return templateP;
}

/* virtual */ objectE
Ctemplate::type(void) const
{
	return(templateE);
}

/* virtual */ void
Ctemplate::emit_id(void) const
{
	fprintf(stdout, "T%u", m_id);
}

/* virtual */ void
Ctemplate::emit_edges(void)
{
	fputs("contain T ", stdout);
	emit_id();
	fputc('\n', stdout);
}

/* virtual */ void
Ctemplate::emit_instance(void) const
{
	fputs("$INSTANCE ", stdout);
	emit_id();
	fputs(" T\n", stdout);
}

void
Ctemplate::emit_attributes(void) const
{
	char	*labelP;
	char	*demangleP;

	emit_id();
	fputs(" {", stdout);
	labelP = m_nameP;
	// This is a malloced string
	demangleP = cplus_demangle(labelP, DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3);
	if (demangleP) {
		labelP = demangleP;
	}
	fprintf(stdout, "label=\"%s\"", labelP);
	if (demangleP) {
		free(demangleP);
	}
	if (m_fileP) {
		fprintf(stdout, " file=\"%s\" lineno=%d", m_fileP->m_nameP, m_lineno);
	}
	fputs("}\n", stdout);
}

/* virtual */ void
Ctemplate::print(void) const
{
	fprintf(stdout, "%s::", m_nameP);
}
