#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include "signature_buffer.h"
#include "signature.h"

#define basename FUDGE_BASENAME
#include "demangle.h"
#undef basename

extern int	cplus_demangle_dictionary_count;

int
main(int argc, char **argv)
{
	Csignature	signature;
	char 		buffer[1024];
	char		*demangleP;
	int			find_signature = 1;
	int			full_dump = 0;
	char		*P;
	const char	*retP;
	int			dictionary_count;
	int			i;

	for (i = 1; i < argc; ++i) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
			case 'e':
				find_signature = 0;
				break;
			case 'f':
				full_dump = 1;
				break;
	}	}	}

	while (fgets(buffer, sizeof(buffer), stdin)) {
		P = strchr(buffer, '\n');
		if (P) {
			*P = 0;
		}
		dictionary_count = -1;
		fprintf(stdout, "mangle=\"%s\"\n", buffer);
		fflush(stdout);
		retP = 0;
		if (find_signature) {
			retP = signature.signature(buffer);
			if (!retP) {
				printf("signature failed\n");
			} else {
				dictionary_count = signature.dictionary_count();
				printf("signature: \n");
				if (full_dump) {
					signature.dump(stdout);
		}	}	}

		demangleP = cplus_demangle(buffer, 
				DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3/*|DMGL_RET_POSTFIX*/);
		if (!demangleP) {
			printf("demangle failed\n");
		} else {
			printf("expand=\"%s\"\n", demangleP);
			free(demangleP);
			if (retP && dictionary_count != cplus_demangle_dictionary_count) {
				printf("Dictionary counts disagree: %d .v. %d\n",
					dictionary_count,
					cplus_demangle_dictionary_count);
		}	}
		fflush(stdout);

		if (!retP) {
			continue;
		}
		P = signature.get_classname();
		printf("classname: ");	
		if (!P) {
			printf("failed");
		} else {
			printf("'%s'", P);
			demangleP = cplus_demangle(P, 
				DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3/*|DMGL_RET_POSTFIX*/);
			if (!demangleP) {
				printf(" demangle failed");
			} else {
				printf("='%s'", demangleP);
				free(demangleP);
		}	}
		printf("\n");

		P = signature.get_template();
		printf("template: ");	
		if (!P) {
			printf("failed");
		} else {
			printf("'%s'", P);
			demangleP = cplus_demangle(P, 
				DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3/*|DMGL_RET_POSTFIX*/);
			if (!demangleP) {
				printf(" demangle failed");
			} else {
				printf("='%s'", demangleP);
				free(demangleP);
		}	}
		printf("\n");

		P = signature.get_function();
		printf("function: ");	
		if (!P) {
			printf("failed");
		} else {
			printf("'%s'", P);
			demangleP = cplus_demangle(P, 
				DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3/*|DMGL_RET_POSTFIX*/);
			if (!demangleP) {
				printf(" demangle failed");
			} else {
				printf("='%s'", demangleP);
				free(demangleP);
		}	}
		printf("\n");

		P = signature.get_function_name();
		printf("function name: ");	
		if (!P) {
			printf("failed");
		} else {
			printf("'%s'", P);
			demangleP = cplus_demangle(P, 
				DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3/*|DMGL_RET_POSTFIX*/);
			if (!demangleP) {
				printf(" demangle failed");
			} else {
				printf("='%s'", demangleP);
				free(demangleP);
		}	}
		printf("\n\n");
		fflush(stdout);
	}
	return(0);
}
