#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "classmember.h"
#include "class.h"
#include "directory.h"
#include "source.h"
#include "collection.h"
#include "variable.h"
#include "function.h"
#include "signature_buffer.h"
#include "signature.h"

#define basename FUDGE_BASENAME
#include "demangle.h"
#undef basename

Cvariable		*Cvariable::g_hash[HASHSIZE] = {0};
unsigned int	Cvariable::g_hash_cnt        = 0;
Cvariable		*Cvariable::g_local_headP    = 0;

Cvariable		*Cvariable::g_addr_hash[HASHSIZE] = {0};
unsigned int	Cvariable::g_addr_hash_cnt        = 0;

extern void trap();

Cvariable::Cvariable(const char *nameP) : Cclassmember(nameP)
{
	if (!strcmp(nameP, "_ZTV8AsMemory")) {
		trap();
	}
	m_hashP       = 0;
	m_local_nextP = 0;
}

void
Cvariable::reset(void)
{
	int 		i;
	Cvariable	*variableP;

	for (i = 0; i < HASHSIZE; ++i) {
		for (variableP = g_hash[i]; variableP; variableP = variableP->m_hashP) {
			variableP->m_flags |= InvisibleX;
		}
		for (variableP = g_addr_hash[i]; variableP; variableP = variableP->m_hashP) {
			variableP->m_flags |= InvisibleX;
}	}	}

Cvariable **
Cvariable::exists(const char *nameP, int flags, const Centity *sourceP, const Centity *functionP, const Centity *addressesP)
{
	unsigned int	index;
	Cvariable		**variablePP, *variableP, **bestPP;
	Centity			*parentP;
	const char		*P;

#if 0
	if (!strcmp(nameP, "_ZTV8AsMemory")) {
		extern char *g_startP;
		for (P = g_startP; *P; ++P) {
			fputc(*P, stderr);
			if (*P == '\n') {
				break;
		}	}
		trap();
	}
#endif
	bestPP     = 0;

	if (flags & LocalX) {
		if (!(flags & NestedX)) {
			P = strchr(nameP, '.');
			/* The assembler labels local static variables declared within
			 * functions with a numeric suffix to avoid collisions with
			 * global variables and the same named local variables in other
			 * functions.
		 	 */
			if (P != 0) {
				flags |= NestedX;
	}	}	}

	index      = hash(nameP);
	if (flags & AddressesX) {
		variablePP = g_addr_hash;
	} else {
		variablePP = g_hash;
	}

	for (variablePP += index; (variableP = *variablePP); variablePP = &(variableP->m_hashP)) {
		if (strcmp(variableP->m_nameP, nameP)) {
			// Name differs so not the right variable
			continue;
		}
		if (variableP->m_flags & InvisibleX) {
			// This variable is invisible following a reset
			continue;
		}
		parentP = variableP->m_parentP;		// null if don't know parent
		if (addressesP) {
			if (parentP == addressesP) {
				bestPP = variablePP;
				break;
			}
			continue;
		}
		if (parentP) {
			if (variableP->m_flags & NestedX) {
				if (parentP == functionP) {
					bestPP = variablePP;
					break;
				}
				// Not our variable if we are in a diffent function from it
				continue;
			}
			if (variableP->m_flags & LocalX) {
				if (parentP == sourceP) {
					bestPP = variablePP;
					// Don't break because a nested variable with the same
					// name is a better selection than a local with name
				}
				// Not our variable if we are in a different source
				continue;
		}	}
		
		if (flags & (NestedX | LocalX)) {
			// A nested or local variable should be established in pass1
			// If it exists we should find an existing copy of it
			continue;
		}
		if (!bestPP) {
			bestPP = variablePP;
	}	}

	if (!bestPP) {
		bestPP = variablePP;
	}
	return(bestPP);
}

extern void trap();

Cvariable *
Cvariable::locate(char *nameP, int flags, Centity *sourceP, Centity *functionP)
{
	Cfunction		**functionPP;
	Cvariable		**variablePP, **bestPP, *bestP;
	Centity			*addressesP;
	const char		*P;
	int				flags1;

	if (flags & LocalX) {
		if (!(flags & NestedX)) {
			P = strchr(nameP, '.');
			/* The assembler labels local static variables declared within
			 * functions with a numeric suffix to avoid collisions with
			 * global variables and the same named local variables in other
			 * functions.
		 	 */
			if (P != 0) {
				flags |= NestedX;
	}	}	}

	addressesP = 0;
	flags1     = 0;
	if (flags & AddressesX) {
		if (!strcmp(nameP, "add_collation")) {
			trap();
		}
		flags1     = (flags | LocalX) & ~AddressesX;
		functionPP = Cfunction::exists(nameP, flags1, sourceP);
		addressesP = *functionPP;
		if (addressesP) {
			flags1 = FunctionX;
		} else {
			bestPP = Cvariable::exists(nameP, flags1, sourceP, functionP, 0);
			addressesP = *bestPP;
			flags1     = VariableX;
	}	}
	variablePP = Cvariable::exists(nameP, flags, sourceP, functionP, addressesP);
	bestP      = *variablePP;

	if (!bestP) {
		bestP = new Cvariable(nameP);
		if (!bestP) {
			outofmemory();
		}
		/* Add to end so always return first function declaration seen if
		 * searching for location of the function declaration:
		 *
	     * eg. if we are looking for foo and foo was in foo.c later
	     *     also seen in foo.o return reference to foo.c:foo in
		 *     preferance to foo.o:foo
	     */
	
		*variablePP = bestP;
		if (flags & AddressesX) {
			++Cvariable::g_addr_hash_cnt;
			if (addressesP) {
				bestP->m_parentP = addressesP;
				flags           |= flags1;
			}
		} else {
			++Cvariable::g_hash_cnt;
			if (functionP) {
				if (flags & (DynamicX|NestedX)) {
					if (!bestP->m_parentP) {
						bestP->m_parentP = functionP;
			}	}	}
			if (sourceP) {
				if ((flags & (NestedX | LocalX)) || !(flags & FindX)) {
					if (!bestP->m_parentP) {
						bestP->m_parentP = sourceP;
			}	}	}
		
			if (bestP->m_flags & NestedX) {
				// Condition variable to be added to next function seen
				if (!(bestP->m_flags & OnlistX)) {
					bestP->m_local_nextP = g_local_headP;
					g_local_headP        = bestP;
					bestP->m_flags      |= OnlistX;
		}	}	}
		bestP->m_flags  = flags;
	}

/*
	if (!strcmp(nameP, "_ZZN1IL4doitEPNS_1AEE8remember")) {
		if (!bestP->m_parentP) {
			trap_variable();
	}	}
*/
	return(bestP);
}

extern Csignature	g_signature;

void
Cvariable::resolve(int show_variables, int function_calls)
{
	Csource		*sourceP;
	Centity		*parentP;
	Cfunction	**functionPP, *functionP;
	Cvariable	*variableP, *addrP;
	char		*nameP, *P;
	int 		i, flags, vtable;
	
	// Linked addresses of things to the things they address
	for (i = 0; i < HASHSIZE; ++i) {
		for (addrP = g_addr_hash[i]; addrP; addrP = addrP->m_hashP) {
			nameP      = addrP->m_nameP;
			parentP    = addrP->m_parentP;
			if (!parentP) {
				functionPP = Cfunction::exists(nameP, 0, 0);
				functionP  = *functionPP;
				if (!functionP) {
					if (g_signature.is_function(nameP)) {
						functionP = Cfunction::locate(nameP, 0, 0);
				}	}
				if (functionP) {
					parentP = functionP;
					addrP->m_flags  |= FunctionX;
				} else {
					variableP = Cvariable::locate(nameP, 0, 0, 0);
					assert(variableP);
					parentP = variableP;
					addrP->m_flags  |= VariableX;
				}
				addrP->m_parentP = parentP;
			}
			if (addrP->m_flags & VirtualX) {
				parentP->m_flags |= VirtualX;
				if (addrP->m_flags & FunctionX) {
					functionP = (Cfunction *) parentP;
					vtable    = addrP->m_vtable;
               		if (vtable != NOT_IN_VTABLE) {
						if (functionP->m_vtable == NOT_IN_VTABLE) {
							// A function might occur in more than one
							// vtable.. this is only a hint as to
							// the fact that it is in at least one
							// vtable
							functionP->m_vtable = vtable;
			}	}	}	}

			if (addrP->m_flags & PureX) {
				addrP->m_parentP->m_flags |= PureX;
	}	}	}	
			
	sourceP = 0;
	for (i = 0; i < HASHSIZE; ++i) {
		for (variableP = g_hash[i]; variableP; variableP = variableP->m_hashP) {
			nameP   = variableP->m_nameP;
			parentP = variableP->m_parentP;
			flags   = variableP->m_flags;

			if (nameP[0] == '_') {
				switch (nameP[1]) {
				case '_':
					if (!strcmp(nameP,"__PRETTY_FUNCTION__")) {
						variableP->m_flags |= IgnoreX;
						continue;
					}
					break;
				case 'Z':
					if (nameP[2] == 'T') {
						Cclass	*classP;
		
						switch (nameP[3]) {
						case 'T':	// Virtual table pointers
						case 'C':	// Constructor vtable
						case 'S':	// Typeinfo name
						case 'N':	// Typeinfo number
						case 'V':	// Vtable
						case 'I':	// Typeinfo
						case 'h':	// Thunk
						case 'v':	// Thunk
						case 'c':	// Thunk
							// These variables always are to be found in their class
							// If the classname can be deduced rather than under a
							// source file name or a function name
							Cclassmember::find_class(nameP, &classP, 0);
							if (classP) {
								variableP->m_parentP = classP;
								continue;
			}	}	}	}	}

			if (!parentP) {
				if (!sourceP) {
					sourceP    = new Ccollection(":globals:", 0);
					if (!sourceP) {
						outofmemory();
					}
				}
				variableP->m_parentP = sourceP;
				variableP->m_flags  |= ExternalX;
				continue;
			}

			if (flags & NestedX) {
				P = strchr(nameP, '.');
				if (P) {
					// Remove .<number> from the end of variable names
					*P = 0;
			}	}
	}	}
}

/* virtual */ objectE
Cvariable::type(void) const
{
	return(variableE);
}

/* virtual */ void
Cvariable::emit_id(void) const
{
	fprintf(stdout, "V%u", m_id);
}

const char *
Cvariable::get_type(void) const
{
	int			flags;
	const char 	*typeP;

	flags = m_flags;
	if (flags & FunctionX) {
		typeP = "FA";
	} else if (flags & AddressesX) {
		typeP = "VA";
	} else if (flags & DynamicX) {
		if (flags & NotParamX) {
			typeP = "LV";	// Local variable
		} else {
			typeP = "PV";	// Parameter variable
		}
	} else if (flags & NestedX) {
		typeP = "FV";		// Function variable
	} else if (flags & LocalX) {
		typeP = "SV";		// Static variable
	} else if (flags & WeakX) {
		char	*nameP;
		typeP = "WV";
		nameP = m_nameP;
		if (!strncmp(nameP, "_ZT", 3)) {
			switch (nameP[3]) {
			case 'C':
			case 'V':
				typeP = "TV";
				break;
			case 'I':
				typeP = "TI";
				break;
			case 'S':
				typeP = "TN";
				break;
			case 'h':
			case 'v':
			case 'c':
				typeP = "TH";
				break;
		}	}
	} else if (flags & ExternalX) {
		typeP = "EV";
	} else {
		typeP = "GV";
	}
	return(typeP);
}

/* virtual */ void
Cvariable::emit_edges(void)
{
	if (!(m_flags & IgnoreX)) {
		Cclassmember::emit_edges();
		if (Cclass::g_headP) {
			emit_class();
	}	}
}
		
/* virtual */ void
Cvariable::emit_instance(void) const
{
	fputs("$INSTANCE ", stdout);
	emit_id();
	fprintf(stdout, " %s\n", get_type());
}

void
Cvariable::emit_attributes(void) const
{
	const char	*nameP;
	char		*demangleP;

	emit_id();
	fputs(" {", stdout);

	nameP     = m_nameP;
	demangleP = 0;
	if (nameP[0] == '_') {
		demangleP = cplus_demangle(nameP, DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3);
		if (demangleP) {
			fprintf(stdout, "mangle=\"%s\" ", nameP);
			nameP = demangleP;
	}	}
	fprintf(stdout, "label=\"");
	if (m_flags & AddressesX) {
		fprintf(stdout, "&");
	}
	fprintf(stdout, "%s\" file=\".\"", nameP);
	if (demangleP) {
		free(demangleP);
	}
	fputs("}\n", stdout);
}

/* virtual */ void
Cvariable::print(void) const
{
	fputs(m_nameP, stdout);
}
